//priority 30
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.GridPageWindowGroupEditPart = function () {
    this.initSpecific( "shinken-edition-main-part" );
};

SHINKEN.OBJECT.GridPageWindowGroupEditPart.prototype = {
    initSpecific       : function ( group_name ) {
        this.init( group_name );
        this.addClass( "shinken-layout-bottom-v" );
        this.initWithData( SHINKEN_PAGE.CONST.WINDOWS_TABS_EDIT_PART.TABS );
    },
    getChildConstructor: function ( window_name, parent_name ) {
        switch ( window_name ) {
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL:
                return new SHINKEN.OBJECT.WindowGenericEditPart( window_name, this.name );
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON:
                return new SHINKEN.OBJECT.WindowJsonEditPart( window_name, this.name );
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.HISTORY:
                return new SHINKEN.OBJECT.WindowEditPartAbstract( window_name, this.name );
            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT:
                return new SHINKEN.OBJECT.WindowDefaultEditPart( window_name, this.name );
        }
    },
    
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "set_active_window":
                this.setPhase( param[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] );
                break;
        }
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  HTML  **************************************************//
    getEventManager    : function () {
        return "CONTROLLER.PageController.askNavigateGroupEdition(event, " + this.parseParamForEventsToHtml() + ")";
    },
    computeHtmlSpecific: function ( window_container ) {
        this.setContentDomElementTarget( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON, window_container.querySelector( ".shinken-json-div" ) );
        this.setContentDomElementTarget( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.HISTORY, window_container.querySelector( ".shinken-view-history-container" ) );
        this.setContentDomElementTarget( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT, window_container.querySelector( ".shinken-view-default-container" ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageWindowGroupEditPart, WINDOW_V2.ElementGroupFromDataWithComma );

