//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.WindowProblemGeneral           = function ( window_name, parent_name ) {
    this.__class_name__ = 'SHINKEN.OBJECT.WindowProblemGeneral';
    this.init( window_name, parent_name );
};
SHINKEN.OBJECT.WindowProblemGeneral.prototype = {
    init             : function ( window_name, parent_name ) {
        this.initCommon( window_name, parent_name );
        this.label            = new COMPONENT.LabelFromData( _( "edit_mode.windows.label." + this.name ) );
        this.problem_for_init = new SHINKEN_PAGE.Messages();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_object_json_fail":
                this.problem_for_init.addMessage( COMPONENT.CONST.STATUS.ERROR, param[ SHINKEN.OBJECT.JSON_EDITOR.PARAM_EVENT.JSON_FORM_OBJECT ].message_invalid );
                return;
            case "add_object_with_problems__to__window_problem":
                this.problem_for_init.addMessages( param[ SHINKEN.OBJECT.CONST.VALIDATION.PARAM.CURRENT_OBJECT ].messages.getAllMessages() );
                return;
            case "compute_html_done":
                this.updateLabelCounters();
                this.computeContentTarget();
                break;
        }
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    hasProblems  : function () {
        let current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                return !!this.problem_for_init.hasMessage();
        }
        return this.hasCounterProblems();
    },
    //********************************************  HTML  *****************************************************//
    updateLabelCounters: function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, "", this.problem_for_init.getNumberErrors() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, "", this.problem_for_init.getNumberWarnings() );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml         : WINDOW_V2.ElementFromData.prototype.computeHtml,
    computeContentTarget: function () {
        this.content_dom_element_target = DOM.Service.createElement( "div", { class: "shinken-window-problem-general-container" } );
        if ( !this.problem_for_init.hasMessage() ) {
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-note" }, _( 'messages.no_message_to_display', [DICTIONARY_COMMON_UI] ) ), this.content_dom_element_target );
            return;
        }
        DOM.Service.addElementTo(
            DOM.Service.createElement(
                "div",
                { class: "shinken-dom-element-problem" },
                this.problem_for_init.buildMessage()
            ),
            this.content_dom_element_target
        );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WindowProblemGeneral, WINDOW_V2.ElementFromDataWithComma );
