//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.WindowProblemCell           = function ( window_name, parent_name ) {
    this.__class_name__ = 'SHINKEN.OBJECT.WindowProblemCell';
    this.init( window_name, parent_name );
};
SHINKEN.OBJECT.WindowProblemCell.prototype = {
    init             : function ( window_name, parent_name ) {
        this.initCommon( window_name, parent_name );
        this.label                   = new COMPONENT.LabelFromData( _( "edit_mode.windows.label." + this.name ) );
        this.problem_for_init        = [];
        this.weather_cells__20240829 = new SHINKEN.OBJECT.GridCellWithProblem();
        this.weather_cells__20240829.setCountersParent( this );
        this.weather_cells__20240829.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS ).setParent( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS ) );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS );
    },
    hasProblems      : function () {
        let current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                return !!this.problem_for_init.length;
        }
        return this.hasCounterProblems();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "clean_widget_with_problem":
            case "add_object__with_problems__from_user_action":
                param[ WINDOW_V2.CONST.PARAM.WINDOW_OBJECT ] = this;
                this.weather_cells__20240829.doActionAfter( event_name, param );
                break;
            case "add_object_with_problems__to__window_problem":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
                    this.problem_for_init.push( param[ SHINKEN.OBJECT.CONST.VALIDATION.PARAM.CURRENT_OBJECT ] );
                }
                return;
            case "compute_html_done":
                this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS ).addTargetsDomElement( this.getDomElement(), "problems" );
                this.mergeProblemsOnCell();
                this.computeContentTarget();
                break;
            case "click_on_button_V3":
                param[ WINDOW_V2.CONST.PARAM.WINDOW_OBJECT ] = this;
                this.weather_cells__20240829.doActionAfter( event_name, param );
                return;
            case "link__dom_element__to_widget_problem__counter":
                this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS ).addTargetsDomElement( param[ "dom_element_to_link" ], "problems" );
                break;
        }
        this.doActionAfterSpecificComma( event_name, param );
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  ACTION  *****************************************************//
    mergeProblemsOnCell: function () {
        for ( let i = 0, _size_i = this.problem_for_init.length; i < _size_i; i++ ) {
            this.weather_cells__20240829.addSpecific( this.problem_for_init[ i ] );
        }
        this.problem_for_init = [];
    },
    //********************************************  HTML  *****************************************************//
    computeHtml         : WINDOW_V2.ElementFromData.prototype.computeHtml,
    computeContentTarget: function () {
        this.content_dom_element_target = DOM.Service.createElement( "div", { class: "shinken-window-problem-cell-container" } );
        this.weather_cells__20240829.computeHtml__20240829( this );
        DOM.Service.addElementTo( this.weather_cells__20240829.getDomElement(), this.content_dom_element_target );
    },
    getLabelCellHtml    : function () {
        var _action_after_param = SHINKEN.TOOLS.DICT.parseToHTMLParam( { "window_problem_tab_target": WEATHER.CONST.WINDOWS_TABS_EDITION_MESSAGE.WIDGET } );
        let previous_button     = this._buildButtonHtml( "click-on-window-group-problem-go-previous", "<span class='shinkon-double-chevron-left-lite'></span>", _( "edit_mode.windows.tooltips.previous_cell" ) );
        let label_button        = this._buildButtonHtml( "click-on-window-group-problem-focus-current" );
        let next_button         = this._buildButtonHtml( "click-on-window-group-problem-go-next", "<span class='shinkon-double-chevron-right-lite'></span>", _( "edit_mode.windows.tooltips.next_cell" ) );
        DOM.Service.addClasses( label_button.getDomElement(), "shinken-layout-expand-1" );
        this.dom_element_widget_label       = DOM.Service.createElement( "span", { "class": "shinken-window-widget-label" } );
        this.dom_element_widget_label_index = DOM.Service.addElementTo( DOM.Service.createElement( "span", { "class": "shinken-data-user" } ), this.dom_element_widget_label );
        label_button.setLabelDomElement( this.dom_element_widget_label );
        
        let _to_return = DOM.Service.createElement( "div", { "class": "shinken-container-buttons shinken-layout-justify-between" } );
        
        this.label.computeHtml();
        
        DOM.Service.addElementTo( this.label.getDomElement(), _to_return );
        
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.label.getDomElement() );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.label.getDomElement() );
        
        let _div_actions = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-window-element-actions-area shinken-layout-inline-center-h-v" } ), _to_return );
        
        DOM.Service.addElementTo( previous_button.getDomElement(), _div_actions );
        DOM.Service.addElementTo( label_button.getDomElement(), _div_actions );
        DOM.Service.addElementTo( next_button.getDomElement(), _div_actions );
        
        return _to_return;
    },
    _buildButtonHtml    : function ( event_name, label, tooltip_html ) {
        let to_return = new COMPONENT.ButtonFromData_V3( event_name, label );
        to_return.addParamsForEvents( this.getParamForEvents() );
        to_return.computeHtml();
        if ( tooltip_html ) {
            to_return.setTooltipHtml( tooltip_html );
        }
        return to_return;
    },
    changeIndexLabelHtml: function ( to_set ) {
        if ( !this.dom_element_widget_label_index ) {
            return;
        }
        this.dom_element_widget_label_index.innerHTML = to_set;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WindowProblemCell, WINDOW_V2.ElementFromDataWithComma );


SHINKEN.OBJECT.GridCellWithProblem           = function () {
    this.init();
};
SHINKEN.OBJECT.GridCellWithProblem.prototype = {
    init             : function () {
        this.initCounterCommon();
        this.initContents();
        this.last_focused_widget = 0;
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_object__with_problems__from_user_action":
                this.addSpecific( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ] );
                this.computeHtmlOfGridElement( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ], true );
                this.focusOnAProblem( param );
                return;
            case "clean_widget_with_problem":
                let grid_cell_uuid = param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ];
                let index_deleting = this.getMappingIndex( grid_cell_uuid );
                if ( index_deleting === undefined ) {
                    return;
                }
                DOM.Service.removeElement( this.getContentByUUID( grid_cell_uuid ).dom_element_problem );
                this.removeContent( grid_cell_uuid, null, true );
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, grid_cell_uuid, 0 );
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, grid_cell_uuid, 0 );
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS, grid_cell_uuid, 0 );
                this.setIndexFocus( index_deleting, param );
                break;
            default:
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "click-on-window-group-problem":
                        this.setIndexFocus( this.last_focused_widget || 0, param );
                        break;
                    case "click-on-window-group-problem-go-previous":
                        this.setIndexFocus( this.last_focused_widget - 1, param );
                        break;
                    case "click-on-window-group-problem-go-next":
                        this.setIndexFocus( this.last_focused_widget + 1, param );
                        break;
                    case "click-on-window-group-problem-focus-current":
                        this.doFocusWidget( param, true );
                        break;
                }
        }
    },
    //********************************************  ACTION  *****************************************************//
    addSpecific    : function ( to_add ) {
        let current_counter   = to_add.getCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) ? to_add.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) : to_add.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        let current_grid_cell = current_counter.getObjectParentWithClassNameV2( "WEATHER.Cell" );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, current_grid_cell.getUUID(), current_grid_cell.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ).getValue() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, current_grid_cell.getUUID(), current_grid_cell.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS ).getValue() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.PROBLEMS, current_grid_cell.getUUID(), 1 );
        this.add( current_grid_cell );
    },
    focusOnAProblem: function ( param ) {
        const index_to_focus = this.getMappingIndex( param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ].getUUID() );
        this.setIndexFocus( index_to_focus, param );
    },
    setIndexFocus  : function ( to_set, param ) {
        if ( this.getSize() === 0 ) {
            this.last_focused_widget = 0;
            return;
        }
        if ( to_set < 0 ) {
            to_set = this.getSize() - 1;
        }
        else if ( to_set >= this.getSize() ) {
            to_set = 0;
        }
        for ( let i = 0; i < this.getSize(); i++ ) {
            const contentElement = this.getContent( i ).dom_element_problem;
            const isFocused      = i === to_set;
            DOM.Service.addOrRemoveClasses( contentElement, !isFocused, "shinken-hidden" );
            if ( isFocused ) {
                const dom_parent = DOM.Service.findParentElementWithID( contentElement, "id-shinken-window-V2-widget-grid_page_window_group_problem-target", 20 );
                DOM.Service.askAddClass( dom_parent, "shinken-animation-for-focused-message", 500 );
            }
        }
        this.last_focused_widget = to_set;
        param[ WINDOW_V2.CONST.PARAM.WINDOW_OBJECT ].changeIndexLabelHtml( this.getContent( this.last_focused_widget ).index_label );
        this.doFocusWidget( {}, !param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ] );
    },
    doFocusWidget  : function ( param, do_focus_on_widget ) {
        let _focus_widget = this.getContent( this.last_focused_widget );
        _focus_widget.dom_element_problem.classList.remove( "shinken-hidden" );
        if ( do_focus_on_widget ) {
            _focus_widget.doActionAfter( "focus_on_dom_element" );
        }
        param[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] = _focus_widget;
        CONTROLLER.PageController.doActionAfter( "focus-on-json-if-existing", param );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml__20240829   : function ( window_element_problem_cell_object ) {
        this.setDomElement( DOM.Service.createElement( "div" ) );
        if ( !this.getSize() ) {
            this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-note" }, _( 'messages.no_message_to_display', [DICTIONARY_COMMON_UI] ) ) );
            return;
        }
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.computeHtmlOfGridElement( this.getContent( i ), i > 0 );
        }
        window_element_problem_cell_object.changeIndexLabelHtml( this.getContent( this.last_focused_widget ).index_label );
    },
    computeHtmlOfGridElement: function ( grid_element, hide_element ) {
        //if ( grid_element.dom_element_problem ) {
        //    return;
        //}
        grid_element.dom_element_problem = DOM.Service.createElement( "div", { class: "shinken-dom-element-problem", "data-problem-cell-uuid": grid_element.getUUID() }, grid_element.buildMessage() );
        if ( hide_element ) {
            grid_element.dom_element_problem.classList.add( "shinken-hidden" );
        }
        if ( this.getDomElement() ) {
            DOM.Service.removeElement( this.getDomElement().querySelector( '.shinken-dom-element-problem[data-problem-cell-uuid="' + grid_element.getUUID() + '"]' ) );
        }
        
        this.addDomElement( grid_element.dom_element_problem );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridCellWithProblem, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridCellWithProblem, SHINKEN.OBJECT.ShinkenObjectContainer );