#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import List
from ..object.shinken_object import ShinkenObject
from ..object.array import ShinkenArray
from ..window.window import Window


class WindowGroup(ShinkenObject):
    def __init__(self, group_name, list_tabs=None):
        # type: (str, List[str])-> None
        super(WindowGroup, self).__init__()
        self.name = group_name
        self.content = ShinkenArray()
        self.set_content(list_tabs)
    
    
    def set_content(self, to_set):
        # type: (List[str])-> None
        if not to_set:
            return
        for _current in to_set:
            _to_add = Window(_current, self.name, label=_current)
            self.content.add_element(_to_add)
    
    
    def get_html(self, extra_content=""):
        # type: (str)-> str
        _to_return = ['''<tr class="shinken-window-group" data-name="%s" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'%s')">''' % (self.name, self.name),
                      '''%s''' % self.content.get_html(),
                      '''</tr>''']
        return ''.join(_to_return)
