#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


from collections import namedtuple

from datetime import datetime

# ATTENTION : import cyclique dans schedulingitem.py
# from shinken.misc.type_hint import TYPE_CHECKING
#
TYPE_CHECKING = False
if TYPE_CHECKING:
    from shinken.misc.type_hint import Union

DisplayFormat = namedtuple('DisplayFormat', ['ms', 's', 'm', 'h', 'd'])
DEFAULT_FORMAT_DATE = {'fr': '%d/%m/%Y', 'en': '%m/%d/%Y', 'iso': '%Y/%m/%d'}
DEFAULT_FORMAT_DATE_TIME = {'fr': '%H:%M:%S %d-%m-%Y (%Z)', 'en': '%H:%M:%S %m/%d/%Y (%Z)', 'iso': '%H:%M:%S %Y/%m/%d (%Z)'}


def print_human_readable_period(time_period, time_format='s', display_format=DisplayFormat('%.2fms', '%.2fs', '%sm', '%sh', '%s days'), separator=' '):
    if isinstance(time_period, str):
        try:
            time_period = int(time_period)
        except ValueError:
            return time_period
    
    if not isinstance(time_period, (float, int)):
        return time_period
    
    if time_format == 's':
        return display_format.s % time_period
    if time_format == 'ms':
        return display_format.ms % (time_period * 1000)
    
    if time_period < 1:
        if display_format.ms:
            return display_format.ms % (time_period * 1000)
        else:
            return ''
    elif 1 <= time_period < 60:
        return display_format.s % time_period
    elif 60 <= time_period < 3600:
        m = int(time_period / 60)
        s = time_period % 60
        if s:
            return separator.join((display_format.m, display_format.s)) % (m, s)
        return display_format.m % m
    elif 3600 <= time_period < 86400:
        h = int(time_period / 3600)
        m = int((time_period % 3600) / 60)
        s = int((time_period % 3600) % 60)
        if m and s:
            return separator.join((display_format.h, display_format.m, display_format.s)) % (h, m, s)
        if m:
            return separator.join((display_format.h, display_format.m)) % (h, m)
        return display_format.h % h
    else:
        d = int(time_period / 86400)
        h = int((time_period % 86400) / 3600)
        m = int((time_period % 3600) / 60)
        s = int((time_period % 3600) % 60)
        
        if h and m and s:
            return separator.join((display_format.d, display_format.h, display_format.m, display_format.s)) % (d, h, m, s)
        if h and m:
            return separator.join((display_format.d, display_format.h, display_format.m)) % (d, h, m)
        if h:
            return separator.join((display_format.d, display_format.h)) % (d, h)
        return display_format.d % d


def print_date_locate(date, lang='', date_format=''):
    if not date:
        return ''
    
    if not date_format:
        if not lang or lang not in DEFAULT_FORMAT_DATE:
            lang = 'iso'
        date_format = DEFAULT_FORMAT_DATE[lang]
    
    if isinstance(date, datetime):
        return date.strftime(date_format)
    return datetime.fromtimestamp(date).strftime(date_format)


def print_human_readable_date_time(date_time, lang='', date_format=''):
    # type: (Union[datetime, float, int], str, str) -> str
    if not date_time:
        return ''
    
    if not date_format:
        if not lang or lang not in DEFAULT_FORMAT_DATE_TIME:
            lang = 'iso'
        date_format = DEFAULT_FORMAT_DATE_TIME[lang]
    if isinstance(date_time, float) or isinstance(date_time, int):
        date_time = datetime.fromtimestamp(date_time)
    return date_time.strftime(date_format)
