#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ....utils.weather_tools import travel_dictionaries

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, Optional


# WEATHER CONSTANTS ARE FORBIDDEN HERE

def _parse_existing(grid, path, default_value='default'):
    # type: (Dict, str, Optional[Any]) -> Optional[Any]
    return travel_dictionaries(grid, path, default_value=default_value)


def generate_new_weather_default_external_link(external_links):
    # type: (Dict) -> Dict
    return {
        'link_protocol'         : _parse_existing(external_links, 'links__default_link_protocol', default_value='protocol_from_webui'),
        'link_base_url'         : _parse_existing(external_links, 'links__default_base_url'),
        'link_external_part_url': _parse_existing(external_links, 'links__default_external_part_url'),
        'authentication_needed' : _parse_existing(external_links, 'links__default_authentication_needed'),
        'info_bar'              : _parse_existing(external_links, 'links__default_info_bar', {}),
    }
