#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024:
# This file is part of Shinken Enterprise, all rights reserved.

"""
This module contains the patches to apply to a weather JSON in order to upgrade to the version : 4

Register your migration hook function using the @weather_format_patch decorator

Each callback must take the weather dict to modify, and return None
Example:

from ..patch_decorator import weather_format_patch

@weather_format_patch
def add_grid_default(weather_data):  # The parameter name can be anything
    # type: (Dict[unicode, Any]) -> None
    # Do your stuff...
    return

N.B.: The functions will NOT always be called in the same order as the declaration
"""

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.date_helper import get_now
from ..patch_decorator import weather_format_patch

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict


@weather_format_patch
def add_phase_to_weathers(weather_data):
    # type: (Dict) -> None
    
    current_timestamp = get_now()
    view_behaviour_phase = weather_data.setdefault('view_behaviour_phase', {})
    view_behaviour_phase.setdefault('phase', 'running_phase')
    view_behaviour_phase.setdefault('previous_phase', 'draft_phase')
    view_behaviour_phase.setdefault('last_update', current_timestamp)
