
@echo off

setlocal

for /f "delims=" %%A in ('powershell -Command "Get-Date -Format 'MM/dd/yyyy/HH/mm/ss'"') do (
    set "dateTime=%%A"
)

for /f "tokens=1-6 delims=/" %%A in ("%dateTime%") do (
    set "MM=%%A"
    set "DD=%%B"
    set "YY=%%C"
    set "HH=%%D"
    set "MN=%%E"
    set "SS=%%F"
)

set "timestamp=%YY%-%DD%-%MM%__%HH%h%MN%m%SS%"

:: Log file
set LOGFILE=C:\shinken\var\versions_installations\install__shinken_enterprise.log.%timestamp%
set LOGFILE-DETAIL=C:\shinken\var\versions_installations\install__shinken_enterprise_detail.log.%timestamp%

:: Path to the file you want to check
set FILE_PATH=C:\shinken\var\context.json

mkdir C:\shinken >nul 2>&1
mkdir C:\shinken\var\ >nul 2>&1
mkdir C:\shinken\var\versions_installations >nul 2>&1


for /f "delims=" %%i in ('powershell -File InstallFiles\get_shinken_version.ps1') do set "jsonValue=%%i"



echo -------------Starting Shinken Windows Poller installation-------------------------
echo.
echo -------------Starting Shinken Windows Poller installation------------------------- >> %LOGFILE%


echo This installer is designed to install the Windows Shinken Poller %jsonValue%
echo.
echo This installer is designed to install the Windows Shinken Poller %jsonValue% >> %LOGFILE%


echo -------------System checks--------------------------------------------------------
echo.
echo -------------System checks-------------------------------------------------------- >> %LOGFILE%


echo Assert administrator rights
echo.
echo Assert administrator rights >> %LOGFILE%

net session >nul 2>&1 >>%LOGFILE-DETAIL% 2>&1
if %errorLevel% neq 0 (
    echo [ERROR] You must run this script with administrator rights.
    echo [ERROR] You must run this script with administrator rights. >> %LOGFILE%
    exit /b 1
)
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%




echo Assert no Shinken on the System
echo.
echo Assert no Shinken on the System >> %LOGFILE%
if exist %FILE_PATH% (
    echo [ERROR] Shinken Poller is already installed on your machine. Use update.cmd if you want to update Shinken.
    echo [ERROR] Shinken Poller is already installed on your machine. Use update.cmd if you want to update Shinken. >> %LOGFILE%
    exit /b 1
)
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo Assert Python 3.11 not installed on the system
echo.
echo Assert Python 3.11 not installed on the system >> %LOGFILE%
py -3.11 --version >nul 2>&1 >>%LOGFILE-DETAIL% 2>&1
if %errorlevel%==0 (
    echo [ERROR] Python 3.11 is already installed on your system and will prevent Shinken from working correctly. You need to uninstall it before installing Shinken.
    echo [ERROR] Python 3.11 is already installed on your system and will prevent Shinken from working correctly. You need to uninstall it before installing Shinken. >> %LOGFILE%
    exit /b 1
 )
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo -------------Installing Shinken Enterprise %jsonValue%----------------------------
echo.
echo -------------Installing Shinken Enterprise %jsonValue%---------------------------- >> %LOGFILE%


echo Installing Python 3.11.11
echo.
echo Installing Python 3.11.11 >> %LOGFILE%

InstallFiles\python-3.11.11-amd64.exe /quiet /passive InstallAllUsers=1 Include_tcltk=0 DefaultAllUsersTargetDir=c:\Python311 SimpleInstall=1 >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to install Python 3.11
	echo [ERROR] Failed to install Python 3.11 >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo Installing Shinken dependencies
echo.
echo Installing Shinken dependencies >> %LOGFILE%

dir /s /b "InstallFiles\*.whl" > InstallFiles/requirements.txt
c:\Python311\Scripts\pip.exe install -r InstallFiles\requirements.txt --no-warn-script-location --no-index --find-links=InstallFiles >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (

    echo [ERROR] Failed to install Python packages
	echo [ERROR] Failed to install Python packages >> %LOGFILE%
    exit /b 1
)
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo Installing Shinken Package
echo.
echo Installing Shinken Package >> %LOGFILE%
:: Copy Shinken and Shinken solutions directories
xcopy /E /I /Y .\shinken C:\shinken >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy Shinken directory
	echo [ERROR] Failed to copy Shinken directory >> %LOGFILE%
    exit /b 1
)

xcopy /E /I /Y .\shinkensolutions C:\Python311\Lib\site-packages\shinkensolutions >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (

    echo [ERROR] Failed to copy Shinken solutions directory
	echo [ERROR] Failed to copy Shinken solutions directory >> %LOGFILE%
    exit /b 1
)

:: Copy context.json and openssl.cnf files
echo F | xcopy /Y .\InstallFiles\context.json C:\shinken\var\context.json >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to copy context.json
    echo [ERROR] Failed to copy context.json >> %LOGFILE%
    exit /b 1
)


echo F | xcopy /Y .\InstallFiles\openssl.cnf C:\shinken\etc\openssl.cnf >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to copy openssl.cnf
    echo [ERROR] Failed to copy openssl.cnf >> %LOGFILE%
    exit /b 1
)

:: Create the Shinken-Poller service
sc create "Shinken-Poller" binpath= "c:\shinken\srvany\srvany.exe" DisplayName= "Shinken-Poller" >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to create Shinken-Poller service
    echo [ERROR] Failed to create Shinken-Poller service >> %LOGFILE%
    exit /b 1
)


:: Make the Shinken-Poller service automatic
sc config ""Shinken-Poller"" start=auto >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to make Shinken-Poller service automatic
	echo [ERROR] Failed to make Shinken-Poller service automatic >> %LOGFILE%
    exit /b 1
)

:: Add the "Parameters" subkey and its values
reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v Application /t REG_SZ /d "c:\Python311\python.exe" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add Application registry value
	echo [ERROR] Failed to add Application registry value >> %LOGFILE%
    exit /b 1
)

reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v AppDirectory /t REG_SZ /d "c:\shinken" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add AppDirectory registry value
	echo [ERROR] Failed to add AppDirectory registry value >> %LOGFILE%
    exit /b 1
)

reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v AppParameters /t REG_SZ /d "-X utf8 c:\shinken\bin\shinken-poller -c c:\shinken\etc\daemons\pollerd-windows.ini" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add AppParameters registry value
	echo [ERROR] Failed to add AppParameters registry value >> %LOGFILE%
    exit /b 1
)

:: Add the "Environment" value
reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller" /v Environment /t REG_MULTI_SZ /d "OPENSSL_CONF=C:\shinken\etc\openssl.cnf" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to add Environment registry value
    echo [ERROR] Failed to add Environment registry value >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%

echo Starting Shinken Service
echo.
echo Starting Shinken Service >> %LOGFILE%

:: Start the Shinken-Poller service
net start Shinken-Poller >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to start Shinken-Poller service
	echo [ERROR] Failed to start Shinken-Poller service >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo -------------Shinken Windows Poller installation completed------------------------
echo.
echo -------------Shinken Windows Poller installation completed------------------------ >> %LOGFILE%



exit /b 0




endlocal
