#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.modules.base_module.basemodule import BaseModule
from shinken.objects.module import Module as ShinkenModuleDefinition

if TYPE_CHECKING:
    from shinken.log import PartLogger


class AutoLoadedModule(BaseModule):
    enabled: bool = True
    
    
    @classmethod
    def get_autoload_configuration(cls, daemon_type: 'str', daemon_id: 'int|str', daemon_name: 'str', module_type: 'str', logger: 'PartLogger' = None) -> 'ShinkenModuleDefinition|None':
        return cls.get_autoload_auto_configuration(daemon_name, module_type, logger)
    
    
    @staticmethod
    def get_autoload_auto_configuration(daemon_name: 'str', module_type: 'str', logger: 'PartLogger' = None) -> 'ShinkenModuleDefinition|None':
        if logger and logger.is_debug():
            logger.debug('Generating a new module configuration with default setup')
        module_auto_conf = ShinkenModuleDefinition({'module_name': f'''{module_type.replace('_', '-')}--{daemon_name}''', 'module_type': module_type, 'modules': [], 'auto_configured': '1'})
        module_auto_conf.compute_hash()
        return module_auto_conf
