#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#    Thibault Cohen, thibault.cohen@savoirfairelinux.com
#    Francois Mikus, fmikus@acktomic.com
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.objects.contact import Contact

if TYPE_CHECKING:
    from shinken.configuration_incarnation import ConfigurationIncarnation


class BrokerContact(Contact):
    def __init__(self, params=None, skip_useless_in_configuration=False, configuration_incarnation: 'ConfigurationIncarnation|None' = None):
        super(BrokerContact, self).__init__(params=params, skip_useless_in_configuration=skip_useless_in_configuration)
        self.configuration_incarnation = configuration_incarnation
    
    
    def is_allowed_to_create_view_in_private_share(self) -> bool:
        if not getattr(self, 'acl_share_private', None):
            return False
        return self.acl_share_private[3] == '1'  # noqa
