%from shinkensolutions.toolbox.box_tools_string import ToolsBoxString

<div class="shinken-table-show-item-container">
    %if title:
    <h4>{{title}}</h4>
    %end
    %if not origin_item_properties_description_is_valid:
    <div class="shinken-complementary-information-data">{{!validation_state.as_html()}}</div>
    %end
    <table class="shinken-table-show-item shinken-table-info shinken-table-info-data striped shinken-table-layout-fixed">
        <thead>
            <tr>
                <th><span class="shinken-table-header">{{translate('display_origin_item.description')}}</span></th>
                <th><span class="shinken-table-header">{{translate('display_origin_item.source_key')}}</span></th>
                <th><span class="shinken-table-header">{{translate('display_origin_item.source_value')}}</span></th>
            </tr>
        </thead>
        <tbody>
            %for property_name, property_value in sorted(raw_data.items()):
                <tr class="shinken-table-source-data">
                    <td>
                        <div class="shinken-table-data">
                            {{origin_item_properties_description.get(property_name, '')}}
                        </div>
                    </td>
                    <td>
                        <div class="shinken-table-data">
                                {{ToolsBoxString.unescape_XSS(property_name)}}
                        </div>
                    </td>
                    <td>
                        <div class="shinken-table-data">
                                {{ToolsBoxString.unescape_XSS(property_value)}}
                        </div>
                    </td>
                </tr>
            %end
        </tbody>
    </table>
</div>
