#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.



class SourceImportProgression:
    def __init__(self):
        # type: () -> None
        self.step_name = ''
        self.step_count = 0
        self.max_step = 0
        self.step_progress_max = 0
        self.step_progress = 0
    
    
    def set_max_step(self, max_step):
        # type: (int) -> None
        self.max_step = max_step
    
    
    def set_current_step(self, step_name, step_count, step_progress_max=0):
        # type: (str, int, float) -> None
        self.step_name = step_name
        self.step_count = step_count
        self.step_progress_max = step_progress_max
    
    
    def set_step_progress_max(self, step_progress_max):
        # type: (float) -> None
        self.step_progress_max = step_progress_max
    
    
    def set_step_progress(self, step_progress):
        # type: (float) -> None
        self.step_progress = step_progress
    
    
    def get_current_step(self):
        # type: () -> str
        return '(%s/%s) %s %s' % (self.step_count, self.max_step, self.step_name, self._get_step_percent_progress())
    
    
    def _get_step_percent_progress(self):
        # type: () -> str
        if self.step_progress_max:
            return '%s%%' % int((float(self.step_progress) / float(self.step_progress_max)) * 100)
        else:
            return ''
