"use strict";
var CONTROLLER   = CONTROLLER || {};
CONTROLLER.Apply = (function ( self ) {
    self.controller_name     = CONTROLLER.CONST.APPLY.NAME;
    self.phase               = new SHINKEN.OBJECT.Phase();
    self.clickOnButton       = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-option-header-popup":
            case "click-on-header-popup":
            case "click-on-header":
            case "click_on_pagination_btn":
                self.set_apply_msg.clickOnButton( event, event_name, param );
                break;
            case "click_on_apply_clean_error":
                self.slide_panel.setSize__20240926( self.slide_panel.getMinSize__partAdded() );
                set_left_column_state( __STATE_ACTION_AREA_NONE );
                MANAGER.ApplySize.reset();
                break;
            case "shinken-edition-main-panel-pin-to-right":
                self.slide_panel.setSize__20240926( self.slide_panel.getMinSize__partExisting() );
                this.computeSizes();
                break;
            case "shinken-edition-main-panel-pin-to-left":
                self.slide_panel.setSize__20240926( self.slide_panel.getMinSize__partAdded() );
                this.computeSizes();
                break;
        }
    };
    self.clickOnInput        = function ( event ) {
        self.set_apply_msg.clickOnInput( event );
    };
    self.onChangeOnInput     = function ( event ) {
        var _key_code = event.keyCode || "";
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
            case SHINKEN.CONST.KEY_CODE.UP:
            case SHINKEN.CONST.KEY_CODE.DOWN:
                self.doActionAfter( "on-key-down", event );
                break;
            default:
                self.set_apply_msg.askComputeAfterChange( event.target );
                break;
        }
        self.computeSizes();
        self.slide_panel.computeSizes__20240926();
    };
    self.computeSizes        = function () {
        MANAGER.ApplySize.computeSizes();
        self.slide_panel.computeSizes__20240926();
    };
    self.onClick             = function ( event ) {
        if ( self.set_apply_msg ) {
            self.set_apply_msg.onClick( event );
        }
    };
    self.doActionAfter       = function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button_V3":
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
                self.set_apply_msg.doActionAfter( event_name, param_1, param_2, param_3 );
                break;
            case "ask-for-pop-up-close-event":
                break;
            case "click_on_button":
                switch ( param_1 ) {
                    case "display_override_difference":
                        SHINKEN.OBJECT.OVERRIDE.addDifferenceDetail( param_2, param_3 );
                        break;
                }
                break;
        }
    };
    self.clickOnSelector     = function ( event, param ) {
        self.set_apply_msg.clickOnSelector( event, param );
    };
    self.clickOnItemSelector = function ( event, parent_name, element ) {
        self.set_apply_msg.clickOnItemSelector( event, parent_name, element );
        self.computeSizes();
    };
    
    self.onResizeStart = function ( element_name ) {
    };
    self.onResizeMove  = function ( element_name, width, height ) {
    };
    self.onResizeStop  = function ( element_name ) {
    };
    
    self.onDragStart           = function ( origin_x, origin_y ) {
        self.slide_panel.onDragStart( origin_x, origin_y );
    };
    self.onDragMove            = function ( element_name, width, height ) {
        self.slide_panel.onDragMove( width, height );
        self.computeSizes();
    };
    self.onDragStop            = function () {
        self.slide_panel.onDragStop();
    };
    self.init                  = function () {
        self.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        self.slide_panel = new SHINKEN.OBJECT.SlidePanelLeftFromHtml( "apply-slide-panel", document.getElementById( "id-shinken-apply-slide-panel" ) );
        self.slide_panel.setMinSize( 800, 200 );
        self.slide_panel.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        self.slide_panel.computeSizes__20240926();
        self.slide_panel.setSize__20240926( 200 );
        setTimeout( function () {
            self.computeSizes();
        }, 100 );
        CONTROLLER.CommonUI.doActionAfter( "open_override_specific_display" );
    };
    self.initSetApplyMsg       = function ( data ) {
        self.slide_panel.setSize__20240926( 450 );
        var datetime_now          = DATE_TIME.now();
        var left_panel_date       = document.getElementById( 'left-panel-error-datetime' );
        left_panel_date.innerHTML = '<span id="left-panel-error-datetime-content">' + _( 'apply.on_date' ) + ' <span class="shinken-date">' + DATE_TIME.FORMAT.get_date( datetime_now ) + '</span> ' + _( 'apply.at' ) + '   <span class="shinken-date">' + datetime_now.toLocaleTimeString( global_lang ) + '</span></span>';
        
        self.set_apply_msg = new SHINKEN_LIST.SetUIApply( "apply_message", 100 );
        self.set_apply_msg.setHeaders( new SHINKEN_LIST.HeadersApplyMsg( "apply_message" ) );
        self.set_apply_msg.setFilters( new SHINKEN_LIST.FiltersApplyMsg( "apply_message" ) );
        self.set_apply_msg.computeLines( data );
        self.set_apply_msg.computeHtml();
        
        self.set_apply_msg.initCountersSpecific();
        
        var left_panel_content = document.getElementById( 'left-panel-error-content' );
        DOM.Service.empty( left_panel_content );
        DOM.Service.addElementTo( self.set_apply_msg.getDomElement(), left_panel_content );
        
        set_left_column_state( __STATE_ACTION_AREA_CHECKING_LOG_ERROR_FULL );
        
        self.computeSizes();
    };
    self.askComputeAfterResize = function () {
        if ( self.timeout_resize ) {
            clearTimeout( self.timeout_resize );
        }
        self.timeout_resize = setTimeout( function () {
            self.timeout_resize = null;
            self.resizeDone();
        }, 100 );
    };
    self.resizeDone            = function () {
    };
    return self;
})( CONTROLLER.Apply || {} );
document.addEventListener( "click", function ( e ) {
    CONTROLLER.Apply.onClick( e );
} );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    CONTROLLER.Apply.init();
} );
window.addEventListener( "resize", function () {
    CONTROLLER.Apply.computeSizes();
} );
MANAGER.ApplySize = (function ( self ) {
    var __dom_nav_bar;
    var __dom_parent_left_zone;
    var __dom_left_buttons;
    var __dom_left_without_buttons;
    
    var __dom_parent_left_panel_error;
    var __dom_left_panel_error_datetime;
    var __dom_left_panel_error_container;
    var __dom_left_list_fix_part;
    var __dom_left_list_scroll_part;
    var __dom_left_pagination;
    self.computeSizes                    = function () {
        this.computeSizesContentExceptButton();
        this.computeSizesPanelError();
    };
    self.computeSizesContentExceptButton = function () {
        var _height_nav_bar = DOM.Service.getBoundingClientRect( self.getDomElement_nav_bar(), DOM.CONST.STYLE.HEIGHT );
        var _height_window  = window.innerHeight;
        var _height_button  = DOM.Service.getBoundingClientRect( self.getDomElement_left_buttons(), DOM.CONST.STYLE.HEIGHT );
        DOM.Service.setStyle( self.getDomElement_left_except_buttons(), DOM.CONST.STYLE.HEIGHT, _height_window - _height_nav_bar - _height_button );
    };
    self.computeSizesPanelError          = function () {
        let _parent    = DOM.Service.getBoundingClientRect( self.getDomElement_left_except_buttons(), DOM.CONST.STYLE.HEIGHT );
        let _date_time = DOM.Service.getBoundingClientRect( self.getDomElement_left_panel_error_datetime(), DOM.CONST.STYLE.HEIGHT );
        if ( !_date_time ) {
            return;
        }
        let _container_message = DOM.Service.getBoundingClientRect( self.getDomElement_left_panel_error_container(), DOM.CONST.STYLE.HEIGHT );
        let _head              = DOM.Service.getBoundingClientRect( self.getDomElement_left_list_fix_part(), DOM.CONST.STYLE.HEIGHT );
        let _pagination        = DOM.Service.getBoundingClientRect( self.getDomElement_left_pagination(), DOM.CONST.STYLE.HEIGHT );
        
        let _padding_bottom = 12; // TODO: I DON'T KNOW HOW TO CALCULATE THAT FOR THE MOMENT
        let _size           = _parent - _date_time - _container_message - _head - _pagination - _padding_bottom;
        if ( !isNaN( _size ) ) {
            DOM.Service.setStyle( self.getDomElement_left_list_scroll_part(), DOM.CONST.STYLE.HEIGHT, _size );
        }
        else {
            console.shinken.debug( "compute size panel impossible" );
        }
    };
    
    self.getDomElement_nav_bar                    = function () {
        if ( !__dom_nav_bar ) {
            __dom_nav_bar = document.querySelector( ".shinken-menu-top-bar" );
        }
        return __dom_nav_bar;
    };
    self.getDomElement_left_parent                = function () {
        if ( !__dom_parent_left_zone ) {
            __dom_parent_left_zone = document.querySelector( "#id-shinken-left-column" );
        }
        return __dom_parent_left_zone;
    };
    self.getDomElement_left_buttons               = function () {
        if ( !__dom_left_buttons ) {
            __dom_left_buttons = self.getDomElement_left_parent().querySelector( "#id-shinken-action-area-apply" );
        }
        return __dom_left_buttons;
    };
    self.getDomElement_left_except_buttons        = function () {
        if ( !__dom_left_without_buttons ) {
            __dom_left_without_buttons = self.getDomElement_left_parent().querySelector( ".shinken-left-panel-content-except-button" );
        }
        return __dom_left_without_buttons;
    };
    self.getDomElement_left_panel_error_parent    = function () {
        if ( !__dom_parent_left_panel_error ) {
            __dom_parent_left_panel_error = self.getDomElement_left_parent().querySelector( "#left-panel-error" );
        }
        return __dom_parent_left_panel_error;
    };
    self.getDomElement_left_panel_error_datetime  = function () {
        if ( !__dom_left_panel_error_datetime ) {
            __dom_left_panel_error_datetime = self.getDomElement_left_parent().querySelector( "#left-panel-error-datetime" );
        }
        return __dom_left_panel_error_datetime;
    };
    self.getDomElement_left_panel_error_container = function () {
        if ( !__dom_left_panel_error_container ) {
            __dom_left_panel_error_container = self.getDomElement_left_parent().querySelector( ".shinken-left-panel-error-title-zone-info" );
        }
        return __dom_left_panel_error_container;
    };
    self.getDomElement_left_list_fix_part         = function () {
        if ( !__dom_left_list_fix_part ) {
            __dom_left_list_fix_part = self.getDomElement_left_parent().querySelector( ".shinken-list-container-fix-header-filter" );
        }
        return __dom_left_list_fix_part;
    };
    self.getDomElement_left_list_scroll_part      = function () {
        if ( !__dom_left_list_scroll_part ) {
            __dom_left_list_scroll_part = self.getDomElement_left_parent().querySelector( ".shinken-list-container-with-scroll" );
        }
        return __dom_left_list_scroll_part;
    };
    self.getDomElement_left_pagination            = function () {
        if ( !__dom_left_pagination ) {
            __dom_left_pagination = self.getDomElement_left_parent().querySelector( ".shinken-pagination-V3" );
        }
        return __dom_left_pagination;
    };
    
    self.reset = function () {
        __dom_nav_bar              = null;
        __dom_parent_left_zone     = null;
        __dom_left_buttons         = null;
        __dom_left_without_buttons = null;
        
        __dom_parent_left_panel_error    = null;
        __dom_left_panel_error_datetime  = null;
        __dom_left_panel_error_container = null;
        __dom_left_list_fix_part         = null;
        __dom_left_list_scroll_part      = null;
        __dom_left_pagination            = null;
    };
    return self;
})( MANAGER.ApplySize || {} );
SHINKEN_LIST.LineCellApplyMsgId           = function ( name, data ) {
    this.name  = name;
    this.value = data[ 'id' ];
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgId.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    computeLabel: function () {
        this.label = '<div class="shinken-id-content">' + this.value + '</div>';
    },
    computeHtml: function () {
        this.computeContentHtml__20241107();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgId, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellApplyMsgStatus           = function ( name, text ) {
    this.name  = name;
    this.value = text;
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgStatus.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    computeLabel: function () {
        this.label = '<div class="shinken-status-content text-break-all-pre-line" data-status="' + this.value + '">' + _( 'filter.error_level.' + this.value, [DICTIONARY_COMMON_UI] ) + '</div>';
    },
    computeHtml: function () {
        this.computeContentHtml__20241107();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgStatus, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.LineCellApplyMsgType           = function ( name, text ) {
    this.name  = name;
    this.value = text;
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgType.prototype = {
    computeLabel: function () {
        if ( this.value ) {
            this.label = '<div class="shinken-status-content" data-status="' + this.value + '">' + _( 'type.' + this.value ) + '</div>';
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgType, SHINKEN_LIST.LineCellApplyMsgStatus );
SHINKEN_LIST.LineCellApplyMsgText           = function ( name, data ) {
    this.name = name;
    this.computeValues( data );
    this.init();
};
SHINKEN_LIST.LineCellApplyMsgText.prototype = {
    init: function () {
        this.setSortingValue( this.value );
    },
    computeLabel: function () {
        this.label = '<div class="shinken-text-content">' + this.value + '</div>';
    },
    computeHtml  : function () {
        this.computeContentHtml__20241107();
        this.setDomElement( DOM.Service.createElement( "td",
            {
                class: "shinken-list-cell", "data-name": this.name,
                "shi-tip-placement"                    : "top"
            } ) );
        this.addDomElement( this.dom_element_content );
    },
    computeValues: function ( data ) {
        this.value = SHINKEN.TOOLS.STRING.cleanXss( data[ this.name ] );
        switch ( data[ 'message_type' ] ) {
            case "ELEMENT" :
                this.value = data[ 'link' ] + " - " + this.value;
                break;
        }
    },
    getDataToSave: function () {
        return null;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellApplyMsgText, SHINKEN_LIST.LineCellFromData );
SHINKEN_LIST.FilterApplyMsg           = function ( type, name ) {
    this.type = type;
    this.name = name;
    this.init();
};
SHINKEN_LIST.FilterApplyMsg.prototype = {
    init          : function () {
        this.initComponents();
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.SelectFromData( this.type );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                this.component = new COMPONENT.InputFromData();
                this.component.setPlaceholder(_( 'filter.message_placeholder' , [ DICTIONARY_COMMON_UI ]  )  );
                this.component.skipValidation( true );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterApplyMsg, SHINKEN_LIST.FilterFromData );
SHINKEN_LIST.FiltersApplyMsg           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.FiltersApplyMsg.prototype = {
    init                : function () {
        this.initContents();
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            var _to_add    = new SHINKEN_LIST.FilterApplyMsg( _current_value.FILTER_TYPE, _current_value._KEY );
            if ( _current_value.FILTER_TYPE === COMPONENT.CONST.TYPE.SINGLE_SELECT ) {
                _to_add.getComponent().setOptionsFromArray( this.computeFilterOptions( _current_value ) );
            }
            this.add( _to_add );
        }
    },
    computeFilterOptions: function ( header_info ) {
        var _to_return = [];
        var _keys      = Object.keys( header_info.FILTER_OPTIONS );
        var _current_key;
        var _to_add;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key       = _keys[ i ];
            _to_add            = { "name": header_info.FILTER_OPTIONS[ _current_key ] };
            switch ( header_info._KEY) {
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY :
                    _to_add[ 'label' ] = _( 'filter.error_level.' + _to_add.name , [ DICTIONARY_COMMON_UI ]  );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY :
                    _to_add[ 'label' ] = _( 'type.' + _to_add.name );
                    break;
    
            }
            if ( i === 0 ) {
                _to_add[ 'is_selected' ] = true;
            }
            _to_return.push( _to_add );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersApplyMsg, SHINKEN_LIST.FiltersFromData );
SHINKEN_LIST.HeaderMessageApplyMsg           = function ( type ) {
    this.type = type;
    this.initSpecific();
};
SHINKEN_LIST.HeaderMessageApplyMsg.prototype = {
    initSpecific: function () {
        this.init();
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-object-type": this.getObjectType() } ) );
        var _to_add                          = DOM.Service.createElement( "div", { class: "shinken-container" } );
        var _table                           = DOM.Service.createElement( "table", { class: "shinken-table" } );
        var _tr                              = DOM.Service.createElement( "tr" );
        var _td_1                            = DOM.Service.createElement( "td", { class: "shinken-cell-label" } );
        var _td_2                            = DOM.Service.createElement( "td", { class: "shinken-cell-filtering" } );
        var _div_1                           = DOM.Service.createElement( "div", { class: "shinken-label" }, this.label );
        this.dom_element_parent_filter       = DOM.Service.createElement( "div", { class: "shinken-filtering-apply" }, _( 'apply.header_filter_message' ) );
        var _div_2 = DOM.Service.createElement( "div", { class: "shinken-active-if-has-filter" }, _( 'apply.header_filter_message_after_filter' ) );
        
        DOM.Service.addElementTo( _table, _to_add );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _td_1, _tr );
        DOM.Service.addElementTo( _td_2, _tr );
        DOM.Service.addElementTo( _div_1, _td_1 );
        DOM.Service.addElementTo( this.dom_element_parent_filter, _td_2 );
        DOM.Service.addElementAtIndex( _div_2, this.dom_element_parent_filter, 0 );
        this.addDomElement( _to_add );
        
        this.dom_element_current_filter = this.getDomElement().querySelector( ".shinken-current-filter-value" );
        this.dom_element_total_filter   = this.getDomElement().querySelector( ".shinken-total-filter-value" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderMessageApplyMsg, SHINKEN_LIST.HeaderFromData );
SHINKEN_LIST.HeadersApplyMsg           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeadersApplyMsg.prototype = {
    init         : function () {
        this.initContents();
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        var _to_add;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            switch ( _current_value._KEY ) {
                case SHINKEN_LIST.APPLY_MSG.HEADERS.MESSAGE._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderMessageApplyMsg( this.type );
                    _to_add.name  = "message";
                    _to_add.label = "Message";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "type";
                    _to_add.label = "Type";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "error_level";
                    _to_add.label = "Statut";
                    this.add( _to_add );
                    break;
                case SHINKEN_LIST.APPLY_MSG.HEADERS.ID._KEY:
                    _to_add       = new SHINKEN_LIST.HeaderFromData( this.type );
                    _to_add.name  = "id";
                    _to_add.label = "Ligne";
                    this.add( _to_add );
                    break;
            }
        }
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersApplyMsg, SHINKEN_LIST.HeadersFromData );
SHINKEN_LIST.APPLY_MSG         = {};
SHINKEN_LIST.APPLY_MSG.HEADERS = {
    ID  : {
        _KEY        : "id",
        INDEX_COLUMN: 0,
        FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
    },
    ERROR_LEVEL: {
        _KEY          : "error_level",
        INDEX_COLUMN  : 1,
        FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
        FILTER_OPTIONS: {
            ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
            CRITICAL: "CRITICAL",
            ERROR  : "ERROR",
            WARNING: "WARNING",
        }
    },
    TYPE  : {
        _KEY        : "type",
        INDEX_COLUMN: 2,
        FILTER_TYPE : COMPONENT.CONST.TYPE.SINGLE_SELECT,
        FILTER_OPTIONS: {
            ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
            EMPTY    : SHINKEN_LIST.CONST.FILTER.EMPTY,
            NOT_EMPTY    : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
            CLUSTERS   : 'clusters',
            CLUSTERTPLS: 'clustertpls',
            HOSTS     : 'hosts',
            HOSTTPLS  : 'hosttpls',
            HOSTGROUPS: 'hostgroups',
            SERVICESHOSTS      : 'serviceshosts',
            SERVICESHOSTTPLS   : 'serviceshosttpls',
            SERVICESCLUSTERS   : 'servicesclusters',
            SERVICESCLUSTERTPLS: 'servicesclustertpls',
            SERVICETPLS        : 'servicetpls',
            CONTACTS     : 'contacts',
            CONTACTTPLS  : 'contacttpls',
            CONTACTGROUPS: 'contactgroups',
            ESCALATIONS              : 'escalations',
            NOTIFICATIONWAYS         : 'notificationways',
            COMMANDS                 : 'commands',
            TIMEPERIODS              : 'timeperiods',
        }
    },
    MESSAGE  : {
        _KEY        : "message",
        INDEX_COLUMN: 3,
        FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
    }
};
SHINKEN_LIST.LineApplyMsg           = function ( data, header ) {
    this.__class_name__ = "SHINKEN_LIST.LineApplyMsg";
    this.type           = "apply_message";
    this.initSpecific( data, header );
};
SHINKEN_LIST.LineApplyMsg.prototype = {
    initSpecific          : function ( data, header ) {
        this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        this.init(data, header);
    },
    initCellsValue: function ( data ) {
        var _headers = [];
        switch ( this.type ) {
            case "apply_message":
                _headers = SHINKEN_LIST.APPLY_MSG.HEADERS;
                break;
        }
        var _keys = Object.keys( _headers );
        var _current_value;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_value = _headers[ _keys[ i ] ];
            this.addWithFactory( _current_value._KEY, data );
        }
    },
    addWithFactory: function ( current_key, data ) {
        switch ( current_key ) {
            case SHINKEN_LIST.APPLY_MSG.HEADERS.ID._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgId( current_key, data ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.MESSAGE._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgText( current_key, data ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.TYPE._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgType( current_key, data[ current_key ] ) );
                break;
            case SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL._KEY :
                this.add( new SHINKEN_LIST.LineCellApplyMsgStatus( current_key, data[ current_key ] ) );
                break;
        }
    },
    clickOnButton: function ( event, event_name, param ) {
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "do_action_after_filter_change":
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING, this.uuid, this.is_filtered ? 0 : 1 );
                break;
            
        }
    },
    isErrorLevel      : function () {
        return this.getContent( SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL.INDEX_COLUMN ).getValue() !== SHINKEN_LIST.APPLY_MSG.HEADERS.ERROR_LEVEL.FILTER_OPTIONS.WARNING;
    },
    initFilterCounter: function (parent) {
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.setCounterParent( parent, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
    },
    computeHtml: function () {
        var _selector_css_for_tooltip = '.shinken-list-cell[data-name="name"]';
        this.dom_element              = DOM.Service.createElement( "tr", {
            class      : "shinken-list-line",
            "data-uuid": this.uuid
        } );
        this.setPhaseDomElement( this.dom_element );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    },
    getFilterStatusForInputString(_value_filter, _value_cell, _filter) {
        if ( !SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter ) ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN_LIST.LineFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineApplyMsg, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN_LIST.LinesApplyMsg           = function ( parent ) {
    this.__class_name__ = "SHINKEN_LIST.LinesApplyMsg";
    this.init( parent );
};
SHINKEN_LIST.LinesApplyMsg.prototype = {
    init: SHINKEN_LIST.LinesFromDataWithPagination.prototype.init,
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
        }
    },
    linkHeaderWithData: function ( headers ) {
    },
    getChildConstructor: function ( data, headers ) {
        return new SHINKEN_LIST.LineApplyMsg( data, headers );
    },
    initCountersSpecific: function ( parent ) {
        this.setCountersParent( parent );
        let _counter_error   = 0;
        let _counter_warning = 0;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).isErrorLevel() ? _counter_error++ : _counter_warning++;
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.__class_name__, _counter_error );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.__class_name__, _counter_warning );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, this.__class_name__, _counter_warning + _counter_error );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN_LIST.LinesFromDataWithPagination );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesApplyMsg, SHINKEN.OBJECT.PhaseInterface );
SHINKEN_LIST.SetUIApply           = function ( name, pagination_size ) {
    this.__class_name__ = "SHINKEN_LIST.SetUIApply";
    this.initSpecific( name, pagination_size );
};
SHINKEN_LIST.SetUIApply.prototype = {
    initSpecific: SHINKEN_LIST.SetFromDataWithPagination.prototype.initSpecific,
    clickOnButton: function ( event, event_name, param, param2 ) {
        switch ( event_name ) {
            case "click-on-open-view-external-urls-popup":
            case "click-on-open-change-view-owner-popup":
                this.onClick( event );
                break;
            case "copy_external_link":
            case "open_external_link":
            case "click-on-confirm-change-popup":
                this.lines.clickOnButton( event, event_name, param );
                break;
            case "delete-view":
            case "cancel_button":
                this.onClick();
                this.lines.clickOnButton( event, event_name, param, param2 );
                break;
            case "click-on-header-popup":
                this.onClick( event );
                this.headers.clickOnButton( event, event_name, param );
                break;
            case "click-on-option-header-popup":
            case "click-on-header":
                this.hidePopup();
                this.headers.clickOnButton( event, event_name, param );
                this.doActionAfterChange( { "type": "shinken-list-sorting" } );
                break;
            case "click_on_pagination_btn":
                this.pagination.doActionAfter( event_name, param );
                this.computeLinesHtml();
                break;
        }
    },
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesApplyMsg();
    },
    initCountersSpecific: function () {
        var _header_message = this.headers.getContentByUUID( "message" );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setDomElement( _header_message.dom_element_total_filter );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setDomElementLabel( _header_message.dom_element_total_filter );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).addTargetsDomElement( _header_message.dom_element_parent_filter );
        
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ).setDomElement( document.getElementById( "id-shinken-set-apply-msg-error" ) );
        
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS ).setDomElement( document.getElementById( "id-shinken-set-apply-msg-warning" ) );
        this.lines.initCountersSpecific( this );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setShowIfNull( true );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setDomElement( _header_message.dom_element_current_filter );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).setDomElementLabel( _header_message.dom_element_current_filter );
        this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING ).addTargetsDomElement( _header_message.dom_element_parent_filter );
    },
    doActionAfterSetDomElement: function () {
        this.lines.linkHeaderWithData( this.headers );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN_LIST.SetFromDataWithPagination );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetUIApply, SHINKEN.OBJECT.PhaseInterface );
