"use strict";
var WEATHER   = {};
WEATHER.CONST = {
    WIDGET_TYPE   : {
        WEATHER  : "weather",
        SEPARATOR: "separator",
        TITLE    : "title"
    },
    DEFAULT_VALUE : "default",
    PARAM         : {
        PAGE: {
            NOTIFICATIONS  : {
                _KEY  : "notifications",
                SOUND : {
                    _KEY: "sound"
                },
                VISUAL: {
                    _KEY : "visual",
                    BLINK: {
                        _KEY: "blink"
                    }
                },
                COMMON: {
                    ENABLED: "enabled"
                }
            },
            TYPE           : "type",
            WEATHER_UUID   : "weather_uuid",
            USERS          : {
                _KEY               : "users",
                COMMON             : {
                    USER_NAME: "user_name",
                    USER_UUID: "user_uuid"
                },
                OWNER_USER         : "owner_user",
                PREVIOUS_OWNER_USER: "previous_owner_user",
                CREATOR_USER       : "creator_user"
            },
            WEATHER_VERSION: "weather_version"
        }
    },
    DOM_ELEMENT   : {
        EDIT_MODE_BTN_EXTERNAL_LINKS_CONTAINER: "edit_mode_btn_external_links_container"
    },
    EXTERNAL_LINKS: {
        _KEY                 : "external_links",
        SLIDE_PANEL_FORM_NAME: "slide-panel_external-links-form",
        PARAM                : {
            DEFAULT_LINK : {
                _KEY        : "default_link",
                COMPOSED_KEY: "external_links.default_link"
            },
            URL_CF       : "url",
            CONFIGURATION: "configuration",
            LINKS                 : "links",
            LINK_PREVIEW_URL      : "link_preview_url",
            LINK_NAME             : {
                _KEY        : "link_name",
                COMPOSED_KEY: "link_name",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_UUID             : {
                _KEY        : "link_uuid",
                COMPOSED_KEY: "link_uuid",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_PROTOCOL         : {
                _KEY        : "link_protocol",
                COMPOSED_KEY: "link_protocol",
                OPTIONS     : {
                    PROTOCOL_FROM_WEBUI: "protocol_from_webui",
                    HTTPS              : "https",
                    HTTP               : "http"
                }
            },
            LINK_BASE_URL         : {
                _KEY        : "link_base_url",
                COMPOSED_KEY: "link_base_url",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_EXTERNAL_PART_URL: {
                _KEY        : "link_external_part_url",
                COMPOSED_KEY: "link_external_part_url",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            AUTHENTICATION_NEEDED : {
                _KEY        : "authentication_needed",
                COMPOSED_KEY: "authentication_needed",
                OPTIONS     : {
                    TRUE : "true",
                    FALSE: "false"
                }
            },
            INFO_BAR              : {
                _KEY            : "info_bar",
                BACKGROUND_COLOR: {
                    _KEY        : "background_color",
                    COMPOSED_KEY: "info_bar.background_color",
                    OPTIONS     : {
                        STRING_INPUT: "string_input"
                    }
                },
                LOGO_DISPLAYED  : {
                    _KEY        : "logo_displayed",
                    COMPOSED_KEY: "info_bar.logo_displayed",
                    OPTIONS     : {
                        TRUE : "true",
                        FALSE: "false"
                    }
                },
                POSITION        : {
                    _KEY        : "position",
                    COMPOSED_KEY: "info_bar.position",
                    OPTIONS     : {
                        TOP   : "top",
                        BOTTOM: "bottom"
                    }
                },
                REFRESH         : {
                    _KEY                     : "refresh",
                    CHRONO_DISPLAYED         : {
                        _KEY        : "chrono_displayed",
                        COMPOSED_KEY: "info_bar.refresh.chrono_displayed",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    },
                    GENERATION_TIME_DISPLAYED: {
                        _KEY        : "chrono_displayed",
                        COMPOSED_KEY: "info_bar.refresh.generation_time_displayed",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    }
                }
            },
            NOTIFICATIONS         : {
                _KEY  : "notifications",
                SOUND : {
                    _KEY   : "sound",
                    ENABLED: {
                        _KEY        : "enabled",
                        COMPOSED_KEY: "notifications.sound.enabled",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    }
                },
                VISUAL: {
                    _KEY : "visual",
                    BLINK: {
                        _KEY   : "blink",
                        ENABLED: {
                            _KEY        : "enabled",
                            COMPOSED_KEY: "notifications.visual.blink.enabled",
                            OPTIONS     : {
                                TRUE : "true",
                                FALSE: "false"
                            }
                        }
                    }
                }
            }
        },
        EVENTS_PARAM         : {
            EXTERNAL_LINKS       : "links_external__objects",
            LIST_LINK__UUID      : "link_list_objects__uuid",
            DEFAULT_EXTERNAL_LINK: "link__default__object",
            LINK__UUID           : "link__object__uuid",
            LINK__FORM__MAIN_LINK: "link__form__main_link_object",
            EXTERNAL_LINK_FORM   : "link__form__object"
        }
    },
    
    WINDOWS_TABS_EDITION_MESSAGE: {
        TABS     : [
            {
                name: "general"
            },
            {
                name: "widget"
            }
        ],
        INDEX_TAB: {
            GENERAL: 0,
            WIDGET : 1
        }
    },
    WINDOWS_TABS_EDIT_PART      : {
        TABS     : [
            {
                name     : "edit_tab_visual",
                is_active: true
            },
            {
                name: "edit_tab_json"
            },
            {
                name: "edit_tab_history"
            }
        ],
        INDEX_TAB: {
            VISUAL : 0,
            JSON   : 1,
            HISTORY: 2
        }
    },
    CONFIGURATION_ID_IS_OUTDATED: "configuration_id_is_outdated",
    COMPONENT                   : {
        SVG: {
            RADIO_ICON: "", //INIT DYNAMIC
            SUN       : "", //INIT DYNAMIC
            SEPARATOR : "", //INIT DYNAMIC
            UNKNOWN   : "" //INIT DYNAMIC
        }
    },
    STEP                        : {
        JS_JSON_VERIFICATION     : 1,
        CALL_BACKEND_VERIFICATION: 2,
        BACKEND_RETURN_TREATMENT : 3,
        END                      : 4
    }
};
WEATHER.CONST.isExternalLinkComposedKey = function ( composed_key ) {
    switch ( composed_key ) {
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.POSITION.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.LOGO_DISPLAYED.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.CHRONO_DISPLAYED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.GENERATION_TIME_DISPLAYED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED.COMPOSED_KEY:
            return true;
    }
    return false;
};
WEATHER.ViewHistory           = function ( name, pagination ) {
    this.init( name, pagination );
};
WEATHER.ViewHistory.prototype = {
    init        : SHINKEN.OBJECT.ViewHistory.prototype.init,
    initSpecific: function ( parent, dom_element_target, avoid_load_last_modification ) {
        this.parent = parent;
        this.initList();
        this.dom_element_parent__20240822 = dom_element_target;
        this.getDataFromBackend__20241001();
        if ( parent.last_modifications && !avoid_load_last_modification ) {
            this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, "load_last_modifications", { modifications_objects_until_init: parent.last_modifications.contents } );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "redo_last_modification":
            case "add_last_modification":
                this._updateLastModifications( "add", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] );
                break;
            case "load_last_modifications":
                for ( let i = 0, _size_i = param[ "modifications_objects_until_init" ].length; i < _size_i; i++ ) {
                    this._updateLastModifications( "add", param[ "modifications_objects_until_init" ][ i ] );
                }
                break;
            case "undo_last_modification":
                this._updateLastModifications( "remove" );
                break;
            case "clear_all_last_modifications":
                this._updateLastModifications( "clear", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.NUMBER ] );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    _updateLastModifications: function ( type_action, data ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        DOM.Service.removeElement( this.getList__20240822().getDomElement() );
        switch ( type_action ) {
            case "add":
                this.getList__20240822().addLineWithData( this.parseLastModificationDataLine( data ), 0 );
                break;
            case "remove":
                this.getList__20240822().getLines().removeContentByIndex( 0 );
                break;
            case "clear":
                this.getList__20240822().getLines().removeFirstXContent( data );
                break;
        }
        this.computeHtml();
        DOM.Service.addElementTo( this.getList__20240822().getDomElement(), this.dom_element_parent__20240822 );
    },
    getBackendUrl: function () {
        return SHINKEN.HIGHWAY.getOrigin() + "/service-weather/api/V1/get-history/" + this.getName();
    },
    parseLastModificationDataLine: function ( data ) {
        return this.parseLastModificationDataLineGrid( data );
    },
    parseBackendDataLine: function ( data ) {
        return this.parseBackendDataLineGrid( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ViewHistory, SHINKEN_GRID.ViewHistory );
WEATHER.DefaultLink = function ( data ) {
    this.initSpecific( data );
    _load_extra_lang_obj( "weather_lang" );
};
WEATHER.DefaultLink.prototype = {
    initSpecific: function ( data ) {
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK, "WEATHER.DefaultLink" );
        this.setUUID();
        this.init( data );
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "value__param__configured__from_form":
                this.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                let default_link_param                                      = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ];
                default_link_param.addParamsForEvents( this.getParamForEvents() );
                default_link_param.doActionAfter( event_name, params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                CONTROLLER.PageController.doActionAfter( "force_close_current_external_link_form" );
                break;
        }
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        let param_object           = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ) );
        param_object.doActionAfter( event_name, params );
        this.updateJsonIfNeeded( params );
    },
    _getValidOwnProperty           : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS, WEATHER.CONST.DEFAULT_VALUE ), false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    _getValidOwnChildren           : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY, "SHINKEN_PAGE.InfoBar"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY, "WEATHER.Notifications"]
        ] );
    },
    getValueForTooltip             : function ( key ) {
        switch ( key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY:
                return this.getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED:
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH )
                           .getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY :
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY )
                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ? _( "external_link_tooltip.bottom", ["weather_lang"] ) : _( "external_link_tooltip.top", ["weather_lang"] );
            default:
                return this.getValue( key );
        }
    },
    getComputeHostUrl              : function () {
        let _host = SHINKEN.HIGHWAY.getHost();
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            return "<span class='shinken-sensible'>" + _host + "</span>";
        }
        return _host;
    },
    computeUrl                     : function () {
        let _base_url     = this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY );
        this.computed_url = [
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY ) + ":/",
            _base_url || this.getComputeHostUrl(),
            COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY ),
            this.weather_uuid,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY )
        ].join( "/" );
    },
    getComputedUrl                 : function () {
        if ( !this.computed_url ) {
            this.computeUrl();
        }
        return this.computed_url;
    },
    resetComputedUrl               : function () {
        this.computed_url = null;
    },
    buildTooltip                   : function () {
        let icon_authenticate_type = this.authenticationNeeded() ? "#id-shinken-template-view .authentication-svg" : "#id-shinken-template-view .not-authentication-svg";
        let icon_protocol_type     = this.isHttps() ? "#id-shinken-template-view .https-icon-svg" : "#id-shinken-template-view .not-https-icon-svg";
        let class_to_add;
        
        let to_return                                     = document.querySelector( "#id-shinken-template-view .shinken-external-link-tooltip-template" ).innerHTML;
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_auth_icon_$$$", document.querySelector( icon_authenticate_type ).outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_part_url_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_attribute_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_protocol_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_protocol_icon_$$$", document.querySelector( icon_protocol_type ).outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_position_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY )
                                                                                                                                                                                               .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) ) );
        let background_color_view                         = DOM.Service.createElement( "span", { class: "shinken-external-link-background-color" } );
        background_color_view.style[ "background-color" ] = this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_view_$$$", background_color_view.outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_logo_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_chrono_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_generated_time_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) ) );
        
        class_to_add                = this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) === "Activé" ? "shinken-notification-sound-enable" : "shinken-notification-sound-disable";
        let sound_notification_icon = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-sound-svg' ) );
        sound_notification_icon.classList.add( class_to_add );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_icon_$$$", sound_notification_icon.outerHTML );
        
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) ) );
        
        class_to_add                = this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) === "Activé" ? "shinken-notification-blink-enable" : "shinken-notification-sound-disable";
        let blink_notification_icon = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-blink-icon' ) );
        blink_notification_icon.classList.add( class_to_add );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_icon_$$$", blink_notification_icon.outerHTML );
        
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_url$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getComputedUrl() ) );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, '"', "&quot;" );
        return to_return;
    },
    getJsonEditorInstance: function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    getUUID              : function () {
        return this.uuid;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set || SHINKEN.TOOLS.STRING.buildUUID();
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID, this.getUUID() );
        this.addJsonAnchor( this.getUUID() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.DefaultLink, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Link           = function ( data, uuid ) {
    this.initSpecific( data, uuid );
};
WEATHER.Link.prototype = {
    initSpecific: function ( data, uuid ) {
        this.setUUID( uuid );
        this.init( data );
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
        _load_extra_lang_obj( "weather_lang" );
        this.addJsonAnchor( this.getUUID() );
    },
    initAsNew   : function () {
        this.setName( _( "form.external_links.new_external_link_title" ) );
        this.setLinkUUID();
    },
    getName                               : function () {
        return this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ].getValue();
    },
    getLinkUUID                           : function () {
        return this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ].getValue();
    },
    setName                               : function ( to_set ) {
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ] = new SHINKEN.OBJECT.ParamGridPage( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY );
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ].setUserValueAndValue( to_set );
        SHINKEN.TOOLS.ARRAY.addElement( this.own_property_keys, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY );
    },
    setLinkUUID                           : function ( to_set ) {
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ] = new SHINKEN.OBJECT.ParamGridPage( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY );
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ].setUserValueAndValue( to_set || SHINKEN.TOOLS.STRING.buildUUID() );
        SHINKEN.TOOLS.ARRAY.addElement( this.own_property_keys, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY );
    },
    getLinkPropertiesWithSpecialValidation: function () {
        return {
            [ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ]: this.getName(),
            [ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ]: this.getLinkUUID()
        };
    },
    remove                                : function () {
        this.resetCounters();
        this.resetHTML();
    },
    isHttps                               : function () {
        return this.link_protocol.getValue() === WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS.HTTPS;
    },
    authenticationNeeded                  : function () {
        return this.authentication_needed.getValue() + "" === "true";
    },
    doActionAfter          : function ( event_name, params ) {
        switch ( event_name ) {
            case "enter_on_external_link_line":
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-placement", "left-bottom" );
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-type", "external-links" );
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-html", this.tooltip_html );
                SHINKEN_TOOLTIP.showTooltip( this.getDomElement() );
                break;
            case "leave_on_external_link_line":
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-placement" );
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-type" );
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-html" );
                SHINKEN_TOOLTIP.hideTooltip();
                break;
            case "default__param__configured__from_form":
                const param_to_update = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                if ( param_to_update.user_value !== param_to_update.default_value ) {
                    return;
                }
                param_to_update.addParamsForEvents( this.getParamForEvents() );
                param_to_update.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                param_to_update.doActionAfter( event_name, params );
                break;
            case "external_link__configured__from_form":
                if ( this.getUUID() !== params[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ] ) {
                    return;
                }
                let param_to_update_2;
                const composed_key_list = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ];
                for ( let i = 0; i < composed_key_list.length; i++ ) {
                    const new_value                                             = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ composed_key_list[ i ] ];
                    params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = new_value;
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]                = composed_key_list[ i ];
                    
                    param_to_update_2 = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, composed_key_list[ i ] );
                    param_to_update_2.addParamsForEvents( this.getParamForEvents() );
                    param_to_update_2.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                    param_to_update_2.doActionAfter( "value__param__configured__from_form", params );
                    
                    this.updateLinkLabelIfNeeded( composed_key_list[ i ], new_value );
                }
                this.updateJsonIfNeeded( params );
                this.resetComputedUrl();
                this.tooltip_html = this.buildTooltip();
                break;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "open_external_link":
                        if ( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] === this.getUUID() ) {
                            SHINKEN.HIGHWAY.goToBlank( this.getComputedUrl() );
                        }
                        break;
                    case "copy_external_link":
                        if ( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] === this.getUUID() ) {
                            CLIPBOARD_SERVICE.setContent( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, this.getComputedUrl(), this.copyLinkToClipboardCallback );
                        }
                        break;
                }
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
                this.updateLinkLabelIfNeeded( modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ), modification_element.getNextOrPrevious( event_name ) );
                this.resetComputedUrl();
                break;
        }
    },
    _getProtocolIcon       : function () {
        let icon_protocol_type = this.isHttps() ? "#id-shinken-template-view .https-icon-svg" : "#id-shinken-template-view .not-https-icon-svg";
        let icon_protocol      = DOM.Service.cloneElement( document.querySelector( icon_protocol_type ) );
        icon_protocol.classList.add( "shinken-weather-link-icon-https" );
        return icon_protocol;
    },
    _getAuthenticationIcon : function () {
        let icon_authenticate_type = this.authenticationNeeded() ? "#id-shinken-template-view .authentication-svg" : "#id-shinken-template-view .not-authentication-svg";
        let icon_authentication    = DOM.Service.cloneElement( document.querySelector( icon_authenticate_type ) );
        icon_authentication.classList.add( "shinken-weather-link-icon-authentication-needed" );
        return icon_authentication;
    },
    updateLinkLabelIfNeeded: function ( composed_key, new_value ) {
        switch ( composed_key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME.COMPOSED_KEY:
                this.dom_element_text_label.innerHTML = new_value.value;
                break;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED.COMPOSED_KEY :
                const new_authentication_icon = this._getAuthenticationIcon();
                DOM.Service.replaceElement( this.icon_autentication, new_authentication_icon );
                this.icon_autentication = new_authentication_icon;
                break;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY:
                const new_protocol_icon = this._getProtocolIcon();
                DOM.Service.replaceElement( this.icon_protocol, new_protocol_icon );
                this.icon_protocol = new_protocol_icon;
                break;
        }
    },
    _getValidOwnProperty   : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY, SHINKEN_VALIDATION.CONST.OTHERS.NOT_EMPTY__MAX_LENGTH__DONT_HAVE_FORBIDDEN, [300, ["'", '"', "<", ">"]], true],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " "]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS, WEATHER.CONST.DEFAULT_VALUE ), false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    
    copyLinkToClipboardCallback: function ( status, dom_button ) {
        let _text     = status ? _( "copy_service.copyExternalLinkSuccess", [DICTIONARY_COMMON_UI] ) : _( "copy_service.copyFail", [DICTIONARY_COMMON_UI] );
        let _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        let _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    },
    computeHtml      : function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.tooltip_html = this.buildTooltip();
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID, this.getUUID() );
        this.computeUrl();
        this.setDomElement( DOM.Service.createElement( "div", {
            class       : "shinken-weather-link-element",
            "data-uuid" : this.getUUID(),
            onmouseenter: "MANAGER.EventManagerV2.doActionAfter( event, 'enter_on_external_link_line'," + this.parseParamForEventsToHtml() + ")",
            onmouseleave: "MANAGER.EventManagerV2.doActionAfter( event, 'leave_on_external_link_line'," + this.parseParamForEventsToHtml() + ")",
            onclick     : "MANAGER.EventManagerV2.doActionAfter( event, 'click_on_external_link_line'," + this.parseParamForEventsToHtml() + ")"
        } ) );
        
        let btn_supp_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "delete_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-bin-svg" ) ).outerHTML, "shinken-delete-button" ), btn_supp_container );
        
        let link_name       = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-name-element" } ) );
        let label_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-label-container" } ), link_name );
        
        let dom_element_icon_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-icon-container shinken-layout-center-h-v" } ), label_container );
        this.icon_protocol             = DOM.Service.addElementTo( this._getProtocolIcon(), dom_element_icon_container );
        this.icon_autentication        = DOM.Service.addElementTo( this._getAuthenticationIcon(), dom_element_icon_container );
        
        this.dom_element_text_label = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-label-element" }, SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) ) ), label_container );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, label_container );
        
        
        let btn_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container shinken-external-link-action-buttons" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "open_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML, "shinken-open-external-link" ), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "copy_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-copy-svg" ) ).outerHTML, "shinken-copy-external-link" ), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "configure_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) ).outerHTML, "shinken-configure-external-link" ), btn_container );
        
        this.setPhaseDomElement( this.getDomElement() );
    },
    computeHtmlButton: function ( event_name, label, class_to_add, tooltip_to_add ) {
        let to_return = new COMPONENT.ButtonFromData_V3( event_name, label );
        to_return.addParamsForEvents( this.getParamForEvents() );
        to_return.computeHtml();
        if ( class_to_add ) {
            to_return.getDomElement().classList.add( class_to_add );
        }
        if ( tooltip_to_add ) {
            to_return.setTooltipHtml( tooltip_to_add );
        }
        return to_return.getDomElement();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Link, WEATHER.DefaultLink );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Link, SHINKEN.OBJECT.PhaseInterface );
WEATHER.LinkForView           = function ( data, uuid ) {
    this.initSpecific( data, uuid );
};
WEATHER.LinkForView.prototype = {
    initSpecific: WEATHER.Link.prototype.initSpecific,
    computeHtml: function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.computeUrl();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-element", "data-uuid": this.getUUID(), "shi-tip-placement": "left-bottom" } ) );
        this.setTooltipHtml( this.buildTooltip(), "external-links" );
        
        let link_name = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-name-element" } ) );
        let label     = SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) );
        
        let dom_element_icon_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-icon-container shinken-layout-center-h-v" } ), link_name );
        this.icon_protocol             = DOM.Service.addElementTo( this._getProtocolIcon(), dom_element_icon_container );
        this.icon_autentication        = DOM.Service.addElementTo( this._getAuthenticationIcon(), dom_element_icon_container );
        
        this.dom_element_text_label = DOM.Service.createElement( "div", { class: "shinken-weather-link-label-element shinken-user-select-text" }, label );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.dom_element_text_label );
        
        DOM.Service.addElementTo( this.dom_element_text_label, link_name );
        
        let btn_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container shinken-external-link-action-buttons" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "open_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML ,"", _( "views.manager.service_weather.tooltips.open_link" )), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "copy_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-copy-svg" ) ).outerHTML, "", _( "views.manager.service_weather.tooltips.copy_link" ) ), btn_container );
        
        this.setPhaseDomElement( this.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinkForView, WEATHER.Link );
WEATHER.Links = function ( data ) {
    this.init( data );
};
WEATHER.Links.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initCounterCommon();
        this.initContents();
        this.updateData( data );
        this.setUUID();
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                if ( this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) ) ) {
                    this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) ).doActionAfter( event_name, params );
                    return;
                }
                this.doActionAfter__lastModification( event_name, params );
                return;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "create_new_external_link":
                        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS, "WEATHER.ExternalLink" );
                        this.setPreviousModificationElement();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_ADD_LINK );
                        let new_link = this.add( new WEATHER.Link( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT ) ) );
                        new_link.initAsNew();
                        new_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ] = new_link;
                        this.addDomElement( new_link.getDomElement() );
                        this.updateJsonIfNeeded( params );
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK ) );
                        CONTROLLER.PageController.doActionAfter( "add_last_modification", params );
                        return;
                    case "delete_external_link":
                        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS, "WEATHER.ExternalLink" );
                        this.setPreviousModificationElement();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_REMOVE_LINK );
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = [params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ]];
                        this.removeLink( params );
                        this.updateJsonIfNeeded( params );
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK ) );
                        CONTROLLER.PageController.doActionAfter( "add_last_modification", params );
                        return;
                }
        }
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        const _uuid_list_next      = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNext().mapping );
        const _uuid_list_previous  = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious().mapping );
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK:
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _uuid_list_next, _uuid_list_previous );
                switch ( event_name ) {
                    case "undo_last_modification":
                        this.removeLink( params );
                        break;
                    case "redo_last_modification":
                        let new_link = this.add( new WEATHER.Link( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT ), params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ 0 ] ) );
                        new_link.initAsNew();
                        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
                        this.addDomElement( new_link.getDomElement() );
                        break;
                }
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK:
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _uuid_list_previous, _uuid_list_next );
                switch ( event_name ) {
                    case "redo_last_modification":
                        this.removeLink( params );
                        break;
                    case "undo_last_modification":
                        this.addLinksFromLastModification( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious(), params );
                        break;
                }
                break;
        }
        this.updateJsonIfNeeded( params );
    },
    getChildrenObject                                       : function () {
        return this.getContents();
    },
    getChildrenObjectDict                                   : function () {
        return this.getContents();
    },
    getJsonEditorInstance                                   : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    getLinksPropertiesWithSpecialValidation__WithExcludeUUID: function ( uuid_to_exclude ) {
        const to_return = [];
        let current_link;
        for ( let i = 0; i < this.getSize(); i++ ) {
            current_link = this.getContent( i );
            if ( current_link.getUUID() === uuid_to_exclude ) {
                continue;
            }
            to_return.push( current_link.getLinkPropertiesWithSpecialValidation() );
        }
        return to_return;
    },
    hasLinks           : function () {
        return !!this.getSize();
    },
    getLinkByUuid      : function ( uuid ) {
        let _current;
        for ( let i = 0, _size = this.getSize(); i < _size; i++ ) {
            _current = this.getContent( i );
            if ( uuid === _current.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ) ) {
                return _current;
            }
        }
        return null;
    },
    getChildConstructor: function ( data ) {
        return new WEATHER.Link( data );
    },
    getUUID            : function () {
        return this.uuid;
    },
    setUUID            : function ( to_set ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.addJsonAnchor( this.uuid );
    },
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    reset                       : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    setData                     : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                let to_add;
                for ( let i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    to_add = this.getChildConstructor( value[ i ] );
                    to_add.setCountersParent( this );
                    this.add( to_add );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    removeLink                  : function ( params ) {
        for ( let i = 0, _size_i = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ].length; i < _size_i; i++ ) {
            this.removeContent( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ], params );
            CONTROLLER.PageController.doActionAfter( "close_current_external_link_form_if_needed", { [ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ]: params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ] } );
        }
        this.updateJsonIfNeeded( params );
    },
    addLinksFromLastModification: function ( datas, params ) {
        for ( let i = 0, _size_i = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ].length; i < _size_i; i++ ) {
            let index = datas.mapping[ params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ] ];
            this.addLinkFromLastModification( datas.contents[ index ], params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ], params, index );
        }
    },
    addLinkFromLastModification : function ( data, uuid, params, index ) {
        let new_link = new WEATHER.Link( data, uuid );
        this.insertAtIndex( new_link, index );
        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
        DOM.Service.addElementAtIndex( new_link.getDomElement(), this.getDomElement(), index );
    },
    getDataToSave: function () {
        const _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    getLastModificationElement: function ( type_modification ) {
        let to_return;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK:
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK:
                previous = this.previous_modication_data;
                next     = this.getDataForLastModification();
                break;
        }
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        this.previous_modication_data = null;
        return to_return;
    },
    computeHtml               : function ( weather_uuid ) {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-links" } ) );
        for ( let i = 0, _size = this.getSize(); i < _size; i++ ) {
            this.getContent( i ).computeHtml( weather_uuid );
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    },
    initMessages              : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    getDataForLastModification: SHINKEN.OBJECT.EditableElementContainerInterface.prototype.getDataForLastModification
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.EditableElementContainerInterface );
WEATHER.LinksForView = function ( data ) {
    this.init( data );
};
WEATHER.LinksForView.prototype = {
    init: WEATHER.Links.prototype.init,
    getChildConstructor: function ( data ) {
        return new WEATHER.LinkForView( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinksForView, WEATHER.Links );
WEATHER.Notifications           = function ( data ) {
    this.init( data );
};
WEATHER.Notifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY, "WEATHER.SoundNotification" ],
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY, "WEATHER.VisualNotifications" ]
        ] );
    },
    getSoundNotification   : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.SOUND ];
    },
    getVisualNotifications : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.VISUAL ];
    },
    hasNotificationsEnabled: function () {
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            return true;
        }
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            return true;
        }
        return false;
    },
    playNotifications      : function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( _sizeData === 0 ) {
            return;
        }
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            this.getSoundNotification().playNotification();
        }
        this.playVisualNotifications( notifications_of_change );
    },
    playVisualNotifications: function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            for ( var i = 0; i < _sizeData; i++ ) {
                this.getVisualNotifications().playNotification( notifications_of_change[ i ] );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Notifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.NotificationInterface           = function ( data ) {
    this.init( data );
};
WEATHER.NotificationInterface.prototype = {
    _getValidOwnProperty  : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    hasNotificationEnabled: function () {
        return this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ].getValue();
    },
    playNotification: function ( notification_of_change ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.NotificationInterface, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.SoundNotification           = function ( data ) {
    this.init( data );
};
WEATHER.SoundNotification.prototype = {
    setVolume       : function ( volume ) {
        this.getAudio().volume = volume;
    },
    playNotification: function () {
        var play_promise = this.getAudio().play();
    },
    getAudio        : function () {
        if ( !this.audio ) {
            this.audio = new Audio( "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/sound/notification_of_change.mp3" );
        }
        return this.audio;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.SoundNotification, WEATHER.NotificationInterface );
WEATHER.BlinkVisualNotification           = function ( data ) {
    this.init( data );
};
WEATHER.BlinkVisualNotification.prototype = {
    playNotification: function ( notification_of_change ) {
        notification_of_change.getObjectThatChanged().blink( 3 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.BlinkVisualNotification, WEATHER.NotificationInterface );
WEATHER.VisualNotifications           = function ( data ) {
    this.init( data );
};
WEATHER.VisualNotifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY, "WEATHER.BlinkVisualNotification"]
        ] );
    },
    hasNotificationsEnabled: function () {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            return true;
        }
        return false;
    },
    playNotification: function ( notification_of_change ) {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].playNotification( notification_of_change );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.VisualNotifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
