"use strict";
var SHINKEN     = SHINKEN || {};
SHINKEN.UI      = SHINKEN.UI || {};
SHINKEN.UI.VIEW = SHINKEN.UI.VIEW || {
    VISIBILITY_RESTRICTION   : {
        HAS_EDITABLE_RIGHT: "has_editable_right",
        NONE              : null
    },
    TYPE                     : {
        WEATHER: "service_weather"
    },
    WINDOWS_PANEL_TABS       : [
        {
            name           : "views",
            controller_name: CONTROLLER.CONST.UI_PANELS_VIEW.NAME,
            is_active      : true
        }
    ],
    WINDOWS_VIEW_MANAGER_TABS: [
        {
            name           : "weather_service",
            controller_name: CONTROLLER.CONST.UI_VIEW_WEATHER_MANAGER.NAME,
            is_active      : true
        }
    ],
    ACTIONS                  : {
        CLONE_VIEW   : "clone_view",
        CHANGE_OWNER : "change_owner",
        REMOVE       : "remove",
        REMOVE_FORCED: "remove_forever",
        RESTORED     : "restore_view",
        ERRORS       : {
            USER_NOT_FOUND       : "user_not_found",
            WEATHER_NOT_FOUND    : "weather_not_found",
            CANNOT_PERFORM_ACTION: "cannot_perform_action",
            USER_RENAMED         : "user_has_been_renamed"
        }
    }
};
SHINKEN.UI.VIEW.WEATHER = SHINKEN.UI.VIEW.WEATHER || {
    TRAD_CONTAINER: "views.manager.service_weather",
    TABS          : {
        ADMINISTRATION: {
            _KEY                : "window-ui-panel-weather-administration",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.administration",
            HEADERS             : {
                CANCEL_ORDERS_IN_FORM: {
                    _KEY          : "cancel_orders_in_form",
                    INDEX_COLUMN  : 0,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                SHARES               : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 1,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME                 : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                PROBLEMS             : {
                    _KEY          : "weather_problems",
                    INDEX_COLUMN  : 3,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                CURRENT_OWNER        : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                PREVIOUS_OWNER       : {
                    _KEY        : "previous_owner",
                    INDEX_COLUMN: 5,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CREATOR              : {
                    _KEY        : "creator",
                    INDEX_COLUMN: 6,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS       : {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS        : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                },
                VIEW_BEHAVIOUR       : {
                    _KEY          : "view_behaviour",
                    INDEX_COLUMN  : 9,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL     : SHINKEN_LIST.CONST.FILTER.ALL,
                        RUNNING : SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.RUNNING,
                        DRAFT   : SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.DRAFT,
                        CREATING: SHINKEN_LIST.CONST.FILTER.VIEW_BEHAVIOUR.CREATING
                    }
                },
                ACTION               : {
                    _KEY        : "action",
                    INDEX_COLUMN: 10,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
                }
            }
        },
        RUNNING       : {
            _KEY                : "window-ui-panel-weather-running",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.running",
            HEADERS             : {
                SHARES        : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 1,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME          : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CURRENT_OWNER : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS: {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                }
            }
        },
        DELETING      : {
            _KEY                : "window-ui-panel-weather-deleting",
            LABEL_TRAD_CONTAINER: "views.manager.service_weather.window.deleting",
            HEADERS             : {
                CANCEL_ORDERS_IN_FORM: {
                    _KEY          : "cancel_orders_in_form",
                    INDEX_COLUMN  : 0,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NAME                 : {
                    _KEY        : "name",
                    INDEX_COLUMN: 2,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                DELETING_TIME        : {
                    _KEY        : "deleting_time",
                    INDEX_COLUMN: 3,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CURRENT_OWNER        : {
                    _KEY        : "current_owner",
                    INDEX_COLUMN: 4,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                CREATOR              : {
                    _KEY        : "creator",
                    INDEX_COLUMN: 6,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.STRING_INPUT
                },
                EXTERNAL_LINKS       : {
                    _KEY          : "external_links",
                    INDEX_COLUMN  : 7,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                NOTIFICATIONS        : {
                    _KEY          : "notifications",
                    INDEX_COLUMN  : 8,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY,
                        VISUAL : SHINKEN_LIST.CONST.FILTER.VISUAL,
                        AUDIO  : SHINKEN_LIST.CONST.FILTER.AUDIO
                    }
                },
                SHARES               : {
                    _KEY          : "nb_shared_links",
                    INDEX_COLUMN  : 9,
                    FILTER_TYPE   : COMPONENT.CONST.TYPE.SINGLE_SELECT,
                    FILTER_OPTIONS: {
                        ALL    : SHINKEN_LIST.CONST.FILTER.ALL,
                        WITH   : SHINKEN_LIST.CONST.FILTER.NOT_EMPTY,
                        WITHOUT: SHINKEN_LIST.CONST.FILTER.EMPTY
                    }
                },
                ACTION               : {
                    _KEY        : "action",
                    INDEX_COLUMN: 10,
                    FILTER_TYPE : COMPONENT.CONST.TYPE.HIDDEN
                }
            }
        }
    }
};
var EXTERNAL_LINKS   = {};
EXTERNAL_LINKS.CONST = {
    EXTERNAL_LINK: {
        ENUM: {
            LINK_PROTOCOL: {
                HTTP      : "http",
                HTTPS     : "https",
                FROM_WEBUI: "protocol_from_webui"
            }
        }
    }
};
SHINKEN.ELEMENT.UiCurrentUser = function ( data ) {
    this.init( data );
};
SHINKEN.ELEMENT.UiCurrentUser.prototype = {
    clickOnDefaultView: function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION.simulateClickOnDefaultView();
    },
    doActionAfter     : function ( event_name, param ) {
        switch ( event_name ) {
            case "change_value_notification_of_change_sound":
            case "change_value_notification_of_change_visual_blink":
                this.getPrefs().doActionAfter( event_name, param );
                break;
        }
    },
    _setData                         : function ( key, value ) {
        switch ( key ) {
            case "resources":
                MANAGER.DistributorResourcesManager.factory( key, value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS:
                if ( CONTROLLER.UiVisualisation ) {
                    CONTROLLER.UiVisualisation.doActionAfter( "init_default_notifications_settings", value );
                }
                break;
            case SHINKEN.ELEMENT.USER.PARAM.GROUPS:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SYNTHESIS_REPORT_ENABLED:
                this[ key ] = value;
                break;
            default:
        }
    },
    setPrefs                         : function ( value ) {
        this.getPrefs().updateData( value );
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.updateNotificationCurrentUser();
        }
    },
    setModules                       : function ( to_set ) {
        if ( SHINKEN.TOOLS.ARRAY.areEqual( to_set, this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ] ) ) {
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ]              = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ]       = SHINKEN.TOOLS.ARRAY.contains( to_set, 'event_container' );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] = SHINKEN.TOOLS.ARRAY.contains( to_set, 'webui_module_service_weather' );
        if ( CONTROLLER.NavigationBar ) {
            CONTROLLER.NavigationBar.refresh();
        }
    },
    hasEventTubModule                : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ] || false;
    },
    hasServiceWeatherModule          : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] || false;
    },
    setServers                       : function ( data ) {
        if ( this.servers === undefined ) {
            this.servers = new SHINKEN.SERVER.ShinkenServers();
        }
        this.servers.updateData( data );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_ARCHITECTURE_MODULE ] = !!this.servers.size;
        if ( CONTROLLER.NavigationBar ) {
            CONTROLLER.NavigationBar.askUpdateArchitectureExportMenu( this.servers );
        }
    },
    setName                          : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] === to_set ) {
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] = to_set;
        this.askUpdateHtml();
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.initWhenUserSet();
        }
    },
    setShinkenVersion                : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] === to_set ) {
            return;
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] = to_set;
        this.askUpdateHtml();
    },
    updateHtml                       : function () {
        if ( this.isAdmin() ) {
            if ( !this.dom_element_version_number ) {
                this.dom_element_version_number = document.getElementById( "id-shinken-version-number" );
            }
            if ( this.dom_element_version_number ) {
                this.dom_element_version_number.setAttribute( "shi-tip-html", this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] );
            }
            if ( SHINKEN.HIGHWAY.getParams( "shinken_documentation" ) ) {
                var blurred_shinken_version = "Version : <span class='shinken-sensible'>" + SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION.repeat( 4 ) +
                                              "</span><br>Patch : <span class='shinken-sensible'>" + SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION.repeat( 4 ) + "</span>";
                this.dom_element_version_number.setAttribute( "shi-tip-html", blurred_shinken_version );
            }
        }
    },
    isSynthesisReportEnabled         : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.SYNTHESIS_REPORT_ENABLED ];
    },
    canSeeViewByHash                 : function ( view_hash ) {
        if ( SHINKEN.TOOLS.STRING.startsWith( view_hash, "#/reporting" ) ) {
            return this.isSynthesisReportEnabled();
        }
        return true;
    },
    canCreateFavorite                : function () {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ] ) {
            return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ].hasRightToCreateFavoriteInPrivate()
            || (this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ][ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ].hasRight( "create" ) && this.hasGroups())
            || this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ][ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ].hasRight( "create" );
        }
        return false;
    },
    canCreateCloneFavorite                : function () {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ] ) {
            return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ].hasRightToCreateFavoriteInPrivate()
        }
        return false;
    },
    getAclSpaceShare                 : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ];
    },
    computeEllipsisLogoutButton      : function () {
        this.dom_element_user_name = document.getElementById( "id-shinken-user-name" );
        var _data                  = DOM.ServiceEllipsis.ellipsis(
            this.dom_element_user_name,
            this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ],
            "10px Lato",
            2
        );
        if ( _data.line_number === 1 ) {
            DOM.Service.setStyles( this.dom_element_user_name, { "font-size": "10px", "line-height": "20px" } );
        }
    },
    setLocalTime                     : function ( to_set ) {
        if ( CONTROLLER.UiVisualisation ) {
            CONTROLLER.UiVisualisation.setLocalTime( to_set );
        }
    },
    hasRightToCreateFavoriteInPrivate: function () {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ] ) {
            return this.acl.hasRightToCreateFavoriteInPrivate();
        }
        return false;
    },
    getDataFromBackend: function ( callback ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    self.updateData( data );
                    if ( callback ) {
                        callback();
                    }
                    break;
            }
        };
        var _error   = function ( _status, data ) {
            console.log( _( "users.errors.cannot_get_user_from_backend", [DICTIONARY_COMMON_UI] ) );
        };
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.USER.KEY, _success, _error, null, CONTROLLER.UiVisualisation.callbackAfter401 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiCurrentUser, SHINKEN.ELEMENT.UiUser );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiCurrentUser, SHINKEN.OBJECT.ShinkenObjectHtml );
