"use strict";
SHINKEN_PAGE.VISUALFORM.WIDGET  = {
    COLLAPSE_FOLDER: {
        ELEMENT       : {
            _KEY: "cf_weather_edit_widget_element_part"
        },
        DISPLAY       : {
            _KEY: "cf_weather_edit_widget_display_part"
        },
        AREAS         : {
            _KEY: "cf_weather_edit_widget_areas_part"
        },
        LEFT_AREA     : {
            _KEY: "cf_weather_edit_widget_left_area_part"
        },
        TOP_RIGHT_AREA: {
            _KEY: "cf_weather_edit_widget_top_right_area_part"
        },
        SLA_AREA      : {
            _KEY: "cf_weather_edit_widget_sla_area_part"
        },
        NAME_AREA     : {
            _KEY: "cf_weather_edit_widget_name_area_part"
        },
        RIGHT_AREA    : {
            _KEY: "cf_weather_edit_widget_right_area_part"
        },
        TITLE_AREA    : {
            _KEY: "cf_weather_edit_widget_title_area_part"
        }
    }
};
SHINKEN_PAGE.DEFAULTFORM.WIDGET = {
    COLLAPSE_FOLDER: {
        ELEMENT       : {
            _KEY: "cf_weather_default_widget_element_part"
        },
        DISPLAY       : {
            _KEY: "cf_weather_default_widget_display_part"
        },
        AREAS         : {
            _KEY: "cf_weather_default_widget_areas_part"
        },
        LEFT_AREA     : {
            _KEY: "cf_weather_default_widget_left_area_part"
        },
        TOP_RIGHT_AREA: {
            _KEY: "cf_weather_default_widget_top_right_area_part"
        },
        SLA_AREA      : {
            _KEY: "cf_weather_default_widget_sla_area_part"
        },
        NAME_AREA     : {
            _KEY: "cf_weather_default_widget_name_area_part"
        },
        RIGHT_AREA    : {
            _KEY: "cf_weather_default_widget_right_area_part"
        },
        TITLE_AREA    : {
            _KEY: "cf_weather_default_widget_title_area_part"
        },
        DIMENSION_AREA: {
            _KEY: "cf_weather_default_widget_dimension_area_part"
        }
    }
};
SHINKEN_PAGE.VISUALFORM.EXTERNAL_LINK = {
    COLLAPSE_FOLDER: {
        EXTERNAL_LINK_FORM:{
            _KEY : "cf_weather_edit_external_link_name_part"
        }
    }
};
SHINKEN.WidgetFormFactory = function ( params ) {
    let to_return;
    switch ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getWidgetType() ) {
        case WIDGET.CONST.TYPE.WEATHER:
            to_return = new SHINKEN.OBJECT.WeatherWidgetForm( params );
            break;
        case WIDGET.CONST.TYPE.SEPARATOR:
            to_return = new SHINKEN.OBJECT.SeparatorWidgetForm( params );
            break;
        case WIDGET.CONST.TYPE.TITLE:
            to_return = new SHINKEN.OBJECT.TitleWidgetForm( params );
            break;
    }
    to_return.computeHtml();
    DOM.Service.addElementToAfterEmpty( to_return.getDomElement(), document.querySelector( ".shinken-weather-form-container .shinken-extra-form-specific" ) );
    CONTROLLER.Form.setCurrentForm( to_return );
    return to_return;
};
SHINKEN.OBJECT.InterfaceWidgetForm = function ( params ) {
    this.init( "widget-visual-form", params );
};
SHINKEN.OBJECT.InterfaceWidgetForm.prototype = {
    init                : function ( name, params ) {
        this.initCommon( name );
        this.grid_object    = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ];
        this.main_grid_cell = params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ];
        this.grid_cells     = new SHINKEN.OBJECT.ShinkenObjectContainer();
        this.grid_cells.add( params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] );
        this.initialValue = params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getDataToSave();
        this.initAllContent();
        this.initPropertiesValues();
        this.properties_modified = [];
        setTimeout( () => {
            CONTROLLER.Form.isValid();
        }, 20 );
    },
    initPropertiesValues: function () {
        let current_property;
        let current_value;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            current_value    = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.initialValue, current_property.getName() );
            current_value    = current_value !== undefined ? current_value : "";
            current_property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: current_value + "" } );
            current_property.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_LINK_OBJECT_UUID, this.main_grid_cell.getUUID() );
            current_property.setPreviousModificationElement();
        }
    },
    doActionAfter                      : function ( event_name, params ) {
        switch ( event_name ) {
            case "on_key_down":
                if ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey && params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode === SHINKEN.CONST.KEY_CODE.Z ) {
                    params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].preventDefault();
                }
                break;
            case "close_form__for__widget_configuration":
                this.resetHTML();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                CONTROLLER.PageController.doActionAfter( "close_form__for__widget_configuration__done" );
                break;
            case "on_key_up":
                switch ( params[ SHINKEN.CONST.PARAM.KEY_CODE ] ) {
                    case SHINKEN.CONST.KEY_CODE.ESCAPE:
                        this.doActionAfter( "close_form__for__widget_configuration", params );
                        return;
                }
                break;
            case "change_radio_mode_done":
                this.askValidateForm( params );
                break;
            case "load_data_from_back_end":
                this.getBackendData( params );
                return;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case"cancel_form":
                        this.doActionAfter( "close_form__for__widget_configuration", params );
                        return;
                    case"change__widget_preview_zone__activity":
                        this.doActionAfter( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ], params );
                        return;
                }
                break;
            case "click_on_item_selector_done":
                this.doActionAfter( "synchronize_property_value", params );
                this.askValidateForm( params );
                return;
            case "onchange_in_input_V3_done":
                if ( params[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getName() === WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ) {
                    let shinken_element = CONTROLLER.PageController.list_element_from_webui.getContentByUUID( params[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getValue() );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ] : "" );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ] : "" );
                    this.setPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, shinken_element ? shinken_element[ WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ] : "" );
                }
                this.askValidateForm( params );
                return;
            case "ask_close_form__if_needed":
                if ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ] ) {
                    if ( !SHINKEN.TOOLS.ARRAY.contains( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ], this.main_grid_cell.getUUID() ) ) {
                        this.doActionAfter( "close_form__for__widget_configuration" );
                    }
                }
                else if ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ] ) {
                    if ( !params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ].getContentByUUID( this.main_grid_cell.getUUID() ) ) {
                        this.doActionAfter( "close_form__for__widget_configuration" );
                    }
                }
                else if ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ] ) {
                    if ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getUUID() !== this.main_grid_cell.getUUID() ) {
                        this.doActionAfter( "close_form__for__widget_configuration" );
                    }
                }
                break;
            case "widget_preview__compute_html_done":
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_LINK_OBJECT_UUID ) !== this.main_grid_cell.getUUID() ) {
                    return;
                }
                if ( this.grid_for_preview && params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_UUID ) === this.grid_for_preview.getUUID() ) {
                    this.grid_for_preview.doActionAfter( event_name, params );
                    return;
                }
                this.property_set.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME ) ).doActionAfterLastModification( event_name, params );
                return;
            case "show_form_for_widget_configuration":
                CONTROLLER.Form.isValid();
                break;
            case "ask_close_popups":
            case "mouse_up":
                this.property_set.doActionAfter( event_name, params );
                break;
            default:
                break;
        }
        this.doActionAfterCommon( event_name, params );
        this.doActionAfterShinkenElementSpecific( event_name, params );
        this.doActionAfterSpecific( event_name, params );
    },
    doActionAfterShinkenElementSpecific: function ( event_name, params ) {
    },
    doActionAfterSpecific              : function ( event_name, params ) {
    },
    getChildConstructor: function () {
        return new SHINKEN.OBJECT.PropertiesSetWidgetForm();
    },
    isWidgetInForm     : function ( widget_focus ) {
        return this.main_grid_cell.getUUID() === widget_focus.getUUID();
    },
    getMandatoryClass  : function ( property_structure ) {
        const validation    = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.main_grid_cell, SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( property_structure.COMPOSED_KEY, "." ) ).getValidOwnProperty( property_structure._KEY );
        let mandatory_class = "";
        if ( validation && validation.is_mandatory ) {
            mandatory_class = "shinken-mandatory-property";
        }
        return mandatory_class;
    },
    validateForm               : function ( params ) {
        let new_params                                                    = {};
        new_params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]          = this.grid_object;
        new_params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]    = this.grid_cells;
        new_params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]       = this.main_grid_cell.getUUID();
        new_params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ]   = this.properties_modified;
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ]                   = this.parseDataForSpecialCase( this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID, this.properties_modified ) );
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ]               = CONTROLLER.Form.isValid( params );
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_WIDGET_VALUE_MODIFICATION );
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ] = true;
        if ( this.doValidateFormSpecific( new_params ) ) {
            return;
        }
        for ( let i = 0; i < this.properties_modified.length; i++ ) {
            new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.property_set.getContentByUUID( this.properties_modified[ i ] ).getLastModificationElement() );
        }
        if ( this.grid_for_preview && new_params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ] ) {
            this.grid_for_preview.doActionAfter( "value__param__configured__from_form", new_params );
        }
        CONTROLLER.PageController.doActionAfter( "value__param__configured__from_form", new_params );
        return true;
    },
    doValidateFormSpecific     : function () {
        return false;
    },
    parseDataForSpecialCase    : function ( data ) {
        return data;
    },
    computeValidation__20241125: function ( params ) {
        this.status_validation      = COMPONENT.CONST.STATUS.VALID;
        let current_property;
        const validate_all_property = !params;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            if ( !validate_all_property && !this.properties_modified.includes( current_property.getName() ) ) {
                continue;
            }
            PROPERTY_V2.VALIDATOR.validWithParameter( current_property, this.getParameterValidation( current_property ), '"' );
            if ( validate_all_property ) {
                switch ( current_property.getName() ) {
                    case WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY:
                        if ( !this.main_grid_cell.getShinkenElement().isExisting() ) {
                            let messages = new SHINKEN.OBJECT.Messages();
                            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( "widget.weather.shinken_element_not_found" ) );
                            CONTROLLER.Form.doActionAfter( "add_message_validation", {
                                [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]  : current_property,
                                [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: messages
                            } );
                        }
                        break;
                }
            }
        }
    },
    getParameterValidation     : function ( current_property ) {
        let _composed_key = SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( current_property.getName(), "." );
        let _key          = SHINKEN.TOOLS.STRING.splitForGetLastOne( current_property.getName(), "." );
        return SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.main_grid_cell, _composed_key ).getValidOwnProperty( _key );
    },
    computeHtmlTitle          : function () {
        let title_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-title-container shinken-layout-center-h-v" } ) );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', {
            class              : "shinken-tag-help shinken-layout-center-h-v",
            "shi-tip-placement": "bottom-left",
            "shi-tip-html"     : this.getHelpHtml( this.main_grid_cell.getWidgetType() ),
            "onClick"          : "event.stopPropagation();",
            "onmouseenter"     : "SHINKEN_TOOLTIP.showTooltip(this)",
            "onmouseleave"     : "SHINKEN_TOOLTIP.hideTooltip()"
        }, "?" ), title_container );
        DOM.Service.addElementTo( this.getSpecificDomElementTitle(), title_container );
    },
    getSpecificDomElementTitle: function () {
        return DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.main_grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) );
    },
    computeHtmlActions        : function () {
        let _div_action         = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-action shinken-parent-event-listener shinken-layout-order-first", "data-controller": CONTROLLER.CONST.FORM_CONTROLLER.NAME } ) );
        let _div_action_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-table-form-container" } ), _div_action );
        let _div                = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-width-100 shinken-table-form-content shinken-layout-in-end-position" } ), _div_action_content );
        
        let _td_2          = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-form-action-cell" } ), _div );
        let _button_cancel = new COMPONENT.ButtonFromData_V3( "cancel_form" );
        _button_cancel.addClass( "shinken-cancel-form shinkon-times-bold" );
        _button_cancel.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        _button_cancel.computeHtml();
        DOM.Service.addElementTo( _button_cancel.getDomElement(), _td_2 );
    },
    getHelpHtml            : function ( weather_type ) {
        let contents = this.getHelpContents( weather_type );
        if ( !contents.length ) {
            return "";
        }
        return this.getHelpHtmlFromContents( contents );
    },
    getHelpHtmlFromContents: function ( contents ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-container", "data-help-parent-name": this.getName() } );
        contents.forEach( content => {
            DOM.Service.addElementTo( this.getHelpHtmlLineContent( content ), to_return );
        } );
        return to_return.outerHTML;
    },
    getHelpHtmlLineContent : function ( content ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-content shinken-tooltip-edit-widget" } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-title" }, content.label ), to_return );
        let element_content = this.getHelpHtmlElementContent( content );
        if ( element_content ) {
            DOM.Service.addElementTo( element_content, to_return );
        }
        return to_return;
    },
    getHelpContents        : function ( widget_type ) {
        let data = {
            weather_widget: [
                {
                    type_content: "label_&_content",
                    elements    : [
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.cancel_and_validate_actions" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_cancel" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_redo" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.back_to_visual" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_clic" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_cross" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_escape" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_configuration" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_computed" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.widget_preview" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.preview_exemple" ) }
                    ]
                }
            ],
            default       : [
                {
                    type_content: "label_&_content",
                    elements    : [
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.cancel_and_validate_actions" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_cancel" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_redo" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.back_to_visual" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_clic" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_cross" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_escape" ) },
                        { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_configuration" ) },
                        { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_computed" ) }
                    ]
                }
            ]
        };
        return widget_type === "weather_widget" ? data[ widget_type ] : data.default;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceWidgetForm, SHINKEN.OBJECT.FormSetFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceWidgetForm, SHINKEN.OBJECT.CommonFormInterface );
SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement = function () {
};
SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement.prototype = {
    initContentShinkenElement: function () {
        let widget_type_prop = this.addSpecific( new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.TYPE.COMPOSED_KEY, this.main_grid_cell.content.getValue( WIDGET.CONST.PARAM.TYPE._KEY ) ), false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        let collapse_folder  = this.addSpecific( new WEATHER.CollapseFolderShinkenElement( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.ELEMENT._KEY ), true );
        
        let prop_name = this.addSpecificToChild( this.factoryProperty__shinkenElement( WIDGET.CONST.PARAM.ITEM.NAME ), collapse_folder );
        let prop_visu = this.addSpecificToChild( this.factoryProperty__shinkenElement( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME ), collapse_folder );
        prop_name.getSelector().setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.weather_widget.content.item.default_label_selector", [DICTIONARY_COMMON_UI] ) );
        prop_visu.getSelector().setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.weather_widget.content.item.default_label_selector", [DICTIONARY_COMMON_UI] ) );
        
        let prop_uuid = this.addSpecificToChild( this.factoryProperty__shinkenElement( WIDGET.CONST.PARAM.ITEM.UUID ), collapse_folder, false, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ), collapse_folder, false, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        if ( !this.is_configured__20241216 ) {
            this.doActionAfter( "property_visibility__set", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, [ PROPERTY.COMMON.PARAM.PROPERTY_VISIBILITY ]: SHINKEN.CONST.VISIBILITY_STATE.HIDDEN
            } );
        }
        setTimeout( () => { //TODO TO CHANGE WHEN BACKEND CALL ALWAYS DONE WHEN CONFIGURATION_UUID
            this.doActionAfter( "load_data_from_back_end", {} );
        }, 0 );
    },
    initPropertiesValues     : function () {
        let current_property;
        let current_value;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            current_value    = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.initialValue, current_property.getName() );
            current_value    = current_value !== undefined ? current_value : "";
            current_property.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_LINK_OBJECT_UUID, this.main_grid_cell.getUUID() );
            
            if ( this.is_configured__20241216 && current_property.getName() === WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ) {
                const shinken_element = this.main_grid_cell.getShinkenElement();
                current_value         = shinken_element.getVisualisationName();
            }
            current_property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: current_value + "" } );
            current_property.setPreviousModificationElement();
        }
    },
    doActionAfterShinkenElementSpecific   : function ( event_name, params ) {
        switch ( event_name ) {
            case "synchronize_property_value":
                if ( params[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ) {
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                }
                else if ( params[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ) {
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                    this.synchronizeShinkenElementPropertyValue( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY, params[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] );
                }
                return;
            case "add_message_validation":
                switch ( params[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ].getName() ) {
                    case WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY:
                    case WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY:
                        this.doActionAfter( "add_message_validation", {
                            [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]  : this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ),
                            [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: params[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]
                        } );
                        break;
                }
                return;
            case "compute_form_after_undo_or_redo_last_modification":
                CONTROLLER.Form.current_form.computeValidation__20241125();
                CONTROLLER.Form.current_form.doActionAfterSpecific( this.main_grid_cell.getShinkenElement().isConfigured() ? "widget_becomes_configured" : "widget_becomes_not_configured" );
                break;
        }
    },
    doValidateFormSpecific                : function ( params ) {
        let data_widget_form = this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
        let is_new_widget    = !this.is_configured__20241216;
        if ( !is_new_widget && this.main_grid_cell.getShinkenElement().getUUID() === data_widget_form[ WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ] [ SHINKEN.OBJECT.CONST.PARAM.VALUE ] ) {
            return false;
        }
        
        let grid_cell_existing                                           = this.main_grid_cell.getObjectToJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT );
        grid_cell_existing[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] = data_widget_form[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ];
        
        for ( let i = 0; i < this.properties_modified.length; i++ ) {
            params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.property_set.getContentByUUID( this.properties_modified[ i ] ).getLastModificationElement() );
        }
        params[ WIDGET.CONST.PARAM_EVENT.WIDGET_DATA_FROM_FORM ] = data_widget_form;
        CONTROLLER.PageController.doActionAfter( "change__shinken_element__from_form", params );
        
        if ( !this.is_configured__20241216 ) {
            this.doActionAfterSpecific( "widget_becomes_configured" );
        }
        return true;
    },
    synchronizeShinkenElementPropertyValue: function ( property_name, line_grid_object ) {
        this.addToPropertyModified( property_name );
        let value = line_grid_object.getData__20241114( property_name );
        this.setPropertyValue( property_name, value );
    },
    factoryProperty__shinkenElement: function ( property_structure ) {
        let mandatory_class = this.getMandatoryClass( property_structure );
        let to_return;
        switch ( property_structure ) {
            case WIDGET.CONST.PARAM.ITEM.NAME:
            case WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME:
                to_return = new PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce( property_structure.COMPOSED_KEY, _( "grid.mode_edition.form_widget.weather_widget.content.item.label." + property_structure._KEY, [DICTIONARY_COMMON_UI] ), [WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY] );
                to_return.addClass( mandatory_class );
                break;
            case WIDGET.CONST.PARAM.ITEM.UUID:
                to_return = new PROPERTY.LabelFromData_V3( property_structure.COMPOSED_KEY, _( "grid.mode_edition.form_widget.weather_widget.content.item.label." + property_structure._KEY, [DICTIONARY_COMMON_UI] ), "" );
                to_return.addClass( mandatory_class );
                break;
        }
        return to_return;
    },
    getBackendData  : function ( params ) {
        this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ).setPhase( SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
        this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ).setPhase( SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
        let func_updateSelectorsContent = () => {
            func_createSelectors( WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY );
            func_createSelectors( WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY );
            this.doActionAfter( "add_main_selector_content", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]  : WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY,
                [ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ]: CONTROLLER.PageController.selectors_once[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ]
            } );
            this.doActionAfter( "add_main_selector_content", {
                [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]  : WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY,
                [ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ]: CONTROLLER.PageController.selectors_once[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ]
            } );
        };
        let func_createSelectors        = ( property_name ) => {
            CONTROLLER.PageController.selectors_once = CONTROLLER.PageController.selectors_once || {};
            if ( CONTROLLER.PageController.selectors_once[ property_name ] ) {
                return;
            }
            CONTROLLER.PageController.selectors_once[ property_name ] = new COMPONENT.SingleSelectWithResearchFromData_V3( property_name, null, [WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY] );
            CONTROLLER.PageController.selectors_once[ property_name ].setDefaultLabelForSelector( _( "grid.mode_edition.form_widget.weather_widget.content.item.default_label_selector", [DICTIONARY_COMMON_UI] ) );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.computeLines( CONTROLLER.PageController.list_element_from_webui.getContents() );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.computeHtml();
            CONTROLLER.PageController.selectors_once[ property_name ].computeHtml();
            CONTROLLER.PageController.selectors_once[ property_name ].addDomElement( CONTROLLER.PageController.selectors_once[ property_name ].list_element.getDomElement() );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            CONTROLLER.PageController.selectors_once[ property_name ].list_element.doActionAfter( "update_counter__with_children" );
        };
        if ( CONTROLLER.PageController.list_element_from_webui ) {
            func_updateSelectorsContent();
            return;
        }
        let success = ( _status, data ) => {
            data = this.parseBackendData( data );
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    CONTROLLER.PageController.list_element_from_webui = new SHINKEN.OBJECT.ShinkenObjectContainer();
                    let current;
                    for ( let i = 0, _size_i = data.length; i < _size_i; i++ ) {
                        current = new SHINKEN.OBJECT.ShinkenElement();
                        current.init( data[ i ] );
                        current[ WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.NAME._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY ] = current[ WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.UUID._KEY ];
                        current[ WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY ]               = current[ WIDGET.CONST.PARAM.ITEM.TYPE._KEY ];
                        CONTROLLER.PageController.list_element_from_webui.add( current );
                    }
                    func_updateSelectorsContent();
                    break;
                case COMMUNICATION.CODE.NOT_FOUND:
                    SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "communication.unknown_call", [DICTIONARY_COMMON_UI] ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
                    break;
            }
        };
        SHINKEN.COMUNICATION.requestGet_withTimeout( 10, "/service-weather/widget-configuration/list-elements", success );        //NEED TO ADD TIMEOUT IN ORDER TO SEE ( ALWAYS ) THE SPINNER...
    },
    parseBackendData: function ( data ) {
        return data; //NEEDED FOR SHINKEN DOCUMENTATION
    },
    getFakeDataShinkenElementData: function ( nb_to_generate ) {
        const to_return = [];
        for ( let i = 0; i < nb_to_generate; i++ ) {
            let str_i = +i.toString();
            to_return.push( {
                "item_name": str_i + "", "item_type": "host", "uuid": "uuid-" + str_i, "visualisation_name": "visu-" + str_i
            } );
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.OBJECT.PropertiesSetWidgetForm           = function () {
    this.initContentsSpecific();
};
SHINKEN.OBJECT.PropertiesSetWidgetForm.prototype = {
    initContentsSpecific: SHINKEN.OBJECT.PropertiesSet.prototype.initContentsSpecific,
    doActionAfter: function ( event_name, params ) {
        let _current_prop;
        
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                const property = this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME ) );
                property.doActionAfterLastModification( event_name, params );
                break;
            default:
                this.doActionAfterCommon( event_name, params );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PropertiesSetWidgetForm, SHINKEN.OBJECT.PropertiesSet );
PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce           = function ( property_name, label, extra_columns ) {
    this.initSpecific( property_name, [], label, extra_columns );
};
PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce.prototype = {
    initSpecific    : PROPERTY.SingleSelectWithResearchFromData_V3.prototype.initSpecific,
    initMainSelector: function ( data_option_array, extra_columns ) {
        this.setComponentSelector( new COMPONENT.SingleSelectWithResearchFromData_V3( this.getName(), null, extra_columns ) );
    },
    doActionAfter      : function ( event_name, params ) {
        switch ( event_name ) {
            case "add_main_selector_content":
                params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "clean_filter" );
                params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "clean_selected_element" );
                params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "add_message_validation", { [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: this.component_selector.getMessage__2024_12_16() } );
                
                params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: this.component_selector.getValue() } );
                params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ].doActionAfter( "reset_display" );
                this.setComponentSelector( params[ PROPERTY.SELECT.PARAM.SELECTOR_OBJECT ] );
                DOM.Service.addElementToAfterEmpty( this.component_selector.getDomElement(), this.dom_cell_action );
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.LOADING_DATA );
                return;
        }
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfterChange: function ( validation_done ) {
        this.component_selector.doActionAfter( "ask_apply_filter" );
    },
    addClass: function ( to_add ) {
        this.class_to_add = to_add;
    },
    computeHtml_getClassContainer: function () {
        return "shinken-element-property-line-V3 shinken-layout-column-start-h " + this.class_to_add;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithResearchFromData_V3_computeOnce, PROPERTY.SingleSelectWithResearchFromData_V3 );
WEATHER.VisualForm           = function ( name ) {
    this.init( name );
};
WEATHER.VisualForm.prototype = {
    init          : function ( name ) {
        this.initCommon( name );
        this.initAllContent();
        this.setPhaseDomElement( document.querySelector( ".shinken-weather-form-container" ) );
    },
    initAllContent: function () {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY ) ), true );
        widget_cf.addClass( "shinken-collapse-disabled" );
        widget_cf.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
        
        let widget_modes = this.addSpecificToChild( new SHINKEN.OBJECT.WidgetRadioModes( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY ), widget_cf );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSelect( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT ) );
        let widget_mode_add = widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeAdd( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD ) );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSpaceCreate( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE ) );
        widget_modes.add( new SHINKEN.OBJECT.RadioWidgetModeSpaceDelete( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE ) );
        
        let widget_mode_add_radios = this.addSpecificToChild( new SHINKEN.OBJECT.AddRadioModes( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.RADIOS._KEY ), widget_mode_add );
        widget_mode_add_radios.add( new WEATHER.AddRadioModeWeather( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.WEATHER_ADD ) );
        widget_mode_add_radios.add( new WEATHER.AddRadioModeSeparator( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.SEPARATOR_ADD ) );
        
        widget_modes.setPhaseDomElement( CONTROLLER.PageController.current_page.getDomElement(), SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY );
    },
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "compute_linked_objects":
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY ).resetCountersByType( [SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL] );
                CONTROLLER.PageController.current_page.content.grids.setCounterParent( this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS._KEY ), SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
                break;
            default:
                for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, params );
                }
                break;
        }
    },
    
    computeHtmlActions: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.VisualForm, SHINKEN.OBJECT.GridPageVisualForm );
SHINKEN.OBJECT.SeparatorWidgetForm = function ( params ) {
    this.init( "widget-visual-form", params );
};
SHINKEN.OBJECT.SeparatorWidgetForm.prototype = {
    init: SHINKEN.OBJECT.InterfaceWidgetForm.prototype.init,
    initAllContent: function () {
        const _title = this.factoryProperty__separator( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL );
        _title.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.content.layout.information_to_display.title_area.label.input.placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( _title );
        
        this.addSpecific( this.getCollapseFolder__widgetSeparator__content(), true );
        this.addSpecific( this.getCollapseFolder__widgetSeparator__leftArea(), true );
        this.addSpecific( this.getCollapseFolder__widgetSeparator__rightArea(), true );
        this.addSpecific( this.getCollapseFolder__widgetSeparator__titleArea(), true );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SeparatorWidgetForm, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SeparatorWidgetForm, SHINKEN.OBJECT.SeparatorWidgetFormInterface );
SHINKEN.OBJECT.TitleWidgetForm = function ( params ) {
    this.init( "widget-visual-form", params );
};
SHINKEN.OBJECT.TitleWidgetForm.prototype = {
    
    initAllContent: function () {
        this.initContentTitleArea();
    },
    
    initContentTitleArea: function () {
        let _title = this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL );
        _title.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.content.layout.information_to_display.title_area.label.input.placeholder", [DICTIONARY_COMMON_UI] ) } );
        this.addSpecific( _title );
        
        this.addSpecific( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ) );
        this.addSpecific( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ) );
        this.addSpecific( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ) );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleWidgetForm, SHINKEN.OBJECT.InterfaceWidgetForm );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleWidgetForm, SHINKEN.OBJECT.TitleWidgetFormInterface );
SHINKEN.OBJECT.WeatherWidgetForm = function ( params ) {
    this.init( "widget-visual-form", params );
};
SHINKEN.OBJECT.WeatherWidgetForm.prototype = {
    init: SHINKEN.OBJECT.InterfaceWidgetForm.prototype.init,
    doActionAfterSpecific: function ( event_name, param ) {
        switch ( event_name ) {
            case "slide_panel__size__has_changed":
                if ( this.grid_for_preview ) {
                    this.grid_for_preview.doActionAfter( event_name, param );
                }
                break;
            case "change_radio_mode_done":
                this.synchronizationProperty( param );
                this.synchronizationPreviewWithProperty( param );
                break;
            case "widget_becomes_configured":
                this.is_configured__20241216 = true;
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( "grid_for_preview" ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.NORMAL );
                this.getContentByUUID( "grid_for_preview" ).computeSizes();
                break;
            case "widget_becomes_not_configured":
                this.is_configured__20241216 = false;
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.property_set.getContentByUUID( WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                this.getContentByUUID( "grid_for_preview" ).setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
        }
    },
    initAllContent: function () {
        this.is_configured__20241216 = this.main_grid_cell.getShinkenElement().isConfigured();
        this.initContentShinkenElement();
        this.addSpecific( this.getCollapseFolder__widgetWeather__display(), true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecific( this.getCollapseFolder__widgetWeather__areas(), true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        
        this.grid_for_preview = new SHINKEN_GRID.GridForPreview( this.getInitialDataForPreviewWidget() );
        this.grid_for_preview.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        this.grid_for_preview.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_LINK_OBJECT_UUID, this.main_grid_cell.getUUID() );
        this.grid_cell_for_preview = this.grid_for_preview.grid_elements.getContent( 0 );
        this.addSpecific( this.grid_for_preview, true, this.is_configured__20241216 ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        
        this.addSpecific( this.getCollapseFolder__widgetWeather__leftArea(), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecific( this.getCollapseFolder__widgetWeather__topRightArea(), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecific( this.getCollapseFolder__widgetWeather__slaArea(), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecific( this.getCollapseFolder__widgetWeather__nameArea(), true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
    },
    synchronizationPreviewWithProperty: function ( param ) {
        switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED.COMPOSED_KEY:
                let property = this.property_set.getContentByUUID( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
                let value    = property.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                if ( !value[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] || value[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === "false" ) {
                    this.getContentByUUID( param[ SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW ] ).doActionAfter( "hide_collapse_folder" );
                }
                break;
        }
    },
    parseDataForSpecialCase: function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( data[ _keys[ i ] ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI ) {
                data[ _keys[ i ] ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] = this.parseTilesBackgroundValueForPreview( _keys[ i ] );
            }
        }
        return data;
    },
    
    
    getSpecificDomElementTitle: function () {
        let to_return;
        if ( this.is_configured__20241216 ) {
            to_return = DOM.Service.createElement( 'div', { class: "shinken-form-title-content" } );
            DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.main_grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) ), to_return );
            DOM.Service.addElementTo( DOM.Service.createElement( 'span', { class: "shinken-form-title" }, this.main_grid_cell.content.getNameToDisplay() ), to_return );
        }
        else {
            to_return = DOM.Service.createElement( 'span', { class: "shinken-form-title" }, _( "grid.mode_edition.form_widget." + this.main_grid_cell.getWidgetType() + ".title", [DICTIONARY_COMMON_UI] ) );
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WeatherWidgetForm, SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WeatherWidgetForm, SHINKEN.OBJECT.WeatherWidgetFormInterface );
WEATHER.AddRadioModeWeather           = function ( name ) {
    this.initSpecific( name );
};
WEATHER.AddRadioModeWeather.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.setLabel( WIDGET.Weather.prototype.getTypeLabel() );
    },
    
    getIconHtml: function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.RADIO_ICON ) {
            WEATHER.CONST.COMPONENT.SVG.RADIO_ICON = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-radio-button-svg" ) ).outerHTML;
        }
        return WEATHER.CONST.COMPONENT.SVG.RADIO_ICON;
    },
    getLabelDomElement: function () {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-label-container shinken-layout-center-h-v" } );
        DOM.Service.addElementTo( WIDGET.Weather.prototype.getIconTypeDom(), to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), to_return );
        return to_return;
    },
    callbackForPhase  : function () {
         switch ( this.getCurrentPhase() ){
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                CONTROLLER.PageController.doActionAfter("change_virtual_add_grid_cell", {[SHINKEN.OBJECT.RADIOMODE.PARAM.NAME] : this.name } );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.AddRadioModeWeather, SHINKEN.OBJECT.RadioMode );
WEATHER.AddRadioModeSeparator           = function ( name ) {
    this.initSpecific( name );
};
WEATHER.AddRadioModeSeparator.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name );
        this.setLabel( WIDGET.Separator.prototype.getTypeLabel() );
        
    },
    
    getIconHtml: function () {
        return WEATHER.AddRadioModeWeather.prototype.getIconHtml();
    },
    
    getLabelDomElement: function () {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-label-container shinken-layout-center-h-v" } );
        DOM.Service.addElementTo( WIDGET.Separator.prototype.getIconTypeDom(), to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), to_return );
        return to_return;
    },
    callbackForPhase  : function () {
         switch ( this.getCurrentPhase() ){
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                CONTROLLER.PageController.doActionAfter("change_virtual_add_grid_cell", {[SHINKEN.OBJECT.RADIOMODE.PARAM.NAME] : this.name } );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.AddRadioModeSeparator, SHINKEN.OBJECT.RadioMode );
WEATHER.DefaultForm = function ( name, params ) {
    this.init( name, params );
};
WEATHER.DefaultForm.prototype = {
    init                : SHINKEN.OBJECT.GridPageDefaultForm.prototype.init,
    initAllContent      : function ( user_prefs ) {
        let prefs = user_prefs.getValueByKey( [this.getName()] );
        this.initWeatherWidgetDefault( prefs );
        this.initTitleWidgetDefault( prefs );
        this.initSeparatorWidgetDefault( prefs );
        this.initExternalLinkDefault( prefs );
    },
    
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.DefaultForm, SHINKEN.OBJECT.GridPageDefaultForm );
WEATHER.CollapseFolderShinkenElement           = function ( name, is_configured ) {
    this.initSpecific( name, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_shinken_element", [DICTIONARY_COMMON_UI] ) );
};
WEATHER.CollapseFolderShinkenElement.prototype = {
    initSpecific: SHINKEN.OBJECT.CollapseFolderFromData.prototype.initSpecific,
    computeSpecificHtml: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.CollapseFolderShinkenElement, SHINKEN.OBJECT.CollapseFolderFromData );
WEATHER.ViewHistory           = function ( name, pagination ) {
    this.init( name, pagination );
};
WEATHER.ViewHistory.prototype = {
    init        : SHINKEN.OBJECT.ViewHistory.prototype.init,
    initSpecific: function ( parent, dom_element_target, avoid_load_last_modification ) {
        this.parent = parent;
        this.initList();
        this.dom_element_parent__20240822 = dom_element_target;
        this.getDataFromBackend__20241001();
        if ( parent.last_modifications && !avoid_load_last_modification ) {
            this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, "load_last_modifications", { modifications_objects_until_init: parent.last_modifications.contents } );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "redo_last_modification":
            case "add_last_modification":
                this._updateLastModifications( "add", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] );
                break;
            case "load_last_modifications":
                for ( let i = 0, _size_i = param[ "modifications_objects_until_init" ].length; i < _size_i; i++ ) {
                    this._updateLastModifications( "add", param[ "modifications_objects_until_init" ][ i ] );
                }
                break;
            case "undo_last_modification":
                this._updateLastModifications( "remove" );
                break;
            case "clear_all_last_modifications":
                this._updateLastModifications( "clear", param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.NUMBER ] );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    _updateLastModifications: function ( type_action, data ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        DOM.Service.removeElement( this.getList__20240822().getDomElement() );
        switch ( type_action ) {
            case "add":
                this.getList__20240822().addLineWithData( this.parseLastModificationDataLine( data ), 0 );
                break;
            case "remove":
                this.getList__20240822().getLines().removeContentByIndex( 0 );
                break;
            case "clear":
                this.getList__20240822().getLines().removeFirstXContent( data );
                break;
        }
        this.computeHtml();
        DOM.Service.addElementTo( this.getList__20240822().getDomElement(), this.dom_element_parent__20240822 );
    },
    getBackendUrl: function () {
        return SHINKEN.HIGHWAY.getOrigin() + "/service-weather/api/V1/get-history/" + this.getName();
    },
    parseLastModificationDataLine: function ( data ) {
        return this.parseLastModificationDataLineGrid( data );
    },
    parseBackendDataLine: function ( data ) {
        return this.parseBackendDataLineGrid( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ViewHistory, SHINKEN_GRID.ViewHistory );
SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION = (function ( self ) {
    "use strict";
    self.askEnterEditMode = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenEnterEditMode();
            }
        }
        catch ( e ) {
            console.warn( "askEnterEditMode", e );
        }
    };
    self.askLeaveEditMode = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenLeaveEditMode();
            }
        }
        catch ( e ) {
            console.warn( "askLeaveEditMode", e );
        }
    };
    self.askOpenHelp      = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenOpenHelp();
            }
        }
        catch ( e ) {
            console.warn( "askOpenHelp", e );
        }
    };
    self.listenSaveDone   = function () {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenSaveDone();
            }
        }
        catch ( e ) {
            console.warn( "listenSaveDone", e );
        }
    };
    self.askSaveUserPrefs = function ( key, value ) {
        try {
            if ( window.parent.EXTERNAL ) {
                window.parent.EXTERNAL.IFRAME.LISTENER.listenSaveUserSinglePref( key, value );
            }
        }
        catch ( e ) {
            console.warn( "askSaveUserPrefs", e );
        }
    };
    self.getUserPref      = function ( pref_name ) {
        try {
            if ( window.parent.EXTERNAL ) {
                return window.parent.EXTERNAL.IFRAME.LISTENER.listenGetUserPref( pref_name );
            }
        }
        catch ( e ) {
            console.warn( "getUserPref", e );
        }
        return {};
    };
    
    return self;
})( SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION || {} );
WEATHER.SlidePanelLinksForm           = function ( params ) {
    this.initSpecific( params );
};
WEATHER.SlidePanelLinksForm.prototype = {
    initSpecific     : function ( params ) {
        this.name = "slide-panel-external-links";
        this.initExternalLinks( params );
        this.initSlidePanel();
        this.setPhaseDomElement( this.parent_dom_element );
    },
    initExternalLinks: function ( params ) {
        this.parent_dom_element = document.querySelector( ".shinken-weather-form-container .shinken-extra-form-specific" );
        this.page_object        = params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ];
        this.computeExternalLinksHTML( params );
        this.computeHtmlActions();
    },
    initSlidePanel   : function () {
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM );
        this.init( WEATHER.CONST.EXTERNAL_LINKS.SLIDE_PANEL_FORM_NAME, this.external_link_dom_element );
        this.setInitialSize( SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.getUserPref( SHINKEN_PAGE.CONST.USER_PREFS.NAME )[ this.getName() ] );
        this.setMinSize( 170, 200 );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
    },
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "on_key_up":
                switch ( params[ SHINKEN.CONST.PARAM.KEY_CODE ] ) {
                    case SHINKEN.CONST.KEY_CODE.ESCAPE:
                        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) || this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
                            this.computeCurrentLinkWithParam( params );
                            this.doActionAfter( "close_current_external_link_form", params );
                        }
                        else {
                            this.doActionAfter( "close_external_link_slide_panel", params );
                        }
                        return;
                    case SHINKEN.CONST.KEY_CODE.UP:
                    case SHINKEN.CONST.KEY_CODE.DOWN:
                        if ( this.current_link ) { // TODO CHANGER ICI en 5.1
                            this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                        }
                        if ( this.form__external__link ) {
                            this.current_link = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].getNextOrPreviousLinks( this.form__external__link.getLinkUUID(), params[ SHINKEN.CONST.PARAM.KEY_CODE ] === SHINKEN.CONST.KEY_CODE.UP );
                        }
                        else {
                            this.current_link = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].getFirstOrLastLink( params[ SHINKEN.CONST.PARAM.KEY_CODE ] === SHINKEN.CONST.KEY_CODE.DOWN );
                        }
                        if ( this.current_link ) {
                            this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                            break;
                        }
                }
                break;
            case "click_on_external_link_line":
                this.computeCurrentLinkWithParam( params );
                if ( this.isSameForm() ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                    return;
                }
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                break;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "delete_external_link":
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].doActionAfter( event_name, params );
                        if ( this.form__external__link ) {
                            this.form__external__link.doActionAfter( "external_link_have_been_deleted_or_created", params );
                        }
                        return;
                    case "configure_external_link":
                        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) && this.isCurrentLinkSameAsParams( params ) ) {
                            return;
                        }
                        this.computeCurrentLinkWithParam( params );
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                        return;
                    case "create_new_external_link":
                        if ( this.current_link ) {
                            this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                        }
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].doActionAfter( event_name, params );
                        this.current_link = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ];
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                        return;
                }
                break;
            case "force_close_current_external_link_form":
                if ( this.current_link ) {
                    this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                }
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                break;
            case "close_current_external_link_form":
                this.computeCurrentLinkWithParam( params );
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) && this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                    return;
                }
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                break;
            case "ask_close_form__if_needed":
            case "close_external_link_slide_panel":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                this.resetHTML();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                CONTROLLER.PageController.doActionAfter( "close_form__for__link_configuration__done" );
                return;
            case "close_current_external_link_form_if_needed":
                if ( this.form__external__link && this.current_link.getUUID() !== params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] ) {
                    return;
                }
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                return;
            case "on_drag_stop":
                this.computeSizes__20240926();
                break;
        }
        if ( this.form__external__link ) {
            this.form__external__link.doActionAfter( event_name, params );
        }
        this.doActionAfterCommon( event_name, params );
    },
    computeExternalLinksHTML: function ( params ) {
        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].computeHtml();
        this.external_link_dom_element = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].getDomElement();
        DOM.Service.addElementToAfterEmpty( this.external_link_dom_element, this.parent_dom_element );
    },
    buildResetContent       : function () {
        const to_return       = DOM.Service.createElement( "div", { class: "shinken-weather-external-link-form-main-container" } );
        this.window_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-external-link-form-window-container" } ), to_return );
        DOM.Service.addElementTo( this._getWaitingScreen(), this.window_container );
        return to_return;
    },
    _getWaitingScreen       : function () {
        if ( !this.waiting_screen ) {
            this.waiting_screen = this.buildWaitingScreen();
        }
        return this.waiting_screen;
    },
    buildWaitingScreen      : function () {
        let Help      = DOM.Service.Help;
        let to_return = new Help.Help( "shinken-waiting-screen" );
        DOM.Service.addElementTo( Help.HelpTitle( _( "form.external_links.waiting_screen.title" ) ), to_return );
        let content = DOM.Service.addElementTo( Help.HelpContent(), to_return );
        DOM.Service.addElementTo( Help.HelpList( [
            Help.HelpPointList( Help.HelpLabel( Help.HelpClone( ".shinken-button-V3[data-name='create_new_external_link']" ), _( "form.external_links.waiting_screen.create_link_explication" ) ), Help.HelpComment( _( "form.external_links.waiting_screen.create_link_note" ) ) ),
            Help.HelpPointList( Help.HelpLabel( Help.HelpClone( "#id-shinken-template-view .shinken-bin-svg" ), _( "form.external_links.waiting_screen.delete_link_explication" ) ), Help.HelpComment( _( "form.external_links.waiting_screen.delete_link_note" ) ) ),
            Help.HelpPointList( Help.HelpLabel( Help.HelpClone( "#id-shinken-template-view .shinken-open-link-svg" ), _( "form.external_links.waiting_screen.open_link_explication" ) ) ),
            Help.HelpPointList( Help.HelpLabel( Help.HelpClone( "#id-shinken-template-view .shinken-copy-svg" ), _( "form.external_links.waiting_screen.copy_link_explication" ) ) ),
            Help.HelpPointList( Help.HelpLabel( Help.HelpClone( "#id-shinken-template-view .shinken-cog-svg" ), _( "form.external_links.waiting_screen.configure_link_explication" ) ), Help.HelpComment( _( "form.external_links.waiting_screen.configure_link_note" ) ) ),
            Help.HelpPointList(
                Help.HelpLabel(
                    Help.HelpContainerSpan( [
                        Help.HelpClone( "#id-shinken-template-view .https-icon-svg" ),
                        Help.HelpText( "/" ),
                        Help.HelpClone( "#id-shinken-template-view .not-https-icon-svg" )
                    ] ),
                    _( "form.external_links.waiting_screen.link_protocol_explication" )
                ) ),
            Help.HelpPointList(
                Help.HelpLabel(
                    Help.HelpContainerSpan( [
                        Help.HelpClone( "#id-shinken-template-view .authentication-svg" ),
                        Help.HelpText( "/" ),
                        Help.HelpClone( "#id-shinken-template-view .not-authentication-svg" )
                    ] ),
                    _( "form.external_links.waiting_screen.authentication_explication" )
                ) ),
            Help.HelpPointList(
                Help.HelpLabel(
                    Help.HelpContainerSpan( [
                        Help.HelpButtonAction( "⬆" ),
                        Help.HelpText( _( "form.external_links.waiting_screen.and" ) ),
                        Help.HelpButtonAction( "⬇" )
                    ] ),
                    _( "form.external_links.waiting_screen.change_link_explication" )
                ) )
        ] ), content );
        return to_return;
    },
    computeHtmlActions      : function () {
        let _button_cancel = new COMPONENT.ButtonFromData_V3( "close_external_link_slide_panel" );
        _button_cancel.addClass( "shinken-cancel-form shinkon-times-bold" );
        _button_cancel.computeHtml();
        DOM.Service.addElementAtIndex( _button_cancel.getDomElement(), this.external_link_dom_element.querySelector( ".shinken-weather-external-links-header" ), 0 );
    },
    resetHTML               : function () {
        DOM.Service.empty( this.parent_dom_element );
        if ( this.current_link ) {
            this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
        }
        this.current_link              = null;
        this.parent_dom_element        = null;
        this.external_link_dom_element = null;
        this.window_container          = null;
        this.form__external__link      = null;
        this.resetHTMLCommon();
    },
    getController_20241003     : function () {
        return CONTROLLER.PageController;
    },
    isSameForm                 : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) || this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
            return this.form__external__link.isLinkInForm( this.current_link );
        }
        return false;
    },
    isCurrentLinkSameAsParams  : function ( params ) {
        return this.form__external__link.getLinkUUID() === params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ];
    },
    computeCurrentLinkWithParam: function ( params ) {
        if ( this.current_link ) {
            this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
        }
        this.current_link = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].getLinkByUuid( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] || this.form__external__link.getLinkUUID() );
    },
    isActive                   : function () {
        return (this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) || this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) || this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RESET ));
    },
    callbackForPhase: function () {
        const _current = this.getCurrentPhase();
        let params     = {};
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RESET:
                if ( this.form__external__link ) {
                    if ( this.current_link ) {
                        this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                    }
                    this.form__external__link.resetHTML();
                    this.form__external__link = null;
                }
                this.setContent__20240925( this.buildResetContent() );
                this.computeHtml();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
                if ( this.form__external__link && this.isSameForm() && !this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
                    return;
                }
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ] = this.current_link;
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ]        = this.page_object[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]                     = this.page_object;
                this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                this.form__external__link = new WEATHER.ExternalLinkForm( params );
                this.form__external__link.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.form__external__link.getDomElement(), this.window_container );
                CONTROLLER.Form.setCurrentForm( this.form__external__link );
                return;
            case SHINKEN.OBJECT.CONST.PHASE.SELECTED:
                if ( this.form__external__link && this.isSameForm() && !this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    return;
                }
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ] = this.current_link;
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ]        = this.page_object[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]                     = this.page_object;
                this.current_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                this.form__external__link = new WEATHER.ExternalLinkFormViewOnly( params );
                this.form__external__link.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.form__external__link.getDomElement(), this.window_container );
                CONTROLLER.Form.setCurrentForm( this.form__external__link );
                return;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.SlidePanelLinksForm, SHINKEN.OBJECT.SlidePanel );
WEATHER.ExternalLinkForm           = function ( params ) {
    this.init( "external-link-form", params );
};
WEATHER.ExternalLinkForm.prototype = {
    init                           : function ( name, params ) {
        this.initCommon( name );
        this.page_object         = params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ];
        this.main_external_link  = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ];
        this.properties_modified = [];
        this.initCounterCommon();
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINK_FORM, "WEATHER.ExternalLinkForm" );
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID, this.main_external_link.getUUID() );
        this.initFormContent();
        DOM.Service.scrollIntoElementIfNotVisible( this.main_external_link.getDomElement() );
        this.bad_values_for_properties = this.initBadValueForProperties( params );
        setTimeout( () => { // TODO a changer en enlevant le timeout
            CONTROLLER.Form.isValid();
        }, 20 );
    },
    initFormContent                : function () {
        this.addSpecific( this.getCollapseFolder__external_links__NameArea(), true );
        this.addSpecific( this.getCollapseFolder__external_links__URLArea(), true );
        this.addSpecific( this.getCollapseFolder__external_links__info_barArea(), true );
        this.addSpecific( this.getCollapseFolder__external_links__notificationArea(), true );
    },
    initBadValueForProperties      : function ( params ) {
        return params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ].getLinksPropertiesWithSpecialValidation__WithExcludeUUID( this.main_external_link.getUUID() );
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "close_current_external_link_form":
                    case "configure_external_link":
                        this.page_object.doActionAfter( event_name, params );
                }
                break;
            case "change_radio_mode_done":
            case "onchange_in_input_V3_done":
                this.askValidateForm( params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                break;
            case "external_link_have_been_deleted_or_created":
                this.bad_values_for_properties = this.initBadValueForProperties( params );
                CONTROLLER.Form.isValid();
                return;
        }
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
                if ( modification_element.getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) !== this.main_external_link.getUUID() ) {
                    return;
                }
                this.property_set.getContentByUUID( modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME ) ).doActionAfterLastModification( event_name, params );
                this.updateFormLabelIfNeeded( modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME ), modification_element.getNextOrPrevious( event_name ) );
                break;
        }
    },
    validateForm                              : function () {
        const new_params                                                  = {};
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ]                   = this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID, this.properties_modified );
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ]               = CONTROLLER.Form.isValid( this.properties_modified );
        new_params[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ]   = this.main_external_link.getUUID();
        new_params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ]   = this.properties_modified;
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_LINK_VALUE_MODIFICATION );
        for ( let i = 0; i < this.properties_modified.length; i++ ) {
            new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.property_set.getContentByUUID( this.properties_modified[ i ] ).getLastModificationElement() );
            this.updateFormLabelIfNeeded( this.properties_modified[ i ], new_params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ this.properties_modified[ i ] ] );
        }
        CONTROLLER.PageController.doActionAfter( "external_link__configured__from_form", new_params );
        this.updateUrlPreviewIfNeeded( new_params );
        CONTROLLER.PageController.doActionAfter( "add_last_modification", new_params );
        return true;
    },
    updateFormLabelIfNeeded                   : function ( composed_key, new_value ) {
        switch ( composed_key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME.COMPOSED_KEY:
                let new_title_label           = SHINKEN.TOOLS.STRING.cleanXss( typeof new_value === "object" ? new_value.value : new_value );
                new_title_label               = new_title_label.length > 350 ? new_title_label.slice( 0, 350 ) + "..." : new_title_label;
                this.dom_title_form.innerHTML = new_title_label;
                break;
        }
    },
    computeValidation__20241125               : function ( params ) {
        this.status_validation      = COMPONENT.CONST.STATUS.VALID;
        let current_property;
        const validate_all_property = !params;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            if ( !validate_all_property && !this.properties_modified.includes( current_property.getName() ) ) {
                continue;
            }
            let parameter_validation = this.getParameterValidation( current_property );
            PROPERTY_V2.VALIDATOR.validWithParameter( current_property, parameter_validation, '"', this.computeValidationSpecialCase( current_property ) );
        }
    },
    computeValidationSpecialCase              : function ( current_property ) {
        if ( !this.bad_values_for_properties.length ) {
            return;
        }
        const dict_keys = Object.keys( this.bad_values_for_properties[ 0 ] );
        if ( !dict_keys.includes( current_property.getName() ) ) {
            return;
        }
        for ( let i = 0; i < this.bad_values_for_properties.length; i++ ) {
            if ( this.bad_values_for_properties[ i ][ current_property.getName() ] === current_property.getValue() ) {
                return this.createValidationMessageSameValueOtherLinks();
            }
        }
    },
    createValidationMessageSameValueOtherLinks: function () {
        const messages = new SHINKEN.OBJECT.Messages();
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.business.external_links.same_value_as_other_link' ) );
        return messages;
    },
    getParameterValidation                    : function ( current_property ) {
        let _composed_key = SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( current_property.getName(), "." );
        let _key          = SHINKEN.TOOLS.STRING.splitForGetLastOne( current_property.getName(), "." );
        return SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.main_external_link, _composed_key ).getValidOwnProperty( _key );
    },
    isLinkInForm                : function ( link_focus ) {
        return this.main_external_link.getUUID() === link_focus.getUUID();
    },
    updateUrlPreviewIfNeeded    : function ( params ) {
        const property_who_need_to_update_url = [
            WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID.COMPOSED_KEY,
            WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY,
            WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL.COMPOSED_KEY,
            WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL.COMPOSED_KEY
        ];
        if ( !this.properties_modified.some( property => property_who_need_to_update_url.includes( property ) ) ) {
            return;
        }
        const url_preview          = this.getExternalLinkUrlForPreview();
        const new_param            = { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: url_preview, [ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ]: url_preview };
        const property_url_preview = this.property_set.getContentByUUID( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL );
        property_url_preview.doActionAfter( "property_value__set__by_js", new_param );
        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( property_url_preview.getLastModificationElement() );
    },
    setValueForProperty         : function ( property_structure, property ) {
        property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.main_external_link, property_structure.COMPOSED_KEY ).getUserValue() + "" } );
    },
    getExternalLinkUrlForPreview: function () {
        let _base_url = this.main_external_link.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY );
        let protocol  = this.main_external_link.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY );
        if ( protocol === WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS.PROTOCOL_FROM_WEBUI ) {
            protocol = this.getDefaultValueExternalLinks( WIDGET.CONST.TYPE.EXTERNAL_LINKS, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY );
        }
        return [
            protocol + ":/",
            _base_url || this.main_external_link.getComputeHostUrl(),
            COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE,
            this.main_external_link.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY ),
            this.main_external_link.weather_uuid,
            this.main_external_link.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY )
        ].join( "/" );
    },
    getLinkUUID                 : function () {
        return this.main_external_link.getUUID();
    },
    getMandatoryClass           : function ( property_structure ) {
        const validation    = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.main_external_link ).getValidOwnProperty( property_structure._KEY );
        let mandatory_class = "";
        if ( validation && validation.is_mandatory ) {
            mandatory_class = "shinken-mandatory-property";
        }
        return mandatory_class;
    },
    computeHtmlTitle              : function () {
        let title_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-title-container shinken-external-link-form-header shinken-layout-center-h-v" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "close_current_external_link_form", '', ["shinken-cancel-form", "shinkon-times-bold"] ), title_container );
        DOM.Service.addElementTo( this.getSpecificDomElementTitle(), title_container );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', {
            class              : "shinken-tag-help shinken-layout-center-h-v",
            "shi-tip-placement": "bottom-left",
            "shi-tip-html"     : this.getHelpHtml(),
            "onClick"          : "event.stopPropagation();",
            "onmouseenter"     : "SHINKEN_TOOLTIP.showTooltip(this)",
            "onmouseleave"     : "SHINKEN_TOOLTIP.hideTooltip()"
        }, "?" ), title_container );
    },
    getSpecificDomElementTitle    : function () {
        const title_label_container = DOM.Service.createElement( "div", { class: "shinken-form-label-container shinken-form-title" } );
        this.dom_title_form         = DOM.Service.createElement( 'span', { class: "shinken-form-title-label" }, this.main_external_link.getName() || _( "form.external_links.new_external_link_title" ) );
        DOM.Service.addElementTo( this.dom_title_form, title_label_container );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, title_label_container );
        return title_label_container;
    },
    computeHtmlActions            : function () {
    },
    computeExternalLinksPreviewUrl: function ( collapse_folder ) {
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL ), collapse_folder );
    },
    computeHtmlButton             : function ( event_name, label, class_to_add ) {
        let to_return = new COMPONENT.ButtonFromData_V3( event_name, label );
        to_return.addParamsForEvents( this.getParamForEvents() );
        to_return.computeHtml();
        if ( class_to_add ) {
            for ( let i = 0; i < class_to_add.length; i++ ) {
                to_return.getDomElement().classList.add( class_to_add[ i ] );
            }
        }
        return to_return.getDomElement();
    },
    _getLinkProtocolIcon          : function ( raw_value ) {
        let icon_protocol_type = raw_value === WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS.HTTPS ? "#id-shinken-template-view .https-icon-svg" : "#id-shinken-template-view .not-https-icon-svg";
        let icon_protocol      = DOM.Service.cloneElement( document.querySelector( icon_protocol_type ) );
        icon_protocol.classList.add( "shinken-weather-link-icon-https" );
        return icon_protocol;
    },
    _getLinkAuthenticationIcon    : function ( raw_value ) {
        let icon_authenticate_type = raw_value + "" === "true" ? "#id-shinken-template-view .authentication-svg" : "#id-shinken-template-view .not-authentication-svg";
        let icon_authentication    = DOM.Service.cloneElement( document.querySelector( icon_authenticate_type ) );
        icon_authentication.classList.add( "shinken-weather-link-icon-authentication-needed" );
        return icon_authentication;
    },
    _getNotificationSoundIcon     : function ( raw_value ) {
        const class_to_add = raw_value + "" === "true" ? "shinken-notification-sound-enable" : "shinken-notification-sound-disable";
        let to_return      = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-sound-svg' ) );
        to_return.classList.add( class_to_add );
        return to_return;
    },
    _getNotificationBlinkIcon     : function ( raw_value ) {
        const class_to_add = raw_value + "" === "true" ? "shinken-notification-blink-enable" : "shinken-notification-sound-disable";
        let to_return      = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-blink-icon' ) );
        to_return.classList.add( class_to_add );
        return to_return;
    },
    getHelpHtml            : function () {
        let contents = this.getHelpContents();
        return this.getHelpHtmlFromContents( contents );
    },
    getHelpHtmlFromContents: function ( contents ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-container", "data-help-parent-name": this.getName() } );
        DOM.Service.addElementTo( this.getHelpHtmlLineContent( contents ), to_return );
        return to_return.outerHTML;
    },
    getHelpHtmlLineContent : function ( content ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-content shinken-tooltip-edit-external-link" } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-title" }, content.label ), to_return );
        let element_content = this.getHelpHtmlElementContent( content );
        if ( element_content ) {
            DOM.Service.addElementTo( element_content, to_return );
        }
        return to_return;
    },
    getHelpContents        : function () {
        return {
            type_content: "label_&_content",
            elements    : [
                { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.cancel_and_validate_actions" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_cancel" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.actions_redo" ) },
                { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.back_to_visual" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_cross" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.back_with_escape" ) },
                { className: "shinken-tooltip-help-title", content: _( "edit_mode.windows.tooltips.labels_help.default_values" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_configuration" ) },
                { className: "shinken-tooltip-help-label-li", content: _( "edit_mode.windows.tooltips.labels_help.default_values_computed" ) }
            ]
        };
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkForm, SHINKEN.OBJECT.FormSetFromData );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkForm, SHINKEN.OBJECT.CommonFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkForm, SHINKEN.OBJECT.ExternalLinkFormInterface );
WEATHER.ExternalLinkFormViewOnly           = function ( params ) {
    this.init( "external-link-form-view-only", params );
};
WEATHER.ExternalLinkFormViewOnly.prototype = {
    init                           : WEATHER.ExternalLinkForm.prototype.init,
    factoryProperty                : function ( property_structure ) {
        let to_return;
        switch ( property_structure ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL:
                to_return = new PROPERTY.LabelFromData_V3_ForViewOnly( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL, '<span class="shinkon-globe"></span>', this.getExternalLinkUrlForPreview() );
                return to_return;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.POSITION:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.LOGO_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.CHRONO_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.GENERATION_TIME_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR:
                to_return = new PROPERTY.LabelFromData_V3_ForViewOnly( property_structure.COMPOSED_KEY, _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".label" ) );
                break;
        }
        this.setValueForProperty( property_structure, SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.main_external_link, property_structure.COMPOSED_KEY ).getUserValue() + "", to_return );
        
        return to_return;
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
                if ( modification_element.getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) !== this.main_external_link.getUUID() ) {
                    return;
                }
                const property_name = modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME );
                const property      = this.property_set.getContentByUUID( property_name );
                let new_value       = modification_element.getNextOrPrevious( event_name );
                
                switch ( property_name ) {
                    case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL.COMPOSED_KEY:
                    case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL.COMPOSED_KEY:
                    case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR.COMPOSED_KEY:
                        new_value = new_value[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ];
                        break;
                    case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL:
                        property.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ]: new_value, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: new_value } );
                        return;
                }
                DOM.Service.addOrRemoveClasses( property.getDomElement(), new_value === WEATHER.CONST.DEFAULT_VALUE, "shinken-is-default" );
                const property_structure = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( WEATHER.CONST.EXTERNAL_LINKS.PARAM, property_name.toUpperCase() );
                this.setValueForProperty( property_structure, new_value, property );
                this.updateFormLabelIfNeeded( property_name, modification_element.getNextOrPrevious( event_name ) );
                break;
        }
        CONTROLLER.Form.isValid();
    },
    setValueForProperty            : function ( property_structure, raw_value, property ) {
        let to_set                                     = {};
        to_set[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] = raw_value;
        if ( raw_value === WEATHER.CONST.DEFAULT_VALUE ) {
            const default_value = this.getDefaultValueExternalLinks( WIDGET.CONST.TYPE.EXTERNAL_LINKS, property_structure.COMPOSED_KEY );
            switch ( property_structure ) {
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED:
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getLinkAuthenticationIcon( default_value ).outerHTML + this.getValueDefault( property_structure );
                    break;
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL:
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getLinkProtocolIcon( default_value ).outerHTML + this.getValueDefault( property_structure );
                    break;
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED:
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getNotificationSoundIcon( default_value ).outerHTML + this.getValueDefault( property_structure );
                    break;
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED:
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getNotificationBlinkIcon( default_value ).outerHTML + this.getValueDefault( property_structure );
                    break;
                default :
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this.getValueDefault( property_structure );
                    break;
            }
            property.addClass( "shinken-is-default" );
        }
        else {
            switch ( property_structure ) {
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR:
                    let color_view                                 = DOM.Service.createElement( "span", { class: "shinken-external-link-background-color", style: "background-color:" + raw_value } );
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = color_view.outerHTML + raw_value;
                    break;
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME:
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID:
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL:
                case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL:
                    to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = raw_value;
                    break;
                default:
                    switch ( property_structure ) {
                        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED:
                            to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getPropertyLabel( property_structure, raw_value, this._getLinkAuthenticationIcon( raw_value ).outerHTML );
                            break;
                        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL:
                            to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getPropertyLabel( property_structure, raw_value, this._getLinkProtocolIcon( raw_value ).outerHTML );
                            break;
                        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED:
                            to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getPropertyLabel( property_structure, raw_value, this._getNotificationSoundIcon( raw_value ).outerHTML );
                            break;
                        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED:
                            to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getPropertyLabel( property_structure, raw_value, this._getNotificationBlinkIcon( raw_value ).outerHTML );
                            break;
                        default :
                            to_set[ PROPERTY.COMMON.PARAM.PROPERTY_LABEL ] = this._getPropertyLabel( property_structure, raw_value );
                            break;
                    }
            }
        }
        property.doActionAfter( "property_value__set__by_data", to_set );
    },
    getValueDefault                : function ( property_structure ) {
        switch ( property_structure ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR:
                let value      = this.getDefaultValueExternalLinks( WIDGET.CONST.TYPE.EXTERNAL_LINKS, property_structure.COMPOSED_KEY );
                let color_view = DOM.Service.createElement( "span", { class: "shinken-external-link-background-color", style: "background-color:" + value } );
                return color_view.outerHTML + value;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL:
                return this.getDefaultValueExternalLinks( WIDGET.CONST.TYPE.EXTERNAL_LINKS, property_structure.COMPOSED_KEY );
            default:
                return _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".radios." + this.getDefaultValueExternalLinks( WIDGET.CONST.TYPE.EXTERNAL_LINKS, property_structure.COMPOSED_KEY ) );
        }
    },
    _getPropertyLabel              : function ( property_structure, raw_value, icon = "" ) {
        let to_return;
        if ( SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.main_external_link, property_structure.COMPOSED_KEY ).hasCounterProblems() ||
             !isTranslateKeyExisting( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".radios." + raw_value ) ) {
            to_return = icon + raw_value;
        }
        else {
            to_return = icon + _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".radios." + raw_value );
        }
        return to_return;
    },
    computeHtmlTitle: function () {
        let title_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-view-only-form-title-container shinken-external-link-form-header shinken-layout-center-h-v" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "close_current_external_link_form", '', ["shinken-cancel-form", "shinkon-times-bold"] ), title_container );
        DOM.Service.addElementTo( this.getSpecificDomElementTitle(), title_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "configure_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) ).outerHTML + '<span class="shinken-label-config-link"> ' + _( "form.external_links.configure_external_link_button" ) + '</span>' ), title_container );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinkFormViewOnly, WEATHER.ExternalLinkForm );
WEATHER.ExternalLinks = function ( weather_uuid, data ) {
    this.weather_uuid = weather_uuid;
    this.initSpecific( data );
};
WEATHER.ExternalLinks.prototype = {
    initSpecific                                            : function ( data ) {
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS, "WEATHER.ExternalLinks" );
        this.init( data );
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
    },
    computeHtml                                             : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-external-links" } ) );
        let header = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-external-links-header" } ) );
        
        this.dom_title_label = DOM.Service.createElement( "span", { class: "shinken-weather-external-links-title" }, _( "form.external_links.title" ) );
        DOM.Service.addElementTo( this.dom_title_label, header );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.dom_title_label );
        
        this.add_new_link_button = new COMPONENT.ButtonFromData_V3( "create_new_external_link", _( "form.external_links.new_external_link_button" ) );
        this.add_new_link_button.computeHtml();
        DOM.Service.addElementTo( this.add_new_link_button.getDomElement(), header );
        this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).computeHtml( this.weather_uuid );
        
        this.addDomElement( this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).getDomElement() );
        this.setPhaseDomElement( this.getDomElement() );
    },
    _getValidOwnProperty                                    : function () {
        return new SHINKEN_VALIDATION.Parameters( [] );
    },
    _getValidOwnChildren                                    : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY, "WEATHER.DefaultLink"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS, "WEATHER.Links"]
        ] );
    },
    getLinksPropertiesWithSpecialValidation__WithExcludeUUID: function ( uuid_to_exclude ) {
        return this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].getLinksPropertiesWithSpecialValidation__WithExcludeUUID( uuid_to_exclude );
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "on_click_2024_07_31":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
                    if ( !DOM.Service.findParentElementWithClass( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, "shinken-weather-external-links", 100 ) ) {
                        this.togglePopup__20250220();
                    }
                }
                break;
            case "default__param__configured__from_form":
                for ( let i = 0; i < params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ].length; i++ ) {
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]                    = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ];
                    params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] = this.getParamForEvents();
                    this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY ].doActionAfter( "value__param__configured__from_form", params );
                    this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].doActionAfter( event_name, params );
                }
                break;
            case "external_link__configured__from_form":
                params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] = this.getParamForEvents();
                this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].doActionAfter( event_name, params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ) ) {
                    this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY ].doActionAfter( event_name, params );
                }
                else {
                    params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ] = this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY ];
                    this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].doActionAfter( event_name, params );
                }
                break;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "create_new_external_link":
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ] = this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY ];
                        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].doActionAfter( event_name, params );
                        break;
                    case "open_external_link":
                    case "copy_external_link":
                    case "delete_external_link":
                        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ].doActionAfter( event_name, params );
                        break;
                    case "toggle_external_links_display":
                    case "click-on-open-view-external-urls-popup":
                        if ( this.hasLinks() ) {
                            this.togglePopup__20250220( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].bar_info.external_link_dropdown );
                        }
                        break;
                }
        }
    },
    togglePopup__20250220          : function ( dom_parent ) {
        const _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING:
                this.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.getDomElement(), dom_parent );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
                this.addClass( "shinken-hidden" );
                break;
        }
        this._computePositionPopUpEditButton( this.dom_element );
    },
    _computePositionPopUpEditButton: function ( dom ) {
        DOM.Service.cleanAllStyles( dom );
        const _rect = DOM.Service.getBoundingClientRect( dom );
        if ( _rect.left < 0 ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.RIGHT );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.LEFT, "0" );
        }
        else if ( _rect.left + _rect.width > window.innerWidth ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.LEFT );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.RIGHT, "0" );
        }
        
        if ( _rect.bottom > window.innerHeight ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.BOTTOM );
            DOM.Service.setStyle( dom, DOM.CONST.STYLE.TOP, "-" + _rect.height + "px" );
        }
        else if ( _rect.top < 0 ) {
            DOM.Service.removeStyle( dom, DOM.CONST.STYLE.TOP );
        }
    },
    closePopup                     : function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
        this.closeCopyNotificationPopup();
    },
    closeCopyNotificationPopup     : function () {
        SHINKEN.TOOLS.NOTIFICATION.cleanAllNotification();
    },
    getUUID               : function () {
        return this.weather_uuid;
    },
    getLinkByUuid         : function ( link_uuid ) {
        return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).getContentByUUID( link_uuid );
    },
    getNextOrPreviousLinks: function ( link_uuid, is_previous ) {
        if ( is_previous ) {
            return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).getPreviousContent( link_uuid );
        }
        return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).getNextContent( link_uuid );
    },
    getFirstOrLastLink    : function ( get_first ) {
        const links_list = this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS );
        if ( links_list.getSize() === 0 ) {
            return;
        }
        return links_list.getContent( get_first ? 0 : links_list.getSize() - 1 );
    },
    hasLinks: function () {
        return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINKS ).hasLinks();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.ExternalLinks, SHINKEN.OBJECT.PhaseInterface );
WEATHER.DefaultLink = function ( data ) {
    this.initSpecific( data );
    _load_extra_lang_obj( "weather_lang" );
};
WEATHER.DefaultLink.prototype = {
    initSpecific: function ( data ) {
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK, "WEATHER.DefaultLink" );
        this.setUUID();
        this.init( data );
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "value__param__configured__from_form":
                this.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                let default_link_param                                      = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ];
                default_link_param.addParamsForEvents( this.getParamForEvents() );
                default_link_param.doActionAfter( event_name, params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                CONTROLLER.PageController.doActionAfter( "force_close_current_external_link_form" );
                break;
        }
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        let param_object           = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ) );
        param_object.doActionAfter( event_name, params );
        this.updateJsonIfNeeded( params );
    },
    _getValidOwnProperty           : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS, WEATHER.CONST.DEFAULT_VALUE ), false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    _getValidOwnChildren           : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY, "SHINKEN_PAGE.InfoBar"],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY, "WEATHER.Notifications"]
        ] );
    },
    getValueForTooltip             : function ( key ) {
        switch ( key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY:
                return this.getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED:
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH )
                           .getBooleanValue( key ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY :
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY ).getChild( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY )
                           .getBooleanValue( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ) ? _( "external_link_tooltip.activated", ["weather_lang"] ) : _( "external_link_tooltip.disabled", ["weather_lang"] );
            case SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION:
                return this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY )
                           .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ? _( "external_link_tooltip.bottom", ["weather_lang"] ) : _( "external_link_tooltip.top", ["weather_lang"] );
            default:
                return this.getValue( key );
        }
    },
    getComputeHostUrl              : function () {
        let _host = SHINKEN.HIGHWAY.getHost();
        if ( SHINKEN.HIGHWAY.isDocumentationOn() ) {
            return "<span class='shinken-sensible'>" + _host + "</span>";
        }
        return _host;
    },
    computeUrl                     : function () {
        let _base_url     = this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY );
        this.computed_url = [
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY ) + ":/",
            _base_url || this.getComputeHostUrl(),
            COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY ),
            this.weather_uuid,
            this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY )
        ].join( "/" );
    },
    getComputedUrl                 : function () {
        if ( !this.computed_url ) {
            this.computeUrl();
        }
        return this.computed_url;
    },
    resetComputedUrl               : function () {
        this.computed_url = null;
    },
    buildTooltip                   : function () {
        let icon_authenticate_type = this.authenticationNeeded() ? "#id-shinken-template-view .authentication-svg" : "#id-shinken-template-view .not-authentication-svg";
        let icon_protocol_type     = this.isHttps() ? "#id-shinken-template-view .https-icon-svg" : "#id-shinken-template-view .not-https-icon-svg";
        let class_to_add;
        
        let to_return                                     = document.querySelector( "#id-shinken-template-view .shinken-external-link-tooltip-template" ).innerHTML;
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_auth_icon_$$$", document.querySelector( icon_authenticate_type ).outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_name_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_uuid_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_part_url_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_auth_needed_attribute_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_protocol_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_protocol_icon_$$$", document.querySelector( icon_protocol_type ).outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_position_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY )
                                                                                                                                                                                               .getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) ) );
        let background_color_view                         = DOM.Service.createElement( "span", { class: "shinken-external-link-background-color" } );
        background_color_view.style[ "background-color" ] = this.getChild( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_background_color_view_$$$", background_color_view.outerHTML );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_logo_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_chrono_displayed_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_info_bar_generated_time_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) ) );
        to_return                                         = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) ) );
        
        class_to_add                = this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY ) === "Activé" ? "shinken-notification-sound-enable" : "shinken-notification-sound-disable";
        let sound_notification_icon = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-sound-svg' ) );
        sound_notification_icon.classList.add( class_to_add );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_sound_notification_icon_$$$", sound_notification_icon.outerHTML );
        
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_enable_$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) ) );
        
        class_to_add                = this.getValueForTooltip( WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ) === "Activé" ? "shinken-notification-blink-enable" : "shinken-notification-sound-disable";
        let blink_notification_icon = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-blink-icon' ) );
        blink_notification_icon.classList.add( class_to_add );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_blink_notification_icon_$$$", blink_notification_icon.outerHTML );
        
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, "$$$_link_external_url$$$", SHINKEN.TOOLS.STRING.cleanXssForTooltip( this.getComputedUrl() ) );
        to_return = SHINKEN.TOOLS.STRING.replaceAll( to_return, '"', "&quot;" );
        return to_return;
    },
    getJsonEditorInstance: function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    getUUID              : function () {
        return this.uuid;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set || SHINKEN.TOOLS.STRING.buildUUID();
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID, this.getUUID() );
        this.addJsonAnchor( this.getUUID() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.DefaultLink, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Link           = function ( data, uuid ) {
    this.initSpecific( data, uuid );
};
WEATHER.Link.prototype = {
    initSpecific: function ( data, uuid ) {
        this.setUUID( uuid );
        this.init( data );
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
        _load_extra_lang_obj( "weather_lang" );
        this.addJsonAnchor( this.getUUID() );
    },
    initAsNew   : function () {
        this.setName( _( "form.external_links.new_external_link_title" ) );
        this.setLinkUUID();
    },
    getName                               : function () {
        return this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ].getValue();
    },
    getLinkUUID                           : function () {
        return this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ].getValue();
    },
    setName                               : function ( to_set ) {
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ] = new SHINKEN.OBJECT.ParamGridPage( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY );
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ].setUserValueAndValue( to_set );
        SHINKEN.TOOLS.ARRAY.addElement( this.own_property_keys, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY );
    },
    setLinkUUID                           : function ( to_set ) {
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ] = new SHINKEN.OBJECT.ParamGridPage( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY );
        this[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ].setUserValueAndValue( to_set || SHINKEN.TOOLS.STRING.buildUUID() );
        SHINKEN.TOOLS.ARRAY.addElement( this.own_property_keys, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY );
    },
    getLinkPropertiesWithSpecialValidation: function () {
        return {
            [ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ]: this.getName(),
            [ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ]: this.getLinkUUID()
        };
    },
    remove                                : function () {
        this.resetCounters();
        this.resetHTML();
    },
    isHttps                               : function () {
        return this.link_protocol.getValue() === WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS.HTTPS;
    },
    authenticationNeeded                  : function () {
        return this.authentication_needed.getValue() + "" === "true";
    },
    doActionAfter          : function ( event_name, params ) {
        switch ( event_name ) {
            case "enter_on_external_link_line":
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-placement", "left-bottom" );
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-type", "external-links" );
                DOM.Service.addAttribute( this.getDomElement(), "shi-tip-html", this.tooltip_html );
                SHINKEN_TOOLTIP.showTooltip( this.getDomElement() );
                break;
            case "leave_on_external_link_line":
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-placement" );
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-type" );
                DOM.Service.removeAttribute( this.getDomElement(), "shi-tip-html" );
                SHINKEN_TOOLTIP.hideTooltip();
                break;
            case "default__param__configured__from_form":
                const param_to_update = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                if ( param_to_update.user_value !== param_to_update.default_value ) {
                    return;
                }
                param_to_update.addParamsForEvents( this.getParamForEvents() );
                param_to_update.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                param_to_update.doActionAfter( event_name, params );
                break;
            case "external_link__configured__from_form":
                if ( this.getUUID() !== params[ WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ] ) {
                    return;
                }
                let param_to_update_2;
                const composed_key_list = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ];
                for ( let i = 0; i < composed_key_list.length; i++ ) {
                    const new_value                                             = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ composed_key_list[ i ] ];
                    params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = new_value;
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]                = composed_key_list[ i ];
                    
                    param_to_update_2 = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, composed_key_list[ i ] );
                    param_to_update_2.addParamsForEvents( this.getParamForEvents() );
                    param_to_update_2.addParamsForEvents( params[ SHINKEN.OBJECT.CONST.EVENT_PARAM.PARENT_PARAMS_OBJECT ] );
                    param_to_update_2.doActionAfter( "value__param__configured__from_form", params );
                    
                    this.updateLinkLabelIfNeeded( composed_key_list[ i ], new_value );
                }
                this.updateJsonIfNeeded( params );
                this.resetComputedUrl();
                this.tooltip_html = this.buildTooltip();
                break;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "open_external_link":
                        if ( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] === this.getUUID() ) {
                            SHINKEN.HIGHWAY.goToBlank( this.getComputedUrl() );
                        }
                        break;
                    case "copy_external_link":
                        if ( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] === this.getUUID() ) {
                            CLIPBOARD_SERVICE.setContent( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, this.getComputedUrl(), this.copyLinkToClipboardCallback );
                        }
                        break;
                }
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
                this.updateLinkLabelIfNeeded( modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ), modification_element.getNextOrPrevious( event_name ) );
                this.resetComputedUrl();
                break;
        }
    },
    _getProtocolIcon       : function () {
        let icon_protocol_type = this.isHttps() ? "#id-shinken-template-view .https-icon-svg" : "#id-shinken-template-view .not-https-icon-svg";
        let icon_protocol      = DOM.Service.cloneElement( document.querySelector( icon_protocol_type ) );
        icon_protocol.classList.add( "shinken-weather-link-icon-https" );
        return icon_protocol;
    },
    _getAuthenticationIcon : function () {
        let icon_authenticate_type = this.authenticationNeeded() ? "#id-shinken-template-view .authentication-svg" : "#id-shinken-template-view .not-authentication-svg";
        let icon_authentication    = DOM.Service.cloneElement( document.querySelector( icon_authenticate_type ) );
        icon_authentication.classList.add( "shinken-weather-link-icon-authentication-needed" );
        return icon_authentication;
    },
    updateLinkLabelIfNeeded: function ( composed_key, new_value ) {
        switch ( composed_key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME.COMPOSED_KEY:
                this.dom_element_text_label.innerHTML = new_value.value;
                break;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED.COMPOSED_KEY :
                const new_authentication_icon = this._getAuthenticationIcon();
                DOM.Service.replaceElement( this.icon_autentication, new_authentication_icon );
                this.icon_autentication = new_authentication_icon;
                break;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY:
                const new_protocol_icon = this._getProtocolIcon();
                DOM.Service.replaceElement( this.icon_protocol, new_protocol_icon );
                this.icon_protocol = new_protocol_icon;
                break;
        }
    },
    _getValidOwnProperty   : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY, SHINKEN_VALIDATION.CONST.OTHERS.NOT_EMPTY__MAX_LENGTH__DONT_HAVE_FORBIDDEN, [300, ["'", '"', "<", ">"]], true],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " "]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.OPTIONS, WEATHER.CONST.DEFAULT_VALUE ), false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL._KEY, SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS, [300, ["!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "/", ":", ";", "=", "?", "@", "[", "]", "<", ">", " ", "http", "https"]], false],
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    
    copyLinkToClipboardCallback: function ( status, dom_button ) {
        let _text     = status ? _( "copy_service.copyExternalLinkSuccess", [DICTIONARY_COMMON_UI] ) : _( "copy_service.copyFail", [DICTIONARY_COMMON_UI] );
        let _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        let _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    },
    computeHtml      : function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.tooltip_html = this.buildTooltip();
        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID, this.getUUID() );
        this.computeUrl();
        this.setDomElement( DOM.Service.createElement( "div", {
            class       : "shinken-weather-link-element",
            "data-uuid" : this.getUUID(),
            onmouseenter: "MANAGER.EventManagerV2.doActionAfter( event, 'enter_on_external_link_line'," + this.parseParamForEventsToHtml() + ")",
            onmouseleave: "MANAGER.EventManagerV2.doActionAfter( event, 'leave_on_external_link_line'," + this.parseParamForEventsToHtml() + ")",
            onclick     : "MANAGER.EventManagerV2.doActionAfter( event, 'click_on_external_link_line'," + this.parseParamForEventsToHtml() + ")"
        } ) );
        
        let btn_supp_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "delete_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-bin-svg" ) ).outerHTML, "shinken-delete-button" ), btn_supp_container );
        
        let link_name       = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-name-element" } ) );
        let label_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-label-container" } ), link_name );
        
        let dom_element_icon_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-icon-container shinken-layout-center-h-v" } ), label_container );
        this.icon_protocol             = DOM.Service.addElementTo( this._getProtocolIcon(), dom_element_icon_container );
        this.icon_autentication        = DOM.Service.addElementTo( this._getAuthenticationIcon(), dom_element_icon_container );
        
        this.dom_element_text_label = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-label-element" }, SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) ) ), label_container );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, label_container );
        
        
        let btn_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container shinken-external-link-action-buttons" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "open_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML, "shinken-open-external-link" ), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "copy_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-copy-svg" ) ).outerHTML, "shinken-copy-external-link" ), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "configure_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) ).outerHTML, "shinken-configure-external-link" ), btn_container );
        
        this.setPhaseDomElement( this.getDomElement() );
    },
    computeHtmlButton: function ( event_name, label, class_to_add, tooltip_to_add ) {
        let to_return = new COMPONENT.ButtonFromData_V3( event_name, label );
        to_return.addParamsForEvents( this.getParamForEvents() );
        to_return.computeHtml();
        if ( class_to_add ) {
            to_return.getDomElement().classList.add( class_to_add );
        }
        if ( tooltip_to_add ) {
            to_return.setTooltipHtml( tooltip_to_add );
        }
        return to_return.getDomElement();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Link, WEATHER.DefaultLink );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Link, SHINKEN.OBJECT.PhaseInterface );
WEATHER.LinkForView           = function ( data, uuid ) {
    this.initSpecific( data, uuid );
};
WEATHER.LinkForView.prototype = {
    initSpecific: WEATHER.Link.prototype.initSpecific,
    computeHtml: function ( weather_uuid ) {
        this.weather_uuid = weather_uuid;
        this.computeUrl();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-element", "data-uuid": this.getUUID(), "shi-tip-placement": "left-bottom" } ) );
        this.setTooltipHtml( this.buildTooltip(), "external-links" );
        
        let link_name = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-link-name-element" } ) );
        let label     = SHINKEN.TOOLS.STRING.cleanXss( this.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME._KEY ) );
        
        let dom_element_icon_container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-weather-link-icon-container shinken-layout-center-h-v" } ), link_name );
        this.icon_protocol             = DOM.Service.addElementTo( this._getProtocolIcon(), dom_element_icon_container );
        this.icon_autentication        = DOM.Service.addElementTo( this._getAuthenticationIcon(), dom_element_icon_container );
        
        this.dom_element_text_label = DOM.Service.createElement( "div", { class: "shinken-weather-link-label-element shinken-user-select-text" }, label );
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.dom_element_text_label );
        
        DOM.Service.addElementTo( this.dom_element_text_label, link_name );
        
        let btn_container = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-buttons-container shinken-external-link-action-buttons" } ) );
        DOM.Service.addElementTo( this.computeHtmlButton( "open_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML ,"", _( "views.manager.service_weather.tooltips.open_link" )), btn_container );
        DOM.Service.addElementTo( this.computeHtmlButton( "copy_external_link", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-copy-svg" ) ).outerHTML, "", _( "views.manager.service_weather.tooltips.copy_link" ) ), btn_container );
        
        this.setPhaseDomElement( this.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinkForView, WEATHER.Link );
WEATHER.Links = function ( data ) {
    this.init( data );
};
WEATHER.Links.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initCounterCommon();
        this.initContents();
        this.updateData( data );
        this.setUUID();
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                if ( this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) ) ) {
                    this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ) ).doActionAfter( event_name, params );
                    return;
                }
                this.doActionAfter__lastModification( event_name, params );
                return;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "create_new_external_link":
                        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS, "WEATHER.ExternalLink" );
                        this.setPreviousModificationElement();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_ADD_LINK );
                        let new_link = this.add( new WEATHER.Link( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT ) ) );
                        new_link.initAsNew();
                        new_link.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__FORM__MAIN_LINK ] = new_link;
                        this.addDomElement( new_link.getDomElement() );
                        this.updateJsonIfNeeded( params );
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK ) );
                        CONTROLLER.PageController.doActionAfter( "add_last_modification", params );
                        return;
                    case "delete_external_link":
                        this.addParamForEvents( WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS, "WEATHER.ExternalLink" );
                        this.setPreviousModificationElement();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_REMOVE_LINK );
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = [params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ]];
                        this.removeLink( params );
                        this.updateJsonIfNeeded( params );
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK ) );
                        CONTROLLER.PageController.doActionAfter( "add_last_modification", params );
                        return;
                }
        }
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        const _uuid_list_next      = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNext().mapping );
        const _uuid_list_previous  = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious().mapping );
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK:
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _uuid_list_next, _uuid_list_previous );
                switch ( event_name ) {
                    case "undo_last_modification":
                        this.removeLink( params );
                        break;
                    case "redo_last_modification":
                        let new_link = this.add( new WEATHER.Link( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.DEFAULT_EXTERNAL_LINK ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT ), params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ 0 ] ) );
                        new_link.initAsNew();
                        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
                        this.addDomElement( new_link.getDomElement() );
                        break;
                }
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK:
                params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _uuid_list_previous, _uuid_list_next );
                switch ( event_name ) {
                    case "redo_last_modification":
                        this.removeLink( params );
                        break;
                    case "undo_last_modification":
                        this.addLinksFromLastModification( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious(), params );
                        break;
                }
                break;
        }
        this.updateJsonIfNeeded( params );
    },
    getChildrenObject                                       : function () {
        return this.getContents();
    },
    getChildrenObjectDict                                   : function () {
        return this.getContents();
    },
    getJsonEditorInstance                                   : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    getLinksPropertiesWithSpecialValidation__WithExcludeUUID: function ( uuid_to_exclude ) {
        const to_return = [];
        let current_link;
        for ( let i = 0; i < this.getSize(); i++ ) {
            current_link = this.getContent( i );
            if ( current_link.getUUID() === uuid_to_exclude ) {
                continue;
            }
            to_return.push( current_link.getLinkPropertiesWithSpecialValidation() );
        }
        return to_return;
    },
    hasLinks           : function () {
        return !!this.getSize();
    },
    getLinkByUuid      : function ( uuid ) {
        let _current;
        for ( let i = 0, _size = this.getSize(); i < _size; i++ ) {
            _current = this.getContent( i );
            if ( uuid === _current.getValue( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID._KEY ) ) {
                return _current;
            }
        }
        return null;
    },
    getChildConstructor: function ( data ) {
        return new WEATHER.Link( data );
    },
    getUUID            : function () {
        return this.uuid;
    },
    setUUID            : function ( to_set ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.addJsonAnchor( this.uuid );
    },
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    reset                       : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    setData                     : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                let to_add;
                for ( let i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    to_add = this.getChildConstructor( value[ i ] );
                    to_add.setCountersParent( this );
                    this.add( to_add );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    removeLink                  : function ( params ) {
        for ( let i = 0, _size_i = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ].length; i < _size_i; i++ ) {
            this.removeContent( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ], params );
            CONTROLLER.PageController.doActionAfter( "close_current_external_link_form_if_needed", { [ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ]: params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ] } );
        }
        this.updateJsonIfNeeded( params );
    },
    addLinksFromLastModification: function ( datas, params ) {
        for ( let i = 0, _size_i = params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ].length; i < _size_i; i++ ) {
            let index = datas.mapping[ params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ] ];
            this.addLinkFromLastModification( datas.contents[ index ], params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LIST_LINK__UUID ][ i ], params, index );
        }
    },
    addLinkFromLastModification : function ( data, uuid, params, index ) {
        let new_link = new WEATHER.Link( data, uuid );
        this.insertAtIndex( new_link, index );
        new_link.computeHtml( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ].getUUID() );
        DOM.Service.addElementAtIndex( new_link.getDomElement(), this.getDomElement(), index );
    },
    getDataToSave: function () {
        const _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    getLastModificationElement: function ( type_modification ) {
        let to_return;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_NEW_LINK:
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_NEW_LINK:
                previous = this.previous_modication_data;
                next     = this.getDataForLastModification();
                break;
        }
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        this.previous_modication_data = null;
        return to_return;
    },
    computeHtml               : function ( weather_uuid ) {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-weather-links" } ) );
        for ( let i = 0, _size = this.getSize(); i < _size; i++ ) {
            this.getContent( i ).computeHtml( weather_uuid );
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    },
    initMessages              : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    getDataForLastModification: SHINKEN.OBJECT.EditableElementContainerInterface.prototype.getDataForLastModification
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Links, SHINKEN.OBJECT.EditableElementContainerInterface );
WEATHER.LinksForView = function ( data ) {
    this.init( data );
};
WEATHER.LinksForView.prototype = {
    init: WEATHER.Links.prototype.init,
    getChildConstructor: function ( data ) {
        return new WEATHER.LinkForView( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.LinksForView, WEATHER.Links );
SHINKEN.OBJECT.WeatherJsonEditor = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.WeatherJsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    this.content        = null;
    this.default_tag    = default_tag;
    this.init();
};
SHINKEN.OBJECT.WeatherJsonEditor.prototype = {
    init: SHINKEN.OBJECT.JsonEditor.init,
    isEditableKeyElement: function ( key ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
            case SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
                return true;
        }
        return false;
    },
    isLabelOfEditableKey: function ( key ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
                return true;
        }
        return false;
    },
    getController       : function () {
        return CONTROLLER.PageController;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.WeatherJsonEditor, SHINKEN.OBJECT.JsonEditor );
WEATHER.PageEdit           = function ( uuid ) {
    this.__class_name__ = "WEATHER.PageEdit";
    this.initSpecific( uuid );
};
WEATHER.PageEdit.prototype = {
    initSpecific: function ( uuid ) {
        this.initCounterCommon();
        this.init( uuid );
        this.initEditMode();
    },
    init        : WEATHER.Page.prototype.init,
    initMessages: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    initCounterCommon     : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    initButtonExternalLink: function () {
        this.button_external_links = new COMPONENT.ButtonFromData_V3( "show_external_links_display", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML + _( 'edit_mode.buttons.external_link' ) );
        this.button_external_links.computeHtml();
    },
    getViewHistoryInstance: function () {
        return new WEATHER.ViewHistory( this.getUUID(), 30 );
    },
    getVisualFormInstance : function () {
        return new WEATHER.VisualForm( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL );
    },
    getJsonEditorInstance : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    isSameViewData        : function ( data ) {
        return this.page_version === data.weather_version && this.last_modifications.getCurrentStep() === SHINKEN.OBJECT.CONST.LAST_MODIFICATION.INITIAL_STEP;
    },
    doActionAfterSpecific : function ( event_name, params ) {
        switch ( event_name ) {
            case "close_form__for__link_configuration__done":
                this.slide_panel__external_links = null;
                CONTROLLER.Form.setCurrentForm( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT ) ? this.form__default_values : this.form__visual_mode );
                this.slide_panel_edition.computeSizes__20240926( true );
                this.slide_panel_problems.computeSizes__20240926( true );
                break;
            case "enter_on_external_link_line":
            case "leave_on_external_link_line":
            case "click_on_external_link_line":
                if ( this.slide_panel__external_links ) {
                    params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ] = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                    params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]              = this;
                    this.slide_panel__external_links.doActionAfter( event_name, params );
                }
                else {
                    this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].getLinkByUuid( params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.LINK__UUID ] ).doActionAfter( event_name, params );
                }
                break;
            case "force_close_current_external_link_form":
            case "close_current_external_link_form_if_needed":
                if ( this.slide_panel__external_links ) {
                    this.slide_panel__external_links.doActionAfter( event_name, params );
                }
                break;
            case "external_link__configured__from_form":
                if ( params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ] ) {
                    this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].doActionAfter( event_name, params );
                }
                break;
            case "on_click_2024_07_31":
                if ( this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ] ) {
                    this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].doActionAfter( event_name, params );
                }
                break;
            case "on_drag_start":
                switch ( params[ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ] ) {
                    case WEATHER.CONST.EXTERNAL_LINKS.SLIDE_PANEL_FORM_NAME:
                        this.slide_panel__external_links.doActionAfter( event_name, params );
                        break;
                }
                break;
            case "on_drag_move":
                switch ( params[ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ] ) {
                    case WEATHER.CONST.EXTERNAL_LINKS.SLIDE_PANEL_FORM_NAME:
                        this.slide_panel__external_links.doActionAfter( event_name, params );
                        break;
                }
                break;
            case "on_drag_stop":
                switch ( params[ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ] ) {
                    case WEATHER.CONST.EXTERNAL_LINKS.SLIDE_PANEL_FORM_NAME:
                        this.slide_panel__external_links.doActionAfter( event_name );
                        this.saveUserPrefs();
                        break;
                }
                break;
            case "current_view_is_being_deleted":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "open_external_link":
                    case "copy_external_link":
                    case "toggle_external_links_display":
                        params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ] = this;
                        this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].doActionAfter( event_name, params );
                        break;
                    case "show_external_links_display":
                        if ( this.slide_panel__external_links ) {
                            return;
                        }
                        if ( this.is_json_modified_manually ) {
                            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                            this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.EDITING, "click_on_button_V3", params );
                            return;
                        }
                        params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]              = this;
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ] = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                        this.slide_panel__external_links                                   = new WEATHER.SlidePanelLinksForm( params );
                        break;
                    case "create_new_external_link":
                    case "configure_external_link":
                    case "delete_external_link":
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ]   = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                        params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]                = this;
                        params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] = this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
                        this.slide_panel__external_links.doActionAfter( event_name, params );
                        break;
                    case "close_current_external_link_form":
                        params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ] = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
                        params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]              = this;
                        this.slide_panel__external_links.doActionAfter( "close_current_external_link_form", params );
                        break;
                    case "close_external_link_slide_panel":
                        this.slide_panel__external_links.doActionAfter( "close_external_link_slide_panel", params );
                        break;
                    case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_ADDED:
                    case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_EXISTING:
                        this.slide_panel__external_links.doActionAfter( event_name, params );
                        break;
                }
                break;
            case "ask_close_external_link_slide_panel":
                if ( this.slide_panel__external_links ) {
                    this.slide_panel__external_links.doActionAfter( "close_external_link_slide_panel", params );
                }
                break;
            case "compute_sizes":
                if ( this.slide_panel__external_links ) {
                    this.slide_panel__external_links.computeSizes__20240926();
                }
                break;
        }
    },
    doActionAfterInForm   : function ( event_name, params ) {
        if ( this.slide_panel__external_links ) {
            params[ WEATHER.CONST.EXTERNAL_LINKS.EVENTS_PARAM.EXTERNAL_LINKS ] = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ];
            params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]              = this;
            this.slide_panel__external_links.doActionAfter( event_name, params );
            return;
        }
        this.doActionAfterInFormCommon( event_name, params );
    },
    getController                  : function () {
        return CONTROLLER.PageController;
    },
    doActionAfter                  : WEATHER.Page.prototype.doActionAfter,
    getDefaultNotificationsOfChange: WEATHER.Page.prototype.getDefaultNotificationsOfChange,
    getChildrenObjectDict          : WEATHER.Page.prototype.getChildrenObjectDict,
    setIdentification              : WEATHER.Page.prototype.setIdentification,
    getInfoBarChildConstructor     : WEATHER.Page.prototype.getInfoBarChildConstructor,
    getDefaultFormInstance         : function () {
        const grid = this.content.grids.getContent( 0 ); // TODO see here how to get the grid with a better way
        let params = {
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ] : grid,
            [ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]: this,
            [ SHINKEN.USER_PREFS.PARAM_EVENT.DATA ]        : this.user_pref
        };
        return new WEATHER.DefaultForm( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT, params );
    },
    getBackendDataUrl__20241008: function ( need_user_value ) {
        let _url = SHINKEN.HIGHWAY.getOrigin() + "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.GET_WEATHER + this.getUUID();
        _url += "?configuration_hash=" + __configuration_hash__ + "&validation_change_time=" + this[ SHINKEN_PAGE.CONST.PARAM.PAGE.VALIDATION_CHANGE_TIME ];
        _url += "&computed_value=true&include_validation_messages=true&source_value=true&config_value=true";
        _url += "&weather_version=";
        _url += need_user_value ? -1 : this.getPageVersion();
        return _url;
    },
    getUrlPreview: function () {
        return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.PREVIEW_WEATHER + this.getUUID();
    },
    getUrlSave   : function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.PUBLISH_WEATHER + this.getUUID();
            default:
                return "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.SAVE_WEATHER + this.getUUID();
        }
    },
    getDataToSaveSpecific: function ( to_return ) {
        to_return[ WEATHER.CONST.EXTERNAL_LINKS._KEY ] = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].getDataToSave();
        return to_return;
    },
    reset                   : function () {
        this.content = new WEATHER.PageContent();
        this.content.init( this.getUUID(), this.getDomElement().querySelector( ".shinken-weather-page" ) );
        this.content.setCounterParent( this, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    setData                 : WEATHER.Page.prototype.setData,
    getDataUserPrefsSpecific: function ( existing_object_save ) {
        if ( this.slide_panel__external_links ) {
            existing_object_save[ this.slide_panel__external_links.getName() ] = this.slide_panel__external_links.getCurrentRatio();
        }
    },
    updateButtonExternalLinks: function () {
        let state = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].hasLinks() ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.EMPTY;
        
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            const dom_element = document.querySelector( ".shinken-weather-edition-button-action .shinken-weather-external-links-button-cell .shinken-button-container" );
            if ( !dom_element ) {
                return;
            }
            DOM.Service.addElementToAfterEmpty( this.button_external_links.getDomElement(), dom_element );
            this.button_external_links.setTooltipHtml( state === COMPONENT.CONST.BTN_STATE.DISABLED ? _( "external_link_tooltip.has_no_links" ) : "" );
            this.button_external_links.dom_element.setAttribute( "shi-tip-placement", "left" );
            this.button_external_links.setState( state );
            return;
        }
        this.bar_info.updateButtonExternalLinks( state );
    },
    callbackForPhaseSpecific : function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.doActionAfter( "ask_close_external_link_slide_panel" );
                this.updateButtonExternalLinks();
                if ( this.getPreviousPhase() === SHINKEN.OBJECT.CONST.PHASE.RUNNING ) {
                    this.doActionAfter( "ask_play_notifications", this.default_notifications_of_changed.getFlatUserVolume( this.user_prefs.getNotificationOfChange() ) );
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING:
                this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].closePopup();
                DOM.Service.addElementTo( this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].getDomElement(), document.querySelector( ".shinken-box-mode-editing" ) );
                this.updateButtonExternalLinks();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                this.doActionAfter( "ask_close_external_link_slide_panel" );
                this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].closePopup();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, SHINKEN.OBJECT.GridPageEdit );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageEdit, WEATHER.Page );
WIDGET.ShinkenGridStructure           = function ( data ) {
    this.init( data );
};
WIDGET.ShinkenGridStructure.prototype = {
    
    
    __computeHtml : function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-widget shinken-height-100", "data-type": "shinken-grid-structure" } );
        DOM.Service.addElementToAfterEmpty( this.dom_element, this.dom_element_parent );
    },
    updateSize    : function () {
        this.computeAllStyle();
    },
    computeAllStyle: function () {
    },
    getNameToDisplay            : function () {
        if ( (__external_url_uuid__ && !__has_authentication_needed__) ) {
            return this.type.value;
        }
        return this.shinken_widget_separator_title.innerHTML;
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ShinkenGridStructure, WIDGET.Separator );
SHINKEN_GRID.GridForPreview           = function ( data_widget ) {
    this.initSpecific( data_widget );
};
SHINKEN_GRID.GridForPreview.prototype = {
    initSpecific: function ( data_widget ) {
        this.init( this.createPreviewWidgetWithContext( data_widget ) );
        this.setUUID( "grid_for_preview" );
        this.addClass( "shinken-weather-page" );
        this.addClass( "shinken-grid-for-preview" );
    },
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "value__param__configured__from_form__if_needed":
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]    = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] = this.grid_elements.getContent( 0 ).getUUID();
                for ( let i = 0; i < params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ].length; i++ ) {
                    switch ( params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ] ) {
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON.COMPOSED_KEY:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
                            params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]   = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ];
                            params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] = SHINKEN.TOOLS.STRING.splitForGetFirstOne( params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ], "." );
                            this.grid_elements.doActionAfter( "value__param__configured__from_form", params );
                            break;
                    }
                }
                return;
            case "value__param__configured__from_form":
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]    = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] = this.grid_elements.getContent( 0 ).getUUID();
                for ( let i = 0; i < params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ].length; i++ ) {
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]   = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ];
                    params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] = SHINKEN.TOOLS.STRING.splitForGetFirstOne( params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ], "." );
                    this.grid_elements.doActionAfter( "value__param__configured__from_form", params );
                }
                return;
            case "toggl_collapse_folder__is_open":
            case "toggl_collapse_folder__is_open__or__close_others":
            case "slide_panel__size__has_changed":
                this.computeSizes();
                break;
            case "make_compute_after_0ms":
                setTimeout( () => { // I DON'T KNOW WHY IS IT NECESSARY
                    this.computeSizes();
                }, 0 );
                break;
            case "compute_html_done":
                this.updateContentData();
                this.computeSizes();
                setTimeout( () => { // I DON'T KNOW WHY IS IT NECESSARY
                    this.computeSizes();
                }, 100 );
                break;
            default:
                this.grid_elements.getContent( 0 ).doActionAfter( event_name, params );
                break;
        }
    },
    getChildConstructor           : function ( data ) {
        return new SHINKEN_GRID.CellsForPreview( data );
    },
    computeTileSize               : function () {
        let new_tile_size    = DOM.Service.getBoundingClientRect( this.getDomElement(), DOM.CONST.STYLE.WIDTH ) / this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ) - 1;
        this.tile_pixel_size = Math.min( new_tile_size, 24 );
    },
    computeFontSize               : function () {
        this.font_size = 13;
    },
    getComputedStyle              : function () {
        const _nb_tiles                         = this.max_nb_tiles;
        const _to_return                        = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ]    = this.tile_pixel_size * _nb_tiles;
        _to_return[ DOM.CONST.STYLE.FONT_SIZE ] = this.font_size;
        return _to_return;
    },
    updateContentData             : function () {
        this.grid_elements.updateContentData( {
            "host-010010010": {
                "item_uuid"                                   : "010010010",
                "item_type"                                   : "host",
                "context"                                     : "DOWNTIME",
                "item_name"                                   : _( "grid.mode_edition.form_widget.weather_widget.cf_preview_widget.item_name", [DICTIONARY_COMMON_UI] ),
                "visualisation_name"                          : _( "grid.mode_edition.form_widget.weather_widget.cf_preview_widget.visualisation_name", [DICTIONARY_COMMON_UI] ),
                "sla"                                         : {
                    "value"             : "100",
                    "warning_threshold" : 99,
                    "critical_threshold": 97,
                    "tendency"          : "arrow-up-ok"
                },
                "status"                                      : 0,
                "exists"                                      : true,
                "element_visibility_on_not_authenticated_view": false,
                "is_not_authorized_for_user"                  : false
            }
        } );
    },
    createPreviewWidgetWithContext: function ( preview_context ) {
        const preview_pattern_to_change = this.getPatternForPreviewWidget();
        const pattern_value_to_change   = preview_pattern_to_change[ "grid_elements" ][ "list_content" ][ 0 ][ "value" ];
        
        pattern_value_to_change[ "content" ][ "value" ] = preview_context[ "content" ];
        pattern_value_to_change[ "height" ]             = preview_context[ "height" ];
        pattern_value_to_change[ "width" ]              = preview_context[ "width" ];
        return preview_pattern_to_change;
    },
    getPatternForPreviewWidget    : function () {
        return {
            "type"                           : {
                "value": "grid"
            },
            "nb_tiles_in_width"              : {
                "value": 15
            },
            "nb_tiles_in_height"             : {
                "value": 4
            },
            "separation_grid_element_min"    : {
                "value": 10
            },
            "separation_grid_element_max"    : {
                "value": 10
            },
            "separation_grid_element_percent": {
                "value": 0
            },
            "grid_elements"                  : {
                "list_content": [
                    {
                        "value": {
                            "width"     : {
                                "value": 0
                            },
                            "height"    : {
                                "value": 0
                            },
                            "content"   : {
                                "value": {}
                            },
                            "position_x": {
                                "value": 0
                            },
                            "position_y": {
                                "value": 0
                            }
                        }
                    }
                ]
            }
        };
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.GridForPreview, SHINKEN_GRID.Grid );
SHINKEN_GRID.CellsForPreview           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.CellsForPreview.prototype = {
    getChildConstructor: function ( data ) {
        return new SHINKEN_GRID.CellForPreview( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.CellsForPreview, SHINKEN_GRID.Cells );
SHINKEN_GRID.CellForPreview           = function ( data ) {
    this.__class_name__ = "WEATHER.CellForPreview";
    this.initSpecific( data );
};
SHINKEN_GRID.CellForPreview.prototype = {
    initSpecific       : function ( data ) {
        this.init( data );
        this.addClass( "shinken-for-preview" );
    },
    isVisible          : function () {
        return true;
    },
    doActionAfter      : function ( event_name, params ) {
        switch ( event_name ) {
            case "value__param__configured__from_form":
                params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ];
                const param_to_update                                       = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                param_to_update.addParamsForEvents( this.getParamForEvents() );
                param_to_update.addParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                param_to_update.doActionAfter( event_name, params );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].updateDomElement();
                return;
            default:
                this.content.doActionAfter( event_name, params );
                break;
        }
        this.doActionAfterCommon( event_name, params );
    },
    getChildConstructor: function ( data ) {
        return WIDGET.factoryPreview( data );
    },
    callbackForPhase   : function () {
        let current_phase = this.getCurrentPhase();
        this.updateSize();
    },
    getUserInteraction: function ( attributes ) {
    },
    wrapHtmlContainer : function () {
        this.dom_element_content = this.dom_element_content || DOM.Service.createElement( "div", { class: "shinken-grid-cell-content" } );
        DOM.Service.addElementToAfterEmpty( this.content_container, this.dom_element_content );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.CellForPreview, SHINKEN_GRID.Cell );
WIDGET.factoryPreview = function ( data ) {
    var _to_return;
    var _type = "";
    try {
        _type = data[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ][ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
    }
    catch ( e ) {
        try {
            _type = data[ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
        }
        catch ( e ) {
            _type = data[ "item_type" ] || "";
        }
    }
    switch ( _type ) {
        case WIDGET.CONST.TYPE.WEATHER:
            _to_return = new WIDGET.WeatherForPreview( data );
            break;
    }
    _to_return._timeout_compute_ellipsis = null;
    return _to_return;
};
WIDGET.WeatherForPreview           = function ( data ) {
    this.__class_name__ = "WIDGET.WeatherForPreview";
    this.initSpecific( data );
};
WIDGET.WeatherForPreview.prototype = {
    initSpecific    : WIDGET.Weather.prototype.initSpecific,
    computeHtml     : function () {
        if ( this.getDomElement() ) {
            return;
        }
        this.__computeHtml();
        CONTROLLER.Form.doActionAfter( "widget_preview__compute_html_done", { [ WIDGET.CONST.PARAM_EVENT.WIDGET_DOM_ELEMENT ]: this.getDomElement() } );
    },
    getDomZoneByName: function ( name ) {
        switch ( name ) {
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-left-area" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-top-right-area" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-sla" );
            case  SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY:
                return this.getDomElement().querySelector( ".shinken-cell-name" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.WeatherForPreview, WIDGET.Weather );
WIDGET.ZoneForPreview           = function ( name ) {
    this.__class_name__ = "WIDGET.ZoneForPreview";
    this.init( name );
};
WIDGET.ZoneForPreview.prototype = {
    init             : function ( name ) {
        this.name = name;
        this.initCounterCommon();
        this.initPhase();
        this.button = new COMPONENT.ButtonFromData_V3( "change__widget_preview_zone__activity", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) ).outerHTML );
        this.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME, this.name );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    getUUID          : function ( event_name, params ) {
        return this.name;
    },
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.button.addParamForEvents( key, value );
    },
    computeHtml              : function ( dom_element_parent ) {
        if ( !this.getDomElement() ) {
            this.setDomElement( DOM.Service.createElement( "div", {
                class    : "shinken-grid-cell-mask-container-preview",
                "onclick": "MANAGER.EventManagerV2.doActionAfter(event,'change__widget_preview_zone__activity'," + this.parseParamForEventsToHtml() + ")"
            } ) );
            this.button.computeHtml();
            this.addDomElement( this.button.getDomElement() );
            this.addCountersTargetDomElement( this.getDomElement() );
            this.setPhaseDomElement( this.getDomElement() );
        }
        this.insertDomElementInPreview( dom_element_parent );
    },
    insertDomElementInPreview: function ( dom_element_parent ) {
        if ( !dom_element_parent ) {
            return;
        }
        dom_element_parent.classList.add( "shinken-relative-div" );
        DOM.Service.addElementTo( this.getDomElement(), dom_element_parent );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ZoneForPreview, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.ZoneForPreview, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview           = function ( name, label, grid_cell_for_preview ) {
    this.initSpecific( name, label );
    this.initZonePreview();
    if ( grid_cell_for_preview ) {
        this.widget_preview = grid_cell_for_preview[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ];
    }
};
SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview.prototype = {
    initSpecific     : SHINKEN.OBJECT.CollapseFolderForProperties.prototype.initSpecific,
    setCountersParent: SHINKEN.OBJECT.CollapseFolderForProperties.prototype.setCountersParent,
    initZonePreview  : function () {
        this.zone_preview = new WIDGET.ZoneForPreview( this.getName() );
        this.setCountersParent( this.zone_preview );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "hide_collapse_folder":
                this.zone_preview.setPhase( SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                this.setVisibilityState( SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
            case "widget_preview__compute_html_done":
                this.computeSpecificHtml();
                break;
            case "change__widget_preview_zone__activity":
                let is_current_cf = params[ SHINKEN.OBJECT.COLLAPSE.PARAM.NAME ] === this.getName();
                if ( this.zone_preview.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) ) {
                    is_current_cf = false;
                }
                this.zone_preview.setPhaseOrPhase( is_current_cf, SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING, SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                this.setVisibilityState( is_current_cf ? SHINKEN.CONST.VISIBILITY_STATE.NORMAL : SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
                break;
        }
        this.doActionAfterCommon( event_name, params );
    },
    
    computeSpecificHtml: function () {
        this.zone_preview.computeHtml( this.widget_preview ? this.widget_preview.getDomZoneByName( this.getName() ) : null );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview, SHINKEN.OBJECT.CollapseFolderForProperties );
