"use strict";
var WEATHER   = {};
WEATHER.CONST = {
    WIDGET_TYPE   : {
        WEATHER  : "weather",
        SEPARATOR: "separator",
        TITLE    : "title"
    },
    DEFAULT_VALUE : "default",
    PARAM         : {
        PAGE: {
            NOTIFICATIONS  : {
                _KEY  : "notifications",
                SOUND : {
                    _KEY: "sound"
                },
                VISUAL: {
                    _KEY : "visual",
                    BLINK: {
                        _KEY: "blink"
                    }
                },
                COMMON: {
                    ENABLED: "enabled"
                }
            },
            TYPE           : "type",
            WEATHER_UUID   : "weather_uuid",
            USERS          : {
                _KEY               : "users",
                COMMON             : {
                    USER_NAME: "user_name",
                    USER_UUID: "user_uuid"
                },
                OWNER_USER         : "owner_user",
                PREVIOUS_OWNER_USER: "previous_owner_user",
                CREATOR_USER       : "creator_user"
            },
            WEATHER_VERSION: "weather_version"
        }
    },
    DOM_ELEMENT   : {
        EDIT_MODE_BTN_EXTERNAL_LINKS_CONTAINER: "edit_mode_btn_external_links_container"
    },
    EXTERNAL_LINKS: {
        _KEY                 : "external_links",
        SLIDE_PANEL_FORM_NAME: "slide-panel_external-links-form",
        PARAM                : {
            DEFAULT_LINK : {
                _KEY        : "default_link",
                COMPOSED_KEY: "external_links.default_link"
            },
            URL_CF       : "url",
            CONFIGURATION: "configuration",
            LINKS                 : "links",
            LINK_PREVIEW_URL      : "link_preview_url",
            LINK_NAME             : {
                _KEY        : "link_name",
                COMPOSED_KEY: "link_name",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_UUID             : {
                _KEY        : "link_uuid",
                COMPOSED_KEY: "link_uuid",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_PROTOCOL         : {
                _KEY        : "link_protocol",
                COMPOSED_KEY: "link_protocol",
                OPTIONS     : {
                    PROTOCOL_FROM_WEBUI: "protocol_from_webui",
                    HTTPS              : "https",
                    HTTP               : "http"
                }
            },
            LINK_BASE_URL         : {
                _KEY        : "link_base_url",
                COMPOSED_KEY: "link_base_url",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            LINK_EXTERNAL_PART_URL: {
                _KEY        : "link_external_part_url",
                COMPOSED_KEY: "link_external_part_url",
                OPTIONS     : {
                    STRING_INPUT: "string_input"
                }
            },
            AUTHENTICATION_NEEDED : {
                _KEY        : "authentication_needed",
                COMPOSED_KEY: "authentication_needed",
                OPTIONS     : {
                    TRUE : "true",
                    FALSE: "false"
                }
            },
            INFO_BAR              : {
                _KEY            : "info_bar",
                BACKGROUND_COLOR: {
                    _KEY        : "background_color",
                    COMPOSED_KEY: "info_bar.background_color",
                    OPTIONS     : {
                        STRING_INPUT: "string_input"
                    }
                },
                LOGO_DISPLAYED  : {
                    _KEY        : "logo_displayed",
                    COMPOSED_KEY: "info_bar.logo_displayed",
                    OPTIONS     : {
                        TRUE : "true",
                        FALSE: "false"
                    }
                },
                POSITION        : {
                    _KEY        : "position",
                    COMPOSED_KEY: "info_bar.position",
                    OPTIONS     : {
                        TOP   : "top",
                        BOTTOM: "bottom"
                    }
                },
                REFRESH         : {
                    _KEY                     : "refresh",
                    CHRONO_DISPLAYED         : {
                        _KEY        : "chrono_displayed",
                        COMPOSED_KEY: "info_bar.refresh.chrono_displayed",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    },
                    GENERATION_TIME_DISPLAYED: {
                        _KEY        : "chrono_displayed",
                        COMPOSED_KEY: "info_bar.refresh.generation_time_displayed",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    }
                }
            },
            NOTIFICATIONS         : {
                _KEY  : "notifications",
                SOUND : {
                    _KEY   : "sound",
                    ENABLED: {
                        _KEY        : "enabled",
                        COMPOSED_KEY: "notifications.sound.enabled",
                        OPTIONS     : {
                            TRUE : "true",
                            FALSE: "false"
                        }
                    }
                },
                VISUAL: {
                    _KEY : "visual",
                    BLINK: {
                        _KEY   : "blink",
                        ENABLED: {
                            _KEY        : "enabled",
                            COMPOSED_KEY: "notifications.visual.blink.enabled",
                            OPTIONS     : {
                                TRUE : "true",
                                FALSE: "false"
                            }
                        }
                    }
                }
            }
        },
        EVENTS_PARAM         : {
            EXTERNAL_LINKS       : "links_external__objects",
            LIST_LINK__UUID      : "link_list_objects__uuid",
            DEFAULT_EXTERNAL_LINK: "link__default__object",
            LINK__UUID           : "link__object__uuid",
            LINK__FORM__MAIN_LINK: "link__form__main_link_object",
            EXTERNAL_LINK_FORM   : "link__form__object"
        }
    },
    
    WINDOWS_TABS_EDITION_MESSAGE: {
        TABS     : [
            {
                name: "general"
            },
            {
                name: "widget"
            }
        ],
        INDEX_TAB: {
            GENERAL: 0,
            WIDGET : 1
        }
    },
    WINDOWS_TABS_EDIT_PART      : {
        TABS     : [
            {
                name     : "edit_tab_visual",
                is_active: true
            },
            {
                name: "edit_tab_json"
            },
            {
                name: "edit_tab_history"
            }
        ],
        INDEX_TAB: {
            VISUAL : 0,
            JSON   : 1,
            HISTORY: 2
        }
    },
    CONFIGURATION_ID_IS_OUTDATED: "configuration_id_is_outdated",
    COMPONENT                   : {
        SVG: {
            RADIO_ICON: "", //INIT DYNAMIC
            SUN       : "", //INIT DYNAMIC
            SEPARATOR : "", //INIT DYNAMIC
            UNKNOWN   : "" //INIT DYNAMIC
        }
    },
    STEP                        : {
        JS_JSON_VERIFICATION     : 1,
        CALL_BACKEND_VERIFICATION: 2,
        BACKEND_RETURN_TREATMENT : 3,
        END                      : 4
    }
};
WEATHER.CONST.isExternalLinkComposedKey = function ( composed_key ) {
    switch ( composed_key ) {
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.POSITION.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.LOGO_DISPLAYED.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.CHRONO_DISPLAYED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.GENERATION_TIME_DISPLAYED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED.COMPOSED_KEY :
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED.COMPOSED_KEY:
        case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED.COMPOSED_KEY:
            return true;
    }
    return false;
};
var WIDGET   = {};
WIDGET.CONST = {
    PARAM             : {
        TITLE  : "title",
        LAYOUT : "layout",
        TYPE   : {
            _KEY        : "type",
            COMPOSED_KEY: "widget.content.type"
        },
        ITEM   : {
            _KEY              : "item",
            NAME              : {
                _KEY        : "item_name",
                COMPOSED_KEY: "weather_widget.content.item.item_name"
            },
            VISUALISATION_NAME: {
                _KEY        : "visualisation_name",
                COMPOSED_KEY: "weather_widget.content.item.visualisation_name"
            },
            UUID              : {
                _KEY        : "item_uuid",
                COMPOSED_KEY: "weather_widget.content.item.item_uuid"
            },
            TYPE              : {
                _KEY        : "item_type",
                COMPOSED_KEY: "weather_widget.content.item.item_type"
            }
        },
        LAYOUTS: {
            TITLE    : {
                _KEY  : "title_widget_layout",
                COMPOSED_KEY : "title_widget.content",
                LAYOUT: {
                    _KEY                  : "layout",
                    INFORMATION_TO_DISPLAY: {
                        _KEY      : "information_to_display",
                        TITLE_AREA: {
                            _KEY             : "title_area",
                            TEXT_COLOR       : {
                                _KEY        : "text_color",
                                COMPOSED_KEY: "title_widget.content.layout.information_to_display.title_area.text_color",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            },
                            TEXT_ALIGN       : {
                                _KEY        : "text_align",
                                COMPOSED_KEY: "title_widget.content.layout.information_to_display.title_area.text_align",
                                OPTIONS     : {
                                    LEFT  : "left",
                                    CENTER: "center",
                                    RIGHT : "right"
                                }
                            },
                            FONT_ZOOM_PERCENT: {
                                _KEY        : "font_zoom_percent",
                                COMPOSED_KEY: "title_widget.content.layout.information_to_display.title_area.font_zoom_percent",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            },
                            LABEL            : {
                                _KEY        : "label",
                                COMPOSED_KEY: "title_widget.content.layout.information_to_display.title_area.label"
                            }
                        }
                    }
                },
                WIDTH : {
                    _KEY        : "width",
                    COMPOSED_KEY: "title_widget.width",
                    OPTIONS     : {
                        STRING_INPUT: "string_input",
                        ALL         : "all"
                    }
                },
                HEIGHT: {
                    _KEY        : "height",
                    COMPOSED_KEY: "title_widget.height",
                    OPTIONS     : {
                        STRING_INPUT: "string_input"
                    }
                }
            },
            SEPARATOR: {
                _KEY  : "separator_widget_layout",
                WIDTH : {
                    _KEY        : "width",
                    COMPOSED_KEY: "separator_widget.width",
                    OPTIONS     : {
                        STRING_INPUT: "string_input",
                        ALL         : "all"
                    }
                },
                HEIGHT: {
                    _KEY        : "height",
                    COMPOSED_KEY: "separator_widget.height",
                    OPTIONS     : {
                        STRING_INPUT: "string_input"
                    }
                },
                LAYOUT: {
                    _KEY                  : "layout",
                    INFORMATION_TO_DISPLAY: {
                        _KEY      : "information_to_display",
                        LEFT_AREA : {
                            _KEY         : "left_area",
                            DISPLAYED    : {
                                _KEY        : "displayed",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.left_area.displayed",
                                OPTIONS     : {
                                    TRUE : "true",
                                    FALSE: "false"
                                }
                            },
                            WIDTH_PERCENT: {
                                _KEY        : "width_percent",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.left_area.width_percent",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            }
                        },
                        RIGHT_AREA: {
                            _KEY         : "right_area",
                            DISPLAYED    : {
                                _KEY        : "displayed",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.right_area.displayed",
                                OPTIONS     : {
                                    TRUE : "true",
                                    FALSE: "false"
                                }
                            },
                            WIDTH_PERCENT: {
                                _KEY        : "width_percent",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.right_area.width_percent",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            }
                        },
                        TITLE_AREA: {
                            _KEY             : "title_area",
                            TEXT_COLOR       : {
                                _KEY        : "text_color",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.title_area.text_color",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            },
                            TEXT_ALIGN       : {
                                _KEY        : "text_align",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.title_area.text_align",
                                OPTIONS     : {
                                    LEFT  : "left",
                                    CENTER: "center",
                                    RIGHT : "right"
                                }
                            },
                            FONT_ZOOM_PERCENT: {
                                _KEY        : "font_zoom_percent",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.title_area.font_zoom_percent",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            },
                            LABEL            : {
                                _KEY        : "label",
                                COMPOSED_KEY: "separator_widget.content.layout.information_to_display.title_area.label"
                            }
                        }
                    }
                }
            },
            WEATHER  : {
                _KEY  : "weather_widget_layout",
                WIDTH : {
                    _KEY        : "width",
                    COMPOSED_KEY: "weather_widget.width",
                    OPTIONS     : {
                        STRING_INPUT: "string_input",
                        ALL         : "all"
                    }
                },
                HEIGHT: {
                    _KEY        : "height",
                    COMPOSED_KEY: "weather_widget.height",
                    OPTIONS     : {
                        STRING_INPUT: "string_input"
                    }
                },
                LAYOUT: {
                    _KEY                  : "layout",
                    BACKGROUND            : {
                        _KEY        : "background",
                        COMPOSED_KEY: "weather_widget.content.layout.background",
                        OPTIONS     : {
                            ONLY_STATUS        : "only_status",
                            NO_BACKGROUND      : "no_background",
                            CONTEXT_AND_STATUS : "context_and_status",
                            CONTEXT_THEN_STATUS: "context_then_status",
                            FROM_WEBUI         : "status_context_from_webui"
                        }
                    },
                    INFORMATION_TO_DISPLAY: {
                        _KEY          : "information_to_display",
                        LEFT_AREA     : {
                            _KEY     : "left_area",
                            ICON_TYPE: {
                                _KEY        : "icon_type",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.left_area.icon_type",
                                OPTIONS     : {
                                    ONLY_STATUS         : "only_status",
                                    STATUS_THEN_CONTEXT : "status_then_context",
                                    CONTEXT_THEN_STATUS : "context_then_status",
                                    SLA_TENDENCY        : "sla_tendency",
                                    QUALITY_SERVICE_ICON: "quality_service_icon",
                                    FROM_WEBUI          : "status_context_from_webui"
                                }
                            }
                        },
                        TOP_RIGHT_AREA: {
                            _KEY     : "top_right_area",
                            DISPLAYED: {
                                _KEY        : "displayed",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.top_right_area.displayed",
                                OPTIONS     : {
                                    TRUE : "true",
                                    FALSE: "false"
                                }
                            },
                            ICON_TYPE: {
                                _KEY        : "icon_type",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.top_right_area.icon_type",
                                OPTIONS     : {
                                    ONLY_STATUS         : "only_status",
                                    CONTEXT_THEN_STATUS : "context_then_status",
                                    STATUS_THEN_CONTEXT : "status_then_context",
                                    QUALITY_SERVICE_ICON: "quality_service_icon",
                                    FROM_WEBUI          : "status_context_from_webui"
                                }
                            }
                        },
                        SLA_AREA      : {
                            _KEY     : "sla_area",
                            DISPLAYED: {
                                _KEY        : "displayed",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.sla_area.displayed",
                                OPTIONS     : {
                                    TRUE : "true",
                                    FALSE: "false"
                                }
                            },
                            SHOW_ICON: {
                                _KEY        : "show_icon",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.sla_area.show_icon",
                                OPTIONS     : {
                                    TRUE : "true",
                                    FALSE: "false"
                                }
                            }
                        },
                        NAME_AREA     : {
                            _KEY                 : "name_area",
                            PROPERTY_USED_AS_NAME: {
                                _KEY        : "property_used_as_name",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.name_area.property_used_as_name",
                                OPTIONS     : {
                                    ITEM_NAME         : "item_name",
                                    VISUALISATION_NAME: "visualisation_name"
                                }
                            },
                            NB_LINES_MAX         : {
                                _KEY        : "nb_lines_max",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.name_area.nb_lines_max",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            },
                            VERTICAL_ALIGN       : {
                                _KEY        : "vertical_align",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.name_area.vertical_align",
                                OPTIONS     : {
                                    TOP   : "top",
                                    MIDDLE: "middle",
                                    BOTTOM: "bottom"
                                }
                            },
                            FONT_ZOOM_PERCENT    : {
                                _KEY        : "font_zoom_percent",
                                COMPOSED_KEY: "weather_widget.content.layout.information_to_display.name_area.font_zoom_percent",
                                OPTIONS     : {
                                    STRING_INPUT: "string_input"
                                }
                            }
                        }
                    }
                }
            }
        }
    },
    STATE_NOT_EXISTING: {
        INIT          : "init",
        FULL_INFO     : "full-info",
        NO_NAME       : "no-name",
        NO_UUID       : "no-uuid",
        NOT_CONFIGURED: "not-configured"
    },
    TYPE              : {
        SEPARATOR             : "separator_widget",
        TITLE                 : "title_widget",
        WEATHER               : "weather_widget",
        SHINKEN_GRID_STRUCTURE: "shinken-grid-structure",
        EXTERNAL_LINKS        : "external_links",
        UNKNOWN               : "Unknown_type_widget"
    },
    COMMON            : {
        PERFECT_RATIO: 3.2
    },
    WEATHER           : {
        PERFECT_RATIO          : 3.2,
        RIGHT_CELL_RATIO       : 0.45,
        SLA_LABEL_CELL_RATIO   : 0.25,
        SLA_TENDENCY_CELL_RATIO: 0.19,
        SLA_VALUE_CELL_RATIO   : 0.5,
        SLA_ICON_CELL_RATIO    : 0.4,
        SLA_CELL_HEIGHT_RATIO  : 0.25,
        STYLE                  : {
            PADDING_CONTENT: 0.05,
            BORDER_SIZE    : 0.025
        },
        ENUM                   : {
            VERTICAL_ALIGN       : {
                TOP   : "top",
                MIDDLE: "middle",
                BOTTOM: "bottom"
            },
            TEXT_ALIGN           : {
                LEFT  : "left",
                CENTER: "center",
                RIGHT : "right"
            },
            PROPERTY_USED_AS_NAME: {
                ITEM_NAME         : "item_name",
                VISUALISATION_NAME: "visualisation_name"
            },
            ITEM_TYPE            : {
                HOST   : "host",
                CLUSTER: "cluster"
            }
        }
    },
    PARAM_EVENT       : {
        WIDGET_DOM_ELEMENT   : "widget_dom_element",
        WIDGET_DATA_FROM_FORM: "widget__data__from_form",
        WIDGET_CONTAINER_KEY : "widget_container_key",
        WIDGET_TYPE          : "widget__type"
    }
};
WIDGET.CONST.isSameIconType = function ( value_left, value_right ) {
    if ( SHINKEN.TOOLS.ARRAY.contains( [
             WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS,
             WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT,
             WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS,
             WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI
         ], value_left[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] )
         && SHINKEN.TOOLS.ARRAY.contains( [
            WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS,
            WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT,
            WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS,
            WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI
        ], value_right[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] ) ) {
        return true;
    }
    return value_left[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON &&
           value_right[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON;
};
WIDGET.factory = function ( data ) {
    var _to_return;
    var _type = "";
    try {
        _type = data[ SHINKEN_PAGE.CONST.PARAM.SPECIFIC_TREATMENT.OBJECT_VALUE ][ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
    }
    catch ( e ) {
        try {
            _type = data[ WIDGET.CONST.PARAM.TYPE._KEY ].value || "";
        }
        catch ( e ) {
            _type = data[ "item_type" ] || "";
        }
    }
    switch ( _type ) {
        case WIDGET.CONST.TYPE.WEATHER:
            _to_return = new WIDGET.Weather( data );
            break;
        case WIDGET.CONST.TYPE.TITLE:
            _to_return = new WIDGET.Title( data );
            break;
        case WIDGET.CONST.TYPE.SEPARATOR:
            _to_return = new WIDGET.Separator( data );
            break;
        case WIDGET.CONST.TYPE.SHINKEN_GRID_STRUCTURE:
            _to_return = new WIDGET.ShinkenGridStructure( data );
            break;
        default:
            _to_return = new WIDGET.Unknown( data );
            break;
    }
    _to_return._timeout_compute_ellipsis = null;
    return _to_return;
};
WIDGET.InterfaceWidget           = function () {
};
WIDGET.InterfaceWidget.prototype = {
    init: function ( data ) {
        this.initPhase();
        this.initInternal();
        this.updateData( data );
        this.addParamForEvents( WIDGET.CONST.PARAM_EVENT.WIDGET_CONTAINER_KEY, SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT );
    },
    doActionAfter      : function ( event_name, params, param_2, param_3 ) {
        return this.doActionAfterCommon( event_name, params, param_2, param_3 );
    },
    doActionAfterCommon: function ( event_name, params ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                switch ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getTypeModification() ) {
                    case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                        if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN.OBJECT.SHINKEN_ELEMENT_HTML.PARAM_EVENT.NAME ) ) {
                            this[ WIDGET.CONST.PARAM.ITEM._KEY ].doActionAfter( event_name, params );
                            return;
                        }
                        break;
                    case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PARAM_MODIFICATION:
                        let param_object = SHINKEN.TOOLS.DICT.getObjectWithComposedKey_fromStartKey( this, params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ), SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT );
                        param_object.doActionAfter( event_name, params );
                        this.updateDomElement();
                        break;
                }
        }
    },
    _getValidOwnProperty      : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.TYPE._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.TYPE ), true]
        ] );
    },
    setDomElementParent       : function ( toSet ) {
        this.dom_element_parent = toSet;
    },
    getTypeValue              : function () {
        return this[ WIDGET.CONST.PARAM.TYPE._KEY ].getValue();
    },
    getUUID                   : function () {
    },
    getObjectClassName        : function () {
        return this.__class_name__ || "WIDGET.InterfaceWidget";
    },
    getLastModificationElement: function ( type_modification ) {
        let to_return;
        let data_last_modification;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                previous = this.getDataForLastModification();
                break;
        }
        to_return = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        return to_return;
    },
    computeMapping: function ( mapping ) {
    },
    computeEllipsis: function () {
    },
    computeContentWithChange: function () {
        return 0;
    },
    updateHtml   : function () {
        this.computeHtml();
        this._updateHtml();
        this.__updateHtml();
    },
    _updateHtml  : function () {
    },
    __updateHtml : function () {
    },
    updateSize   : function () {
    },
    computeHtml  : function () {
        this.__computeHtml();
    },
    __computeHtml: function () {
    },
    blink: function ( nb_of_blink ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.InterfaceWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.InterfaceWidget, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.InterfaceWidget, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.InterfaceWidget, SHINKEN_GRID.BelongGridCell );
WIDGET.InterfaceWidgetShinkenElement = function ( data ) {
};
WIDGET.InterfaceWidgetShinkenElement.prototype = {
    updateShinkenElementData: function ( data ) {
        this[ WIDGET.CONST.PARAM.ITEM._KEY ].updateData( data );
        this.computeWidgetHasChange();
    },
    getShinkenElement             : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].getShinkenElement();
    },
    computeWidgetHasChange        : function () {
        this.has_shinken_element_change = this.computeHasShinkenElementChange();
        DOM.Service.addOrRemoveClasses( this.dom_element, this.has_shinken_element_change, "shinken-widget-has-change" );
    },
    computeHasShinkenElementChange: function () {
        return false;
    },
    getPreviousStatus             : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.previous_status;
    },
    getPreviousContext            : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.previous_context;
    },
    getStatus                     : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.status;
    },
    getContext                    : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.context;
    },
    getTendency                   : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].tendency;
    },
    getName                       : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.name;
    },
    getSlaValue                   : function () {
        if ( this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] ) {
            return '';
        }
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].sla_value_html;
    },
    getSlaQuality                 : function () {
        return this[ WIDGET.CONST.PARAM.ITEM._KEY ].sla_quality_html;
    },
    getTendencyHtml               : function () {
        var _to_return = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-arrow-tendency-with-no-data' ) );
        
        return _to_return;
    },
    computeContentWithChange: function () {
        return this.has_shinken_element_change ? 1 : 0;
    },
    computeMapping: function ( mapping ) {
        if ( this.getChild( WIDGET.CONST.PARAM.ITEM._KEY ) instanceof SHINKEN.OBJECT.ShinkenElementHtml ) {
            this.getChild( WIDGET.CONST.PARAM.ITEM._KEY ).computeMapping( mapping );
        }
    },
    callbackForPhase: function () {
        if ( this[ WIDGET.CONST.PARAM.ITEM._KEY ].isPhase( SHINKEN.OBJECT.CONST.PHASE.WAITING_FOR_UPDATE ) ) {
            if ( this.dom_element_parent ) {
                this.updateHtml();
            }
            this[ WIDGET.CONST.PARAM.ITEM._KEY ].setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.InterfaceWidgetShinkenElement, WIDGET.InterfaceWidget );
SHINKEN.OBJECT.DefaultConfigurationWidgetInterface           = function ( data ) {
};
SHINKEN.OBJECT.DefaultConfigurationWidgetInterface.prototype = {
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "default__param__configured__from_form":
                const param_to_update                                       = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ];
                param_to_update.addParamsForEvents( this.getParamForEvents() );
                param_to_update.doActionAfter( "value__param__configured__from_form", params );
                break;
            case "redo_last_modification":
            case "undo_last_modification": {
                const param_to_update      = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ) );
                param_to_update.doActionAfter(  event_name, params );
                break;
            }
        }
        this.doActionAfterCommon( event_name, params );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWidgetInterface, SHINKEN.OBJECT.EditableElementInterface );
CONTROLLER.Weather = (function ( self ) {
    self.controller_name = CONTROLLER.CONST.WEATHER.NAME;
    self.timeout_resize  = null;
    self.init            = function () {
        self.current_page = __has_edit_mode__ ? new WEATHER.PageEdit( __weather_uuid__ ) : new WEATHER.Page( __weather_uuid__ );
        CONTROLLER.PageController.setCurrentPage( self.current_page );
        CONTROLLER.PageController.askShowLoadingPage();
    };
    self.doActionAfter   = function ( event_name, params ) {
        switch ( event_name ) {
            case "ask_compute_notification_of_change":
                self.current_page.doActionAfter( event_name, params );
                return;
            case "enter_in_edit_mode":
                self.current_page.clickOnButton( event, event_name, "" );
                return;
        }
    };
    return self;
})
( CONTROLLER.Weather || {} );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    try {
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );
window.addEventListener( "resize", function () {
    CONTROLLER.PageController.askComputeSizes();
} );
window.addEventListener( "click", function ( event ) {
    CONTROLLER.PageController.doActionAfter( "on_click_2024_07_31", { [ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]: event } );
    CONTROLLER.PageController.doActionAfter( "mouse_up", { [ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]: event } );
} );
window.addEventListener( "mousedown", function ( event ) {
    SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "click_on_iframe", event );
} );
var doActionWhenDomReady = function ( e ) {
    CONTROLLER.Weather.init();
};
document.onkeydown = function ( e ) {
    var _code = e.key;
    switch ( _code ) {
        case "F1":
            if ( __has_edit_mode__ ) {
                e.preventDefault();
                SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.askOpenHelp();
            }
            break;
    }
};
SHINKEN.OBJECT.DefaultConfigurationExternalLinks           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationExternalLinks.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK._KEY, "WIDGET.SeparatorForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationExternalLinks, SHINKEN.OBJECT.DefaultConfigurationWidgetInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationExternalLinks, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.DefaultConfigurationGridLayouts           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationGridLayouts.prototype = {
    init                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.init,
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER._KEY, "SHINKEN.OBJECT.DefaultConfigurationWeatherWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR._KEY, "SHINKEN.OBJECT.DefaultConfigurationSeparatorWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE._KEY, "SHINKEN.OBJECT.DefaultConfigurationTitleWidget"]
        ] );
    },
    getValueForComposedKeyProperty: function ( property ) {
        let type_widget = property.getName().split( "." )[ 0 ];
        let current_layout = this[ type_widget + "_layout" ];
        let current_value = SHINKEN.TOOLS.DICT.getValueWithComposedKey( current_layout, property.getName() );
        return current_value.user_value;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationGridLayouts, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.DefaultConfigurationPageDefault           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationPageDefault.prototype = {
    init                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.init,
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.EXTERNAL_LINKS._KEY, "SHINKEN.OBJECT.DefaultConfigurationExternalLinks"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationPageDefault, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.DefaultConfigurationSeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationSeparatorWidget.prototype = {
    init : SHINKEN.OBJECT.DefaultConfigurationWidgetInterface.prototype.init,
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [2, SHINKEN_VALIDATION.CONST.NUMBER.MAX, SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [1, SHINKEN_VALIDATION.CONST.NUMBER.MAX, this.getDefaultValueLabel()]]
        ] );
    },
    _getValidOwnChildren  : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren([
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "WIDGET.SeparatorForDefaultConfiguration"]
        ]);
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWidgetInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.DefaultConfigurationTitleWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationTitleWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [2, SHINKEN_VALIDATION.CONST.NUMBER.MAX, SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [1, SHINKEN_VALIDATION.CONST.NUMBER.MAX, this.getDefaultValueLabel()]]
        ] );
    },
    _getValidOwnChildren  : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren([
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "WIDGET.TitleForDefaultConfiguration"]
        ]);
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationTitleWidget, SHINKEN.OBJECT.DefaultConfigurationWidgetInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationTitleWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.DefaultConfigurationWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationWeatherWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [2, SHINKEN_VALIDATION.CONST.NUMBER.MAX, SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [1, SHINKEN_VALIDATION.CONST.NUMBER.MAX, this.getDefaultValueLabel()]]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "WIDGET.WeatherForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWidgetInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Cell           = function ( data ) {
    this.__class_name__ = "WEATHER.Cell";
    this.init( data );
};
WEATHER.Cell.prototype = {
    init: SHINKEN_GRID.Cell.prototype.init,
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "WIDGET.factory"]
        ] );
    },
    addHiddenCell       : function ( pos_x, pos_y ) {
        var data                                              = {};
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ] = pos_x;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ] = pos_y;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]     = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]      = 1;
        data[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ]    = { type: WIDGET.CONST.TYPE.SHINKEN_GRID_STRUCTURE, content: pos_x + "-" + pos_y };
        var _cell                                             = this.addCell( data );
        _cell.type                                            = WIDGET.CONST.TYPE.SHINKEN_GRID_STRUCTURE;
        _cell.addClass( WIDGET.CONST.TYPE.SHINKEN_GRID_STRUCTURE );
    },
    getChildConstructor: function ( data ) {
        return WIDGET.factory( data );
    },
    getCloneConstructor: function ( data ) {
        return new WEATHER.Cell( data );
    },
    confirmDoComputeHtml: function () {
        if ( __has_edit_mode__ ) {
            return true;
        }
        return !this.hasCounterProblems();
    },
    getController      : function () {
        return CONTROLLER.PageController;
    },
    getJsonEditorInstance   : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    getDefaultValueLabel        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getDefaultValueLabel,
    changeToDefaultValueIfNeeded: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.changeToDefaultValueIfNeeded,
    _setData                    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype._setData,
    initInternal                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initInternal,
    initMessages                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    setMessageValidation        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setMessageValidation,
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    setDataKey                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setDataKey,
    getObjectParamConstructor   : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor,
    getObjectMessagesConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectMessagesConstructor,
    doActionAfterAddMessages    : SHINKEN.OBJECT.CounterInterfaceValidation.prototype.doActionAfterAddMessages
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Cell, SHINKEN_GRID.Cell );
WEATHER.Cells           = function ( data ) {
    this.init( data );
};
WEATHER.Cells.prototype = {
    init: SHINKEN_GRID.Cells.prototype.init,
    getChildConstructor: function ( data ) {
        return new WEATHER.Cell( data );
    },
    getJsonEditorInstance   : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.WeatherJsonEditor( dom_element, json, default_tag );
    },
    _setData                    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype._setData,
    initMessages                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    setMessageValidation        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setMessageValidation,
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    getObjectParamConstructor   : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor,
    getObjectMessagesConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectMessagesConstructor
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Cells, SHINKEN_GRID.Cells );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Cells, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Grid           = function ( data ) {
    this.__class_name__ = "WEATHER.Grid";
    this.initSpecific( data );
};
WEATHER.Grid.prototype = {
    initSpecific: function ( data ) {
        this.mouse_position = {};
        this.font_size      = 0;
        this.init( data );
    },
    getController                  : function () {
        return CONTROLLER.PageController;
    },
    getDefaultValueOfGrid          : function () {
        return {
            [ WIDGET.CONST.TYPE.SEPARATOR ]              : this.layouts[ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR._KEY ],
            [ WIDGET.CONST.TYPE.WEATHER ]                : this.layouts[ WIDGET.CONST.PARAM.LAYOUTS.WEATHER._KEY ],
            [ WIDGET.CONST.TYPE.TITLE ]                  : this.layouts[ WIDGET.CONST.PARAM.LAYOUTS.TITLE._KEY ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]: this.nb_tiles_in_height,
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]: this.nb_tiles_in_width
        };
    },
    computeMapping: function ( mapping ) {
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] instanceof WEATHER.Cells ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeMapping( mapping );
        }
    },
    getChildConstructor : function ( data ) {
        return new WEATHER.Cells( data );
    },
    getDefaultValueLabel        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getDefaultValueLabel,
    changeToDefaultValueIfNeeded: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.changeToDefaultValueIfNeeded,
    initInternal                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initInternal,
    _setData                    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype._setData,
    initMessages                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    setMessageValidation        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setMessageValidation,
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    setDataKey                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setDataKey,
    getObjectParamConstructor   : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor,
    getObjectMessagesConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectMessagesConstructor
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Grid, SHINKEN_GRID.Grid );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Grid, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.Grids           = function ( data ) {
    this.init( data );
};
WEATHER.Grids.prototype = {
    init: SHINKEN_GRID.Grids.prototype.init,
    onMouseMove: function ( event ) {
        var _parent_dom_element = event.target.classList.contains( "shinken-weather-page" ) ?
                                  event.target.querySelector( ".shinken-parent-mouse-move-listener" ) :
                                  DOM.Service.findParentElementWithClass( event.target, "shinken-parent-mouse-move-listener", 30 );
        if ( !_parent_dom_element ) {
            return;
        }
        this.getGridByUUID( _parent_dom_element.dataset.gridUuid ).onMouseMove( event );
    },
    
    
    
    
    
    getChildConstructor: function ( data, uuid ) {
        return new WEATHER.Grid( data, uuid );
    },
    _setData                    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype._setData,
    getObjectParamConstructor   : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor,
    getObjectMessagesConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectMessagesConstructor,
    initMessages                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.initMessages,
    setMessageValidation        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setMessageValidation
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Grids, SHINKEN_GRID.Grids );
WEATHER.Notifications           = function ( data ) {
    this.init( data );
};
WEATHER.Notifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.SOUND._KEY, "WEATHER.SoundNotification" ],
            [ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL._KEY, "WEATHER.VisualNotifications" ]
        ] );
    },
    getSoundNotification   : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.SOUND ];
    },
    getVisualNotifications : function () {
        return this[ WEATHER.CONST.NOTIFICATION.PARAMS.VISUAL ];
    },
    hasNotificationsEnabled: function () {
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            return true;
        }
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            return true;
        }
        return false;
    },
    playNotifications      : function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( _sizeData === 0 ) {
            return;
        }
        if ( this.getSoundNotification() && this.getSoundNotification().hasNotificationEnabled() ) {
            this.getSoundNotification().playNotification();
        }
        this.playVisualNotifications( notifications_of_change );
    },
    playVisualNotifications: function ( notifications_of_change ) {
        var _sizeData = notifications_of_change.length;
        if ( this.getVisualNotifications() && this.getVisualNotifications().hasNotificationsEnabled() ) {
            for ( var i = 0; i < _sizeData; i++ ) {
                this.getVisualNotifications().playNotification( notifications_of_change[ i ] );
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Notifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.NotificationInterface           = function ( data ) {
    this.init( data );
};
WEATHER.NotificationInterface.prototype = {
    _getValidOwnProperty  : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    },
    hasNotificationEnabled: function () {
        return this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.COMMON.ENABLED ].getValue();
    },
    playNotification: function ( notification_of_change ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.NotificationInterface, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.SoundNotification           = function ( data ) {
    this.init( data );
};
WEATHER.SoundNotification.prototype = {
    setVolume       : function ( volume ) {
        this.getAudio().volume = volume;
    },
    playNotification: function () {
        var play_promise = this.getAudio().play();
    },
    getAudio        : function () {
        if ( !this.audio ) {
            this.audio = new Audio( "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/sound/notification_of_change.mp3" );
        }
        return this.audio;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.SoundNotification, WEATHER.NotificationInterface );
WEATHER.BlinkVisualNotification           = function ( data ) {
    this.init( data );
};
WEATHER.BlinkVisualNotification.prototype = {
    playNotification: function ( notification_of_change ) {
        notification_of_change.getObjectThatChanged().blink( 3 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.BlinkVisualNotification, WEATHER.NotificationInterface );
WEATHER.VisualNotifications           = function ( data ) {
    this.init( data );
};
WEATHER.VisualNotifications.prototype = {
    _getValidOwnChildren   : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY, "WEATHER.BlinkVisualNotification"]
        ] );
    },
    hasNotificationsEnabled: function () {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            return true;
        }
        return false;
    },
    playNotification: function ( notification_of_change ) {
        if ( this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ] && this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].hasNotificationEnabled() ) {
            this[ WEATHER.CONST.PARAM.PAGE.NOTIFICATIONS.VISUAL.BLINK._KEY ].playNotification( notification_of_change );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.VisualNotifications, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.UserGrids           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.UserGrids.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WEATHER.CONST.PARAM.PAGE.USERS.OWNER_USER, "SHINKEN.OBJECT.OwnerUserGrid"],
            [WEATHER.CONST.PARAM.PAGE.USERS.PREVIOUS_OWNER_USER, "SHINKEN.OBJECT.UserGrid"],
            [WEATHER.CONST.PARAM.PAGE.USERS.CREATOR_USER, "SHINKEN.OBJECT.UserGrid"]
        ] );
    },
    getCurrentOwner     : function () {
        if ( !this[ WEATHER.CONST.PARAM.PAGE.USERS.OWNER_USER ] ) {
            return false;
        }
        return this[ WEATHER.CONST.PARAM.PAGE.USERS.OWNER_USER ].getDataToSave();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.UserGrids, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.UserGrid           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.UserGrid.prototype = {
    _getValidOwnProperty        : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_NAME, SHINKEN_VALIDATION.CONST.STRING.IS_STRING],
            [WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_UUID, SHINKEN_VALIDATION.CONST.STRING.IS_STRING]
        ] );
    },
    changeToDefaultValueIfNeeded: function ( key, value, parameter ) {
    },
    getUUID: function () {
        return this[WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_UUID].getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.UserGrid, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.OwnerUserGrid           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.OwnerUserGrid.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_NAME, SHINKEN_VALIDATION.CONST.STRING.IS_STRING, undefined, true],
            [WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_UUID, SHINKEN_VALIDATION.CONST.STRING.IS_STRING, undefined, true]
        ] );
    },
    getUUID: function () {
        if ( this[WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_UUID] ){
            return this[WEATHER.CONST.PARAM.PAGE.USERS.COMMON.USER_UUID].getValue();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.OwnerUserGrid, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
WEATHER.InfoBar = function ( data, dom_element_parent ) {
    this.initSpecific( data, dom_element_parent );
};
WEATHER.InfoBar.prototype = {
    initSpecific             : function ( data, dom_element_parent ) {
        this.initCommon( data, dom_element_parent );
        this.initNotificationsOfChange( dom_element_parent );
    },
    initNotificationsOfChange: function ( dom_element_parent ) {
        this.notifications_of_change = new SHINKEN.OBJECT.NotificationsOfChangeView__fromData();
        this.notifications_of_change.initPhase();
        this.notifications_of_change.doActionAfter( "init_phase_with_dom_element", dom_element_parent );
    },
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "on_click_2024_07_31":
                this.notifications_of_change.doActionAfter( "click_done", params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                break;
            case "shinken_view_has_disabled_blink_notification":
            case "user_has_disabled_blink_notification":
            case "shinken_view_has_disabled_sound_notification":
            case "user_has_volume_muted_notification":
            case "set_phase_sound_depending_number_of_change":
            case "set_phase_blink_depending_number_of_change":
            case "ask_play_notifications":
            case "ask_play_notification_visual_blink":
                this.notifications_of_change.doActionAfter( event_name, params );
                break;
            case "update__notification_of_change__data":
                this.notifications_of_change.updateData( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.NOTIFICATIONS_OF_CHANGE__DATA ] );
                break;
        }
        this.doActionAfterCommon( event_name, params );
    },
    updateButtonExternalLinks: function ( state ) {
        this.button_external_links.setTooltipHtml( state === COMPONENT.CONST.BTN_STATE.EMPTY ? _( "external_link_tooltip.has_no_links" ) : "" );
        this.button_external_links.dom_element.setAttribute( "shi-tip-placement", "bottom" );
        this.button_external_links.setState( state );
    },
    getBlinkValue: function () {
        return this.notifications_of_change.getBlinkValue();
    },
    getSoundValue: function () {
        return this.notifications_of_change.getSoundValue();
    },
    computeHtml__extraContent      : function () {
        this.computeHtml__externalLinkButton();
        DOM.Service.addElementTo( this.notifications_of_change.getBlinkDomElement(), this.left_positioned_dom );
        DOM.Service.addElementTo( this.notifications_of_change.getSoundDomElement(), this.left_positioned_dom );
        this.computeHtml__viewPhase();
    },
    computeHtml__externalLinkButton: function () {
        if ( !__external_url_uuid__ && __user_is_admin__ ) {
            this.button_external_links = new COMPONENT.ButtonFromData_V3( "toggle_external_links_display", DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-open-link-svg" ) ).outerHTML + _( 'edit_mode.buttons.external_link' ) );
            this.button_external_links.computeHtml();
            
            let container_button = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-button-container shinken-weather-external-links-button-cell" } ), this.left_positioned_dom );
            DOM.Service.addElementTo( this.button_external_links.getDomElement(), container_button );
            this.external_link_dropdown = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-external-link-dropdown" } ), container_button );
        }
    },
    computeHtml__viewPhase         : function () {
        let container_view_phase = DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class              : "shinken-draft-phase-container shinken-view-behaviour-phase-cell shinken-hidden-if-running-phase",
            onmouseenter       : "SHINKEN_TOOLTIP.showTooltip(this)",
            onmouseleave       : "SHINKEN_TOOLTIP.hideTooltip()",
            id                 : "id-shinken-view-behaviour-phase",
            "shi-tip-html"     : _( 'info_bar.tooltip_draft' ),
            "shi-tip-placement": "bottom"
        } ), this.left_positioned_dom );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-draft-phase-content" }, _( 'info_bar.draft_tag' ) ), container_view_phase );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.InfoBar, SHINKEN_PAGE.InfoBar );
WEATHER.PageContent           = function ( weather_uuid, dom_element ) {
};
WEATHER.PageContent.prototype = {
    init             : function ( weather_uuid, dom_element ) {
        this.addParamForEvents( SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_CONTENT_UUID, "WEATHER.PageContent" );
        this.weather_uuid = weather_uuid;
        this.zoom_percent = 100;
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.INIT );
        this.initCounterCommon();
        this.setDomElement( dom_element );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    doActionAfter     : function ( event_name, param ) {
        if ( param ) {
            param[ "dom_relative_position_container_2024_07_18" ] = this.getDomElement();
        }
        switch ( event_name ) {
            case "set_edition_json_manually":
                this.setEditionJsonManually( param[ "is_json_modified_manually" ] );
                break;
            case "position_errors_have_been_modified":
                this.setEditionErrorsManually( true );
                break;
            case "mouse_down_on_grid_cell":
                return this.grids.doActionAfter( event_name, param );
            case "mouse_down":
                if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    this.grids.doActionAfter( "mouse_down", param );
                }
                break;
            case "mouse_up":
                if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    this.grids.doActionAfter( "mouse_up", param );
                }
                break;
            case "mouse_wheel":
                this.onBeforeMouseWheel( param );
                break;
            default:
                return this.grids.doActionAfter( event_name, param );
        }
    },
    onBeforeMouseWheel: function ( event ) {
        if ( event.ctrlKey && !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            event.preventDefault();
            event.stopPropagation();
            if ( !event.buttons ) {
                this.setZoomPercent( this.zoom_percent + 5 * SHINKEN.TOOLS.MOUSE.getWheelDelta( event ) );
            }
        }
    },
    setZoomPercent: function ( to_set ) {
        to_set = Math.min( 100, to_set );
        to_set = Math.max( 10, to_set );
        if ( this.zoom_percent === to_set ) {
            return;
        }
        this.zoom_percent = to_set;
        DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.WIDTH, this.zoom_percent + "%" );
        DOM.BodyService.addOrRemoveClasses( this.zoom_percent !== 100, "shinken-style-zoom-on" );
        this.grids.doActionAfter( "change_zoom_percent_for_widget", { [ SHINKEN_GRID.CONST.PARAM.GRID.ZOOM_PERCENT_FOR_WIDGET ]: this.zoom_percent } );
        this.computeSizes();
    },
    computeSizes           : function () {
        this.grids.computeSizes();
    },
    computeWidgetWithChange: function () {
        if ( !this.grids ) {
            return 0;
        }
        return this.grids.computeContentWithChange();
    },
    getChildrenObject    : function () {
        return [this.grids];
    },
    getChildrenObjectDict: function () {
        var to_return                                    = {};
        to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.GRIDS ] = this.grids;
        return to_return;
    },
    initDomElementsWithCells: function ( init_with_cells ) {
        this.grids.initDomElementsWithCells();
    },
    setEditionJsonManually  : function ( to_set, div_content_message ) {
        this._setEditionManually( to_set, _( "edit_mode.loading_message.json_modified_manually" ) );
    },
    setEditionErrorsManually: function ( to_set ) {
        this._setEditionManually( to_set, _( "edit_mode.loading_message.error_modified_manually" ) );
    },
    _setEditionManually     : function ( to_set, div_content_message ) {
        if ( to_set ) {
            if ( !document.querySelector( ".shinken-text-json-modified-container" ) ) {
                const _button = new COMPONENT.ButtonFromData_V2( "preview_grid_page", _( "edit_mode.buttons.preview" ) );
                _button.computeHtml();
                
                const _div_container = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-text-json-modified-container shinken-layout-center-h-v shinken-hide-when-hover" } ) );
                const _div_content   = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-text-json-modified-content shinken-layout-column shinken-layout-center-h-v" } ), _div_container );
                DOM.Service.addElementTo( DOM.Service.createElement( "span", {}, div_content_message ), _div_content );
                DOM.Service.addElementTo( _button.getDomElement(), _div_content );
            }
        }
        else {
            DOM.Service.removeElement( document.querySelector( ".shinken-text-json-modified-container" ) );
        }
    },
    reset      : function () {
        if ( this.grids ) {
            this.grids.reset();
            DOM.Service.empty( this.getDomElement() );
        }
    },
    setData    : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_PAGE.CONST.PARAM.PAGE.GRIDS:
                this.reset();
                this.grids = new WEATHER.Grids( value );
                this.grids.addParamsForEvents( this.getParamForEvents() );
                this.addSynchronizedPhase( this.grids );
                break;
            case SHINKEN_PAGE.CONST.PARAM.PAGE.ELEMENTS_DATA:
                this.computeData( value );
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
        }
    },
    computeData: function ( data ) {
        this.grids.updateContentData( data ); //WARNING OVERRIDE IN DOCUMENTATION
    },
    getDataToSave: function () {
        var _to_return                                    = {};
        _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.GRIDS ] = this[ SHINKEN_PAGE.CONST.PARAM.PAGE.GRIDS ].getDataToSave();
        return _to_return;
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
                if ( _current === SHINKEN.OBJECT.CONST.PHASE.RUNNING ) {
                    this.setZoomPercent( 100 );
                }
                if ( this.grids.computeHtml( this.getDomElement() ) ) {
                    this.addDomElement( this.grids.getDomElement() );
                }
                this.computeSizes();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageContent, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageContent, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.PageContent, SHINKEN.OBJECT.ShinkenObjectHtml );
WEATHER.Page           = function ( uuid ) {
    this.init( uuid );
};
WEATHER.Page.prototype = {
    init: function ( uuid ) {
        this.initCommon( uuid );
        this.user_prefs                             = new SHINKEN.ELEMENT.UiUserPrefs();
        this.default_notifications_of_changed       = new SHINKEN.OBJECT.NotificationsOfChangeDefaultValues();
        this.timeout_compute_notification_of_change = null;
    },
    onclick: function () {
        if ( !__external_url_uuid__ ) {
            this.notifications_of_change.doActionAfter( "click_done" );
        }
    },
    getCurrentOwner          : function () {
        if ( !this[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ] ){
            return false;
        }
        return this[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ].getCurrentOwner();
    },
    getChildrenObjectDict          : function () {
        const _to_return                                               = this.content.getChildrenObjectDict();
        _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ]         = this.users || new SHINKEN.OBJECT.UserGrids();
        _to_return[ WEATHER.CONST.EXTERNAL_LINKS._KEY ]                = this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ] || new WEATHER.ExternalLinks();
        _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.NOTIFICATIONS._KEY ] = this.notifications || new WEATHER.Notifications();
        return _to_return;
    },
    getChildrenObject              : function () {
        const _to_return = this.content.getChildrenObject();
        _to_return.push( this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ] );
        _to_return.push( this.users );
        _to_return.push( this.notifications );
        return _to_return;
    },
    getDefaultNotificationsOfChange: function ( actions_after_get_user_prefs ) {
        const url                                               = SHINKEN.HIGHWAY.getOrigin() + COMMUNICATION.QUERY.GET.NOTIFICATION_OF_CHANGE.GET_INFORMATION_FOR_WEATHER_EXTERNAL_LINKS;
        const actionAfterGetDefaultNotificationsOfChangeSuccess = function ( _status, data ) {
            actions_after_get_user_prefs( _status, data[ "default_notifications_settings" ] );
            MANAGER.DistributorResourcesManager.factory( "resources", data[ "resources" ] );
        };
        SHINKEN.COMUNICATION.requestGet( url, actionAfterGetDefaultNotificationsOfChangeSuccess );
    },
    getController                  : function () {
        return CONTROLLER.PageController;
    },
    getBackendDataUrl__20241008    : function () {
        var _url = SHINKEN.HIGHWAY.getOrigin() + "/" + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.WEATHER_SPACE;
        if ( __external_url_uuid__ ) {
            _url += "/" + __external_part_url__ + COMMUNICATION.QUERY.GET.SERVICE_WEATHER.GET_WEATHER + this.getUUID() + "/" + __external_url_uuid__;
        }
        else {
            _url += COMMUNICATION.QUERY.GET.SERVICE_WEATHER.GET_WEATHER + this.getUUID();
        }
        _url += "?weather_version=" + this.getPageVersion() + "&configuration_hash=" + __configuration_hash__ + "&validation_change_time=" + this[ SHINKEN_PAGE.CONST.PARAM.PAGE.VALIDATION_CHANGE_TIME ];
        _url += "&computed_value=true&include_validation_messages=true";
        return _url;
    },
    doActionWhenWeatherNotFound    : function () {
        SHINKEN.HIGHWAY.goTo( "/service-weather-not-found/" + this.getUUID() );
    },
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "click_on_button_V3" :
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "ask_play_notification_visual_blink":
                        this.bar_info.doActionAfter( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ], params );
                        return;
                }
                break;
            case "ask_play_notifications":
                this.bar_info.doActionAfter( event_name, params );
                return;
            case "ask_compute_notification_of_change":
                this.user_prefs.updateData( params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].current_user.prefs );
                this.default_notifications_of_changed.updateData( params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].default_notifications_of_changed );
                this.askComputeNotificationOfChange();
                break;
            case "enter_in_edit_mode":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                break;
        }
        this.doActionAfterCommon( event_name, params );
    },
    setIdentification              : function ( to_set ) {
        this.page_version                                    = to_set[ WEATHER.CONST.PARAM.PAGE.WEATHER_VERSION ][ "value" ];
        this[ SHINKEN_PAGE.CONST.PARAM.PAGE.IDENTIFICATION ] = to_set;
    },
    getInfoBarChildConstructor     : function ( data, parent_dom_element ) {
        return new WEATHER.InfoBar( data, parent_dom_element );
    },
    reset                       : function () {
        this.content = new WEATHER.PageContent();
        this.content.init( this.getUUID(), this.getDomElement().querySelector( ".shinken-weather-page" ) );
    },
    setData                     : function ( key, value ) {
        switch ( key ) {
            case WEATHER.CONST.EXTERNAL_LINKS._KEY:
                this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ] = new WEATHER.ExternalLinks( this.getUUID() );
                this[ WEATHER.CONST.EXTERNAL_LINKS._KEY ].initSpecific( value );
                return;
        }
        this.setDataCommon( key, value );
    },
    _setData                    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype._setData,
    updateData                  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.updateData,
    setMessageValidation        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.setMessageValidation,
    getDataForLastModification  : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getDataForLastModification,
    getObjectParamConstructor   : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor,
    isObjectParamConstructor    : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.isObjectParamConstructor,
    getDefaultValueLabel        : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getDefaultValueLabel,
    getObjectMessagesConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectMessagesConstructor,
    
    getNotificationOfChange       : function () {
        return this.bar_info;
    },
    askComputeNotificationOfChange: function () {
        if ( this.timeout_compute_notification_of_change ) {
            clearTimeout( this.timeout_compute_notification_of_change );
        }
        let self                                    = this;
        this.timeout_compute_notification_of_change = setTimeout( function () {
            self.computeNotificationOfChange();
            self.timeout_compute_notification_of_change = null;
        }, 100 );
    },
    computeNotificationOfChange   : function () {
        this.computeWidgetWithChange();
        if ( __has_authentication_needed__ ) {
            this.default_notifications_of_changed.computeViewSettings( this );
        }
        else {
            this.visual_notification_of_change_enabled = this.bar_info.getBlinkValue();
            this.sound_notification_of_change_enabled  = this.bar_info.getSoundValue();
        }
        if ( !this.visual_notification_of_change_enabled ) {
            this.bar_info.doActionAfter( "shinken_view_has_disabled_blink_notification" );
        }
        else if ( __has_authentication_needed__ && !this.default_notifications_of_changed.getFlatUserBlink( this.user_prefs.getNotificationOfChange() ) ) {
            this.bar_info.doActionAfter( "user_has_disabled_blink_notification" );
        }
        else {
            this.bar_info.doActionAfter( "set_phase_blink_depending_number_of_change", this.size_widget_with_change );
        }
        if ( !this.sound_notification_of_change_enabled ) {
            this.bar_info.doActionAfter( "shinken_view_has_disabled_sound_notification" );
        }
        else if ( __has_authentication_needed__ && !this.default_notifications_of_changed.getFlatUserVolume( this.user_prefs.getNotificationOfChange() ) ) {
            this.bar_info.doActionAfter( "user_has_volume_muted_notification" );
        }
        else {
            this.bar_info.doActionAfter( "set_phase_sound_depending_number_of_change", this.size_widget_with_change );
        }
        
        this.doActionAfter( "ask_play_notifications", __has_authentication_needed__ ? this.default_notifications_of_changed.getFlatUserVolume( this.user_prefs.getNotificationOfChange() ) : 100 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Page, SHINKEN.OBJECT.GridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Page, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( WEATHER.Page, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.OBJECT.InformationToDisplaySeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplaySeparatorWidget.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY, "SHINKEN.OBJECT.LeftAreaSeparatorWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY, "SHINKEN.OBJECT.TitleAreaSeparatorWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY, "SHINKEN.OBJECT.RightAreaSeparatorWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplaySeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.InformationToDisplaySeparatorWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplaySeparatorWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY, "SHINKEN.OBJECT.LeftAreaSeparatorWidgetForDefaultConfiguration"],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY, "SHINKEN.OBJECT.TitleAreaSeparatorWidgetForDefaultConfiguration"],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY, "SHINKEN.OBJECT.RightAreaSeparatorWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplaySeparatorWidgetForDefaultConfiguration, SHINKEN.OBJECT.InformationToDisplaySeparatorWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplaySeparatorWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UP
SHINKEN.OBJECT.LayoutSeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LayoutSeparatorWidget.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplaySeparatorWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.LayoutSeparatorWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LayoutSeparatorWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplaySeparatorWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutSeparatorWidgetForDefaultConfiguration, SHINKEN.OBJECT.LayoutSeparatorWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutSeparatorWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UP
SHINKEN.OBJECT.LeftAreaSeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LeftAreaSeparatorWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [0, 100, WEATHER.CONST.DEFAULT_VALUE]]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.LeftAreaSeparatorWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LeftAreaSeparatorWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaSeparatorWidgetForDefaultConfiguration, SHINKEN.OBJECT.LeftAreaSeparatorWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaSeparatorWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UP
SHINKEN.OBJECT.RightAreaSeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.RightAreaSeparatorWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN, [0, 100, WEATHER.CONST.DEFAULT_VALUE]]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RightAreaSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.RightAreaSeparatorWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.RightAreaSeparatorWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RightAreaSeparatorWidgetForDefaultConfiguration, SHINKEN.OBJECT.RightAreaSeparatorWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RightAreaSeparatorWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UP
SHINKEN.OBJECT.TitleAreaSeparatorWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.TitleAreaSeparatorWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY, SHINKEN_VALIDATION.CONST.STRING.MAX_LENGTH, 300, true],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.TEXT_ALIGN, WEATHER.CONST.DEFAULT_VALUE )]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaSeparatorWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.TitleAreaSeparatorWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.TitleAreaSeparatorWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnProperty            : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.TEXT_ALIGN, WEATHER.CONST.DEFAULT_VALUE )]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaSeparatorWidgetForDefaultConfiguration, SHINKEN.OBJECT.TitleAreaSeparatorWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaSeparatorWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UP
SHINKEN.OBJECT.SHINKEN_ELEMENT_HTML         = {
    PARAM_EVENT: {
        NAME: "shinken_element__name"
    }
};
SHINKEN.OBJECT.ShinkenElementHtml           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.ShinkenElementHtml.prototype = {
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "change__shinken_element__from_form":
                this.setPreviousModificationElement();
                this.resetCounters();
                this.initMessages();
                this.updateData( params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ] );
                this.initDataForEditionInProgress();
                this.addParamForEvents( SHINKEN.OBJECT.SHINKEN_ELEMENT_HTML.PARAM_EVENT.NAME, "SHINKEN.OBJECT.ShinkenElementHtml" );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE ) );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                this.doActionAfter__lastModification( event_name, params );
                break;
        }
        return this.doActionAfterCommon( event_name, params );
    },
    init: function ( data ) {
        this.initPhase();
        this.initInternal();
        this.shinken_element = new SHINKEN.OBJECT.ShinkenElement();
        this.html_to_update  = {};
        if ( data ) {
            this.updateData( data[ 'value' ] );         // NECESSARY BECAUSE SLA_VALUE HAS KEY VALUE AND CANNOT BE MANAGED WITH UPDATEDATA ON DEFAULT CONFIGURATION
            if ( data[ SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES ] ) {
                this.setData( SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES, data[ SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES ] );
            }
        }
    },
    _getValidOwnProperty              : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.ITEM.UUID._KEY, SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY, undefined, true],
            [WIDGET.CONST.PARAM.ITEM.NAME._KEY, SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY, undefined, true],
            [WIDGET.CONST.PARAM.ITEM.TYPE._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.ITEM_TYPE ), true]
        ] );
    },
    getUUID                           : function () {
        return this.getItemUuid();
    },
    setName                           : function ( toSet ) {
        if ( this.shinken_element.setName( toSet ) ) {
            this.addHtmlToUpdate( WIDGET.CONST.PARAM.ITEM.NAME._KEY );
        }
    },
    setVisualisationName              : function ( toSet ) {
        if ( this.shinken_element.setVisualisationName( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME );
        }
    },
    setContext                        : function ( toSet ) {
        if ( this.shinken_element.setContext( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT_OR_STATUS );
        }
        MANAGER.__instance_element_distributor.findElement( this.shinken_element.getUUID(), { uuid: this.shinken_element.getUUID(), name: this.shinken_element.getName(), context: toSet } );
    },
    setStatus                         : function ( toSet ) {
        if ( this.shinken_element.setStatus( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT_OR_STATUS );
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.QUALITY );
        }
        MANAGER.__instance_element_distributor.findElement( this.shinken_element.getUUID(), { uuid: this.shinken_element.getUUID(), name: this.shinken_element.getName(), status: toSet } );
    },
    setSlaValue                       : function ( toSet ) {
        if ( this.shinken_element.setSlaValue( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE );
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.QUALITY );
        }
    },
    setSlaThreshold                   : function ( key, value ) {
        if ( this.shinken_element.setSlaThreshold( key, value ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE );
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.QUALITY );
        }
    },
    isNotAuthorized                   : function ( toSet ) {
        if ( this.shinken_element.isNotAuthorized( toSet ) ) {
            this.addHtmlToUpdate( "ever" );
        }
    },
    setVisibilityWithoutAuthentication: function ( toSet ) {
        if ( this.shinken_element.setVisibilityWithoutAuthentication( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW );
        }
    },
    setExists                         : function ( toSet ) {
        this.shinken_element.setExists( toSet );
    },
    setSlaTendency                    : function ( toSet ) {
        if ( this.shinken_element.setSlaTendency( toSet ) ) {
            this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY );
        }
    },
    addHtmlToUpdate                   : function ( to_add ) {
        this.html_to_update[ to_add ] = true;
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.WAITING_FOR_UPDATE );
    },
    setStatusContextDisplay           : function ( toSet ) {
        this.statusContextDisplay = toSet;
    },
    getItemName                       : function () {
        return this.shinken_element.getName();
    },
    getItemNameForHtml                : function () {
        return SHINKEN.TOOLS.STRING.cleanXss( this.getItemName() );
    },
    getItemUuid                       : function () {
        return this.shinken_element.getUUID();
    },
    getItemUuidForHtml                : function () {
        return SHINKEN.TOOLS.STRING.cleanXss( this.getItemUuid() );
    },
    getItemType                       : function () {
        return this.shinken_element.getType();
    },
    getShinkenElement                 : function () {
        return this.shinken_element;
    },
    initDataForEditionInProgress      : function () {
        this.updateData( {
            "context"                                     : "NOTHING",
            "sla"                                         : {
                "value"             : "100.00",
                "warning_threshold" : 99,
                "critical_threshold": 97,
                "tendency"          : "arrow-up-ok"
            },
            "status"                                      : 0,
            "exists"                                      : true,
            "element_visibility_on_not_authenticated_view": false,
            "is_not_authorized_for_user"                  : false
        } );
    },
    computeMapping: function ( mapping ) {
        var _key = this.shinken_element.item_type + "-" + this.shinken_element.uuid;
        if ( !mapping[ _key ] ) {
            mapping[ _key ] = [];
        }
        mapping[ _key ].push( this );
    },
    updateData              : function ( data, skip_distributor ) {
        if ( !data ) {
            return;
        }
        if ( data[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] ) {
            data = data[ SHINKEN.OBJECT.CONST.PARAM.VALUE ];
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                 : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessageValidation( value );
                break;
            case WIDGET.CONST.PARAM.ITEM.UUID._KEY:
            case WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY:
                if ( typeof value === "object" ) {
                    this.setDataKey( WIDGET.CONST.PARAM.ITEM.UUID._KEY, value );
                    this.shinken_element.setUUID( value.value );
                }
                else {
                    this.shinken_element.setUUID( value );
                }
                break;
            case WIDGET.CONST.PARAM.ITEM.TYPE._KEY:
            case WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY:
                if ( typeof value === "object" ) {
                    this.setDataKey( WIDGET.CONST.PARAM.ITEM.TYPE._KEY, value );
                    this.shinken_element.setData( OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE, value.value );
                }
                else {
                    this.shinken_element.setData( OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE, value );
                }
                break;
            case WIDGET.CONST.PARAM.ITEM.NAME._KEY:
            case WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY:
                if ( value && typeof value === "object" ) {
                    this.setDataKey( WIDGET.CONST.PARAM.ITEM.NAME._KEY, value );
                    this.setName( value.value );
                }
                else {
                    this.setName( value );
                }
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT:
                this.setContext( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__:
                var _keys = Object.keys( value );
                var _current_key;
                for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                    _current_key = _keys[ i ];
                    this.setData( _current_key, value[ _current_key ] );
                }
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                this.setSlaValue( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                this.setSlaTendency( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
            case WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY:
                this.setVisualisationName( typeof value === "object" ? value.value : value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD:
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD:
                this.setSlaThreshold( key, value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING:
                this.setExists( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER:
                this.isNotAuthorized( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW:
                this.setVisibilityWithoutAuthentication( value );
                break;
            default:
                this._setData( key, value );
                break;
        }
    },
    doActionAfterAddMessages: function () {
        var _to_remove = 0;
        if ( __has_authentication_needed__ && __external_url_uuid__ ) {
            _to_remove = this.messages.countMessageWithText( COMPONENT.CONST.STATUS.WARNING, _( "validation.business.widgets.weather.not_visible_in_external_link_without_authentication" ) );
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, "SHINKEN.OBJECT.ShinkenElementHtml", this.messages.getNumberWarnings() - _to_remove );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, "SHINKEN.OBJECT.ShinkenElementHtml", this.messages.getNumberErrors() );
    },
    getDataForLastModification     : function () {
        let _to_return = this.getDataForLastModificationCommon();
        if ( this.shinken_element.isConfigured() ) {
            _to_return = this.shinken_element.getDataForLastModification( _to_return );
        }
        if ( this.messages.hasMessage() ) {
            _to_return[ SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES ] = this.messages;
        }
        return _to_return;
    },
    getLastModificationElement     : function ( type_modification ) {
        let to_return;
        let data_last_modification;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                previous = this.previous_modication_data;
                next     = this.getDataForLastModification();
                break;
        }
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        this.previous_modication_data = null;
        return to_return;
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                this.initMessages();
                this.resetCounters();
                this.shinken_element = new SHINKEN.OBJECT.ShinkenElement();
                this.updateData( modification_element.getNextOrPrevious( event_name ) );
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PARAM_MODIFICATION:
                this.updateShinkenElementData( modification_element.getNextOrPrevious( event_name ).getValue() );
                break;
        }
    },
    computeSlaTendencyHtml   : function () {
        switch ( this.shinken_element.tendency ) {
            case SHINKEN.SLA_TENDENCY.ARROW_STAGNANT_CRITICAL:
                if ( parseFloat( this.shinken_element.sla_value ) > this.sla_warning_threshold ) {
                    this.shinken_element.tendency = SHINKEN.SLA_TENDENCY.ARROW_STAGNANT_OK;
                    this.addHtmlToUpdate( OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY );
                }
                break;
        }
        if ( this.shinken_element.sla_value === SHINKEN.SLA_TENDENCY.NO_DATA ) {
            this.shinken_element.tendency = SHINKEN.SLA_TENDENCY.NO_DATA;
        }
    },
    computeStatusContextHtml : function () {
        var _paths               = SHINKEN.StatusService.buildTilePaths( this.shinken_element.status, this.shinken_element.context );
        var _primary_icon_path   = "";
        var _secondary_icon_path = "";
        switch ( this.statusContextDisplay ) {
            case "context_then_status":
                _primary_icon_path   = _paths.path_extra ? _paths.path_extra : _paths.path;
                _secondary_icon_path = _paths.path_extra ? _paths.path : _paths.path_extra;
                break;
            case "status_then_context":
                _primary_icon_path   = _paths.path;
                _secondary_icon_path = _paths.path_extra;
                break;
            case "only_status":
                _primary_icon_path   = _paths.path;
                _secondary_icon_path = null;
                break;
        }
        this.icons_status_context = DOM.Service.createElement( "div", { class: "shinken-height-100" } );
        var _primary_icon         = DOM.Service.createElement( "div", { class: "shinken-primary-icon", style: "background: url(" + _primary_icon_path + ")  no-repeat" } );
        DOM.Service.addElementTo( _primary_icon, this.icons_status_context );
        if ( _secondary_icon_path ) {
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-secondary-icon", style: "background: url(" + _secondary_icon_path + ")  no-repeat" } ), _primary_icon );
        }
    },
    computeSlaValueHtml      : function () {
        if ( !this.shinken_element.sla_value ) {
            return;
        }
        if ( typeof this.shinken_element.sla_value === "object" ) {
            return;
        }
        var split         = this.shinken_element.sla_value.split( '.' );
        var _class_to_add = "shinken-unknown";
        var _sla_status   = this.shinken_element.getSlaValueStatus();
        switch ( _sla_status ) {
            case OBJECT.CONST.ELEMENT.SLA.STATUS.OK:
                _class_to_add = "shinken-ok";
                break;
            case OBJECT.CONST.ELEMENT.SLA.STATUS.CRITICAL:
                _class_to_add = "shinken-critical";
                break;
            case OBJECT.CONST.ELEMENT.SLA.STATUS.WARNING:
                _class_to_add = "shinken-warning";
                break;
        }
        this.sla_value_html = "<span class='" + _class_to_add + "'><span class='shinken-number-before'>" + split[ 0 ];
        if ( parseInt( this.shinken_element.sla_value ) !== 100 ) {
            this.sla_value_html = this.sla_value_html + "</span>.<span class='shinken-number-after'>" + split[ 1 ];
        }
        this.sla_value_html = this.sla_value_html + "<span class='shinken-percent'>%</span>";
    },
    computeSlaQualityHtml    : function () {
        this.sla_quality_html = DOM.Service.createElement( "div", { class: "shinken-primary-icon" }, this.shinken_element.getSlaQuality().getInnerHtmlViaTemplate() );
    },
    getObjectParamConstructor: SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.getObjectParamConstructor
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElementHtml, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElementHtml, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElementHtml, SHINKEN.OBJECT.EditableElementInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElementHtml, SHINKEN_GRID.BelongGridCell );
SHINKEN.OBJECT.InformationToDisplayTitleWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplayTitleWidget.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY, "SHINKEN.OBJECT.TitleAreaTitleWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayTitleWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.InformationToDisplayTitleWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplayTitleWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY, "SHINKEN.OBJECT.TitleAreaTitleWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayTitleWidgetForDefaultConfiguration, SHINKEN.OBJECT.InformationToDisplayTitleWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayTitleWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UPSIDE
SHINKEN.OBJECT.LayoutTitleWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LayoutTitleWidget.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplayTitleWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutTitleWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.LayoutTitleWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LayoutTitleWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplayTitleWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutTitleWidgetForDefaultConfiguration, SHINKEN.OBJECT.LayoutTitleWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutTitleWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UPSIDE
SHINKEN.OBJECT.TitleAreaTitleWidget           = function ( data ) {
    this.__class_name__ = 'SHINKEN.OBJECT.TitleAreaTitleWidget';
    this.init( data );
};
SHINKEN.OBJECT.TitleAreaTitleWidget.prototype = {
    init                : SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.init,
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY, SHINKEN_VALIDATION.CONST.STRING.MAX_LENGTH, 300, true],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.TEXT_ALIGN, WEATHER.CONST.DEFAULT_VALUE )],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaTitleWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.TitleAreaTitleWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.TitleAreaTitleWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    init                            : SHINKEN.OBJECT.TitleAreaTitleWidgetForDefaultConfiguration.init,
    _getValidOwnProperty            : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.TEXT_ALIGN, WEATHER.CONST.DEFAULT_VALUE )],
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaTitleWidgetForDefaultConfiguration, SHINKEN.OBJECT.TitleAreaTitleWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TitleAreaTitleWidget, SHINKEN_GRID.BelongGridCell ); //DON'T MOVE UPSIDE
SHINKEN.OBJECT.InformationToDisplayWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplayWeatherWidget.prototype = {
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY, "SHINKEN.OBJECT.LeftAreaWeatherWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY, "SHINKEN.OBJECT.TopRightAreaWeatherWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA._KEY, "SHINKEN.OBJECT.SlaAreaWeatherWidget"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA._KEY, "SHINKEN.OBJECT.NameAreaWeatherWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.InformationToDisplayWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.InformationToDisplayWeatherWidgetForDefaultConfiguration.prototype = {
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY, "SHINKEN.OBJECT.LeftAreaWeatherWidgetForDefaultConfiguration"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY, "SHINKEN.OBJECT.TopRightAreaWeatherWidgetForDefaultConfiguration"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA._KEY, "SHINKEN.OBJECT.SlaAreaWeatherWidgetForDefaultConfiguration"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA._KEY, "SHINKEN.OBJECT.NameAreaWeatherWidgetForDefaultConfiguration"]
        ] );
    },
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.InformationToDisplayWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InformationToDisplayWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
SHINKEN.OBJECT.LayoutWeatherWidget           = function ( data ) {
    this.__class_name__ = 'SHINKEN.OBJECT.LayoutWeatherWidget';
    this.init( data );
};
SHINKEN.OBJECT.LayoutWeatherWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS, WEATHER.CONST.DEFAULT_VALUE )]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplayWeatherWidget"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.LayoutWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LayoutWeatherWidgetForDefaultConfiguration.prototype = {
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY, "SHINKEN.OBJECT.InformationToDisplayWeatherWidgetForDefaultConfiguration"]
        ] );
    },
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.LayoutWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LayoutWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
SHINKEN.OBJECT.LeftAreaWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LeftAreaWeatherWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS, WEATHER.CONST.DEFAULT_VALUE )]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.LeftAreaWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.LeftAreaWeatherWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.LeftAreaWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LeftAreaWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
SHINKEN.OBJECT.NameAreaWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.NameAreaWeatherWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.WEATHER.ENUM.PROPERTY_USED_AS_NAME, WEATHER.CONST.DEFAULT_VALUE )],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN.OPTIONS, WEATHER.CONST.DEFAULT_VALUE )],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT._KEY, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NameAreaWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.NameAreaWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.NameAreaWeatherWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NameAreaWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.NameAreaWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NameAreaWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
SHINKEN.OBJECT.SlaAreaWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.SlaAreaWeatherWidget.prototype = {
    _getValidOwnProperty             : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlaAreaWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.SlaAreaWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.SlaAreaWeatherWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlaAreaWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.SlaAreaWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlaAreaWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
SHINKEN.OBJECT.TopRightAreaWeatherWidget           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.TopRightAreaWeatherWidget.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, SHINKEN.TOOLS.ARRAY.parseToArray( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS, WEATHER.CONST.DEFAULT_VALUE )]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TopRightAreaWeatherWidget, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.OBJECT.TopRightAreaWeatherWidgetForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.TopRightAreaWeatherWidgetForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TopRightAreaWeatherWidgetForDefaultConfiguration, SHINKEN.OBJECT.TopRightAreaWeatherWidget );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.TopRightAreaWeatherWidget, SHINKEN_GRID.BelongGridCell );//DON'T MOVE UPSIDE
WIDGET.Separator           = function ( data ) {
    this.__class_name__ = "WIDGET.Separator";
    this.init( data );
};
WIDGET.Separator.prototype = {
    
    setContent      : function ( toSet ) {
        this.content = toSet;
    },
    getLeftArea     : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY );
    },
    getRightArea    : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY );
    },
    getTitleArea    : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY );
    },
    getNameToDisplay: function () {
        if ( (__external_url_uuid__ && !__has_authentication_needed__) ) {
            return this.type.value;
        }
        return this.shinken_widget_separator_title.innerHTML;
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutSeparatorWidget"]
        ] );
    },
    getIconTypeDom: function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.SEPARATOR ) {
            WEATHER.CONST.COMPONENT.SVG.SEPARATOR = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view #id-shinken-widget-separator" ) ).innerHTML;
        }
        return DOM.Service.createElement( "span", { class: "shinken-icon-cell shinken-icon-separator" }, WEATHER.CONST.COMPONENT.SVG.SEPARATOR );
    },
    getTypeLabel  : function () {
        return _( 'edit_mode.labels.separator' );
    },
    
    
    initDomElement         : function () {
        this.shinken_widget_separator_title = this.dom_element.querySelector( ".shinken-widget-separator-title" );
        this.shinken_cell_left              = this.dom_element.querySelector( ".shinken-cell-left" );
        this.shinken_cell_right             = this.dom_element.querySelector( ".shinken-cell-right" );
        this.shinken_line_left              = this.shinken_cell_left.querySelector( ".shinken-widget-separator-line" );
        this.shinken_line_right             = this.shinken_cell_right.querySelector( ".shinken-widget-separator-line" );
    },
    updateSize             : function () {
        DOM.Service.cleanAllStyles( this.shinken_widget_separator_title );
        this.computeAllStyle();
    },
    computeFontSize        : function () {
        var _width     = DOM.Service.getBoundingClientRect( document.querySelector( "body" ), DOM.CONST.STYLE.WIDTH );
        this.font_size = Math.floor( _width / 45 );
        this.font_size = Math.min( DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.HEIGHT ) * 0.9, this.font_size );
        var _styles    = { "font-size": DOM.Service.getFontZoomed( this.font_size, this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY ) ) };
        if ( this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY ) ) {
            _styles[ "color" ] = this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY );
        }
        DOM.Service.setStyles( this.shinken_widget_separator_title, _styles );
    },
    computeAllStyle        : function () {
        
        this.computeFontSize();
        
        var _width        = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH );
        var _margin_cells = this.font_size / 2;
        
        var _has_left_area  = this.getLeftArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED._KEY )
                              && this.getLeftArea().isValid( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT._KEY );
        var _has_right_area = this.getRightArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED._KEY )
                              && this.getRightArea().isValid( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT._KEY );
        
        var _left_area_width  = _has_left_area ? (_width - _margin_cells) * this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT._KEY ) / 100 : 0;
        var _right_area_width = _has_right_area ? (_width - _margin_cells) * this.getRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT._KEY ) / 100 : 0;
        DOM.Service.setStyles( this.shinken_cell_left, { "width": _left_area_width } );
        DOM.Service.setStyles( this.shinken_cell_right, { "width": _right_area_width } );
        
        DOM.Service.setStyles( this.shinken_widget_separator_title, {
            "margin"    : "0 " + _margin_cells + "px",
            "text-align": this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY ),
            "width"     : _width - _left_area_width - _right_area_width - 2 * _margin_cells
        } );
        this.computeDomStyle();
    },
    computeDomStyle        : function () {
        DOM.Service.setStyles( this.dom_element, { "border-radius": this.border_radius + "px", "padding": this.content_padding + "px" } );
    },
    updateDomElement: function (  ) {
        this.resetHTML();
        this.computeHtml();
        this.updateSize();
    },
    __computeHtml          : function () {
        this.dom_element                                                              = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-widget[data-type="' + this.getTypeValue() + '"]' ) );
        this.dom_element.querySelector( ".shinken-widget-separator-title" ).innerHTML = SHINKEN.TOOLS.STRING.cleanXss( this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY ) );
        DOM.Service.addElementToAfterEmpty( this.dom_element, this.dom_element_parent );
        this.initDomElement();
        this.updateSize();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.Separator, WIDGET.InterfaceWidget );
WIDGET.SeparatorForDefaultConfiguration           = function ( data ) {
    this.__class_name__ = 'WIDGET.SeparatorForDefaultConfiguration';
    this.init( data );
};
WIDGET.SeparatorForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnProperty            : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutSeparatorWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.SeparatorForDefaultConfiguration, WIDGET.Separator );
WIDGET.Title           = function ( data ) {
    this.__class_name__ = "WIDGET.Title";
    this.initSpecific( data );
};
WIDGET.Title.prototype = {
    initSpecific: function ( data ) {
        this.init( data );
        this.setDocumentTitlePage();
    },
    
    setDocumentTitlePage: function () {
        DOM.Service.setPageTitle( this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY ) );
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "set_weather_current_screen_name", this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY ) );
    },
    getTitleArea        : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT._KEY ).getChild(WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY._KEY ).getChild(WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY );
    },
    getTypeLabel        : function () {
        return _( 'edit_mode.labels.title' );
    },
    getIconTypeDom      : function () {
        return DOM.Service.createElement( "span", { class: "shinken-icon-cell shinken-icon-title" } );
    },
    getType             : function () {
        return this.type.value;
    },
    getNameToDisplay    : function () {
        return this.shinken_widget_title_content.outerText;
    },
    canBeDeleted: function () {
        return false;
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutTitleWidget"]
        ] );
    },
    computeFontSize: function () {
        var _width                       = DOM.Service.getBoundingClientRect( document.querySelector( "body" ), DOM.CONST.STYLE.WIDTH );
        var _width_parent                = DOM.Service.getBoundingClientRect( this.dom_element_parent, DOM.CONST.STYLE.WIDTH );
        this.font_size                   = Math.floor( _width / 30 );
        this.font_size                   = Math.min( DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.HEIGHT ) * 0.9, this.font_size );
        var _styles                      = {};
        _styles[ DOM.CONST.STYLE.WIDTH ] = _width_parent * 0.99;
        if ( this.getTitleArea().getValue(WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY ) ) {
            _styles[ "color" ] = this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR._KEY );
        }
        _styles[ "text-align" ] = this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY );
        DOM.Service.setStyles( this.shinken_widget_title_content, _styles );
        DOM.Service.setStyles( this.dom_element, { "font-size": DOM.Service.getFontZoomed( this.font_size, this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT._KEY ) ) } );
    },
    initDomElement : function () {
        this.shinken_widget_title_content = this.dom_element.querySelector( ".shinken-widget-title-content" );
    },
    updateSize     : function () {
        DOM.Service.cleanAllStyles( this.shinken_widget_title_content );
        this.computeAllStyle();
    },
    computeAllStyle: function () {
        this.computeFontSize();
        this.computeDomStyle();
    },
    computeDomStyle: function () {
        DOM.Service.setStyles( this.dom_element, { "border-radius": this.border_radius + "px", "padding": this.content_padding + "px" } );
    },
    __computeHtml  : function () {
        this.dom_element                                                            = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-widget[data-type="' + this.getTypeValue() + '"]' ) );
        this.dom_element.querySelector( ".shinken-widget-title-content" ).innerHTML = SHINKEN.TOOLS.STRING.cleanXss( this.getTitleArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY ) );
        DOM.Service.addElementToAfterEmpty( this.dom_element, this.dom_element_parent );
        this.initDomElement();
        this.updateSize();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    updateDomElement: function () {
        this.resetHTML();
        this.computeHtml();
        this.updateSize();
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.Title, WIDGET.InterfaceWidget );
WIDGET.TitleForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
WIDGET.TitleForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnProperty            : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutTitleWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.TitleForDefaultConfiguration, WIDGET.Title );
WIDGET.Unknown           = function ( data ) {
    this.initSpecific( data );
};
WIDGET.Unknown.prototype = {
    initSpecific: function ( data ) {
        this.type = this.getObjectParamConstructor( "type", {} ); //IN ORDER TO HAVE AT LEAST THE PROPERTY TYPE
        this.init( data );
    },
    
    
    
    computeAll     : function () {
        this.computeDomStyle();
    },
    computeDomStyle: function () {
        DOM.Service.setStyles( this.dom_element, { "border-radius": this.border_radius + "px" } );
    },
    initDomElement  : function () {
        DOM.Service.addOrRemoveClasses( this.dom_element, __external_url_uuid__ || !__user_is_admin__, 'shinken-hidden' );
    },
    getNameToDisplay: function () {
        return _( "widget.unknown_type.type_is_unknown" );
    },
    __computeHtml   : function () {
        var _template    = document.querySelector( '#id-shinken-template-view .shinken-widget[data-type="unknown_widget"]' ).outerHTML;
        _template        = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_title_$$$", this.getNameToDisplay() );
        var _to_add      = DOM.Service.createElement( "div", {}, _template );
        this.dom_element = _to_add.firstChild;
        DOM.Service.addElementToAfterEmpty( this.dom_element, this.dom_element_parent );
        this.initDomElement();
        this.updateSize();
    },
    updateSize      : function () {
        this.computeAll();
    },
    getIconTypeDom  : function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.SUN ) {
            WEATHER.CONST.COMPONENT.SVG.SUN = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view #id-shinken-sla-quality-template-sun" ) ).innerHTML;
        }
        return DOM.Service.createElement( "span", { class: "shinken-icon-cell shinken-icon-unknown" }, WEATHER.CONST.COMPONENT.SVG.UNKNOWN );
    },
    getTypeLabel    : function () {
        return _( 'edit_mode.labels.unknown' );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.Unknown, WIDGET.InterfaceWidget );
WIDGET.Weather           = function ( data ) {
    this.__class_name__ = "WIDGET.Weather";
    this.initSpecific( data );
};
WIDGET.Weather.prototype = {
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "adding_new_widget_manually":
                this.item.setMessageValidation( {
                    "warnings": [
                        {
                            "text"     : _( "validation.business.widgets.weather.key_type_is_mandatory" ),
                            "list_keys": [
                                "item_type"
                            ]
                        },
                        {
                            "text"     : _( "validation.business.widgets.weather.name_or_uuid_needed" ),
                            "list_keys": [
                                "item_uuid",
                                "item_name"
                            ]
                        }
                    ],
                    "critical": [],
                    "errors"  : []
                } );
                this.resetHTML();
                return;
            case "change__shinken_element__from_form":
                this[ WIDGET.CONST.PARAM.ITEM._KEY ].addParamsForEvents( this.getParamForEvents() );
                this[ WIDGET.CONST.PARAM.ITEM._KEY ].doActionAfter( event_name, params );
                this.updateDomElement();
                break;
        }
        return this.doActionAfterCommon( event_name, params );
    },
    initSpecific: function ( data ) {
        this.dom_element_dict      = {};
        this.font_ratio__area_name = 1;
        this.init( data );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.ITEM._KEY, "SHINKEN.OBJECT.ShinkenElementHtml", "setPhaseParent(this)"],
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutWeatherWidget"]
        ] );
    },
    resetHTML           : function () {
        this.dom_element_dict = {};
        this.resetHTMLCommon();
    },
    computeHasShinkenElementChange: function () {
        var _left_area_value = this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY );
        switch ( _left_area_value ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
                if ( this.getPreviousContext() && this.getPreviousContext().getCode() !== undefined && !this.getContext().isByCode( this.getPreviousContext().getCode() ) ) {
                    return true;
                }
                if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                    return true;
                }
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON:
                if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                    return true;
                }
                break;
        }
        if ( this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY ) ) {
            var _top_right_area_value = this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY );
            switch ( _top_right_area_value ) {
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
                    if ( this.getPreviousContext() && this.getPreviousContext().getCode() !== undefined && !this.getContext().isByCode( this.getPreviousContext().getCode() ) ) {
                        return true;
                    }
                    if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                        return true;
                    }
                    break;
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON:
                    if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                        return true;
                    }
                    break;
            }
        }
        var _background_value = this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND._KEY );
        switch ( _background_value ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_THEN_STATUS:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.STATUS_THEN_CONTEXT:
                if ( this.getPreviousContext() && this.getPreviousContext().getCode() !== undefined && !this.getContext().isByCode( this.getPreviousContext().getCode() ) ) {
                    return true;
                }
                if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                    return true;
                }
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.ONLY_STATUS:
                if ( this.getPreviousStatus() && this.getPreviousStatus().getCode() !== undefined && !this.getStatus().isByCode( this.getPreviousStatus().getCode() ) ) {
                    return true;
                }
                break;
        }
        return false;
    },
    getLeftArea    : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY )
                   .getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY );
    },
    getTopRightArea: function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY )
                   .getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY );
    },
    getSlaArea     : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY )
                   .getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA._KEY );
    },
    getNameArea    : function () {
        return this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY._KEY )
                   .getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA._KEY );
    },
    getUUID        : function () {
        if ( this.getShinkenElement().isConfigured() ) {
            return this.item.getItemType() + "-" + this.item.getItemUuid();
        }
        return "";
    },
    getController  : function () {
        return CONTROLLER.PageController;
    },
    getDomElementHtml           : function ( css_selector ) {
        if ( !this.dom_element_dict[ css_selector ] ) {
            switch ( css_selector ) {
                case ".shinken-widget-content":
                case ".shinken-doesnt-exist":
                    this.dom_element_dict[ css_selector ] = this.dom_element.querySelector( css_selector );
                    break;
                case ".shinken-doesnt-exist .shinken-element-name":
                case ".shinken-doesnt-exist .shinken-element-uuid":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-doesnt-exist" ).querySelector( css_selector );
                    break;
                case ".shinken-optimal-container":
                case ".shinken-container-name .shinken-label":
                case ".shinken-main-table":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-widget-content" ).querySelector( css_selector );
                    break;
                case ".shinken-bg":
                case ".shinken-cell-left-area":
                case ".shinken-cell-top-right-area":
                case ".shinken-cell-sla-label":
                case ".shinken-cell-sla-tendency":
                case ".shinken-cell-sla-value":
                case ".shinken-cell-sla-icon":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-main-table" ).querySelector( css_selector );
                    break;
                case ".shinken-icon-container.shinken-left-area":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-cell-left-area" ).querySelector( css_selector );
                    break;
                case ".shinken-optimal-container.shinken-top-right":
                case ".shinken-icon-container.shinken-top-right":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-cell-top-right-area" ).querySelector( css_selector );
                    break;
                case ".shinken-value.shinken-sla-value":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-cell-sla-value" ).querySelector( css_selector );
                    break;
                case ".shinken-icon-container.shinken-sla-icon":
                    this.dom_element_dict[ css_selector ] = this.getDomElementHtml( ".shinken-cell-top-right-area" ).querySelector( css_selector );
                    break;
            }
        }
        return this.dom_element_dict[ css_selector ];
    },
    updatePartElementHtml       : function () {
        var _keys = Object.keys( this[ WIDGET.CONST.PARAM.ITEM._KEY ].html_to_update );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            switch ( _current_key ) {
                case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT_OR_STATUS:
                    if ( !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.status, !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.context ) {
                        break;
                    }
                    this[ WIDGET.CONST.PARAM.ITEM._KEY ].computeStatusContextHtml();
                    let _left_area_value = this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY );
                    switch ( _left_area_value ) {
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
                        case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                            DOM.Service.addElementToAfterEmpty( this[ WIDGET.CONST.PARAM.ITEM._KEY ].icons_status_context, this.getDomElementHtml( ".shinken-icon-container.shinken-left-area" ) );
                            break;
                    }
                    if ( this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY ) ) {
                        var _top_right_area_value = this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY );
                        switch ( _top_right_area_value ) {
                            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
                            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
                            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                                DOM.Service.addElementToAfterEmpty( this[ WIDGET.CONST.PARAM.ITEM._KEY ].icons_status_context, this.getDomElementHtml( ".shinken-icon-container.shinken-top-right" ) );
                                break;
                        }
                    }
                    this.dom_element.dataset.status  = this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.status.getCode();
                    this.dom_element.dataset.context = this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.context.getCode();
                    break;
                case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                    if ( this.getSlaArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY ) ) {
                        this[ WIDGET.CONST.PARAM.ITEM._KEY ].computeSlaValueHtml();
                        this.getDomElementHtml( ".shinken-value.shinken-sla-value" ).innerHTML = this.getSlaValue();
                        DOM.Service.setDataSet( this.dom_element, "slaStatus", this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.getSlaValueStatus() );
                    }
                    break;
                case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.QUALITY:
                    if ( this.getLeftArea()
                             .getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY ) === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                        this[ WIDGET.CONST.PARAM.ITEM._KEY ].computeSlaQualityHtml();
                        DOM.Service.addElementToAfterEmpty( this.getSlaQuality(), this.getDomElementHtml( ".shinken-icon-container.shinken-left-area" ) );
                    }
                    else if ( this.getTopRightArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY ) &&
                              this.getTopRightArea()
                                  .getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY ) === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                        this[ WIDGET.CONST.PARAM.ITEM._KEY ].computeSlaQualityHtml();
                        DOM.Service.addElementToAfterEmpty( this.getSlaQuality(), this.getDomElementHtml( ".shinken-icon-container.shinken-top-right" ) );
                    }
                    break;
                case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                    this[ WIDGET.CONST.PARAM.ITEM._KEY ].computeSlaTendencyHtml();
                    DOM.Service.setDataSet( this.dom_element, "slaTendency", this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element.tendency );
                    if ( this.getLeftArea()
                             .getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY ) === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.SLA_TENDENCY ) {
                        DOM.Service.addElementToAfterEmpty( this.getTendencyHtml(), this.getDomElementHtml( ".shinken-icon-container.shinken-left-area" ) );
                    }
                    break;
                case WIDGET.CONST.PARAM.ITEM.NAME._KEY:
                case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
                    this.askComputeEllipsis();
                    break;
            }
        }
        this.updateMissingElementHtml();
        if ( !this.updateWidgetVisibility() ) {
            this.updateNoUserRightElementHtml();
        }
        this[ WIDGET.CONST.PARAM.ITEM._KEY ].html_to_update = {};
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    askComputeEllipsis          : function () {
        if ( this.timeout__compute_ellipsis ) {
            clearTimeout( this.timeout__compute_ellipsis );
        }
        this.timeout__compute_ellipsis = setTimeout( () => {
            this.computeEllipsis();
            this.timeout__compute_ellipsis = null;
        }, 10 );
    },
    updateWidgetVisibility      : function () {
        var is_hidden = __external_url_uuid__ && !__has_authentication_needed__ && !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW ];
        DOM.Service.addOrRemoveClasses( this.dom_element, is_hidden, 'shinken-hidden' );
        return is_hidden;
    },
    getNameToDisplay            : function () {
        let to_return = this.getShinkenElement().getName();
        if ( (__external_url_uuid__ && !__has_authentication_needed__)
             || this.getNameArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME._KEY ) === WIDGET.CONST.WEATHER.ENUM.PROPERTY_USED_AS_NAME.VISUALISATION_NAME ) {
            to_return = this.getShinkenElement().getVisualisationName();
        }
        if ( !to_return ) {
            to_return = this.getShinkenElement().isConfigured() ? _( 'widget.weather.shinken_element_not_found' ) : _( 'widget.weather.not_configured' );
        }
        return to_return;
    },
    updateMissingElementHtml    : function () {
        var _do_no_exist_state = WIDGET.CONST.STATE_NOT_EXISTING.NOT_CONFIGURED;
        var _is_existing       = this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ];
        if ( !_is_existing ) {
            this.getDomElementHtml( ".shinken-doesnt-exist .shinken-element-name" ).innerHTML = this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemNameForHtml();
            this.getDomElementHtml( ".shinken-doesnt-exist .shinken-element-uuid" ).innerHTML = "[&nbsp;" + this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemUuidForHtml() + "&nbsp;]";
            if ( this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemName() && this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemUuid() ) {
                _do_no_exist_state = WIDGET.CONST.STATE_NOT_EXISTING.FULL_INFO;
            }
            else if ( this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemName() ) {
                _do_no_exist_state = WIDGET.CONST.STATE_NOT_EXISTING.NO_UUID;
            }
            else if ( this[ WIDGET.CONST.PARAM.ITEM._KEY ].getItemUuid() ) {
                _do_no_exist_state = WIDGET.CONST.STATE_NOT_EXISTING.NO_NAME;
            }
        }
        DOM.Service.setDataSet( this.getDomElementHtml( ".shinken-doesnt-exist" ), "doNotExistState", _do_no_exist_state );
        DOM.Service.addOrRemoveClasses( this.dom_element, !_is_existing, "shinken-unknown-element shinken-user-select" );
        DOM.Service.addOrRemoveClasses( this.dom_element, !_is_existing && (__external_url_uuid__ || !__user_is_admin__), 'shinken-hidden' );
    },
    updateNoUserRightElementHtml: function () {
        DOM.Service.setDataSet( this.dom_element, "notAuthorizedForUser", this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] ? 1 : 0 );
    },
    updateSize                  : function () {
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            return;
        }
        this.computeAllStyle();
        this.askComputeEllipsis();
    },
    computeStateIcon            : function () {
        switch ( this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY ) ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                return this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY );
        }
        switch ( this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY ) ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                return this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY );
        }
    },
    updateDomElement            : function () {
        this.resetHTML();
        this[ WIDGET.CONST.PARAM.ITEM._KEY ].html_to_update = {
            "item_name"                                   : true,
            "context_or_status"                           : true,
            "visualisation_name"                          : true,
            "value"                                       : true,
            "quality"                                     : true,
            "tendency"                                    : true,
            "element_visibility_on_not_authenticated_view": true,
            "ever"                                        : true
        };
        this.computeHtml();
        this.updateSize();
    },
    __computeHtml               : function () {
        if ( !this.dom_element ) {
            this[ WIDGET.CONST.PARAM.ITEM._KEY ].setStatusContextDisplay( this.computeStateIcon() );
            this.dom_element = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-widget[data-type="' + this.getTypeValue() + '"]' ) );
            DOM.Service.addOrRemoveClasses( this.dom_element, this.has_shinken_element_change, "shinken-widget-has-change" );
            DOM.Service.addElementTo( this.dom_element, this.dom_element_parent );
            this.updatePartElementHtml();
            this[ WIDGET.CONST.PARAM.ITEM._KEY ].setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
    },
    __updateHtml                : function () {
        this.updatePartElementHtml();
    },
    blink: function ( nb_of_blink ) {
        DOM.Service.askAddClass( this.dom_element, 'shinken-pulsate', nb_of_blink * 800 );
    },
    
    computeAllStyle         : function () {
        this.computeFontSize();
        this.computeOptimalZone();
        this.computeDomStyle();
        if ( !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] ) {
            return;
        }
        this.computeLeftAreaStyle();
        this.computeTopRightCellStyle();
        this.computeSlasCellsStyle();
        this.computeTextAreaStyle();
    },
    computeEllipsis         : function () {
        DOM.Service.removeStyle( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), "height" );
        DOM.Service.removeStyle( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), "line-height" );
        var _data = DOM.ServiceEllipsis.ellipsis(
            this.getDomElementHtml( ".shinken-container-name .shinken-label" ),
            this.getNameToDisplay(),
            this.computeFontSizeWithZoom() + "px Helvetica, Arial, sans-serif",
            this.getNameArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX._KEY )
        );
        DOM.Service.setStyle( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), "height", _data.height );
        if ( _data.height < DOM.Service.getBoundingClientRect( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), 'height' ) ) {
            DOM.Service.setStyle( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), "line-height", 1 );
            if ( this.getNameArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN._KEY ) !== "middle" ) {
                DOM.Service.setStyle( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), "line-height", Math.min( this.computeFontSizeWithZoom(), _data.height ) );
            }
            
        }
        
    },
    computeOptimalZone      : function () {
        var _is_existing = this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ];
        var _rect        = _is_existing ? DOM.Service.getBoundingClientRect( this.getDomElementHtml( ".shinken-widget-content" ) ) : DOM.Service.getBoundingClientRect( this.getDomElementHtml( ".shinken-doesnt-exist" ) );
        var _ratio       = _rect[ DOM.CONST.STYLE.WIDTH ] / _rect[ DOM.CONST.STYLE.HEIGHT ];
        
        if ( _ratio > WIDGET.CONST.WEATHER.PERFECT_RATIO ) {
            this.optimal_height = _rect[ DOM.CONST.STYLE.HEIGHT ];
        }
        else {
            this.optimal_height               = parseInt( _rect[ DOM.CONST.STYLE.WIDTH ] / WIDGET.CONST.WEATHER.PERFECT_RATIO );
            this.padding_to_have_optimal_zone = parseInt( (_rect[ DOM.CONST.STYLE.HEIGHT ] - this.optimal_height) / 2 );
        }
        this.content_padding = parseInt( this.optimal_height * WIDGET.CONST.WEATHER.STYLE.PADDING_CONTENT );
        if ( this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND._KEY ) === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.NO_BACKGROUND ) {
            this.border_size     = parseInt( this.optimal_height * WIDGET.CONST.WEATHER.STYLE.BORDER_SIZE );
            this.content_padding = this.content_padding - this.border_size * 2;
        }
        this.optimal_height = this.optimal_height - this.content_padding;
        this.border_radius  = Math.ceil( 0.06 * this.optimal_height );
    },
    computeDomStyle         : function () {
        DOM.Service.setDataSet( this.dom_element, 'background', this.getChild( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ).getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND._KEY ) );
        DOM.Service.setDataSet( this.dom_element, 'stateIcon', this.computeStateIcon() );
        DOM.Service.setDataSet( this.dom_element, 'leftArea', this.getLeftArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY ) );
        DOM.Service.setDataSet( this.dom_element, 'topRightArea', this.getTopRightArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY )
                                                                  ? this.getTopRightArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY ) : "hidden" );
        DOM.Service.setDataSet( this.dom_element, 'showSlaIcon', this.getSlaArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY ) ? "1" : "0" );
        DOM.Service.setDataSet( this.dom_element, 'displaySla', this.getSlaArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY ) ? "1" : "0" );
        
        DOM.Service.setStyles( this.dom_element, { "border-radius": this.border_radius + "px" } );
        if ( !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] ) {
            DOM.Service.setStyles( this.dom_element.querySelector( ".shinken-doesnt-exist" ), { "border-radius": this.border_radius + "px" } );
        }
        DOM.Service.setStyles( this.dom_element, { "font-size": this.font_size } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-widget-content" ), { "padding": this.content_padding + "px " + 2 * this.content_padding + "px", "border-width": this.border_size + "px", "border-radius": this.border_radius + "px" } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-bg" ), { "border-radius": this.border_radius + "px" } );
    },
    computeLeftAreaStyle    : function () {
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-left-area" ), { "width": this.optimal_height + "px" } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-icon-container.shinken-left-area" ), {
            "width": this.optimal_height * 0.9 + 'px', "height": this.optimal_height * 0.9 + 'px'
        } );
    },
    computeTopRightCellStyle: function () {
        if ( !this.getTopRightArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY ) ) {
            return;
        }
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-top-right-area" ), { "width": this.optimal_height * WIDGET.CONST.WEATHER.RIGHT_CELL_RATIO } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-optimal-container.shinken-top-right" ), {
            "height": "calc(100% - " + parseInt( this.optimal_height * WIDGET.CONST.WEATHER.SLA_ICON_CELL_RATIO - this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO ) + "px)"
        } );
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) ) {
            DOM.Service.setStyles( this.getDomElementHtml( ".shinken-optimal-container.shinken-top-right" ).querySelector( ".shinken-primary-icon" ), {
                "height"  : "" + this.optimal_height * WIDGET.CONST.WEATHER.RIGHT_CELL_RATIO + "px",
                "position": "relative",
                "top"     : "calc(50% - " + (this.optimal_height * WIDGET.CONST.WEATHER.RIGHT_CELL_RATIO) / 2 + "px)"
            } );
        }
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-icon-container.shinken-top-right" ), {
            "width": this.optimal_height * 0.5 + 'px', "height": this.optimal_height * 0.5 + 'px'
        } );
    },
    computeTextAreaStyle    : function () {
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-container-name .shinken-label" ), {
            "font-size"     : this.computeFontSizeWithZoom(),
            "vertical-align": this.getNameArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN._KEY )
        } );
    },
    computeSlasCellsStyle   : function () {
        if ( !this.getSlaArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY ) ) {
            return;
        }
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-sla-label" ), {
            "width" : this.optimal_height * WIDGET.CONST.WEATHER.SLA_LABEL_CELL_RATIO,
            "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO
        } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-sla-tendency" ), { "width": this.optimal_height * WIDGET.CONST.WEATHER.SLA_TENDENCY_CELL_RATIO, "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO } );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-sla-tendency" ).querySelector( ".shinken-icon-container" ), {
            "width": this.optimal_height * WIDGET.CONST.WEATHER.SLA_TENDENCY_CELL_RATIO, "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO
        } );
        this.getDomElementHtml( ".shinken-cell-sla-tendency" ).classList.remove( "shinken-hidden" );
        DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-sla-value" ), { "width": this.optimal_height * WIDGET.CONST.WEATHER.SLA_VALUE_CELL_RATIO, "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO } );
        
        if ( this.getSlaArea().getBooleanValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY ) ) {
            DOM.Service.setStyles( this.getDomElementHtml( ".shinken-cell-sla-icon" ), { "width": this.optimal_height * WIDGET.CONST.WEATHER.SLA_ICON_CELL_RATIO, "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_CELL_HEIGHT_RATIO } );
            DOM.Service.setStyles( this.getDomElementHtml( ".shinken-icon-container.shinken-sla-icon" ), {
                "width": this.optimal_height * WIDGET.CONST.WEATHER.SLA_ICON_CELL_RATIO, "height": this.optimal_height * WIDGET.CONST.WEATHER.SLA_ICON_CELL_RATIO
            } );
        }
    },
    computeFontSize         : function () {
        var _rect        = DOM.Service.getBoundingClientRect( this.dom_element );
        var _width_rect  = _rect[ DOM.CONST.STYLE.WIDTH ];
        var _height_rect = _rect[ DOM.CONST.STYLE.HEIGHT ];
        this.font_size   = Math.floor( Math.min( _width_rect, 3.45 * _height_rect ) / 16 );
        if ( !this[ WIDGET.CONST.PARAM.ITEM._KEY ].shinken_element[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] ) {
            this.font_size = Math.min( 25, this.font_size );
            this.font_size = Math.max( 8, this.font_size );
        }
    },
    computeFontSizeWithZoom : function () {
        return parseInt( DOM.Service.getFontZoomed( this.font_size * this.font_ratio__area_name, this.getNameArea().getValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT._KEY ) ) );
    },
    
    getIconTypeDom: function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.SUN ) {
            WEATHER.CONST.COMPONENT.SVG.SUN = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view #id-shinken-sla-quality-template-sun" ) ).innerHTML;
        }
        return DOM.Service.createElement( "span", { class: "shinken-icon-cell shinken-icon-sun" }, WEATHER.CONST.COMPONENT.SVG.SUN );
    },
    getTypeLabel  : function () {
        return _( 'edit_mode.labels.meteo' );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.Weather, WIDGET.InterfaceWidgetShinkenElement );
WIDGET.WeatherForDefaultConfiguration           = function ( data ) {
    this.init( data );
};
WIDGET.WeatherForDefaultConfiguration.prototype = {
    is_belonging_to_grid_cell_object: false,
    _getValidOwnProperty            : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren            : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY, "SHINKEN.OBJECT.LayoutWeatherWidgetForDefaultConfiguration"]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WIDGET.WeatherForDefaultConfiguration, WIDGET.Weather );
