//noinspection JSUnusedGlobalSymbols
"use strict";
SHINKEN.DOCUMENTATION_DATA = {
    SHARE            : "share",
    NOTIFICATION     : "notification",
    WEATHER          : "weather",
    LIST             : "list",
    USER             : "user",
    JSON             : "json",
    WEATHER_LIST_HOST: "weather_list_host",
    UI_PANEL_LIST    : "ui_panel_list",
    WEATHER_HISTORY  : "weather_history"
};

SHINKEN.DOCUMENTATION_DATA.__is_documentation = null;

SHINKEN.DOCUMENTATION_DATA.getDocumentationData                     = function ( type_documentation, param ) {
    let to_return = null;
    try {
        switch ( type_documentation ) {
            case SHINKEN.DOCUMENTATION_DATA.JSON:
            case SHINKEN.DOCUMENTATION_DATA.WEATHER_LIST_HOST:
            case SHINKEN.DOCUMENTATION_DATA.WEATHER_HISTORY:
                to_return = SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ SHINKEN.DOCUMENTATION_DATA.WEATHER ] ];
                break;
            case SHINKEN.DOCUMENTATION_DATA.NOTIFICATION:
                to_return = SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ];
                to_return = SHINKEN.TOOLS.STRING.contains( param.uuid, "-" ) ? to_return[ "check" ] : to_return[ "host" ];
                break;
            default:
                to_return = SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ];
                break;
        }
        
    }
    catch ( e ) {
    }
    if ( !to_return ) {
        let string = `Valeur ${SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ]} pour la clé ${type_documentation} inexistante`;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( string, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.WARNING );
    }
    return to_return;
};
SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated = function ( type_documentation ) {
    return !!SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ];
};
SHINKEN.DOCUMENTATION_DATA.isDocumentationModeOn                    = function () {
    let to_return = SHINKEN.HIGHWAY.getParams( "shinken_documentation" ) || window.parent.parent.SHINKEN.HIGHWAY.getParams( "shinken_documentation" );
    if ( to_return ) {
        SHINKEN.DOCUMENTATION_DATA.__parsed_documentation = SHINKEN.DOCUMENTATION_DATA.parseDocumentationValues( to_return.split( ',' ) );
    }
    return !!to_return;
};

SHINKEN.DOCUMENTATION_DATA.parseDocumentationValues = function ( to_parse_to_array ) {
    let _to_return   = {};
    let split_object;
    let key;
    let string_error = "";
    to_parse_to_array.forEach( function ( item ) {
        split_object = item.split( '-' );
        key          = split_object[ 0 ];
        if ( SHINKEN.TOOLS.ARRAY.contains( SHINKEN.DOCUMENTATION_DATA.AUTHORIZED_KEYS, key ) ) {
            _to_return[ key ] = split_object[ 1 ];
        }
        else {
            if ( string_error ) {
                string_error += ",";
            }
            string_error += key;
        }
    } );
    if ( string_error ) {
        string_error = string_error + " is not a valid documentation key<br>Valid keys =>" + SHINKEN.DOCUMENTATION_DATA.AUTHORIZED_KEYS + "<br>exemple => ?shinken_documentation=share-2,weather-1";
        console.error( "[DOCUMENTATION_DATA - parseDocumentationValues]", string_error );
        SHINKEN.TOOLS.NOTIFICATION.addNotification( string_error, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    }
    return _to_return;
};

SHINKEN.HIGHWAY.isDocumentationOn = function () {
    if ( SHINKEN.DOCUMENTATION_DATA.__is_documentation === null ) {
        SHINKEN.DOCUMENTATION_DATA.__is_documentation = SHINKEN.DOCUMENTATION_DATA.isDocumentationModeOn();
    }
    return SHINKEN.DOCUMENTATION_DATA.__is_documentation;
};

document.addEventListener( "DOMContentLoaded", function ( e ) {
    //******************************************** FUNCTION OVERRIDE FOR DOCUMENTATION **************************//
    if ( CONTROLLER.Weather && WEATHER && WEATHER.PageContent && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.WEATHER ) ) {
        WEATHER.PageContent.prototype.computeData             = function ( data ) {
            console.log( "[Weather - computeData]", "[OVERRIDE BY DOCUMENTATION]", "[WEATHER]" );
            data = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.WEATHER ) || data;
            this.grids.updateContentData( data );
        };
        WEATHER.Page.prototype.actionsAfterGetData            = function ( _status, data ) {
            this.updateUserPrefsFromBackendData();
            let data_clean = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.JSON );
            delete data_clean.value.external_links;
            this.updateObject( data_clean, true );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        };
        WEATHER.Page.prototype.askComputeNotificationOfChange = function () {
        };
        try {
            WEATHER.PageEdit.prototype.actionsAfterGetData                                  = function ( _status, data ) {
                this.updateUserPrefsFromBackendData();
                this.updateObject( SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.JSON ), true );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
            };
            WEATHER.PageEdit.prototype.updateData__20240926                                 = function ( data ) {
                this.updateObject( SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.JSON ) );
            };
            SHINKEN.OBJECT.InterfaceWidgetFormWithShinkenElement.prototype.parseBackendData = function ( data ) {
                return SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.WEATHER_LIST_HOST );
            };
            SHINKEN.OBJECT.ViewHistory.prototype.getDataFromBackend__20241001               = function ( url ) {
                let history_data = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.WEATHER_HISTORY );
                this.formatAndApplyData( history_data );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
            };
            WEATHER.ViewHistory.prototype.getDataFromBackend__20241001                      = SHINKEN.OBJECT.ViewHistory.prototype.getDataFromBackend__20241001;
        }
        catch ( e ) {
        }
    }
    if ( CONTROLLER.Share && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.SHARE ) ) {
        CONTROLLER.Share.loadSharesFromAngular = function ( param ) {
            console.log( "[Share - loadSharesFromAngular]", "[OVERRIDE BY DOCUMENTATION]", "[SHARE]" );
            param                = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.SHARE ) || param;
            self.share_data      = param;
            self.share_data_used = false;
            return param;
        };
    }
    if ( CONTROLLER.UiVisualisation && SHINKEN.HIGHWAY.isDocumentationOn() ) {
        if ( SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.LIST ) ) {
            CONTROLLER.UiVisualisation.loadListElementDataFromAngular = function ( param ) {
                var to_return = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.LIST );
                return to_return || param;
            };
        }
        if ( SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.NOTIFICATION ) ) {
            CONTROLLER.UiVisualisation.loadShinkenElementDataFromAngular       = function ( param ) {
                var to_return = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.NOTIFICATION, param );
                return to_return || param;
            };
            CONTROLLER.UiVisualisation.loadShinkenElementParentDataFromAngular = function ( param ) {
                var to_return = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.NOTIFICATION, param );
                return to_return || param;
            };
        }
        else if ( SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.USER ) ) {
            CONTROLLER.UiVisualisation.setUserData = function ( data_user ) {
                console.log( "[UiVisualisation - setUserData]", "[OVERRIDE BY DOCUMENTATION]", "[USER]" );
                data_user = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.USER ) || data_user;
                CONTROLLER.UiVisualisation.current_user.updateData( data_user );
                return data_user;
            };
        }
    }
    if ( CONTROLLER.UiViewWeatherManager && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.UI_PANEL_LIST ) ) {
        CONTROLLER.UiViewWeatherManager.getDataFromBackend = function ( is_update ) {
            console.log( "[UiPanelsView - getDataFromBackend]", "[OVERRIDE BY DOCUMENTATION]", "[ UI PANEL LIST ]" );
            self.doActionAfter( "ui_panel_start_saving" );
            self.delay_before_view_deletion = data[ "output" ][ "views_trash" ][ "delay_before_deletion" ];
            data[ "output" ][ "weathers" ]  = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.UI_PANEL_LIST );
            self.setLinesWithData( data[ "output" ][ "weathers" ], is_update );
            
        };
    }
} );