//noinspection JSUnusedGlobalSymbols
"use strict";

SHINKEN.DOCUMENTATION_DATA.AUTHORIZED_KEYS = [
    SHINKEN.DOCUMENTATION_DATA.SHARE,
    SHINKEN.DOCUMENTATION_DATA.NOTIFICATION,
    SHINKEN.DOCUMENTATION_DATA.WEATHER,
    SHINKEN.DOCUMENTATION_DATA.LIST,
    SHINKEN.DOCUMENTATION_DATA.USER,
    SHINKEN.DOCUMENTATION_DATA.JSON,
    SHINKEN.DOCUMENTATION_DATA.UI_PANEL_LIST,
    SHINKEN.DOCUMENTATION_DATA.WEATHER_HISTORY
];

SHINKEN.DOCUMENTATION_DATA[ "share-1" ] = [
    {
        "uuid"             : "00000",
        "name"             : "France",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50000",
            "type" : "service_weather",
            "name" : "France",
            "owner": {
                "uuid": "10001",
                "name": "R.Dubois [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        }
    },
    {
        "uuid"             : "00001",
        "name"             : "Portail SO",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 1,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50001",
            "type": "hive",
            "name": "Portail SO"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        }
    },
    {
        "uuid"             : "00002",
        "name"             : "Sud Est",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 2,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00003",
        "name"             : "Marseille",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50002",
            "type": "hive",
            "name": "Marseille"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "parent"           : {
            "uuid": "00002"
        }
    },
    {
        "uuid"             : "00004",
        "name"             : "Montpellier",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50004",
            "type": "hive",
            "name": "Montpellier"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "parent"           : {
            "uuid": "00002"
        }
    },
    {
        "uuid"             : "00006",
        "name"             : "Sud Ouest",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 2,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00007",
        "name"             : "Listes",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00008",
        "name"             : "Toulouse",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50005",
            "type": "list",
            "name": "Toulouse"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00008",
        "name"             : "Portails",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 4,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00009",
        "name"             : "Bordeaux",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50006",
            "type": "hive",
            "name": "Bordeaux"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00010",
        "name"             : "Météos",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00011",
        "name"             : "Bordeaux-Datacenter",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 7,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50007",
            "type" : "service_weather",
            "name" : "Bordeaux-Datacenter",
            "owner": {
                "uuid": "10001",
                "name": "R.Dubois [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00012",
        "name"             : "Shinken",
        "type"             : "group",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50008",
            "type" : "service_weather",
            "name" : "Shinken",
            "owner": {
                "uuid": "10000",
                "name": "C.Moreau"
            }
        },
        "group"            : {
            "uuid": "20000"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00013",
        "name"             : "VMWARE",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 2,
        "state"            : {
            "removed": false
        },
        "group"            : {
            "uuid": "20000"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00014",
        "name"             : "Bordeaux",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50009",
            "type": "hive",
            "name": "Bordeaux"
        },
        "group"            : {
            "uuid": "20000"
        },
        "parent"           : {
            "uuid": "00013"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        }
    },
    {
        "uuid"             : "00015",
        "name"             : "Toulouse",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50010",
            "type": "list",
            "name": "Toulouse"
        },
        "group"            : {
            "uuid": "20000"
        },
        "parent"           : {
            "uuid": "00013"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "R.Dubois [Admin]"
        }
    },
    {
        "uuid"             : "00016",
        "name"             : "Bordeaux-Datacenter",
        "type"             : "personal",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50007",
            "type" : "service_weather",
            "name" : "Bordeaux-Datacenter",
            "owner": {
                "uuid": "10001",
                "name": "R.Dubois [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00017",
        "name"             : "En création",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00018",
        "name"             : "Tous les éléments",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50010",
            "type": "list",
            "name": "Tous les éléments"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00019",
        "name"             : "Problèmes Sources",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50011",
            "type": "list-root-problem",
            "name": "Problèmes Sources"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00020",
        "name"             : "Toulon",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 4,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Toulon"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00021",
        "name"             : "Sauvegardes",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00022",
        "name"             : "Marseille (copie)",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Marseille (copie)"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    }, {
        "uuid"             : "00022",
        "name"             : "Montpellier (copie)",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Montpellier (copie) avant le changement de système (Prévu dimanche)"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    }
];
SHINKEN.DOCUMENTATION_DATA[ "share-2" ] = [
    {
        "uuid"             : "00000",
        "name"             : "France",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50000",
            "type" : "service_weather",
            "name" : "Francia",
            "owner": {
                "uuid": "10001",
                "name": "N.Chevet [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        }
    },
    {
        "uuid"             : "00001",
        "name"             : "Portail SO",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 1,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50001",
            "type": "hive",
            "name": "Portail SO"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        }
    },
    {
        "uuid"             : "00002",
        "name"             : "Sud Est",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 2,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00003",
        "name"             : "Marseille",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50002",
            "type": "hive",
            "name": "Marseille"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "parent"           : {
            "uuid": "00002"
        }
    },
    {
        "uuid"             : "00004",
        "name"             : "Montpellier",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50004",
            "type": "hive",
            "name": "Montpellier"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "parent"           : {
            "uuid": "00002"
        }
    },
    {
        "uuid"             : "00006",
        "name"             : "Sud Ouest",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 2,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00007",
        "name"             : "Listes",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00008",
        "name"             : "Toulouse",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50005",
            "type": "list",
            "name": "Toulouse"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00008",
        "name"             : "Portails",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 4,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00009",
        "name"             : "Bordeaux",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50006",
            "type": "hive",
            "name": "Bordeaux"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00010",
        "name"             : "Météos",
        "type"             : "global",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00011",
        "name"             : "Bordeaux-Datacenter",
        "type"             : "global",
        "screenIsReference": true,
        "index"            : 7,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50007",
            "type" : "service_weather",
            "name" : "Bordeaux-Datacenter",
            "owner": {
                "uuid": "10001",
                "name": "N.Chevet [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "parent"           : {
            "uuid": "00006"
        }
    },
    {
        "uuid"             : "00012",
        "name"             : "Shinken",
        "type"             : "group",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50008",
            "type" : "service_weather",
            "name" : "Shinken",
            "owner": {
                "uuid": "10000",
                "name": "C.Moreau"
            }
        },
        "group"            : {
            "uuid": "20000"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00013",
        "name"             : "VMWARE",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 2,
        "state"            : {
            "removed": false
        },
        "group"            : {
            "uuid": "20000"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        },
        "isOpen"           : true
    },
    {
        "uuid"             : "00014",
        "name"             : "Bordeaux",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50009",
            "type": "hive",
            "name": "Bordeaux"
        },
        "group"            : {
            "uuid": "20000"
        },
        "parent"           : {
            "uuid": "00013"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        }
    },
    {
        "uuid"             : "00015",
        "name"             : "Toulouse",
        "type"             : "group",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50010",
            "type": "list",
            "name": "Toulouse"
        },
        "group"            : {
            "uuid": "20000"
        },
        "parent"           : {
            "uuid": "00013"
        },
        "owner"            : {
            "uuid": "10001",
            "name": "N.Chevet [Admin]"
        }
    },
    {
        "uuid"             : "00016",
        "name"             : "Bordeaux-Datacenter",
        "type"             : "personal",
        "screenIsReference": true,
        "index"            : 0,
        "kind"             : 1,
        "screen"           : {
            "uuid" : "50007",
            "type" : "service_weather",
            "name" : "Bordeaux-Datacenter",
            "owner": {
                "uuid": "10001",
                "name": "N.Chevet [Admin]"
            }
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00017",
        "name"             : "En création",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 1,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00018",
        "name"             : "Tous les éléments",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 2,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50010",
            "type": "list",
            "name": "Tous les éléments"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00019",
        "name"             : "Problèmes Sources",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 3,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50011",
            "type": "list-root-problem",
            "name": "Problèmes Sources"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00020",
        "name"             : "Toulon",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 4,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Toulon"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00021",
        "name"             : "Sauvegardes",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 5,
        "kind"             : 3,
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    },
    {
        "uuid"             : "00022",
        "name"             : "Marseille (copie)",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Marseille (copie)"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    }, {
        "uuid"             : "00022",
        "name"             : "Montpellier (copie)",
        "type"             : "personal",
        "screenIsReference": false,
        "index"            : 6,
        "kind"             : 1,
        "screen"           : {
            "uuid": "50012",
            "type": "hive",
            "name": "Montpellier (copie) avant le changement de système (Prévu dimanche)"
        },
        "owner"            : {
            "uuid": "10000",
            "name": "C.Moreau"
        }
    }
];

SHINKEN.DOCUMENTATION_DATA[ "user-1" ] = {
    'uuid'    : "10000",
    'userName': "C.Moreau",
    'groups'  : [
        {
            "uuid": "20000",
            "name": "Groupe Sud"
        },
        {
            "uuid": "20001",
            "name": "Group Sud Ouest"
        }
    ]
};

SHINKEN.DOCUMENTATION_DATA[ "list-1" ] = {
    "elements"                          : [
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1718686465,
            "last_hard_state_change"                 : 1718686465,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 1,
            "is_root_problem"                        : false,
            "output"                                 : "OK, worst of [12 OK] states",
            "long_output"                            : "<ul><li>And [12] OK.</li></ul>",
            "perf_data"                              : "",
            "smart_perf_data"                        : [],
            "got_business_rule"                      : true,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : false,
            "thresholds_display"                     : "",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "display_name"                           : "Int - Mongo cluster",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "d",
                "u",
                "r",
                "f"
            ],
            "type"                                   : "cluster",
            "extended_type"                          : "cluster",
            "is_unknown"                             : false,
            "host_name"                              : "Int - Mongo cluster",
            "name"                                   : "Int - Mongo cluster",
            "realm"                                  : "All",
            "host_templates"                         : [],
            "host_groups"                            : [],
            "uuid"                                   : "b4607e655b9911eda9e4a4bb6dae2517",
            "uuid_parent"                            : "b4607e655b9911eda9e4a4bb6dae2517"
        },
        {
            "business_impact"                        : 5,
            "status"                                 : 3,
            "context"                                : "NOTHING",
            "status_since"                           : 1720076386,
            "last_hard_state_change"                 : 1719470532,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 1,
            "is_root_problem"                        : false,
            "output"                                 : "This cluster did not match any element.",
            "long_output"                            : "",
            "perf_data"                              : "",
            "smart_perf_data"                        : [],
            "got_business_rule"                      : true,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : false,
            "thresholds_display"                     : "",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "display_name"                           : "Bordeaux",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "d",
                "u",
                "r",
                "f"
            ],
            "type"                                   : "cluster",
            "extended_type"                          : "cluster",
            "is_unknown"                             : false,
            "host_name"                              : "Bordeaux",
            "name"                                   : "Bordeaux",
            "realm"                                  : "All",
            "host_templates"                         : [],
            "host_groups"                            : [
                ""
            ],
            "uuid"                                   : "b8bf57d4776711eeb90d0800273dde77",
            "uuid_parent"                            : "b8bf57d4776711eeb90d0800273dde77"
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720674731,
            "last_hard_state_change"                 : 1719470591,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "PING OK - Packet loss = 0%, RTA = 0.06 ms",
            "long_output"                            : "",
            "perf_data"                              : "rta=0.058000ms;1000.000000;3000.000000;0.000000 pl=0%;100;100;0",
            "smart_perf_data"                        : [
                {
                    "name"    : "rta",
                    "value"   : 0.058,
                    "uom"     : "ms",
                    "warning" : 1000,
                    "critical": 3000,
                    "min"     : 0,
                    "max"     : null
                },
                {
                    "name"    : "pl",
                    "value"   : 0,
                    "uom"     : "%",
                    "warning" : 100,
                    "critical": 100,
                    "min"     : 0,
                    "max"     : 100
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "Vue détaillée~=http://lab-validationsw1/shinken-core-map/frontend/nagvis-js/index.php?mod=Map&show=shinken_architecture-4efa68b7-a2c5-fc40-af46-1f227dbfdcf7~=tag~=POPUP(80)~#~Arbre des royaumes~=http://lab-validationsw1/shinken-core-map/frontend/nagvis-js/index.php?mod=Map&show=shinken_global-4efa68b7-a2c5-fc40-af46-1f227dbfdcf7~=tag~=POPUP(80)",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "next_check"                             : 1720707371,
            "last_check"                             : 1720707349.6300678,
            "display_name"                           : "Hôte [Sud_Ouest], <br> ne pas modifier.",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "d",
                "u"
            ],
            "type"                                   : "host",
            "extended_type"                          : "host",
            "is_unknown"                             : false,
            "address"                                : "localhost",
            "host_name"                              : "Supervision de Shinken",
            "name"                                   : "Supervision de Shinken",
            "realm"                                  : "All",
            "host_templates"                         : [
                "shinken-broker-module-visualisation-ui",
                "shinken-full",
                "shinken-graphite",
                "shinken-broker-module-visualisation-ui-service-weather"
            ],
            "host_groups"                            : [
                ""
            ],
            "uuid"                                   : "4f3938ecf2a4442aa1d96fb8595e9b6b",
            "uuid_parent"                            : "4f3938ecf2a4442aa1d96fb8595e9b6b"
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701732,
            "last_hard_state_change"                 : 1720701731,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style><br>Arbiter answered in 0.004s.<br/><br/>Connected to daemons&nbsp;<ul class='skn-ul '><li><span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span>: broker [broker-master] Version : [VC_Charlie-003.6-B55.fr] </li><li><span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span>: poller [poller-master] Version : [VC_Charlie-003.6-B55.fr] </li><li><span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span>: reactionner [reactionner-master] Version : [VC_Charlie-003.6-B55.fr] </li><li><span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span>: receiver [receiver-master] Version : [VC_Charlie-003.6-B55.fr] </li><li><span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span>: scheduler [scheduler-master] Version : [VC_Charlie-003.6-B55.fr] </li></ul><br/>Version [VC_Charlie-003.6-B55.fr]<br/>",
            "long_output"                            : "",
            "perf_data"                              : "",
            "smart_perf_data"                        : [],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>CPU stolen ( <i>cpu_stolen__vmware__percent_ready</i> )</div></td>\n<td>⩾ 10 %</td>\n<td>⩾ 5 %</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702869,
            "last_check"                             : 1720702811.2866435,
            "display_name"                           : "Arbiter - arbiter-master - Performance",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Arbiter - arbiter-master - Performance",
            "name"                                   : "Arbiter - arbiter-master - Performance",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-bb9bfcec614afa874dcac0cfdbd234f9",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-bb9bfcec614afa874dcac0cfdbd234f9",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701732,
            "last_hard_state_change"                 : 1720701612,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ict,.skn-ict td,.skn-ict th{border:1px solid #000000 !important;border-collapse:collapse !important;word-break: break-all !important;color:#000000 !important} .skn-ict{width:100% !important;} .skn-ict th{background-color:#DDDDDD !important;padding:2px !important;word-break:break-word !important} .skn-ict td{padding:2px;width:auto !important;font-weight:normal !important;word-break:break-word !important;background-color:#FFFFFF !important} .skn-tbl-98109 .skn-ict{table-layout: fixed;} .skn-tbl-12751 .skn-ict{table-layout: fixed;} .skn-tbl-36069 .skn-ict{table-layout: fixed;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Modules performance is going well<br/><ul><li><span class=\"skn-ctg \" style=\"color:#2A9A3D;border-color:#2A9A3D;\">OK</span> The module Graphite-Perfdata have <span style=\"font-style:italic;color: black;\">1 workers</span></li></ul><br/><ul><li><span class=\"skn-ctg \" style=\"color:#2A9A3D;border-color:#2A9A3D;\">OK</span> The module sla have <span style=\"font-style:italic;color: black;\">1 workers</span></li></ul><br/><ul><li><span class=\"skn-ctg \" style=\"color:#2A9A3D;border-color:#2A9A3D;\">OK</span> The module event-manager-writer have <span style=\"font-style:italic;color: black;\">1 workers</span></li></ul><br/>",
            "long_output"                            : "<div class=\"skn-ich\">Module Graphite-Perfdata workers :</div><div class=\"skn-tbl-98109\"><table class=\"skn-ict\" ><tr><th>Worker</th><th>Managed hosts</th></tr><tr><td>Graphite-Perfdata Worker - 0</td><td>12</td></tr></table></div><br/><div class=\"skn-ich\">Module sla workers :</div><div class=\"skn-tbl-12751\"><table class=\"skn-ict\" ><tr><th>Worker</th><th>Managed hosts</th></tr><tr><td>sla Worker - 1</td><td>12</td></tr></table></div><br/><div class=\"skn-ich\">Module event-manager-writer workers :</div><div class=\"skn-tbl-36069\"><table class=\"skn-ict\" ><tr><th>Worker</th><th>Managed hosts</th></tr><tr><td>event-manager-writer Worker - 0</td><td>0</td></tr></table></div><br/>",
            "perf_data"                              : " module.WebUI.data_queue=0 module.Livestatus.data_queue=0 module.broker-module-livedata.data_queue=0 module.Graphite-Perfdata.data_queue=0 module.Graphite-Perfdata.managed_hosts=12 module.sla.data_queue=0 module.sla.managed_hosts=12 module.event-manager-writer.data_queue=0 module.event-manager-writer.managed_hosts=0 ",
            "smart_perf_data"                        : [
                {
                    "name"    : "module.WebUI.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.Livestatus.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.broker-module-livedata.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.Graphite-Perfdata.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.Graphite-Perfdata.managed_hosts",
                    "value"   : 12,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.sla.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.sla.managed_hosts",
                    "value"   : 12,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.event-manager-writer.data_queue",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "module.event-manager-writer.managed_hosts",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702870,
            "last_check"                             : 1720702811.8029501,
            "display_name"                           : "Broker - broker-master - Performance Modules Queues",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Broker - broker-master - Performance Modules Queues",
            "name"                                   : "Broker - broker-master - Performance Modules Queues",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-b5ca397a42540fcfce85dee3a24c6587",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-b5ca397a42540fcfce85dee3a24c6587",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 1,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701782,
            "last_hard_state_change"                 : 1720701782,
            "is_status_confirmed"                    : true,
            "attempts"                               : 2,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#f57700;font-weight:bold;\">[WARNING]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Livedata broker-module-livedata module has some issues.<br/><br/><table class=\"skn-brd \" style=\"border-color:#f57700; \"><tr><td><div class=\"skn-ln\">You are using the default token, it's recommended to change it<br/></div></tr></td></table>API Version&nbsp;:&nbsp;<span style=\"color:#000000;font-weight:bold;\">2</span><br/>Protocol <span style=\"color: black;\">HTTP</span><br/><br/><br/>The module handled <span style=\"color: black;\">0</span> request(s) in the last hour<br/><ul class='skn-ul '><li>No error handled</li><li>You need to make at least one call to the api for informations</li></ul><br/>",
            "long_output"                            : "",
            "perf_data"                              : "livedata_nb_error_last_hour=0 livedata_nb_request_last_hour=0 livedata_error_percent=0",
            "smart_perf_data"                        : [
                {
                    "name"    : "livedata_nb_error_last_hour",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "livedata_nb_request_last_hour",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "livedata_error_percent",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702860,
            "last_check"                             : 1720702802.1659727,
            "display_name"                           : "Broker - broker-master-broker-module-livedata - Module Livedata",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Broker - broker-master-broker-module-livedata - Module Livedata",
            "name"                                   : "Broker - broker-master-broker-module-livedata - Module Livedata",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-6417024c613bb4a53687927df6ffbbad",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-6417024c613bb4a53687927df6ffbbad",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 2,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701923,
            "last_hard_state_change"                 : 1720701683,
            "is_status_confirmed"                    : true,
            "attempts"                               : 2,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#FF0000;font-weight:bold;\">[CRITICAL]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ict,.skn-ict td,.skn-ict th{border:1px solid #000000 !important;border-collapse:collapse !important;word-break: break-all !important;color:#000000 !important} .skn-ict{width:100% !important;} .skn-ict th{background-color:#DDDDDD !important;padding:2px !important;word-break:break-word !important} .skn-ict td{padding:2px;width:auto !important;font-weight:normal !important;word-break:break-word !important;background-color:#FFFFFF !important} .skn-tbl-87055 .skn-ict .skn-lfh {width: 25%;} .skn-tbl-04877 .skn-ict .skn-lfh {width: 25%;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style><table class=\"skn-brd \" style=\"border-color:#FF0000; \"><tr><td><div class=\"skn-ln\"><span style=\"color:#FF0000;font-weight:bold;\">=></span>All graphite backends are critical.<br/></div><div class=\"skn-ln\"><span style=\"color:#FF0000;font-weight:bold;\">=></span>The module <span style=\"color:#000000;font-weight:bold;\">WebUI</span> is critical.<br/></div></tr></td></table>",
            "long_output"                            : "<div class=\"skn-ich\">Graphite backend(s) :</div><br/><div class=\"skn-tbl-87055\"><table class=\"skn-ict\" ><tr><th class=\"skn-lfh\">*=http://127.0.0.1:8799 is <span style=\"color:#FF0000;font-weight:bold;\">CRITICAL</span></th><td><ul class='skn-ul '><li>HTTP API status : <span style=\"color:#FF0000;font-weight:bold;\">CRITICAL</span> - Fail to request metrics to graphite server.</li></ul></td></tr></table></div><br/><br/><br/><div class=\"skn-ich\">Module :</div><br/><div class=\"skn-tbl-04877\"><table class=\"skn-ict\" ><tr><th class=\"skn-lfh\">WebUI is <span style=\"color:#FF0000;font-weight:bold;\">CRITICAL</span></th><td><ul class='skn-ul '><li><span style=\"color:#000000;font-weight:bold;\">Graphite backends defined by the * backend in the WebUI configuration</span>&nbsp;<ul class='skn-ul '><li><span style=\"color:#000000;font-weight:bold;\">All</span>&nbsp;<ul class='skn-ul '><li><span style=\"color:#FF0000;font-weight:bold;\">CRITICAL</span> : Graphite backend <span style=\"color:#000000;font-weight:bold;\">127.0.0.1:8799 ( -> http://lab-validationsw1:8799 )</span> &nbsp;<ul class='skn-ul '><li>Server is <span style=\"color:#FF0000;font-weight:bold;\">unreachable</span></li></ul></li></ul></li></ul></li></ul></td></tr></table></div><br/>",
            "perf_data"                              : "",
            "smart_perf_data"                        : [],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Data Base Latency timeout </div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 25 s</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720703121,
            "last_check"                             : 1720702823.2916756,
            "display_name"                           : "Broker - broker-master-WebUI - Module Visualisation UI - Metrology Reader",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Broker - broker-master-WebUI - Module Visualisation UI - Metrology Reader",
            "name"                                   : "Broker - broker-master-WebUI - Module Visualisation UI - Metrology Reader",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-6112a002f2c1ebbdd586fb6c06891044",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-6112a002f2c1ebbdd586fb6c06891044",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701742,
            "last_hard_state_change"                 : 1720701621,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ict,.skn-ict td,.skn-ict th{border:1px solid #000000 !important;border-collapse:collapse !important;word-break: break-all !important;color:#000000 !important} .skn-ict{width:100% !important;} .skn-ict th{background-color:#DDDDDD !important;padding:2px !important;word-break:break-word !important} .skn-ict td{padding:2px;width:auto !important;font-weight:normal !important;word-break:break-word !important;background-color:#FFFFFF !important} .skn-tbl-80774 .skn-ict{table-layout: fixed;} .skn-tbl-94315 .skn-ict{table-layout: fixed;} .skn-tbl-57461 .skn-ict{table-layout: fixed;} .skn-tbl-21447 .skn-ict .skn-lfh {width: 25%;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Module is working as intended.<div class=\"skn-ich\"><br /><span style=\"font-weight: bold;\">Request times in the last 60 seconds</span> :</div><div class=\"skn-tbl-57461\"><table class=\"skn-ict\" style=\"max-width: 360px\"><tr><th>Request type</th><th>Count</th><th>Execution time</th></tr><tr><td>Stored SLAs</td><td>0</td><td>-</td></tr><tr><td>Today's RAW SLAs</td><td>0</td><td>-</td></tr><tr><td>History</td><td>0</td><td>-</td></tr><tr><td>Widget</td><td>0</td><td>-</td></tr><tr><td>Report</td><td>0</td><td>-</td></tr></table></div><style type=\"text/css\">.ctm-tbl td:nth-child(2),.ctm-tbl th:nth-child(2){width:125px !important}.ctm-tbl th:first-child{width:auto !important}</style><br/><br/>",
            "long_output"                            : "<div class=\"skn-tbl-21447\"><table class=\"skn-ict\" ><tr><th class=\"skn-lfh\">SLA - Reader:<br><span class=\"skn-ctg \" style=\"color:#2A9A3D;border-color:#2A9A3D;\">OK</span></th><td><ul class='skn-ul '><li>Stats for the last 60 seconds</li><li><div class=\"skn-ich\">SLAs read :</div><div class=\"skn-tbl-80774\"><table class=\"skn-ict\" ><tr><th>SLA type</th><th>Number read</th><th>Execution time</th></tr><tr><td>Stored</td><td>0</td><td>-</td></tr><tr><td>Raw</td><td>0</td><td>-</td></tr></table></div></li><li><div class=\"skn-ich\">SLA requests from WebUI module(s) :</div><div class=\"skn-tbl-94315\"><table class=\"skn-ict\" ><tr><th>Request type</th><th>Number of calls</th><th>Execution time</th></tr><tr><td>History</td><td>0</td><td>-</td></tr><tr><td>Widget</td><td>0</td><td>-</td></tr><tr><td>Report</td><td>0</td><td>-</td></tr></table></div></li><li>Date the oldest SLA's data was stored: 2023/10/30</li></ul></td></tr></table></div><br/>",
            "perf_data"                              : "",
            "smart_perf_data"                        : [],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702880,
            "last_check"                             : 1720702821.7904737,
            "display_name"                           : "Broker - broker-master-WebUI - Module Visualisation UI - SLA Reader",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Broker - broker-master-WebUI - Module Visualisation UI - SLA Reader",
            "name"                                   : "Broker - broker-master-WebUI - Module Visualisation UI - SLA Reader",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-b16b1280e235152b92c8235b5e926cf6",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-b16b1280e235152b92c8235b5e926cf6",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 2,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701767,
            "last_hard_state_change"                 : 1720701706,
            "is_status_confirmed"                    : true,
            "attempts"                               : 2,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#FF0000;font-weight:bold;\">[CRITICAL]</span> <style type=\"text/css\">.skn-ict,.skn-ict td,.skn-ict th{border:1px solid #000000 !important;border-collapse:collapse !important;word-break: break-all !important;color:#000000 !important} .skn-ict{width:100% !important;} .skn-ict th{background-color:#DDDDDD !important;padding:2px !important;word-break:break-word !important} .skn-ict td{padding:2px;width:auto !important;font-weight:normal !important;word-break:break-word !important;background-color:#FFFFFF !important} .skn-ict th,.skn-ict td{padding:2px!important} .shk-p-4 th,.shk-p-4 td{padding:4px 10px !important} .skn-chk-blue{color:rgb(3, 0, 107)} .shk-no-border td{border:none !important;padding:0px !important;padding-right:10px !important; table-layout:fixed; word-break: keep-all !important; border-collapse: collapse !important; width: 100%} .skn-chk-tbl-stats th,.skn-chk-tbl-stats td{text-align:center;padding:0px !important} .skn-bg-tbl-hd{background-color:rgb(221, 221, 221)} .skn-chk-note{font-style:italic;color:gray;font-size:0.8rem} .skn-threshold-reached{font-size: 12px;padding-left: 5px;float: right;color: orange;font-weight: bold;} .skn-limit-is{color: grey;font-style: italic;font-weight: normal;} .shk-p-4 .skn-ict{table-layout: fixed;} .skn-ict th,.skn-ict td{padding:2px!important} .shk-p-4 th,.shk-p-4 td{padding:4px 10px !important} .skn-chk-blue{color:rgb(3, 0, 107)} .shk-no-border td{border:none !important;padding:0px !important;padding-right:10px !important; table-layout:fixed; word-break: keep-all !important; border-collapse: collapse !important; width: 100%} .skn-chk-tbl-stats th,.skn-chk-tbl-stats td{text-align:center;padding:0px !important} .skn-bg-tbl-hd{background-color:rgb(221, 221, 221)} .skn-chk-note{font-style:italic;color:gray;font-size:0.8rem} .skn-threshold-reached{font-size: 12px;padding-left: 5px;float: right;color: orange;font-weight: bold;} .skn-limit-is{color: grey;font-style: italic;font-weight: normal;} .shk-p-4 .skn-ict{table-layout: fixed;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style><div class=\"skn-ich\">Service weathers status : <span style=\"color:#FF0000;font-weight:bold;\">CRITICAL</span></div><div class=\"shk-p-4\"><table class=\"skn-ict\" ><tr><th></th><th>Total</th></tr><tr><td>Services weather(s) displayed</td><td><span style=\"color:#FF0000;font-weight:bold;\">24</span> <span class=\"skn-threshold-reached\"><span style=\"color:#FF0000;font-weight:bold;\">Threshold reached</span><span class=\"skn-limit-is\"> (Limit is <b>20</b>)</span>.</span></td></tr><tr><td>Services weather(s) managed</td><td>6</td></tr><tr><td>External link(s)</td><td>3</td></tr><tr><td>Requests in the last 5 minutes</td><td><span class=\"shinken-layout-no-external-links\">No request</span></td></tr></table></div><br/><div class=\"skn-ich\">Module state : <span style=\"color:#2A9A3D;font-weight:bold;\">OK</span></div><div class=\"shk-p-4\"><table class=\"skn-ict\" ><tr><th></th><th>State</th></tr><tr><td>Cache running well</td><td><span style=\"color:#2A9A3D;font-weight:bold;\">OK</span></td></tr><tr><td>Mongo connection</td><td><span style=\"color:#2A9A3D;font-weight:bold;\">OK</span></td></tr></table></div><br/>",
            "long_output"                            : "",
            "perf_data"                              : "total_page_requests_in_the_last_5_minutes=0",
            "smart_perf_data"                        : [
                {
                    "name"    : "total_page_requests_in_the_last_5_minutes",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : #f18800;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Request counter for DDOS prevention ( <i>total_page_requests_in_the_last_5_minutes</i> )</div></td>\n<td>⩾ 150</td>\n<td>-</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702845,
            "last_check"                             : 1720702786.6161284,
            "display_name"                           : "Broker - broker-master-WebUI-webui-module-service-weather - Module Visualisation UI - Service Weather - Running Well",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Broker - broker-master-WebUI-webui-module-service-weather - Module Visualisation UI - Service Weather - Running Well",
            "name"                                   : "Broker - broker-master-WebUI-webui-module-service-weather - Module Visualisation UI - Service Weather - Running Well",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-f241dbb33a0911f8e7ed5f062df154a5",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-f241dbb33a0911f8e7ed5f062df154a5",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701745,
            "last_hard_state_change"                 : 1720701624,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Your poller is running well.<br/><br/>Poller <br/><ul class='skn-ul '><li>tags&nbsp;:&nbsp;None</li></ul>The latency between the poller and the schedulers are&nbsp;<ul class='skn-ul '><li><span style=\"color:#2A9A3D;\">scheduler-master [lab-validationsw1:7768]&nbsp;:&nbsp;4.76ms</span></li></ul>Version [VC_Charlie-003.6-B55.fr]<br/>Connection established in 0.006s.<br/>",
            "long_output"                            : "",
            "perf_data"                              : "nb_check_in_timeout=0",
            "smart_perf_data"                        : [
                {
                    "name"    : "nb_check_in_timeout",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : #f18800;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Checks in timeout tolerate ( <i>nb_check_in_timeout</i> )</div></td>\n<td>-</td>\n<td>&gt; 0</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Poller latency tolerate</div></td>\n<td>&gt; 0.5 s</td>\n<td>-</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702883,
            "last_check"                             : 1720702823.792847,
            "display_name"                           : "Poller - poller-master - Running Well",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Poller - poller-master - Running Well",
            "name"                                   : "Poller - poller-master - Running Well",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-1478d9573b3c9f90caf1ed010ee725c5",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-1478d9573b3c9f90caf1ed010ee725c5",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701737,
            "last_hard_state_change"                 : 1720701617,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Your reactionner is running well.<br/><br/>Reactionner <br/><ul class='skn-ul '><li>tags&nbsp;:&nbsp;None</li></ul>The latency between the reactionner and the schedulers are&nbsp;<ul class='skn-ul '><li><span style=\"color:#2A9A3D;\">scheduler-master [lab-validationsw1:7768]&nbsp;:&nbsp;0.47ms</span></li></ul>Version [VC_Charlie-003.6-B55.fr]<br/>Connection established in 0.011s.<br/>",
            "long_output"                            : "",
            "perf_data"                              : "nb_check_in_timeout=0",
            "smart_perf_data"                        : [
                {
                    "name"    : "nb_check_in_timeout",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : #f18800;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Checks in timeout tolerate ( <i>nb_check_in_timeout</i> )</div></td>\n<td>-</td>\n<td>&gt; 0</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Reactionner latency tolerate</div></td>\n<td>&gt; 0.5 s</td>\n<td>-</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702875,
            "last_check"                             : 1720702816.7875977,
            "display_name"                           : "Reactionner - reactionner-master - Running Well",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Reactionner - reactionner-master - Running Well",
            "name"                                   : "Reactionner - reactionner-master - Running Well",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-d71f12f94eb56e4ccbfb4517783b192d",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-d71f12f94eb56e4ccbfb4517783b192d",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701735,
            "last_hard_state_change"                 : 1720701614,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>The daemon is running well:<br/><br/><ul class='skn-ul skn-ul-compact'><li>Version [VC_Charlie-003.6-B55.fr].</li></ul><ul class='skn-ul skn-ul-compact'><li>Connection established in 0.012s.</li></ul>",
            "long_output"                            : "",
            "perf_data"                              : "connexion_time=0.012354135513305664",
            "smart_perf_data"                        : [
                {
                    "name"    : "connexion_time",
                    "value"   : 0.012354135513305664,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>CPU stolen ( <i>cpu_stolen__vmware__percent_ready</i> )</div></td>\n<td>⩾ 10 %</td>\n<td>⩾ 5 %</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720702873,
            "last_check"                             : 1720702814.7880719,
            "display_name"                           : "Receiver - receiver-master - Alive",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Receiver - receiver-master - Alive",
            "name"                                   : "Receiver - receiver-master - Alive",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-172901ea0bf9672ab8131e8270e40f69",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-172901ea0bf9672ab8131e8270e40f69",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701738,
            "last_hard_state_change"                 : 1720701618,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2a9a3d;font-weight: bold;\">[OK]</span> Connection took 0.006 seconds",
            "long_output"                            : "",
            "perf_data"                              : "connection_time=0.006;2.0;4.0",
            "smart_perf_data"                        : [
                {
                    "name"    : "connection_time",
                    "value"   : 0.006,
                    "uom"     : "",
                    "warning" : 2,
                    "critical": 4,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : #f18800;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>Data-Base connection time</div></td>\n<td>⩾ 4 s</td>\n<td>⩾ 2 s</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>SSH tunnel timeout</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 5 s</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720705755,
            "last_check"                             : 1720705698.323747,
            "display_name"                           : "Synchronizer - DB - Connection",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Synchronizer - DB - Connection",
            "name"                                   : "Synchronizer - DB - Connection",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-f8897e70f6ea11e780693cf862f4613a",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-f8897e70f6ea11e780693cf862f4613a",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720701741,
            "last_hard_state_change"                 : 1720701620,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "<span style=\"color:#2A9A3D;font-weight:bold;\">[OK]</span> <style type=\"text/css\">.skn-ul{padding: 0; margin: 0 0 10px 25px;} .skn-ul-compact{margin-bottom: 0px;padding-left: 0px;margin-left: 25px;}.skn-ict,.skn-ict td,.skn-ict th{border:1px solid #000000 !important;border-collapse:collapse !important;word-break: break-all !important;color:#000000 !important} .skn-ict{width:100% !important;} .skn-ict th{background-color:#DDDDDD !important;padding:2px !important;word-break:break-word !important} .skn-ict td{padding:2px;width:auto !important;font-weight:normal !important;word-break:break-word !important;background-color:#FFFFFF !important} .skn-tbl-32993 .skn-ict{table-layout: fixed;} .skn-tbl-51533 .skn-ict{table-layout: fixed;}.skn-ctg{margin:1px;background:#DDD;padding:1px 7px;border-radius:5px;box-sizing:border-box;display:inline-block;border:1px solid} .skn-brd{margin:7px 0px;padding:5px 7px;border-radius:7px;box-sizing:border-box;border:2px solid;width:100%;word-break: break-word;border-collapse: separate;}</style>Your scheduler is running well.<br/><br/><div class=\"skn-ich\">Element in the scheduler :</div><br/><div class=\"skn-tbl-32993\"><table class=\"skn-ict\" ><tr><th>Hosts</th><th>Clusters</th><th>Checks</th><th>Total</th></tr><tr><td>12</td><td>2</td><td>135</td><td>149</td></tr></table></div><br/>Data retrieved from [ lab-validationsw1:7768 ] on realm All.&nbsp;<ul class='skn-ul skn-ul-compact'><li>Version [ VC_Charlie-003.6-B55.fr ]</li><li>Raw Data fetched in 0.007s</li><li>Connectivity to other daemons in 0.009s</li></ul><br/>",
            "long_output"                            : "<div class=\"skn-ich\">Module info :</div><br/><div class=\"skn-tbl-51533\"><table class=\"skn-ict\" ><tr><th>Name</th><th>Type</th><th>Status</th><th>Restart in the last 2h</th><th>Last restart date</th><th>Submodules</th></tr><tr><td>PickleRetentionFile</td><td>pickle_retention_file</td><td><span class=\"skn-ctg \" style=\"color:#2A9A3D;border-color:#2A9A3D;\">OK</span></td><td>0</td><td></td><td>-</td></tr></table></div><br/>",
            "perf_data"                              : " nb_late_checks=0 nb_late_notifications=0 nb_late_event_handlers=0 nb_checks=135 nb_clusters=2 nb_hosts=12 ",
            "smart_perf_data"                        : [
                {
                    "name"    : "nb_late_checks",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "nb_late_notifications",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "nb_late_event_handlers",
                    "value"   : 0,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "nb_checks",
                    "value"   : 135,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "nb_clusters",
                    "value"   : 2,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                },
                {
                    "name"    : "nb_hosts",
                    "value"   : 12,
                    "uom"     : "",
                    "warning" : null,
                    "critical": null,
                    "min"     : null,
                    "max"     : null
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "<div style=\"white-space: pre-wrap;\"><div><style>\n.thresholds th {\nfont-weight: normal;\npadding: 0 5px;\ntext-align: center;\nfont-size:11px;\n}\n.thresholds td:not(.title) {\npadding: 0 2px;\n}\n.thresholds td.title div {\nword-break: break-all;\n}\n.thresholds td:not(.title) {\ntext-align: center;\nfont-size:11px;\n}\n.thresholds .title div i{\ncolor: grey;\n}\n\n</style>\n<body><table class=\"thresholds\">\n<thead>\n<tr>\n<th></th>\n<th><span style=\"color : red;\">Critical</span></th>\n<th><span style=\"color : orange;\">Warning</span></th>\n<th><span style=\"color : grey;\">Unknown</span></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td class=\"title\"><div>CPU stolen ( <i>cpu_stolen__vmware__percent_ready</i> )</div></td>\n<td>⩾ 10 %</td>\n<td>⩾ 5 %</td>\n<td>-</td>\n</tr>\n<tr>\n<td class=\"title\"><div>Timeout ( <i>connexion_time</i> )</div></td>\n<td>-</td>\n<td>-</td>\n<td>&gt; 3 s</td>\n\n</tr>\n</tbody>\n</table></body></div></div>",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "downtimes_inherited"                    : [],
            "next_check"                             : 1720705759,
            "last_check"                             : 1720705700.824584,
            "display_name"                           : "Scheduler - scheduler-master - Running Well",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "w",
                "u",
                "c",
                "r",
                "f",
                "s"
            ],
            "type"                                   : "check",
            "extended_type"                          : "check_host",
            "is_unknown"                             : false,
            "host_name"                              : "Supervision de Shinken",
            "service_description"                    : "Scheduler - scheduler-master - Running Well",
            "name"                                   : "Scheduler - scheduler-master - Running Well",
            "realm"                                  : "All",
            "uuid"                                   : "b0c987742d1844a2a65102353aa31082-9929910a47d3828ccd81981338a2c5b9",
            "check_uuid"                             : "b0c987742d1844a2a65102353aa31082-9929910a47d3828ccd81981338a2c5b9",
            "uuid_parent"                            : "b0c987742d1844a2a65102353aa31082",
            "host_groups"                            : [
                ""
            ]
        },
        {
            "business_impact"                        : 2,
            "status"                                 : 0,
            "context"                                : "NOTHING",
            "status_since"                           : 1720674695,
            "last_hard_state_change"                 : 1719470553,
            "is_status_confirmed"                    : true,
            "attempts"                               : 1,
            "max_attempts"                           : 2,
            "is_root_problem"                        : false,
            "output"                                 : "PING OK - Packet loss = 0%, RTA = 20.97 ms",
            "long_output"                            : "",
            "perf_data"                              : "rta=20.966000ms;1000.000000;3000.000000;0.000000 pl=0%;100;100;0",
            "smart_perf_data"                        : [
                {
                    "name"    : "rta",
                    "value"   : 20.966,
                    "uom"     : "ms",
                    "warning" : 1000,
                    "critical": 3000,
                    "min"     : 0,
                    "max"     : null
                },
                {
                    "name"    : "pl",
                    "value"   : 0,
                    "uom"     : "%",
                    "warning" : 100,
                    "critical": 100,
                    "min"     : 0,
                    "max"     : 100
                }
            ],
            "got_business_rule"                      : false,
            "in_flapping"                            : false,
            "inherited_flapping"                     : false,
            "in_partial_flapping"                    : false,
            "notes_multi_url"                        : "",
            "notes_url"                              : "",
            "active_checks_enabled"                  : true,
            "thresholds_display"                     : "",
            "acknowledgement"                        : {},
            "partial_acknowledge"                    : {},
            "acknowledgement_inherited"              : {},
            "problem_has_been_acknowledged"          : false,
            "problem_has_been_inherited_acknowledged": 0,
            "in_scheduled_downtime"                  : false,
            "in_inherited_downtime"                  : false,
            "downtimes"                              : [],
            "next_check"                             : 1720702893,
            "last_check"                             : 1720702833.7983582,
            "display_name"                           : "PC Documentation Client",
            "contact_groups"                         : [],
            "contacts"                               : [],
            "notification_period"                    : "24x7",
            "notification_options"                   : [
                "d",
                "u",
                "r",
                "f"
            ],
            "type"                                   : "host",
            "extended_type"                          : "host",
            "is_unknown"                             : false,
            "address"                                : "212-129-54-43.rev.poneytelecom.eu",
            "host_name"                              : "PC Documentation Client",
            "name"                                   : "PC Documentation Client",
            "realm"                                  : "All",
            "host_templates"                         : [
                "vmware-vm"
            ],
            "host_groups"                            : [
                ""
            ],
            "uuid"                                   : "1dac22b9e60540a28ed31c33480557cf",
            "uuid_parent"                            : "1dac22b9e60540a28ed31c33480557cf"
        }
    
    ],
    "all_values"                        : {
        "contact_groups"     : [],
        "contacts"           : ["admin"],
        "host_groups"        : [],
        "host_templates"     : [],
        "notification_period": ["24x7"],
        "realm"              : [
            "All"
        ]
    },
    "pages"                             : [
        {
            "start": 0,
            "end"  : 5
        }
    ],
    "timestamp_backend_processing_end"  : Date.now() / 1000,
    "timestamp_backend_processing_start": Date.now() / 1000,
    "configuration_id"                  : "909280f9631d4655b2fe25a8e6dbf4e0",
    "nb_element_filter"                 : 5,
    "nb_element_total"                  : 5,
    "nb_element_root_problems"          : 0
};

SHINKEN.DOCUMENTATION_DATA[ "ui_panel_list-1" ] = [
    {
        "name"                : "Bordeaux-Datacenter",
        "uuid"                : "00000000000000000000000000000001",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "previous_owner_user": {},
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": [
                {
                    "value": {
                        "link_base_url"         : {
                            "value": ""
                        },
                        "link_external_part_url": {
                            "value": "external"
                        },
                        "authentication_needed" : {
                            "value": true
                        },
                        "link_protocol"         : {
                            "value": "http"
                        },
                        "info_bar"              : {
                            "value": {
                                "position"        : {
                                    "value": "bottom"
                                },
                                "background_color": {
                                    "value": "#F5A736"
                                },
                                "logo_displayed"  : {
                                    "value": true
                                },
                                "refresh"         : {
                                    "value": {
                                        "chrono_displayed"         : {
                                            "value": true
                                        },
                                        "generation_time_displayed": {
                                            "value": true
                                        }
                                    }
                                }
                            }
                        },
                        "notifications"         : {
                            "value": {
                                "sound" : {
                                    "value": {
                                        "enabled": {
                                            "value": false
                                        }
                                    }
                                },
                                "visual": {
                                    "value": {
                                        "blink": {
                                            "value": {
                                                "enabled": {
                                                    "value": false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "link_uuid"             : {
                            "value": "d14087cc43304ea0b31254da3a9695a9"
                        },
                        "link_name"             : {
                            "value": "Nom URL 1"
                        }
                    }
                },
                {
                    "value": {
                        "link_base_url"         : {
                            "value": ""
                        },
                        "link_external_part_url": {
                            "value": "external"
                        },
                        "authentication_needed" : {
                            "value": true
                        },
                        "link_protocol"         : {
                            "value": "http"
                        },
                        "info_bar"              : {
                            "value": {
                                "position"        : {
                                    "value": "top"
                                },
                                "background_color": {
                                    "value": "#343434"
                                },
                                "logo_displayed"  : {
                                    "value": true
                                },
                                "refresh"         : {
                                    "value": {
                                        "chrono_displayed"         : {
                                            "value": true
                                        },
                                        "generation_time_displayed": {
                                            "value": false
                                        }
                                    }
                                }
                            }
                        },
                        "notifications"         : {
                            "value": {
                                "sound" : {
                                    "value": {
                                        "enabled": {
                                            "value": false
                                        }
                                    }
                                },
                                "visual": {
                                    "value": {
                                        "blink": {
                                            "value": {
                                                "enabled": {
                                                    "value": false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "link_uuid"             : {
                            "value": "6bab732f4bd241de9a4cdc430054ecb8"
                        },
                        "link_name"             : {
                            "value": "Nom URL 2"
                        }
                    }
                }
            ]
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "running_phase",
            "last_update": 1701938817
        },
        "nb_shared_links"     : 2,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "France",
        "uuid"                : "00000000000000000000000000000002",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000002",
                "user_name"  : "N.Chevet [Admin]",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "",
                "user_name"  : "",
                "user_exists": false
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"         : "running_phase",
            "last_update"   : 1725898664,
            "previous_phase": "deleted_phase"
        },
        "nb_shared_links"     : 0,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Toulouse-Datacenter",
        "uuid"                : "00000000000000000000000000000003",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "previous_owner_user": {},
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 1,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "running_phase",
            "last_update": 1725897797
        },
        "nb_shared_links"     : 0,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Toulouse-Datacenter (Copie)",
        "uuid"                : "00000000000000000000000000000004",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "P.Naref",
                "user_exists": false
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 2,
        "nb_warnings"         : 1,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "draft_phase",
            "last_update": 1725897797
        },
        "nb_shared_links"     : 0,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Nouvelle météo des services",
        "uuid"                : "00000000000000000000000000000005",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "",
                "user_name"  : "",
                "user_exists": false
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "draft_phase",
            "last_update": 1725898664
        },
        "nb_shared_links"     : 1,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Grand Sud Ouest",
        "uuid"                : "00000000000000000000000000000006",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000003",
                "user_name"  : "C.Moreau",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "",
                "user_name"  : "",
                "user_exists": false
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "running_phase",
            "last_update": 1725898664
        },
        "nb_shared_links"     : 5,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Marseille",
        "uuid"                : "00000000000000000000000000000007",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000003",
                "user_name"  : "C.Moreau",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000003",
                "user_name"  : "C.Moreau",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": [
                {
                    "value": {
                        "link_base_url"         : {
                            "value": ""
                        },
                        "link_external_part_url": {
                            "value": "external"
                        },
                        "authentication_needed" : {
                            "value": true
                        },
                        "link_protocol"         : {
                            "value": "http"
                        },
                        "info_bar"              : {
                            "value": {
                                "position"        : {
                                    "value": "bottom"
                                },
                                "background_color": {
                                    "value": "#F5A736"
                                },
                                "logo_displayed"  : {
                                    "value": true
                                },
                                "refresh"         : {
                                    "value": {
                                        "chrono_displayed"         : {
                                            "value": true
                                        },
                                        "generation_time_displayed": {
                                            "value": true
                                        }
                                    }
                                }
                            }
                        },
                        "notifications"         : {
                            "value": {
                                "sound" : {
                                    "value": {
                                        "enabled": {
                                            "value": false
                                        }
                                    }
                                },
                                "visual": {
                                    "value": {
                                        "blink": {
                                            "value": {
                                                "enabled": {
                                                    "value": false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "link_uuid"             : {
                            "value": "d14087cc43304ea0b31254da3a9695a9"
                        },
                        "link_name"             : {
                            "value": "Nom URL 1"
                        }
                    }
                },
                {
                    "value": {
                        "link_base_url"         : {
                            "value": ""
                        },
                        "link_external_part_url": {
                            "value": "external"
                        },
                        "authentication_needed" : {
                            "value": true
                        },
                        "link_protocol"         : {
                            "value": "http"
                        },
                        "info_bar"              : {
                            "value": {
                                "position"        : {
                                    "value": "bottom"
                                },
                                "background_color": {
                                    "value": "#F5A736"
                                },
                                "logo_displayed"  : {
                                    "value": true
                                },
                                "refresh"         : {
                                    "value": {
                                        "chrono_displayed"         : {
                                            "value": true
                                        },
                                        "generation_time_displayed": {
                                            "value": true
                                        }
                                    }
                                }
                            }
                        },
                        "notifications"         : {
                            "value": {
                                "sound" : {
                                    "value": {
                                        "enabled": {
                                            "value": false
                                        }
                                    }
                                },
                                "visual": {
                                    "value": {
                                        "blink": {
                                            "value": {
                                                "enabled": {
                                                    "value": false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "link_uuid"             : {
                            "value": "d14087cc43304ea0b31254da3a9695a9"
                        },
                        "link_name"             : {
                            "value": "Nom URL 1"
                        }
                    }
                },
                {
                    "value": {
                        "link_base_url"         : {
                            "value": ""
                        },
                        "link_external_part_url": {
                            "value": "external"
                        },
                        "authentication_needed" : {
                            "value": true
                        },
                        "link_protocol"         : {
                            "value": "http"
                        },
                        "info_bar"              : {
                            "value": {
                                "position"        : {
                                    "value": "top"
                                },
                                "background_color": {
                                    "value": "#343434"
                                },
                                "logo_displayed"  : {
                                    "value": true
                                },
                                "refresh"         : {
                                    "value": {
                                        "chrono_displayed"         : {
                                            "value": true
                                        },
                                        "generation_time_displayed": {
                                            "value": false
                                        }
                                    }
                                }
                            }
                        },
                        "notifications"         : {
                            "value": {
                                "sound" : {
                                    "value": {
                                        "enabled": {
                                            "value": false
                                        }
                                    }
                                },
                                "visual": {
                                    "value": {
                                        "blink": {
                                            "value": {
                                                "enabled": {
                                                    "value": false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "link_uuid"             : {
                            "value": "6bab732f4bd241de9a4cdc430054ecb8"
                        },
                        "link_name"             : {
                            "value": "Nom URL 2"
                        }
                    }
                }
            ]
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"      : "running_phase",
            "last_update": 1725897797
        },
        "nb_shared_links"     : 3,
        "groups_shares_uuid"  : []
    },
    {
        "name"                : "Marseille (Ancien)",
        "uuid"                : "00000000000000000000000000000008",
        "type"                : "service_weather",
        "users"               : {
            "owner_user"         : {
                "user_uuid"  : "00000000000000000000000000000003",
                "user_name"  : "C.Moreau",
                "user_exists": true
            },
            "previous_owner_user": {
                "user_uuid"  : "00000000000000000000000000000001",
                "user_name"  : "R.Dubois [Admin]",
                "user_exists": true
            },
            "creator_user"       : {
                "user_uuid"  : "00000000000000000000000000000003",
                "user_name"  : "C.Moreau",
                "user_exists": true
            }
        },
        "nb_errors"           : 0,
        "nb_warnings"         : 0,
        "external_links"      : {
            "list_content": []
        },
        "notifications"       : {
            "notifications_sound" : {
                "enabled": false
            },
            "notifications_visual": {
                "blink": {
                    "enabled": false
                }
            }
        },
        "view_behaviour_phase": {
            "phase"         : "deleted_phase",
            "last_update"   : 1726059707,
            "previous_phase": "draft_phase"
        },
        "nb_shared_links"     : 0,
        "groups_shares_uuid"  : []
    }
];