//priority 3
//__lib__ lib_common

"use strict";

var CONTROLLER   = CONTROLLER || {};
CONTROLLER.CONST = CONTROLLER.CONST || {
    PARAM_EVENT            : {
        CONTROLLER_OBJECT: "param_event__controller__object"
    },
    CONTROLLER_NAME_LABEL  : "controller_name",
    MASS_CHANGE            : {
        NAME      : "mass-change",
        TYPE      : {
            PROPERTIES     : 'properties',
            DATAS          : 'datas',
            LOCAL_DATAS    : 'local_datas',
            DFE_DATAS      : 'dfe_datas',
            CHECKS         : 'checks',
            CHECKS_OVERRIDE: 'overrides',
            CHECKS_EXCLUDE : 'excludes'
        },
        GROUP_DATA: {
            ALL  : "___ALL___",
            LOCAL: "___LocalData___"
        }
    },
    PHASE                  : {
        ACTIVE: 1
    },
    SHINKEN_ELEMENT        : {
        NAME: "shinken-element"
    },
    LIST_ALL               : {
        NAME: "list-all"
    },
    SOURCES                : {
        NAME: "sources"
    },
    MAIN                   : {
        NAME: "main"
    },
    WEATHER                : {
        NAME: "weather"
    },
    COMMON_UI              : {
        NAME: "common_ui"
    },
    UI_VISUALISATION       : {
        NAME: "ui_visualisation"
    },
    UI_NAV_BAR             : {
        NAME: "nav_bar"
    },
    SHINKEN_VIEW           : {
        NAME: "shinken_view"
    },
    UI_LOGIN               : {
        NAME: "ui_login"
    },
    REPORT_FORM            : {
        NAME: "report_form"
    },
    REPORT_WEB             : {
        NAME: "report_web"
    },
    UI_VIEW_WEATHER_MANAGER: {
        NAME: "ui_view_weather_manager"
    },
    UI_PANELS              : {
        NAME: "ui_panels"
    },
    APPLY                  : {
        NAME: "apply"
    },
    UI_PANELS_VIEW         : {
        NAME: "ui_panels_view"
    },
    FORM_CONTROLLER        : {
        NAME: "form_controller"
    },
    PAGE_CONTROLLER        : {
        NAME: "page_controller"
    },
    SHARE                  : {
        NAME: "share_controller"
    },
    NOTIFICATION                  : {
        NAME: "notification_controller"
    },
    LOGIN                  : {
        NAME: "login_controller"
    }
};

CONTROLLER.DistributorControllerManager = (function ( self ) {
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller_name = controller_name || self.findControllerName( event );
        return CONTROLLER.DistributorControllerManager.getController( _controller_name );
    };
    self.findControllerName    = function ( event, dom_element ) {
        if ( !event && !dom_element ) {
            return;
        }
        var _target             = dom_element || event.target;
        var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
        if ( !_parent_dom_element ) {
            return;
        }
        return _parent_dom_element.dataset.controller;
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case CONTROLLER.CONST.MASS_CHANGE.NAME:
                return CONTROLLER.MassChange;
            case CONTROLLER.CONST.LIST_ALL.NAME:
                return CONTROLLER.List;
            case CONTROLLER.CONST.SHINKEN_ELEMENT.NAME:
                return CONTROLLER.ShinkenElement;
            case CONTROLLER.CONST.SOURCES.NAME:
                return CONTROLLER.Source;
            case CONTROLLER.CONST.MAIN.NAME:
                return CONTROLLER.Main;
            case CONTROLLER.CONST.APPLY.NAME:
                return CONTROLLER.Apply;
            case CONTROLLER.CONST.WEATHER.NAME:
                return CONTROLLER.Weather;
            case CONTROLLER.CONST.COMMON_UI.NAME:
                return CONTROLLER.CommonUI;
            case CONTROLLER.CONST.UI_VISUALISATION.NAME:
                return CONTROLLER.UiVisualisation;
            case CONTROLLER.CONST.UI_PANELS.NAME:
                return CONTROLLER.UiPanels;
            case CONTROLLER.CONST.UI_PANELS_VIEW.NAME:
                return CONTROLLER.UiPanelsView;
            case CONTROLLER.CONST.UI_VIEW_WEATHER_MANAGER.NAME:
                return CONTROLLER.UiViewWeatherManager;
            case CONTROLLER.CONST.UI_LOGIN.NAME:
                return CONTROLLER.Login;
            case CONTROLLER.CONST.FORM_CONTROLLER.NAME:
                return CONTROLLER.Form;
            case CONTROLLER.CONST.REPORT_FORM.NAME:
                return CONTROLLER.ReportForm;
            case CONTROLLER.CONST.PAGE_CONTROLLER.NAME:
                return CONTROLLER.PageController;
            case CONTROLLER.CONST.SHARE.NAME:
                return CONTROLLER.Share;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( CONTROLLER.DistributorControllerManager || {} );

