"use strict";
SHINKEN.TOOLS.TEST_AUTO_COMPONENT = (function ( self ) {
    self.DOM                    = {};
    self.TEST                   = {};
    self.TEST.JS                = {};
    self.ACTION                 = {};
    //********************************************  RANGE   **************************************************//
    self.TEST.isRangeInputValue = function ( timeout, property_name, value ) {
        setTimeout( function () {
            var _prop = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( _prop.querySelector( 'input[type="range"]' ), 'valueAsNumber', value );
        }, timeout );
        return 50;
    };
    //********************************************  MACRO   **************************************************//
    self.TEST.isMacroError      = function ( timeout, dom_element ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(236, 87, 87)" );
            SHINKEN.TOOLS.TEST_AUTO.__isNotEmpty( dom_element.getAttribute( "shi-tip-html" ), "tooltip de la macro" + dom_element.innerText );
        }, timeout );
        return 0;
    };
    self.TEST.isMacroWarning    = function ( timeout, dom_element ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, "color", "rgb(255, 143, 0)" );
            SHINKEN.TOOLS.TEST_AUTO.__isNotEmpty( dom_element.getAttribute( "shi-tip-html" ), "tooltip de la macro" + dom_element.innerText );
        }, timeout );
        return 0;
    };
    //********************************************  COUNTER   **************************************************//
    self.TEST.hasCounterValue   = function ( timeout, dom_element, value_expected, type_counter ) {
        setTimeout( function () {
            if ( !dom_element ) {
                if ( value_expected !== 0 ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "counter dom is not existing" );
                }
                return;
            }
            if ( value_expected === undefined ) {
                value_expected = "";
            }
            else if ( !value_expected && !dom_element.dataset.showIfNull ) {
                value_expected = "";
            }
            else {
                value_expected = value_expected + "";
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( dom_element.getAttribute( "data-number" ), value_expected, "counter <span class='shinken-data-user'>" + type_counter + "</span>" );
            var _extra_label = dom_element.querySelector( ".shinken-counter-extra-label" );
            if ( !_extra_label ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element, value_expected, "counter <span class='shinken-data-user'>" + type_counter + "</span>" );
            }
        }, timeout );
        return 100;
    };
    self.TEST.counter           = function ( timeout, dom_element, nb_error, nb_warning, nb_user, nb_total ) {
        setTimeout( function () {
            if ( nb_error !== undefined ) {
                self.TEST.hasCounterValue( 0, dom_element.querySelector( ".shinken-error-counter" ), nb_error, 'error' );
            }
            if ( nb_warning !== undefined ) {
                self.TEST.hasCounterValue( 0, dom_element.querySelector( ".shinken-warning-counter" ), nb_warning, 'warning' );
            }
            if ( nb_user !== undefined ) {
                self.TEST.hasCounterValue( 0, dom_element.querySelector( ".shinken-user-set-counter" ), nb_user, 'user-set' );
            }
            if ( nb_total !== undefined ) {
                self.TEST.hasCounterValue( 0, dom_element.querySelector( ".shinken-window-total-counter" ), nb_total, 'total' );
            }
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_COMPONENT || {} );