"use strict";
SHINKEN.TOOLS.TEST_AUTO_MAIN_PAGE = (function ( self ) {
    self.DOM                                = {};
    self.TEST                               = {};
    self.TEST.JS                            = {};
    self.ACTION                             = {};
    self.GET                                = {};
    var _INTERNAL                           = {};
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.isSourceEnabled               = function ( source_name ) {
        return DOM.Service.isVisible( self.DOM.sourceEnableSwitchEnableText( source_name ) );
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getStaging                     = function () {
        return document.querySelector( '.content-staging' );
    };
    self.DOM.getSourcesAndTaggers           = function () {
        return document.querySelector( '.shinken-source-tagger-container' );
    };
    self.DOM.getSourcesContainer            = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return document.querySelector( '#sortable-container-source-all' );
        }
        return document.querySelector( '.shinken-sources-box' );
    };
    self.DOM.getSourcesTableALL             = function () {
        return document.querySelector( '#sortable-container-source-all' );
    };
    self.DOM.getSourceTaggerActionBar       = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return document.querySelector( '#modules-type-area' );
        }
        return document.querySelector( '.shinken-source-tagger-action-bar' );
    };
    self.DOM.getButtonSwitchAllSources      = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.getSourceTaggerActionBar().querySelector( '#sort-list-source' );
        }
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-button[data-name="page_main_switch_to_all_view" ]' );
    };
    self.DOM.getButtonSwitchSeparateSources = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.getSourceTaggerActionBar().querySelector( '#view-sources' );
        }
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-button[data-name="page_main_switch_to_type_view" ]' );
    };
    self.DOM.getInputSearch                 = function () {
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-input-table .shinken-input[data-name="sources_searched_by_name"]' );
    };
    self.DOM.getCheckBoxHideInactiveSources = function () {
        return self.DOM.getSourceTaggerActionBar().querySelector( '.shinken-cell-checkbox-container[data-name="hide_inactive_source"]' );
    };
    self.DOM.sourceEnableSwitchContainer    = function ( source_name ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.sourceLine( source_name ).querySelector( '.column-enabled-table' );
        }
        return self.DOM.sourceLine( source_name ).querySelector( '.shinken-column-enabled-table' );
    };
    self.DOM.sourceEnableSwitchButton       = function ( source_name ) {
        return self.DOM.sourceEnableSwitchContainer( source_name ).querySelector( 'tr' );
    };
    self.DOM.sourceEnableSwitchEnableText   = function ( source_name ) {
        return self.DOM.sourceEnableSwitchContainer( source_name ).querySelector( '.show-if-source-activated' );
    };
    self.DOM.sourceLine__byIndex            = function ( source_index ) {
        return self.DOM.getSourcesContainer().querySelectorAll( "#id-shinken-container-source-all .shinken-line-source" )[ source_index ];
    };
    self.DOM.sourceCellName__byIndex        = function ( source_index ) {
        return self.DOM.sourceLine__byIndex( source_index ).querySelector( '.shinken-column-source-name' );
    };
    self.DOM.sourceLines                    = function () {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.getSourcesContainer().querySelectorAll( ".line-source" );
        }
        return self.DOM.getSourcesContainer().querySelectorAll( ".shinken-line-source" );
    };
    self.DOM.sourceLine                     = function ( source_name ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return document.querySelector( '#sortable-container-source-all .line-source[data-name="' + source_name + '"]' );
        }
        return document.querySelector( '#id-shinken-container-source-all .shinken-line-source[data-name="' + source_name + '"]' );
    };
    self.DOM.sourceLineElementsCounters     = function ( source_name ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.sourceLine( source_name ).querySelectorAll( ".nb-elements-content .shinken-nb-elements" );
        }
        return self.DOM.sourceLine( source_name ).querySelectorAll( ".shinken-content-nb-elements .shinken-nb-elements" );
    };
    self.DOM.sourceState                    = function ( source_name, source_state ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.sourceLine( source_name ).querySelector( 'td.column-state .' + source_state );
        }
        return self.DOM.sourceLine( source_name ).querySelector( 'td.shinken-column-state .' + source_state );
    };
    self.DOM.sourceResult                   = function ( source_name ) {
        if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
            return self.DOM.sourceLine( source_name ).querySelector( 'td.column-output .output-content' );
        }
        return self.DOM.sourceLine( source_name ).querySelector( 'td.shinken-column-output .shinken-output-content' );
    };
    self.DOM.forceImportButton              = function ( source_name ) {
        return self.DOM.sourceLine( source_name ).querySelector( '.icon-play' );
    };
    //********************************************  TEST  **************************************************//
    self.TEST.isSourceExisting              = function ( timeout, source_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'isSourceExisting', source_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.sourceLine( source_name );
            SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom, "source " + source_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isSourceState                 = function ( timeout, source_name, source_state ) {
        let _to_return              = 50;
        let _source_state_lowercase = __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ? source_state.toLowerCase() : source_state;
        let _uuid                   = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'isSourceState', source_name + " - " + _source_state_lowercase );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.sourceState( source_name, _source_state_lowercase ), source_name + " - " + _source_state_lowercase );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.sourceResultContains          = function ( timeout, source_name, text_expected, reverse ) {
        let _to_return = 50;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'sourceResult', source_name + " - " + text_expected );
        setTimeout( () => {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( self.DOM.sourceResult( source_name ), text_expected, null, null, reverse );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.hasSourceElements             = function ( timeout, source_name ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'hasSourceElements', source_name );
        var _to_return = 50;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var elements_nb_list = self.DOM.sourceLineElementsCounters( source_name );
            var has_elements     = false;
            for ( var i = 0, _size = elements_nb_list.length; i < _size; i++ ) {
                if ( elements_nb_list[ i ].innerText > 0 ) {
                    has_elements = true;
                }
            }
            if ( !has_elements ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "The source " + source_name + " has no elements" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isSourceEnable                = function ( timeout, source_name ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'isSourceEnable', source_name );
        var _to_return = 50;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !_INTERNAL.isSourceEnabled( source_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "The source " + source_name + " is not active" );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.sourceOrderIsEqualTo          = function ( timeout, expected_source_name, expected_position ) {
        let dom_element_containing_source_name_at_index = SHINKEN.TOOLS.TEST_AUTO_MAIN_PAGE.DOM.sourceCellName__byIndex( expected_position-1 );
        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element_containing_source_name_at_index, expected_source_name );
    };
    self.TEST.areEnableSources              = function ( timeout, sources ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'areEnableSources' );
        var _to_return = 250;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            for ( var i = 0, _size = sources.length; i < _size; i++ ) {
                if ( !_INTERNAL.isSourceEnabled( sources[ i ] ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "The source " + sources[ i ] + " is not active" );
                }
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.switchListSourceDisplay     = function ( timeout, all_source ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, all_source ? self.DOM.getButtonSwitchAllSources() : self.DOM.getButtonSwitchSeparateSources() );
        }, timeout );
        return 100;
    };
    self.ACTION.setValueSearchInput         = function ( timeout, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.getInputSearch(), to_set );
        }, timeout );
        return 400;
    };
    self.ACTION.ToggleSourcesByActivity     = function ( timeout, to_set ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getCheckBoxHideInactiveSources() );
        }, timeout );
        return 200;
    };
    self.ACTION.forceImport                 = function ( timeout, source_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.forceImportButton( source_name ) );
        }, timeout );
        return 8000;
    };
    self.ACTION.setSourceOrder              = function ( timeout, sorted_source_list ) {
        setTimeout( function () {
            var success = function ( _status, _data ) {
            
            };
            var error   = function ( err ) {
            
            };
            SHINKEN.COMUNICATION.requestGet( "http://" + SHINKEN.HIGHWAY.getHostName() + ":7766/api/sources/setorder?order=" + sorted_source_list.join( "," ), success, error );
        }, timeout );
        return 5000;
    };
    self.ACTION.swapTwoSourcesOrder         = function ( timeout, first_source, second_source ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'swapTwoSourcesOrder', first_source + "-" + second_source );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var sorted_source_list                    = self.GET.getSourceOrder();
            var first_source_index                    = sorted_source_list.indexOf( first_source );
            var second_source_index                   = sorted_source_list.indexOf( second_source );
            sorted_source_list[ second_source_index ] = first_source;
            sorted_source_list[ first_source_index ]  = second_source;
            self.ACTION.setSourceOrder( 0, sorted_source_list );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.addSourceIfNotExist         = function ( timeout, module_type, source_name, port ) {
        __do_next = false;
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'addSourceIfNotExist', source_name + " port : " + port );
        setTimeout( function () {
            if ( !self.DOM.sourceLine( source_name ) ) {
                let _path = '/z-share/packs-' + __version_shinken[ 0 ] + '_' + __version_shinken;
                if ( module_type !== "cfg-file-import" ) {
                    _path += '/_tools_test_auto';
                }
                let installer_path = _path;
                let source_path    = _path;
                let call_source    = '-p';
                let name_source    = '';
                switch ( module_type ) {
                    case SOURCE__MODULE_TYPE__CFG_FILE_IMPORT:
                        installer_path += "/install_pack.py";
                        source_path += "/" + source_name;
                        break;
                    case SOURCE__MODULE_TYPE__LISTENER_TEST_AUTO:
                        installer_path += "/install_sources/install_listener.py";
                        source_path += "/" + SOURCE__MODULE_TYPE__LISTENER_TEST_AUTO;
                        name_source = "-N " + SOURCE__NAME__LISTENER_TEST_AUTO;
                        break;
                    case SOURCE__MODULE_TYPE__COLLECTOR_SYNCHRONIZER_LINKER:
                        installer_path += "/install_sources/install_synchronizer-collector-linker.py";
                        source_path = source_name;
                        call_source = '-s';
                        break;
                    case SOURCE__MODULE_TYPE__COLLECTOR_SYNCHRONIZER_VMWARE:
                        installer_path += "/install_sources/install_synchronizer-collector-vmware.py";
                        source_path = source_name;
                        call_source = '-s';
                        break;
                    case SOURCE__NAME__LISTENER_REST:
                        break;
                    default:
                        throw "ERROR Module type not found in addSourceIfNotExist";
                }
                let _command = "python3-shinken " + installer_path + " -t " + module_type + " " + name_source + " " + call_source + " " + source_path + " -d -n";
                if ( port ) {
                    _command += " -P " + port;
                }
                let _success = function ( _status, data ) {
                    if ( data.rc !== 0 ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "Error while installing pack '" + source_name + "' [ " + data.stdout + " ]" );
                    }
                    else {
                        let _timeout = SHINKEN.TOOLS.TEST_AUTO_DAEMON.SYNCHRONIZER.ACTION.restart( 0 );
                        setTimeout( function () {
                            SHINKEN.HIGHWAY.refreshCurrentPage();
                        }, _timeout );
                        //THE PAGE WILL BE RELOAD IF THE SOURCE IS BE ADDED IN THE PAGE MAIN
                    }
                };
                let _error   = function ( err ) {
                    SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( err );
                };
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
            }
            else {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }, timeout );
    };
    self.ACTION.updateCFGSource             = function ( timeout, module_type, source_name, port ) {
        __do_next = false;
        var _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'addSourceIfNotExist', source_name + " port : " + port );
        setTimeout( function () {
            if ( !self.DOM.sourceLine( source_name ) ) {
                var _path = '/z-share/packs-' + __version_shinken[ 0 ] + '_' + __version_shinken;
                if ( module_type !== "cfg-file-import" ) {
                    _path += '/_tools_test_auto';
                }
                var installer_path = _path;
                var source_path    = _path;
                var call_source    = '-p';
                switch ( module_type ) {
                    case SOURCE__MODULE_TYPE__CFG_FILE_IMPORT:
                        installer_path += "/install_pack.py";
                        source_path += "/" + source_name;
                        break;
                    case SOURCE__MODULE_TYPE__LISTENER_TEST_AUTO:
                        installer_path += "/install_sources/install_listener.py";
                        source_path += "/" + source_name;
                        break;
                    case SOURCE__MODULE_TYPE__COLLECTOR_SYNCHRONIZER_LINKER:
                        installer_path += "/install_sources/install_synchronizer-collector-linker.py";
                        source_path = source_name;
                        call_source = '-s';
                        break;
                    case SOURCE__MODULE_TYPE__COLLECTOR_SYNCHRONIZER_VMWARE:
                        installer_path += "/install_sources/install_synchronizer-collector-vmware.py";
                        source_path = source_name;
                        call_source = '-s';
                        break;
                    default:
                        throw "ERROR Module type not found in addSourceIfNotExist";
                }
                var _command = "python3-shinken " + installer_path + " -t " + module_type + " " + call_source + " " + source_path + " -d -n";
                if ( port ) {
                    _command += " -P " + port;
                }
                var _success = function ( _status, data ) {
                    if ( data.rc !== 0 ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "Error while installing pack '" + source_name + "' [ " + data.stdout + " ]" );
                    }
                    else {
                        SHINKEN.TOOLS.TEST_AUTO_DAEMON.SYNCHRONIZER.ACTION.restart( 0 );
                        //THE PAGE WILL BE RELOAD IF THE SOURCE IS BE ADDED IN THE PAGE MAIN
                    }
                };
                var _error   = function ( err ) {
                    SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( err );
                };
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
            }
            else {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }, timeout );
    };
    self.ACTION.changeEnableStatusForSource = function ( timeout, source_name, to_set ) {
        var _to_return = 500;
        setTimeout( function () {
            // to_set = True for enable, False for disable
            if ( (to_set && !_INTERNAL.isSourceEnabled( source_name ) ||
                  (!to_set && _INTERNAL.isSourceEnabled( source_name ))) ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.sourceEnableSwitchButton( source_name ) );
            }
        }, timeout );
        return _to_return;
        
    };
    self.ACTION.enableSources               = function ( timeout, sources ) {
        var _to_return = 1000;
        setTimeout( function () {
            if ( !Array.isArray( sources ) ) {
                sources = [sources];
            }
            for ( let i = 0, _size = sources.length; i < _size; i++ ) {
                if ( !_INTERNAL.isSourceEnabled( sources[ i ] ) ) {
                    self.ACTION.changeEnableStatusForSource( 0, sources[ i ], true );
                }
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.enableSourceListenerRest    = function ( timeout ) {
        setTimeout( () => {
            self.ACTION.enableSources( 0, SOURCE__NAME__LISTENER_REST );
        }, timeout );
        return 5000;
    };
    self.ACTION.disableSources              = function ( timeout, sources ) {
        var _to_return = 1000;
        setTimeout( function () {
            if ( !Array.isArray( sources ) ) {
                sources = [sources];
            }
            for ( let i = 0, _size = sources.length; i < _size; i++ ) {
                if ( _INTERNAL.isSourceEnabled( sources[ i ] ) ) {
                    self.ACTION.changeEnableStatusForSource( 0, sources[ i ], false );
                }
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.stopRefresh                 = function ( timeout ) {
        var _to_return = 1000;
        setTimeout( function () {
            MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL ).stopAutoRefresh();
        }, timeout );
        return _to_return;
    };
    //********************************************  GET   **************************************************//
    self.GET.getSourceOrder                 = function () {
        var source_lines       = self.DOM.sourceLines();
        var sorted_source_list = Array.apply( null, Array( source_lines.length - 1 ) ).map( function () {
        } );
        for ( var i = 0, _size = source_lines.length; i < _size; i++ ) {
            sorted_source_list[ source_lines[ i ].querySelector( ".shinken-line-number" ).innerText - 1 ] = source_lines[ i ].querySelector( ".shinken-title-source-name" ).innerText;
        }
        return sorted_source_list;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MAIN_PAGE || {} );



