"use strict";
TI.PROPERTY.SELECT = (function ( self ) {
    self.DOM          = {};
    self.TEST         = {};
    self.ACTION       = {};
    self.CONST        = {
        SELECTOR: {
            DISPLAY: {
                NORMAL      : "normal",
                NORMAL_FOCUS: "normal_focus",
                WITH_ERRORS : "with_errors"
            }
        }
    };
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.selector = function ( property_name, selector_name, dom_element ) {
        selector_name = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
        return TI.PROPERTY.DOM.lineV3( property_name, dom_element ).querySelector( '.shinken-select-selector-V3[data-name="' + selector_name + '"]' );
    };
    self.DOM.input          = function ( property_name, dom_element ) {
        return TI.PROPERTY.DOM.lineV3( property_name, dom_element ).querySelector( '.shinken-input-V3' );
    };
    self.DOM.selectorContainer          = function ( property_name, selector_name, dom_element ) {
        return self.DOM.selector( property_name, selector_name, dom_element ).parentNode;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.hasLabel__20250122        = function ( timeout, property_name, text_expected, selector_name, dom_element ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.selector( property_name, selector_name, dom_element ), text_expected );
        }, timeout );
        return 300;
    };
    self.TEST.InputHasValue             = function ( timeout, property_name, text_expected, selector_name, dom_element ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.input( property_name, dom_element ), text_expected );
        }, timeout );
        return 300;
    };
    self.TEST.selectorDisplay__20250131 = function ( timeout, property_name, display_expected ) {
        setTimeout( function () {
            let dom_input = self.DOM.selector( property_name );
            switch ( display_expected ) {
                case self.CONST.SELECTOR.DISPLAY.NORMAL:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgb(255, 255, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(0, 0, 0)" );
                    break;
                //case self.CONST.INPUT.DISPLAY.NORMAL_FOCUS:
                //    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgba(119, 165, 255, 0.2)" );
                //    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(85, 85, 85)" );
                //    break;
                //case self.CONST.INPUT.DISPLAY.WITH_ERRORS:
                //    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgb(253, 123, 123)" );
                //    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(255, 255, 255)" );
                //    break;
            }
        }, timeout );
        return 100;
    };
    return self;
})( TI.PROPERTY.SELECT || {} );