"use strict";
TI.WEATHER.FORM.LINKS = (function ( self ) {
    self.DOM                                       = {};
    self.TEST                                      = {};
    self.ACTION                                    = {};
    //********************************************  DOM  ****************************************//
    self.DOM.slidePanel                            = function () {
        return TI.WEATHER.FORM.DOM.formContainer().querySelector( ".shinken-slide-panel-container" );
    };
    self.DOM.externalLinks                         = function () {
        return self.DOM.slidePanel().querySelector( ".shinken-weather-external-links" );
    };
    self.DOM.externalLinkForm                      = function () {
        return self.DOM.slidePanel().querySelector( ".shinken-form-container" );
    };
    self.DOM.externalLinkFormTitle                 = function () {
        return self.DOM.externalLinkForm().querySelector( ".shinken-form-title" );
    };
    self.DOM.externalLinkFormTitleLabel            = function () {
        return self.DOM.externalLinkFormTitle().querySelector( ".shinken-form-title-label" );
    };
    self.DOM.formTitleCounterError                 = function () {
        return self.DOM.externalLinkFormTitle().querySelector( ".shinken-counter.shinken-errors-counter" );
    };
    self.DOM.formTitleCounterWarning               = function () {
        return self.DOM.externalLinkFormTitle().querySelector( ".shinken-counter.shinken-warning-counter" );
    };
    self.DOM.externalLinkFormInput                 = function ( property_name ) {
        return self.DOM.externalLinkForm().querySelector( ".shinken-element-property-line-V3[data-name='" + property_name + "'] .shinken-input-V3" );
    };
    self.DOM.externalLinkLabel                     = function ( property_name ) {
        return self.DOM.externalLinkForm().querySelector( ".shinken-element-property-line-V3[data-name='" + property_name + "'] .shinken-label" );
    };
    self.DOM.externalLinksHeader                   = function () {
        return self.DOM.externalLinks().querySelector( ".shinken-weather-external-links-header" );
    };
    self.DOM.externalLinksButtonAdd                = function () {
        return self.DOM.externalLinksHeader().querySelector( ".shinken-button-V3[data-name='create_new_external_link']" );
    };
    self.DOM.links                                 = function () {
        return self.DOM.externalLinks().querySelector( ".shinken-weather-links" );
    };
    self.DOM.linkList                                 = function () {
        return self.DOM.links().querySelectorAll( ".shinken-weather-link-element" );
    };
    self.DOM.link_byLinkName                       = function ( link_name ) {
        const links          = self.DOM.links();
        const links_name_div = links.querySelectorAll( ".shinken-weather-link-label-element" );
        let link_name_div    = "";
        for ( let i = 0, _size_i = links_name_div.length; i < _size_i; i++ ) {
            if ( links_name_div[ i ].innerText === link_name ) {
                link_name_div = links_name_div[ i ];
            }
        }
        return DOM.Service.findParentElementWithClass( link_name_div, "shinken-weather-link-element", 20 );
    };
    self.DOM.buttonConfigure_link_byLinkName       = function ( link_name ) {
        return self.DOM.link_byLinkName( link_name ).querySelector( ".shinken-button-V3[data-name='configure_external_link']" );
    };
    self.DOM.buttonConfigure_link_lastLink       = function () {
        let doms_links = self.DOM.linkList();
        return doms_links[doms_links.length-1].querySelector( ".shinken-button-V3[data-name='configure_external_link']" );
    };
    self.DOM.buttonDelete_link_byLinkName          = function ( link_name ) {
        return self.DOM.link_byLinkName( link_name ).querySelector( ".shinken-button-V3[data-name='delete_external_link']" );
    };
    self.DOM.buttonCopyToClipboard_link_byLinkName = function ( link_name ) {
        return self.DOM.link_byLinkName( link_name ).querySelector( ".shinken-button-V3[data-name='delete_external_link']" );
    };
    //********************************************  ACTION  ****************************************//
    self.ACTION.addLink__20250326                            = function ( timeout, name_link ) {
        let _to_return = 1500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "addLink" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.externalLinksButtonAdd() );
            if ( name_link ){
                self.ACTION.configureLink(300);
                TI.PROPERTY.INPUT_STRING.ACTION.setValue__20250205( 600, WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME.COMPOSED_KEY, name_link );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.configureLink                      = function ( timeout, external_link_name ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "configureLink", external_link_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( external_link_name ){
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonConfigure_link_byLinkName( external_link_name ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonConfigure_link_lastLink() );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteLink                         = function ( timeout, external_link_name ) {
        let _to_return = 500;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "deleteLink", external_link_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonDelete_link_byLinkName( external_link_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //******************************************** TEST ****************************************//
    self.TEST.formTitleCounters = function ( timeout, error_expected, warning_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.formTitleCounterError(), error_expected, "error for title" );
            //SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.formTitleCounterWarning(), warning_expected, "warning for title" );
        }, timeout );
        return 100;
    };
    self.TEST.formTitleLabel    = function ( timeout, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.externalLinkFormTitleLabel(), value_expected );
        }, timeout );
        return 50;
    };
    self.TEST.linksNumber       = function ( timeout, value_expected ) {
        let _to_return = 100;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "checkFormTitle", value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( self.DOM.links().childElementCount, value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})
( TI.WEATHER.FORM.LINKS || {} );
