"use strict";
TI.WEATHER.GRID.CELL = (function ( self ) {
    self.DOM                                     = {};
    self.TEST                                    = {};
    self.ACTION                                  = {};
    self.CONST                                   = {
        STATUS: {
            VISIBLE       : "visible",
            HIDDEN        : "hidden",
            HAS_PROBLEM   : "has_problem",
            HAS_NO_PROBLEM: "has_no_problem",
            SELECTED      : "selected",
            UNSELECTED    : "unselected"
        }
    };
    //********************************************  DOM  ****************************************//
    self.DOM.cellByIndex                         = function ( in_iframe, index ) {
        let dom_list = TI.WEATHER.GRID.DOM.grid( in_iframe ).querySelectorAll( ".shinken-grid-cell" );
        if ( !index && index !== 0 ) {
            index = dom_list.length - 1;
        }
        return dom_list[ index ];
    };
    self.DOM.cellByIndexButtonDelete             = function ( in_iframe, index ) {
        return self.DOM.cellByIndex( in_iframe, index ).querySelector( ".shinken-delete-button" );
    };
    self.DOM.containerProblem                    = function ( in_iframe, index ) {
        return self.DOM.cellByIndex( in_iframe, index ).querySelector( ".shinken-grid-cell-container-error-primary-content" );
    };
    self.DOM.buttonOpenConfigGridCellByIndex     = function ( in_iframe, index ) {
        return self.DOM.cellByIndex( in_iframe, index ).querySelector( ".shinken-config-button" );
    };
    self.DOM.clickOnGridCellConfigurationByIndex = function ( in_iframe, index ) {
        let dom = self.DOM.cellByIndex( in_iframe, index );
        return dom.querySelector( ".shinken-config-button" );
    };
    //********************************************  ACTION  ****************************************//
    self.ACTION.clickOnGridCellByIndex           = function ( timeout, index ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnGridCellByIndex", index );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.cellByIndex( false, index ) );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnRemoveByIndex             = function ( timeout, index ) {
        let _to_return = 900;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnRemoveByIndex", index );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 0, self.DOM.cellByIndexButtonDelete( false, index ), SHINKEN.TOOLS.TEST_AUTO_MOUSE_EVENT.getMouseDownEvent() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST  ****************************************//
    self.TEST.displayState__20250219             = function ( timeout, index_cell, state ) {
        setTimeout( function () {
            switch ( state ) {
                case self.CONST.STATUS.SELECTED:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.cellByIndex( false, index_cell ).querySelector( ".shinken-grid-cell-border" ), "border", "2px solid rgb(70, 166, 255)", "displayState on grid cell index " + index_cell );
                    break;
                case self.CONST.STATUS.UNSELECTED:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.cellByIndex( false, index_cell ).querySelector( ".shinken-grid-cell-border" ), "border", "0px none rgb(0, 0, 0)", "displayState on grid cell index " + index_cell );
                    break;
                
                default:
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.cellHasProblem                     = function ( timeout, index_cell, status_expected, in_iframe ) {
        setTimeout( function () {
            switch ( status_expected ) {
                case self.CONST.STATUS.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.cellByIndex( in_iframe, index_cell ) );
                    break;
                case self.CONST.STATUS.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.cellByIndex( in_iframe, index_cell ) );
                    break;
                case self.CONST.STATUS.HAS_PROBLEM:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.containerProblem( in_iframe, index_cell ) );
                    break;
                case self.CONST.STATUS.HAS_NO_PROBLEM:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.containerProblem( in_iframe, index_cell ) );
                    break;
            }
        }, timeout );
        return 100;
    };
    return self;
})
( TI.WEATHER.GRID.CELL || {} );
