"use strict";
SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL_WIDGET = (function ( self ) {
    self.DOM                                       = {};
    self.TEST                                      = {};
    self.ACTION                                    = {};
    self.INTERNAL                                  = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.propertiesFromForm                    = function () {
        return document.querySelectorAll( ".shinken-extra-form-specific .shinken-element-property-line-V3" );
    };
    self.DOM.widgetElementPart                     = function () {
        return document.querySelector( '.shinken-collapse-folder[data-name="cf_weather_edit_widget_element_part"]' );
    };
    self.DOM.widgetElementPartInput                = function () {
        return self.DOM.widgetElementPart().querySelectorAll( ".shinken-select-selector-V3 .shinken-selector-label:not(.shinken-for-pagination)" );
    };
    self.DOM.separatorInput                        = function () {
        return document.querySelector( '.shinken-element-property-line-V3[data-name="layout.information_to_display.title_area.label"] .shinken-input-V3' );
    };
    self.DOM.property                              = function ( property_name ) {
        return document.querySelector( `.shinken-element-property-line-V3[data-name="${property_name}"]` );
    };
    self.DOM.inputBroom                            = function ( property_name ) {
        return self.DOM.property( property_name ).querySelector( `.shinken-button-V3[data-name="clean_input_value"]` );
    };
    self.DOM.domButtonForProperty                  = function ( property_name ) {
        return document.querySelector( `.shinken-element-property-line-V3[data-name="${property_name}"] .shinken-title-icon-container` );
    };
    self.DOM.domForPropertyDefault                 = function ( property_name ) {
        return document.querySelector( `.shinken-element-property-line-V3[data-name="${property_name}"] .shinken-radio-mode[data-name="default"] ` );
    };
    self.DOM.closeWidgetFormButton                 = function ( in_iframe ) {
        return SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.DOM.slidePanelFormContainer( in_iframe ).querySelector( ".shinken-cancel-form" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.closeWidgetForm                    = function ( timeout, index ) {
        let _to_return = 350;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "closeWidgetForm", index );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.closeWidgetFormButton();
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST **************************************************//
    self.TEST.propertiesPresence                   = function ( timeout, type ) {
        let _to_return = 200;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "propertiesPresence" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.TEST.isSameArray( self.INTERNAL.parsePropertiesDomToPropertyName(), self.INTERNAL.propertiesNameByWidgetType( type ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayStateRadio                    = function ( timeout, property_name, radio_name, state ) {
        let _to_return = 300;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "displayStateRadio" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_RADIO_CHECKBOX.TEST.displayState( 0, self.DOM.property( property_name ), radio_name, state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayStateRadioInput               = function ( timeout, property_name, state ) {
        let _to_return = 50;
        let _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "displayStateRadioInput" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_RADIO_CHECKBOX.TEST.INPUT.displayState( 0, self.DOM.property( property_name ), SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT, state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION **************************************************//
    self.ACTION.clicOnCheckbox                     = function ( timeout, property_name, radio_name ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clicOnCheckbox" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_RADIO_CHECKBOX.ACTION.clickRadio( 0, self.DOM.property( property_name ), radio_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 100 );
        }, timeout );
        return 100;
    };
    self.ACTION.clicOnBroom                        = function ( timeout, property_name, radio_name ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clicOnBroom" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.inputBroom( property_name, radio_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 500 );
        }, timeout );
        return 500;
    };
    self.ACTION.changeCheckboxInputValue           = function ( timeout, property_name, radio_name, to_set ) {
        let _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "changeCheckboxInputValue" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_RADIO_CHECKBOX.ACTION.INPUT.changeValue( 0, self.DOM.property( property_name ), radio_name, to_set );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", 500 );
        }, timeout );
        return 500;
    };
    //********************************************  INTERNAL **************************************************//
    self.INTERNAL.propertiesNameByWidgetType       = function ( type ) {
        let to_return = [];
        switch ( type ) {
            case WIDGET.CONST.TYPE.TITLE:
                to_return = [
                    //WIDGET.CONST.PARAM.TYPE._KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY
                ];
                return to_return;
            case WIDGET.CONST.TYPE.SEPARATOR:
                to_return = [
                    //WIDGET.CONST.PARAM.TYPE._KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY
                ];
                return to_return;
            case WIDGET.CONST.TYPE.WEATHER:
                to_return = [
                    WIDGET.CONST.PARAM.TYPE.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.ITEM.NAME.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.ITEM.VISUALISATION_NAME.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.ITEM.UUID.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.ITEM.TYPE.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY,
                    WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX.COMPOSED_KEY
                ];
                return to_return;
        }
    };
    self.INTERNAL.parsePropertiesDomToPropertyName = function () {
        let to_return = [];
        let doms      = self.DOM.propertiesFromForm();
        for ( let i = 0, _size_i = doms.length; i < _size_i; i++ ) {
            to_return.push( doms[ i ].dataset.name );
        }
        return to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT_VISUAL_WIDGET || {} );

