"use strict";
SHINKEN.TOOLS.TEST_AUTO_HEALTHCHECK = (function ( self ) {
    self.ACTION                = {};
    self.TEST                  = {};
    self.COMMON                = {};
    self.CONST                 = {
        ARCHITECTURE       : "Architecture",
        LICENSE_KEY        : "License key",
        LOCAL_LIBRARIES    : "Local libraries",
        STORAGE            : "Storage",
        LOCAL_ADDONS       : "Local addons",
        REALMS_STRUCTURE   : "Realms Structure",
        HEALTHCHECK_SUMMARY: "Healthcheck Summary"
    };
    self.CONST.ORDERED_CHAPTER = [
        self.CONST.ARCHITECTURE,
        self.CONST.LICENSE_KEY,
        self.CONST.LOCAL_LIBRARIES,
        self.CONST.STORAGE,
        self.CONST.LOCAL_ADDONS,
        self.CONST.REALMS_STRUCTURE,
        self.CONST.HEALTHCHECK_SUMMARY
    ];
    
    //********************************************  TEST   **************************************************//
    self.TEST.shinkenHealthCheckContainTextInChapter = function ( timeout, to_test, chapter ) {
        var _success = function ( _status, data ) {
            var next_chapter = self.CONST.ORDERED_CHAPTER[ (self.CONST.ORDERED_CHAPTER.indexOf( chapter ) + 1) ] || "";
            var _data = "";
            if ( next_chapter ) {
                _data = SHINKEN.TOOLS.STRING.extractBetween( data.stdout, chapter, next_chapter );
            } else {
                _data = data.stdout.split(chapter);
                _data = _data[1];
            }
            if ( !SHINKEN.TOOLS.STRING.contains( _data, to_test ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le texte demandé: " + to_test + " n'est pas dans le retour texte du shinken-healthcheck" );
            }
        };
        var _error   = function ( e ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "shinkenHealthCheckContainText a échoué avec l'erreur : " + e );
        };
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, "shinken-healthcheck", _success, _error );
    };
    self.TEST.isShinkenHealthCheckValid = function ( timeout ) {
        var _success = function ( data ) {
            if ( SHINKEN.TOOLS.STRING.startsWith( data.stdout, "##################################################" )) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "shinken-healthcheck is not valid, there's something printed before healthcheck");
            }
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( data.stdout, "traceback" )) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "shinken-healthcheck is not valid, it has return a traceback");
            }
        };
        var _error   = function ( e ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "isShinkenHealthCheckValid a échoué avec l'erreur : " + e );
        };
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, "shinken-healthcheck", _success, _error );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_HEALTHCHECK || {} );
