"use strict";
TI.TAGGER.MAIN_PAGE = (function ( self ) {
    self.DOM                 = {};
    self.TEST                = {};
    self.ACTION              = {};
    //********************************************  DOM  ****************************************//
    self.DOM.listContainer   = function () {
        return document.querySelector( "#id-shinken-table-tagger-main-page" );
    };
    self.DOM.listTaggers     = function () {
        return self.DOM.listContainer().querySelectorAll( ".shinken-tagger-line" );
    };
    self.DOM.byName          = function ( tagger_name ) {
        return self.DOM.listContainer().querySelector( ".shinken-tagger-line[data-name='" + tagger_name + "']" );
    };
    self.DOM.cellOrderByName = function ( tagger_name ) {
        return self.DOM.byName( tagger_name ).querySelector( "td.order" );
    };
    self.DOM.cellStateByName = function ( tagger_name ) {
        return self.DOM.byName( tagger_name ).querySelector( "td.shinken-tagger-state" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.count          = function ( timeout, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.listTaggers(), number_expected, "list tagger" );
        }, timeout );
        return 100;
    };
    self.TEST.orderByName    = function ( timeout, tagger_name, order_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.cellOrderByName( tagger_name ), order_expected, "order of " + tagger_name );
        }, timeout );
        return 100;
    };
    self.TEST.stateByName    = function ( timeout, tagger_name, state_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.cellStateByName( tagger_name ), state_expected, "state of " + tagger_name );
        }, timeout );
        return 100;
    };
    return self;
})
( TI.TAGGER.MAIN_PAGE || {} );
