"use strict";
TI.ANGULAR.LIST_ALL = (function ( self ) {
    self.DOM                                          = {};
    self.TEST                                         = {};
    self.ACTION                                       = {};
    self.CONST                                        = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                                = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error = _has_script_error + 1;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.header                                   = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-title-list-all" );
    };
    self.DOM.buttonAutoRefresh                        = function () {
        return self.DOM.header().querySelector( ".shinken-auto-refresh-cell" );
    };
    self.DOM.buttonRefreshManual                      = function () {
        return self.DOM.header().querySelector( ".shinken-view-button-refresh .shinken-icon-refresh-cell" );
    };
    self.DOM.buttonExportCSV                          = function () {
        return self.DOM.header().querySelector( ".shinken-view-button-export-csv" );
    };
    self.DOM.buttonMassActionParent                   = function ( action ) {
        return self.DOM.header().querySelector( ".shinken-action-container." + action );
    };
    self.DOM.buttonMassAction                         = function ( action ) {
        return self.DOM.buttonMassActionParent( action ).querySelector( ".shinken-action-command" );
    };
    self.DOM.exportCSVFrame                           = function () {
        return self.DOM.getIframe().querySelector( ".loading-frame" );
    };
    self.DOM.exportSaveButton                         = function () {
        return self.DOM.header().querySelector( ".save-list-btn" );
    };
    self.DOM.applyButton                              = function () {
        return self.DOM.header().querySelector( ".shinken-apply-cell" );
    };
    self.DOM.inputName                                = function () {
        return self.DOM.header().querySelector( "#inputListAllName" );
    };
    self.DOM.lineFilter                               = function ( index_line_filter ) {
        index_line_filter = index_line_filter || 0;
        return self.DOM.getIframe().querySelectorAll( ".row-filter-header" )[ index_line_filter ];
    };
    self.DOM.filter                                   = function ( filter_name, index_line_filter ) {
        index_line_filter = index_line_filter || 0;
        return self.DOM.getIframe().querySelector( "th.filter-cell[data-uuid='1_" + filter_name + "_" + index_line_filter + "']" );
    };
    self.DOM.gridDataContainer                        = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-datas-container" );
    };
    self.DOM.gridHeaderContainer                      = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-header-line-fix" );
    };
    self.DOM.getLine                                  = function ( element_uuid ) {
        return self.DOM.gridDataContainer().querySelector( ".row-data[data-uuid='" + element_uuid + "']" );
    };
    self.DOM.getLines                                 = function () {
        return self.DOM.gridDataContainer().querySelectorAll( ".row-data" );
    };
    self.DOM.getCell__inLine                          = function ( element_uuid, header_name ) {
        return self.DOM.getLine( element_uuid ).querySelector( ".shinken-cell-data[data-header-field='" + header_name + "']" );
    };
    self.DOM.getCell                                  = function ( element_uuid, column_name ) {
        return self.DOM.getLine( element_uuid ).querySelector( ".shinken-cell-data[data-header-field=" + column_name + "]" );
    };
    self.DOM.getCellIcon                              = function ( element_uuid, column_name ) {
        return self.DOM.getCell( element_uuid, column_name ).querySelector( ".status-icon" );
    };
    self.DOM.getCellIcons                             = function ( element_uuid, column_name ) {
        return self.DOM.getCell( element_uuid, column_name ).querySelectorAll( ".status-icon" );
    };
    self.DOM.getOptionFilter                          = function ( filter_name, option_name, index_line_filter ) {
        var _doms = self.DOM.filter( filter_name, index_line_filter ).querySelectorAll( ".optionFilter" );
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _doms[ i ].innerText.trim() === option_name ) {
                return _doms[ i ];
            }
        }
        return null;
    };
    self.DOM.columnHeader                             = function ( column_name ) {
        return self.DOM.getIframe().getElementById( "header_" + column_name );
    };
    self.DOM.columnHeaderLabel                        = function ( column_name ) {
        return self.DOM.columnHeader( column_name ).querySelector( ".header-shinken-grid-name" );
    };
    self.DOM.headerManager                            = function () {
        return self.DOM.getIframe().querySelector( ".shinken-grid-header-manager" );
    };
    self.DOM.headerManagerButton                      = function () {
        return self.DOM.headerManager().querySelector( ".shinkenGridHeaderManagerButton" );
    };
    self.DOM.headerManagerSubMenu                     = function () {
        return self.DOM.headerManager().querySelector( ".shinken-grid-header-manager-sub-menu" );
    };
    self.DOM.headerManagerSubMenuList                 = function () {
        return self.DOM.headerManagerSubMenu().querySelector( ".shinken-grid-header-manager-sub-menu-list" );
    };
    self.DOM.headerManagerSubMenuListColumn           = function ( column_name ) {
        return self.DOM.headerManagerSubMenuList().querySelector( ".shinkenGridHeaderManagerSubMenuElement[data-header-id='header_" + column_name + "']" );
    };
    self.DOM.filters                                  = function () {
        return self.DOM.gridHeaderContainer().querySelector( ".row-filter-header" );
    };
    self.DOM.filterInput                              = function ( column_name ) {
        return self.DOM.filters().querySelector( ".ui-filter[id='1_" + column_name + "_0'] input" );
    };
    self.DOM.filterListOptions                        = function ( column_name ) {
        return self.DOM.filters().querySelector( ".ui-filter[id='1_" + column_name + "_0']" );
    };
    self.DOM.filterListOptionsList                    = function ( column_name ) {
        return self.DOM.filters().querySelector( ".dropdown-menu[id='1_" + column_name + "_0_option']" );
    };
    self.DOM.filterList                               = function ( column_name ) {
        return self.DOM.filterListOptionsList( column_name ).querySelectorAll( "li" );
    };
    self.DOM.filterInput                              = function ( column_name ) {
        return self.DOM.filters().querySelector( ".ui-filter[id='1_" + column_name + "_0'] input" );
    };
    self.DOM.formAddAcknowledge                       = function () {
        return self.DOM.getIframe().querySelector( "#shinken-id-acknowledge-form" );
    };
    self.DOM.formAddAcknowledgeInput                  = function () {
        return self.DOM.formAddAcknowledge().querySelector( ".shinken-textarea-reason-container textarea" );
    };
    self.DOM.formAddAcknowledgeSubmit                 = function () {
        return self.DOM.formAddAcknowledge().querySelector( "button[type='submit']" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.displayCSVExportFrame                   = function ( timeout ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.displayCSVExportFrame", "" );
        
        setTimeout( function () {
            var csvFrame = self.DOM.exportCSVFrame();
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, csvFrame );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, 10000 );
        
        return _to_return;
    };
    self.TEST.isOptionFilterState                     = function ( timeout, state, filter_name, option_name, index_line_filter ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnAutoRefresh", filter_name + "-" + option_name + "-" + index_line_filter );
        setTimeout( function () {
            var _option_dom = self.DOM.getOptionFilter( filter_name, option_name, index_line_filter );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_SELECTABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.exists( 0, _option_dom, option_name );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.SELECTED_UNSELECTABLE:
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgb(0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "0.18", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(255, 255, 255)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "pointer-events", "none", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.NOT_SELECTED_SELECTABLE:
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR_CONST.OPTION_STATE.UNKNOWN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _option_dom, option_name );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "background-color", "rgba(0, 0, 0, 0)", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "opacity", "1", "selector option" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( timeout, _option_dom, "color", "rgb(0, 0, 0)", "selector option" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.TEST.isActionCommandState                    = function ( timeout, option_name, state ) {
        setTimeout( function () {
            const _dom_element = self.DOM.buttonMassAction( option_name );
            switch ( state ) {
                case TI.ANGULAR.CONST.STATE.RUNNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "opacity", "1", option_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "cursor", "pointer", option_name );
                    break;
                case TI.ANGULAR.CONST.STATE.DISABLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "opacity", "0.3", option_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, _dom_element, "cursor", "not-allowed", option_name );
                    break;
            }
        }, timeout );
        return 300;
    };
    self.TEST.optionFilterDisplay                     = function ( timeout, state, filter_name, option_name, index_line_filter ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnAutoRefresh", "" );
        
        setTimeout( function () {
            var _option = self.DOM.getOptionFilter( filter_name, option_name, index_line_filter );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _option, "tag information for <span class='shinken-data-user'>" + filter_name + "</span>" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _option, "tag information for <span class='shinken-data-user'>" + filter_name + "</span>" );
                    break;
            }
        }, timeout );
        
        return _to_return;
    };
    self.TEST.columnHeaderLabel                       = function ( timeout, column_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.columnHeaderLabel", label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.columnHeaderLabel( column_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.columnExist                       = function ( timeout, column_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.columnExist" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.___isExisting( self.DOM.columnHeader( column_name ) );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.columnNotExist                       = function ( timeout, column_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.columnExist" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__doesntExist( self.DOM.columnHeader( column_name ) );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.headerManagerSubMenuListColumnLabel     = function ( timeout, column_name, label ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.headerManagerSubMenuListColumnLabel", label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.headerManagerSubMenuListColumn( column_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.headerManagerSubMenuListColumnIsVisible = function ( timeout, column_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.headerManagerSubMenuListColumnIsVisible" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( self.DOM.headerManagerSubMenuListColumn( column_name ), "header-is-visible" );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isElementInList                         = function ( timeout, element_uuid, expected ) {
        var _to_return = 300;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.isElementInList" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( expected ) {
                case true :
                    DOM.Service.isVisible( TI.ANGULAR.DETAIL.DOM.check( element_uuid ) );
                    break;
                case false :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, TI.ANGULAR.DETAIL.DOM.check( element_uuid ) );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.isTextInCell                            = function ( timeout, element_uuid, column_name, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.getCell( element_uuid, column_name ), text_expected, "content in cell" );
        }, timeout );
        
        return 200;
    };
    self.TEST.isIconInCell                            = function ( timeout, element_uuid, column_name, icon_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__containsStyle( self.DOM.getCellIcon( element_uuid, column_name ), "backgroundImage", icon_expected, "icon in cell : " + element_uuid );
        }, timeout );
        
        return 200;
    };
    self.TEST.isIconInCells                           = function ( timeout, element_uuid, column_name, icon_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__containsStyleInDomListAtLeastOneTime( self.DOM.getCellIcons( element_uuid, column_name ), "backgroundImage", icon_expected, "icon in cells : " + element_uuid );
        }, timeout );
        
        return 1000;
    };
    self.TEST.nbIconsInCell                           = function ( timeout, element_uuid, column_name, number_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( self.DOM.getCellIcons( element_uuid, column_name ).length, number_expected );
        }, timeout );
        
        return 200;
    };
    self.TEST.nblinesIs                               = function ( timeout, nb_lines ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( self.DOM.getLines().length, nb_lines );
        }, timeout );
        
        return 200;
    };
    
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnHeaderManager            = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnHeaderManager", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerManagerButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnAutoRefresh              = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnAutoRefresh", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonAutoRefresh() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnRefreshManually          = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnRefreshManually", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonRefreshManual() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnExportCSV                = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnExportCSV", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.buttonExportCSV() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnSave                     = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.saveList", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, self.DOM.exportSaveButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnApply                    = function ( timeout ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "clickOnApply", "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.applyButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.setName                         = function ( timeout, name ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.setName", "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( timeout, self.DOM.inputName(), name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setFilterInInput                = function ( timeout, header_name, filter_value ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setFilter", "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.filterInput( header_name ), filter_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setFilterOption                 = function ( timeout, header_name, filter_value ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "setFilterOption", "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 100, self.DOM.filterListOptions( 'maintenance_period' ) );
            self.DOM.filterList( 'maintenance_period' ).forEach( ( option ) => {
                if ( option.querySelector( ".labelOptionFilter" ).innerText === filter_value ) {
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 100, option );
                    self.ACTION.clickOnApply( 100 );
                }
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.selectLine__byUUID              = function ( timeout, uuid ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "selectLine__byUUID", uuid );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            TI.ANGULAR.ACTION.ngClick( 0, self.DOM.getCell__inLine( uuid, "selectHeader" ), "clickOnTableData" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.unselectLine__byUUID            = function ( timeout, uuid ) {
        return self.ACTION.selectLine__byUUID( timeout, uuid );
    };
    self.ACTION.doMassAction__addAcknowledge    = function ( timeout ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "doMassAction__addAcknowledge" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            TI.ANGULAR.ACTION.ngClick( 0, self.DOM.buttonMassAction( "acknowledge" ), "clickOnActionButton", "acknowledge" );
            setTimeout( function () {
                SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.formAddAcknowledgeInput(), "test_auto" );
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 800, self.DOM.formAddAcknowledgeSubmit() );
            }, 500 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.doMassAction__removeAcknowledge = function ( timeout ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "doMassAction__removeAcknowledge" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            TI.ANGULAR.ACTION.ngClick( 0, self.DOM.buttonMassAction( "remove_acknowledge" ), "clickOnActionButton", "remove_acknowledge" );
            setTimeout( function () {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 800, self.DOM.formAddAcknowledgeSubmit() );
            }, 500 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( TI.ANGULAR.LIST_ALL || {} );
