"use strict";
TI.ANGULAR.SHARES = (function ( self ) {
    self.DOM                        = {};
    self.TEST                       = {};
    self.ACTION                     = {};
    self.CONST                      = {};
    let INTERNAL                    = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.getPrivateFavoriteList = function () {
        return self.DOM.getIframe().querySelector( ".share-tree[data-shareset='personal']" );
    };
    self.DOM.getGroupFavoriteList   = function () {
        return self.DOM.getIframe().querySelector( ".panel-group .group" );
    };
    self.DOM.getGlobalFavoriteList  = function () {
        return self.DOM.getIframe().querySelector( ".share-tree[data-shareset='global']" );
    };
    self.DOM.favoriteFromSection    = function ( section_name, share_uuid ) {
        const section = self.DOM.getFavoriteList( section_name );
        return section.querySelector( "[data-share-uuid='" + share_uuid + "']" );
    };
    self.DOM.getFavoriteList        = function ( favorite_space_name ) {
        switch ( favorite_space_name ) {
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE:
                return self.DOM.getGlobalFavoriteList();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS:
                return self.DOM.getGroupFavoriteList();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE:
                return self.DOM.getPrivateFavoriteList();
        }
    };
    
    //********************************************  INTERNAL **************************************************//
    //INTERNAL.stopPropagation = function () {
    //    return function () {
    //    };
    //};
    
    //********************************************  TEST   **************************************************//
    self.TEST.referenceState            = function ( timeout, section_name, share_uuid, reference_state ) {
        setTimeout( function () {
            let _dom = self.DOM.favoriteFromSection( section_name, share_uuid );
            switch ( reference_state ) {
                case TI.ANGULAR.SHARES.CONST.REFERENCE.STATUS.NONE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".reference-share .glyphicon-link" ), "référence icon est visible" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".reference-share .reference-locked" ), "référence lock icon est visible" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".show-if-no-right-update" ), "lock icon n'est pas visible" );
                    break;
                case TI.ANGULAR.SHARES.CONST.REFERENCE.STATUS.OWNED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".reference-share .glyphicon-link" ), "référence icon n'est pas visible" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".reference-share .reference-locked" ), "référence icon est visible" );
                    break;
                case TI.ANGULAR.SHARES.CONST.REFERENCE.STATUS.LOCKED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".reference-share .glyphicon-link" ), "référence icon n'est pas visible" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".reference-share .reference-locked" ), "référence icon n'est pas visible" );
                    break;
            }
        }, timeout );
    };
    self.TEST.validateNumbersOfFavorite = function ( timeout, expected_number_of_favorites_by_section ) {
        var _to_return = 1500;
        const sections = [SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE, SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS, SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE];
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validateNumbersOfFavorite' );
        setTimeout( function () {
            TI.ANGULAR.SHARES.CONST.TYPE.forEach( ( section, i ) => {
                let _dom = self.DOM.getFavoriteList( section );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
                SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validateNumbersOfFavorite( timeout, _dom.querySelectorAll(".share-element-container"), expected_number_of_favorites_by_section[ i ] );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
            } );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    
    return self;
})( TI.ANGULAR.SHARES || {} );

TI.ANGULAR.SHARES.CONST = {
    STATE    : {
        DISABLE  : "disable",
        RUNNING  : "running",
        HIDDEN   : "hidden",
        VISIBLE  : "visible",
        INHERITED: "inherited"
    },
    REFERENCE: {
        STATUS: {
            NONE  : "0",
            OWNED : "1",
            LOCKED: "2"
        }
    },
    TYPE     : [
        "global",
        "group",
        "personal"
    ]
};