//__lib__ lib_common
"use strict";
COMPONENT.FinderObjectAbstract           = function () {
    this.__class_name__ = 'COMPONENT.FinderObject';
    this.init();
};
COMPONENT.FinderObjectAbstract.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER   **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "apply_filter_check_in_page_host":
                if ( param === undefined ) {
                    this.input_search.setValueFromInput();
                }
                else {
                    this.input_search.setValueFromJs( param );
                }
                this.input_search.askComputeAfterChange( null, this.parent_object );
                break;
            case "compute_phase_depending_input_value":
                this.setPhase( this.input_search.getValue() ? SHINKEN.OBJECT.CONST.PHASE.RUNNING : SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "input-clean-button":
                this.input_search.setValueFromJs( "" );
                break;
            case "toggle_search_activity":
                this.togglePhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "focus-on-filtered-check":
                this.setPhase( param ? SHINKEN.OBJECT.CONST.PHASE.STOPPING : SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    setParentObject: function ( to_set ) {
        this.parent_object = to_set;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.FinderObjectAbstract, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.FinderObjectAbstract, SHINKEN.OBJECT.ShinkenObjectHtml );


COMPONENT.FinderObjectAbstractFromHtml           = function ( dom_element, parent, dom_element_phase ) {
    this.__class_name__ = 'COMPONENT.FinderObject';
    this.init( dom_element, parent, dom_element_phase );
};
COMPONENT.FinderObjectAbstractFromHtml.prototype = {
    init: function ( dom_element, parent, dom_element_phase ) {
        this.initPhase();
        this.setPhaseDomElement( dom_element_phase || dom_element, "finderObject" );
        this.setDomElement( dom_element );
        this.input_search = new COMPONENT.Input( this.getDomElement().querySelector( ".shinken-input" ) );
        this.input_search.setValueFromJs( "" );
        this.setParentObject( parent );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.FinderObjectAbstractFromHtml, COMPONENT.FinderObjectAbstract );

