"use strict";

COMPONENT.OutputRule           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.OutputRule.prototype = {
    initSpecific            : function ( dom_element ) {
        this.inputs[ 'shinken-input-container-cell' ] = 0;
        this.selectors[ 'shinken-matching' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'shinken-final' ]             = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValueFromUser        : function ( _data ) {
        var _size = _data.length;
        switch ( _size ) {
            case 1:
                this.setMatchingValueFromUser( _data[ 0 ] );
                break;
            case 2:
                this.setMatchingValueFromUser( _data[ 0 ] );
                this.setStatutFinal( _data[ 1 ] );
                break;
        }
    },
    setRegexpInput          : function ( to_set ) {
        this.inputs[ 'shinken-input-container-cell' ].setValueFromJs(to_set);
    },
    setStatutMatching       : function ( to_set ) {
        if ( this.selectors[ 'shinken-matching' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'shinken-matching' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'shinken-matching' ].computeTitle();
        }
    },
    setStatutFinal          : function ( to_set ) {
        if ( this.selectors[ 'shinken-final' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'shinken-final' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'shinken-final' ].computeTitle();
        }
    },
    getValue                : function () {
        var _to_return = this.selectors[ 'shinken-matching' ].getValue();
        if ( this.inputs[ 'shinken-input-container-cell' ].getValue() ) {
            _to_return += "/";
            _to_return += this.inputs[ 'shinken-input-container-cell' ].getValue();
            _to_return += "/";
        }
        _to_return += this.separator_key_value_saved + this.selectors[ 'shinken-final' ].getValue();
        return _to_return;
    },
    setMatchingValueFromUser: function ( data ) {
        var _indexes = SHINKEN.TOOLS.STRING.getAllIndexOf( data, '/' );
        var _size    = _indexes.length;
        
        if ( !_size ) {
            this.setStatutMatching( data );
            return;
        }
        this.setStatutMatching( data.substring( 0, _indexes[ 0 ] ).trim() );
        var _regex_value;
        switch ( _size ) {
            case 1:
                _regex_value = data.substring( _indexes[ 0 ] + 1 );
                break;
            case 2:
                _regex_value = data.substring( _indexes[ 0 ] + 1, _indexes[ 1 ] );
                break;
            default:
                _regex_value = data.substring( _indexes[ 0 ], _indexes[ _size - 1 ] );
                break;
        }
        this.setRegexpInput( _regex_value );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue             : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.getValue());
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.OutputRule, 'COMPONENT.OutputRule' );