"use strict";

COMPONENT.UrlLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.UrlLine.prototype = {
    initSpecific    : function ( dom_element ) {
        this.inputs[ 'shinken-name-urlmulti' ] = 0;
        this.inputs[ 'shinken-url-urlmulti' ]  = 1;
        this.selectors[ 'icon-url' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'popupping' ]          = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValueFromUser: function ( _data ) {
        var _size = _data.length;
        switch ( _size ) {
            case 1:
                this.setName( _data[ 0 ] );
                this.setUrl( _data[ 0 ] );
                break;
            case 2:
                this.setName( _data[ 0 ] );
                this.setUrl( _data[ 1 ] );
                break;
            case 4:
                var _name = _data[ 0 ] ? _data[ 0 ] : _data[ 1 ];
                this.setName( _name );
                this.setUrl( _data[ 1 ] );
                this.setIcon( _data[ 2 ].trim() );
                this.setDisplayType( _data[ 3 ].trim() );
                break;
            default:
                return;
        }
    },
    setName         : function ( to_set ) {
        this.inputs[ 'shinken-name-urlmulti' ].setValueFromJs(to_set);
    },
    setUrl          : function ( to_set ) {
        this.inputs[ 'shinken-url-urlmulti' ].setValueFromJs(to_set);
    },
    setIcon         : function ( to_set ) {
        if ( this.selectors[ 'icon-url' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'icon-url' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'icon-url' ].computeTitle();
        }
    },
    setDisplayType  : function ( to_set ) {
        if ( this.selectors[ 'popupping' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'popupping' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'popupping' ].computeTitle();
        }
    },
    getValue        : function ( is_display_cfg ) {
        var _url = this.inputs[ 'shinken-url-urlmulti' ].getValue();
        if ( !is_display_cfg && !_url ) {
            return '';
        }
        var _to_return = '';
        _to_return += this.inputs[ 'shinken-name-urlmulti' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += _url;
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'icon-url' ].getValue();
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'popupping' ].getValue();
        return _to_return;
    },
    addInput        : function ( _current_key ) {
        this.inputs[ _current_key ] = new COMPONENT.Input( this.dom_element.querySelector( "." + _current_key + " .shinken-input-table" ), this, false, _current_key );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue     : function () {
        return SHINKEN.TOOLS.STRING.cleanXss(this.getValue( true ));
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.UrlLine, 'COMPONENT.UrlLine' );