//__lib__ lib_common_V02_01
"use strict";
CONTROLLER.Form = (function ( self ) {
    self.controller_name = CONTROLLER.CONST.FORM_CONTROLLER.NAME;
    //********************************************  EVENT LISTENER  **************************************************//
    self.onClick         = function ( event, event_name ) {
        event.stopPropagation();
        const _dom_target_property = DOM.Service.findParentElementWithClass( event.target, "shinken-element-property-line-V3", 50 );
        if ( _dom_target_property ) {
            self.current_form.hidePopup( { [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: _dom_target_property.dataset.name } );
        }
        else {
            self.current_form.hidePopup();
        }
    };
    self.doActionAfter   = function ( event_name, params ) {
        if ( self.current_form ) {
            self.current_form.doActionAfter( event_name, params );
        }
    };
    self.mouseLeave      = function ( event ) {
    };
    self.mouseEnter      = function ( event ) {
    };
    //********************************************  INIT  **************************************************//
    self.init            = function () {
    };
    self.initPhaseObject = function () {
        self.phase_current_form = new SHINKEN.OBJECT.Phase();
        self.phase_current_form.setDomElement( document.querySelector( ".shinken-weather-form-container" ), "current_form" );
    };
    //********************************************  GETTER SETTER  **************************************************//
    self.setCurrentForm  = function ( to_set ) {
        if ( !self.phase_current_form ) {
            self.initPhaseObject();
        }
        self.phase_current_form.setPhase( to_set.getName() );
        self.current_form = to_set;
    };
    //********************************************  VALIDATION  **************************************************//
    self.isValid         = function ( param ) {
        this.current_form.computeValidation__20241125( param );
        return this.current_form.isValid();
    };
    self.getDataToSave   = function () {
        return this.current_form.getDataToSave();
    };
    return self;
})( CONTROLLER.Form || {} );
