//__lib__ lib_common_V02_01

"use strict";

SHINKEN.OBJECT.FormSetFromData           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.FormSetFromData.prototype = {
    init: SHINKEN.OBJECT.FormSet.prototype.init,
    //********************************************  GETTER SETTER  *****************************************************//
    getController__20240821: function ( name ) {
        return CONTROLLER.Form;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml        : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml  : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-form-container" } ) );
        if ( this.getController__20240821() ) {
            DOM.Service.addControllerAnchor( this.getDomElement(), this.getController__20240821().controller_name );
        }
        this.computeHtmlTitle();
        
        var _div = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-content" } ) );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), _div );
        }
        this.computeHtmlFooter();
        this.computeHtmlActions();
        this.computeHtmlExtra();
        
    },
    computeHtmlActions : function () {
        let _div_action         = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-action shinken-parent-event-listener", "data-controller": CONTROLLER.CONST.FORM_CONTROLLER.NAME } ) );
        let _div_action_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-table-form-container" } ), _div_action );
        let _div                = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-width-100 shinken-table-form-content shinken-layout-justify-between" } ), _div_action_content );
        
        let _td_1            = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-form-action-cell" } ), _div );
        let _button_validate = new COMPONENT.ButtonFromData_V3( "validated_form", _( "form.action_button.submit", [DICTIONARY_COMMON_UI] ) );
        _button_validate.addClass( "shinken-validate-form" );
        _button_validate.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        _button_validate.computeHtml();
        DOM.Service.addElementTo( _button_validate.getDomElement(), _td_1 );
        
        let _td_2          = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-form-action-cell" } ), _div );
        let _button_cancel = new COMPONENT.ButtonFromData_V3( "cancel_form", _( "form.action_button.cancel", [DICTIONARY_COMMON_UI] ) );
        _button_cancel.addClass( "shinken-cancel-form" );
        _button_cancel.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        _button_cancel.computeHtml();
        DOM.Service.addElementTo( _button_cancel.getDomElement(), _td_2 );
    },
    computeHtmlFooter  : function () {
        this.computeFooterContent();
        var _to_add = this.getFooterContent();
        if ( _to_add ) {
            _to_add.addClass( "shinken-footer-form" );
            _to_add.computeHtml();
            this.addDomElement( _to_add.getDomElement() );
        }
    },
    computeSpecificHtml: function () {
    },
    computeHtmlTitle   : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSetFromData, SHINKEN.OBJECT.FormSet );
