//__lib__ lib_common
"use strict";

SHINKEN_LIST.LineCellFromData           = function ( name, value ) {
    this.name  = name;
    this.value = value;
    this.init();
};
SHINKEN_LIST.LineCellFromData.prototype = {
    init: SHINKEN_LIST.LineCell.prototype.init,
    //********************************************  HTML  *****************************************************//
    computeFilterValue          : function () {
        this.data_filter_html = "";
    },
    computeContentHtml__20241107: function () {
        this.computeLabel();
        this.computeFilterValue();
        this.dom_element_content = DOM.Service.createElement( "div", {
            class        : "shinken-list-cell-content",
            "data-filter": this.name
        }, this.label );
    },
    computeHtml                 : function () {
        this.addClass( "shinken-list-cell" );
        this.computeContentHtml__20241107();
        this.setDomElement( DOM.Service.createElement( "td", { class: this.getClass(), "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
        this.doActionAfter( "compute_html_done" );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellFromData, SHINKEN_LIST.LineCell );

