//__lib__ lib_common
"use strict";

SHINKEN_LIST.SetFromData           = function ( name ) {
    this.init( name );
};
SHINKEN_LIST.SetFromData.prototype = {
    init            : SHINKEN_LIST.Set.prototype.init,
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesFromData();
    },
    computeLines    : function ( data ) {
        var lines = this.initLinesObjects();
        lines.computeContentWithData( data, this.headers );
        this.setLines( lines );
    },
    addLineWithData : function ( data, index ) {
        this.lines.addLineWithData( data, this.headers, index );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml        : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml  : function () {
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead = DOM.Service.createElement( "thead" );
        
        this.headers.computeHtml();
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead );
        
        if ( this.filters ) {
            this.filters.computeHtml();
            DOM.Service.addElementTo( this.filters.getDomElement(), _thead );
        }
        
        DOM.Service.addElementTo( _thead, _table );
        if ( this.lines ) {
            DOM.Service.addElementTo( this.lines.getDomElement(), _table );
        }
        this.addDomElement( _table );
        this.computeHtmlExtra();
        this.doActionAfter( "compute_html_done" );
    },
    computeLinesHtml   : function () {
        if ( this.lines ) {
            this.lines.computeHtml();
        }
    },
    computeSpecificHtml: function () {
    
    },
    computeHtmlExtra   : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromData, SHINKEN_LIST.Set );

SHINKEN_LIST.SetFromDataWithFixHeaderFilter           = function ( name ) {
    this.init( name );
};
SHINKEN_LIST.SetFromDataWithFixHeaderFilter.prototype = {
    init: SHINKEN_LIST.SetFromData.prototype.init,
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.headers.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container shinken-list-with-fix-header" } ) );
        if ( this.filters ) {
            this.filters.computeHtml();
            this.getDomElement().classList.add( "shinken-list-has-filters" );
        }
        //*******  First Table Header And Filter  *******//
        var _container_header_filter   = DOM.Service.createElement( "div", {
            class: "shinken-list-container-fix-header-filter"
        } );
        var _table_header_filter       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_header_filter = DOM.Service.createElement( "thead" );
        
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead_table_header_filter );
        if ( this.filters ) {
            DOM.Service.addElementTo( this.filters.getDomElement(), _thead_table_header_filter );
        }
        DOM.Service.addElementTo( _thead_table_header_filter, _table_header_filter );
        DOM.Service.addElementTo( _table_header_filter, _container_header_filter );
        this.addDomElement( _container_header_filter );
        
        //*******  Second Table Header (Height 0px) And List  *******//
        var _container_header_list = DOM.Service.createElement( "div", { class: "shinken-list-container-with-scroll" } );
        var _table_list            = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table" } );
        DOM.Service.addElementTo( this.lines.dom_element_text_no_elements, _table_list );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table_list );
        
        
        DOM.Service.addElementTo( _table_list, _container_header_list );
        this.addDomElement( _container_header_list );
        
        this.computeSpecificHtml();
        this.doActionAfter( "compute_html_done" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithFixHeaderFilter, SHINKEN_LIST.SetFromData );
