//__lib__ lib_common
//priority 100

"use strict";
SHINKEN_LIST.Lines           = function () {
};
SHINKEN_LIST.Lines.prototype = {
    init             : function () {
        this.initCommon();
    },
    initCommon       : function () {
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.LINES_UUID, "main_lines_list" );
        this.initCounterCommon();
        this.initContents();
        this.initPhase();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
    },
    addSpecific      : function ( to_add ) {
        this.add( to_add );
        to_add.setCountersParent( this );
        to_add.addParamsForEvents( this.getParamForEvents() );
    },
    insertAtIndex    : function ( to_add, index ) {
        SHINKEN.TOOLS.ARRAY.insert( this.contents, to_add, index );
        to_add.setCountersParent( this );
        this.computeMapping();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector      : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnSelector( event );
        }
    },
    clickOnInput         : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnInput( event );
        }
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _line = this.getContentByDomElement( dom_element );
        if ( _line ) {
            _line.askComputeAfterChange( dom_element, parent );
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnItemSelector( event );
        }
    },
    doActionAfter        : function ( event_name, param, param_2, param_3 ) {
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    doActionAfterCommon  : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "on-key-down-specific":
                this.getContentByEvent( param ).doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "click_on_selector":
            case "click_on_item_selector":
                this.getContentByUUID( param ).doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "click_on_button":
                switch ( param ) {
                    case "show-history":
                    case "delete-view-forever":
                    case "delete-view":
                    case "restore-deleting-view":
                        this.getContentByUUID( param_2 ).doActionAfter( event_name, param, param_2, param_3 );
                        break;
                }
                break;
            case "click_on_button_V3":
                param[ SHINKEN_LIST.CONST.PARAM.LINES_OBJECT ] = this;
                this.doActionAfterContentChildren( event_name, param );
                break;
            case "onchange_in_input_V3":
                this.getContentByUUID( param[ SHINKEN_LIST.CONST.PARAM.LINE_UUID ] ).doActionAfter( event_name, param );
                break;
            case "cancel_user_orders":
                param[ SHINKEN_LIST.CONST.PARAM.LINES_OBJECT ] = this;
                this.doActionAfterContentChildren( event_name, param );
                break;
        }
    },
    //********************************************  GETTER SETTER *****************************************************//
    addTextForNoElement          : function ( text_no_element, text_no_element_after_filter ) {
        this.text_no_element              = text_no_element;
        this.text_no_element_after_filter = text_no_element_after_filter;
    },
    getContentByCellValue        : function ( key_cell, value_cell ) {
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].getContentByUUID( key_cell ).getValue() === value_cell ) {
                return this.contents[ i ];
            }
        }
        return null;
    },
    getContentByDomElement       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, 'shinken-list-line', 60 );
        if ( !_parent_dom_element ) {
            return null;
        }
        return this.getContentByUUID( _parent_dom_element.dataset.uuid );
    },
    getContentByEvent            : function ( event ) {
        if ( !event ) {
            return;
        }
        return this.getContentByDomElement( event.target );
    },
    updateAfterActionsDone       : function ( data ) {
        this.setMessages();
        var _current_action;
        var to_return = false;
        for ( var k = 0, _size_k = data[ "results" ].length; k < _size_k; k++ ) {
            _current_action = data[ "results" ][ k ];
            if ( _current_action[ "action_done" ] ) {
                this.updateAfterActionDoneOK( _current_action, data );
                to_return = true;
            }
            else {
                return this.updateAfterActionDoneNOK( _current_action, data );
            }
        }
        return to_return;
    },
    updateAfterActionDoneOK      : function ( action, data ) {
        var _current = this.getContentByUUID( data[ "uuid" ] );
        switch ( action.key ) {
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE:
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE_FORCED:
            case SHINKEN.UI.VIEW.ACTIONS.CLONE_VIEW:
                
                this.removeContent( data[ "uuid" ] );
                CONTROLLER.UiViewWeatherManager.doActionAfter( "ask-reload-data-for-current-panel" );
                break;
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER:
                _current.updateAfterActionDoneOK( action );
                this.addMessages( _current.getMessages() );
                break;
            case SHINKEN.UI.VIEW.ACTIONS.RESTORED:
                CONTROLLER.UiViewWeatherManager.doActionAfter( "ask-reload-data-for-current-panel" );
                break;
            default:
                console.warn( "[Lines - updateAfterActionDoneOK]", "[NONE]" );
        }
    },
    updateAfterActionDoneOK_lvl_1: function ( action, data ) {
        return false;
    },
    updateAfterActionDoneNOK     : function ( action, data ) {
        var _current = this.getContentByUUID( data[ "uuid" ] );
        if ( action.critical[ 0 ] === SHINKEN.UI.VIEW.ACTIONS.ERRORS.CANNOT_PERFORM_ACTION ) {
            this.addMessage( COMPONENT.CONST.STATUS.ERROR, _( "views.manager.common.backend_errors.cannot_perform_action" ) );
            return;
        }
        switch ( action.key ) {
            case SHINKEN.UI.VIEW.ACTIONS.CHANGE_OWNER:
                _current.updateAfterActionDoneNOK( action );
                if ( _current.isPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED ) ) {
                    this.removeContent( data[ "uuid" ] );
                }
                this.addMessages( _current.getMessages() );
                break;
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE:
            case SHINKEN.UI.VIEW.ACTIONS.REMOVE_FORCED:
                _current.updateAfterActionDoneNOK( action );
                this.addMessages( _current.getMessages() );
                break;
            //case SHINKEN.UI.VIEW.ACTIONS.CLONE_VIEW:
            //    this.addMessages( _current.getMessages() );
            //    break;
            default:
                console.warn( "[Lines - updateAfterActionDoneNOK]", "[NONE]" );
        }
    },
    getChildConstructor          : function () {
        return new SHINKEN_LIST.Line();
    },
    //********************************************  SELECTION  *****************************************************//
    setSelectAllData       : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected          : function () {
        return this.getSelected().length;
    },
    getSelected            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getSizeNotFiltered     : function () {
        return this.getNotFiltered().length;
    },
    setAllLinesDataSet     : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected: function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter   : function ( filters, params_filter_by_line ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters, params_filter_by_line );
        }
    },
    hideAllLines  : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getNotFiltered: function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isFiltered() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    //********************************************  SORTING  *****************************************************//
    applySorting     : function ( active_headers ) {
        if ( active_headers.length ) {
            var _current_is_increasing;
            var _value_1;
            var _value_2;
            for ( var i = active_headers.length - 1; i >= 0; i-- ) {
                _current_is_increasing = active_headers[ i ].getSortingStatus() === SHINKEN.OBJECT.SORTING.STATUS.INCREASING;
                this.contents.sort( function ( a, b ) {
                    _value_1 = _current_is_increasing ? b : a;
                    _value_2 = _current_is_increasing ? a : b;
                    _value_1 = _value_1.getContentByUUID( active_headers[ i ].name ).getSortingValue();
                    _value_2 = _value_2.getContentByUUID( active_headers[ i ].name ).getSortingValue();
                    if ( _value_1 === _value_2 ) {
                        return 0;
                    }
                    if ( _value_1 > _value_2 ) {
                        return -1;
                    }
                    return 1;
                } );
            }
        }
        else {
            this.contents.sort( function ( a, b ) {
                return a.index_origin - b.index_origin;
            } );
        }
        this.displayDomByOrder();
        this.computeMapping();
    },
    displayDomByOrder: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            DOM.Service.addElementWithIndex( this.contents[ i ].getDomElement(), this.getDomElement(), i );
        }
    },
    //********************************************  SAVE  *****************************************************//
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered ) {
                continue;
            }
            _to_return.push( _current.getDataToExport( headers ) );
        }
        return _to_return;
    },
    //********************************************  HTML *****************************************************//
    addLoadingFrame: function ( dom_loading ) {
        dom_loading = dom_loading || SHINKEN.TOOLS.LOADING_FRAME.getDomElement();
        if ( this.dom_element ) {
            DOM.Service.addElementToAfterEmpty( dom_loading, this.dom_element );
        }
        else {
            this.dom_element_loading = dom_loading;
        }
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings   : function ( list_lines ) {
        var _current;
        for ( var i = 0, _size_i = list_lines.contents.length; i < _size_i; i++ ) {
            _current = this.getSiblingElement( list_lines.contents[ i ] );
            if ( _current ) {
                _current.applySiblingSettings( list_lines.contents[ i ] );
            }
        }
    },
    getSiblingElement      : function ( list_line ) {
        for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
            if ( this.contents[ j ].isSibling( list_line ) ) {
                return this.contents[ j ];
            }
        }
        return null;
    },
    getObjectsType         : function () {
        return "shinken-list-line";
    },
    changeOriginalIndexFrom: function ( original_index_to_start, delta ) {
        let current;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            current = this.getContent( i );
            if ( current.getIndexOriginal() >= original_index_to_start ) {
                current.setIndexOriginal( current.getIndexOriginal() + delta );
            }
        }
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        switch ( this.getCurrentPhase() ) {
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING:
                this.addLoadingFrame();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Lines, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Lines, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Lines, SHINKEN.OBJECT.PhaseInterface );
