//__lib__ lib_common
"use strict";

MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow                      : function ( name, is_menu, has_properties ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = has_properties ? new WINDOW.ElementWithProperties( name, _dom_element, is_menu ) : new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        return _to_return;
    },
    createParentWindow                : function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow                        : function ( name, is_menu, parent_id, has_properties ) {
        if ( !name ) {
            return;
        }
        if ( parent_id ) {
            var _parent = this.findParentWindow( parent_id );
            if ( _parent ) {
                return _parent.getElementByName( name );
            }
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu, has_properties );
        }
        return _to_return;
    },
    findParentWindow                  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow                         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow                   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow                         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName: function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[ 0 ] ].clickOnWindow( name );
    },
    getParentWindow                   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset                             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();