//__lib__ lib_common
"use strict";

SHINKEN.CARTO.ShinkenCarto = function ( data ) {
    //this.name;
    //this.url;
    //this.is_valid
    this.init( data );
};

SHINKEN.CARTO.ShinkenCarto.prototype = {
    init           : function ( data ) {
        if ( data ) {
            this.updateData( data );
            this.setIsValid();
        }
    },
    updateData     : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData        : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.CARTO.CONST.NAME:
            case SHINKEN.CARTO.CONST.URL:
                this[ key ] = value;
                break;
        }
    },
    setIsValid     : function () {
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this[ SHINKEN.CARTO.CONST.URL ], SHINKEN.NETWORK.ADRESSES.LOCALHOST )
             || SHINKEN.TOOLS.STRING.containsIgnoreCase( this[ SHINKEN.CARTO.CONST.URL ], SHINKEN.NETWORK.ADRESSES._127_0_0_1 )
        ) {
            this[ SHINKEN.CARTO.CONST.IS_VALID ] = false;
        }
        else {
            this[ SHINKEN.CARTO.CONST.IS_VALID ] = true;
        }
    },
    hasLocalHostUrl: function () {
        return SHINKEN.TOOLS.STRING.startsWith( this.url, "http://localhost" );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
            var _css_selector = this.hasLocalHostUrl() ? "#shinken-architecture-template .shinken-template-architecture-cartos-start-with-localhost" : "#shinken-architecture-template .shinken-template-architecture-cartos";
            var _template     = document.querySelector( _css_selector ).outerHTML;
            _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_cartos_name_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.name ) );
            _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_cartos_url_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.url ) );
            var _temp         = DOM.Service.createElement( "div", {}, _template );
            this.dom_element  = _temp.firstChild;
        
    }
};