//__lib__ lib_common
"use strict";

SHINKEN.TOOLS.ClockComponent           = function () {
    this.init();
};
SHINKEN.TOOLS.ClockComponent.prototype = {
    
    //********************************************  INIT  *****************************************************//
    init: function () {
        this.color = '#5C5C5C';
        this.name  = SHINKEN.OBJECT.Refresh.CONST.CLOCK;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setColor: function ( color ) {
        this.color = color;
    },
    getName : function () {
        return this.name;
    },
    getDomElement () {
        return this.dom_element;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml             : function () {
        this.dom_element                   = DOM.Service.createElement( "div", { class: "shinken-container-clock" } );
        this.dom_element_container_clock_2 = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-container-clock-2 shinken-centered-icon-container" } ), this.dom_element );
        this.dom_element_container_clock_2.innerHTML = "<svg width='100%' height='100%' class='shinken-clock shinken-clock-refresh' viewbox='0 0 121 121'>" +
                                                       "<circle class='shinken-clock-circle' cx='60' cy='60' r='59' stroke='#5C5C5C' stroke-width='2' fill='none' />" +
                                                       "<path id='id-shinken-clock-path' fill='#5C5C5C' transform='translate(60,60)'></path>" +
                                                       "</svg>";
        this.dom_element_path                        = this.dom_element_container_clock_2.querySelector( "#id-shinken-clock-path" );
    },
    set_refreshing_content  : function () {
        DOM.Service.addClasses( this.dom_element_container_clock_2, 'shinken-clock-refreshing' );
    },
    unset_refreshing_content: function () {
        DOM.Service.removeClasses( this.dom_element_container_clock_2, 'shinken-clock-refreshing' );
    },
    updateHtml              : function ( parent_object ) {
        this.dom_element_path.setAttribute( "d", this.computePathAttribute( parent_object.percent_computed ) );
    },
    //********************************************  COMPUTE  *****************************************************//
    computePathAttribute: function ( percent ) {
        percent   = percent || 0;
        var angle = (360 * percent / 100) % 360;
        
        var rad = (angle * Math.PI) / 180;
        var x   = Math.sin( rad ) * 60;
        var y   = Math.cos( rad ) * -60;
        var mid = angle > 180 ? 1 : 0;
        return "M 0 0 v -60 A 60 60 1 " + mid + " 1 " + x + " " + y + " z";
    },
    //********************************************  OTHERS  *****************************************************//
    //********************************************  EVENT REFRESH  *****************************************************//
    eventIsRunning   : function ( parent_object ) {
        this.unset_refreshing_content();
        this.updateCountdown( parent_object );
    },
    eventIsRefreshing: function ( parent_object ) {
        this.set_refreshing_content();
    },
    updateCountdown  : function ( parent_object ) {
        this.updateHtml( parent_object );
    },
    eventIsStopping  : function ( parent_object ) {
        this.set_refreshing_content();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.ClockComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );
