//__lib__ lib_common
"use strict";

SHINKEN.TOOLS.UpdateAtComponent           = function () {
    this.name       = SHINKEN.OBJECT.Refresh.CONST.UPDATE_AT;
    this.time_label = DOM.Service.createElement( "span", { class: "shinken-time-label" }, "" );
};
SHINKEN.TOOLS.UpdateAtComponent.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    getName           : function () {
        return this.name;
    },
    setLastComputeDate: function ( to_set ) {
        if ( !to_set ) {
            this.time_label.innerHTML = _( 'service_weather.generate_at.generation_in_progress', [DICTIONARY_COMMON_UI] );
        }
        else {
            this.time_label.innerHTML = DATE_TIME.FORMAT.get_time_from_timestamp( to_set );
        }
    },
    getDomElement () {
        return this.dom_element;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-container-update-at shinken-hidden-if-draft-phase" } );
        let div          = DOM.Service.createElement( "div", { class: "shinken-generate-at" }, _( 'info_bar.refresh_component.component_update_at.generate' ) );
        DOM.Service.addElementTo( this.time_label, div );
        DOM.Service.addElementTo( div, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.UpdateAtComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );

