//__lib__ lib_common
"use strict";
SHINKEN.FullStatus                    = function ( raw_full_status ) {
    this.init( raw_full_status );
};
SHINKEN.FullStatus.prototype          = {
    init         : function ( raw_full_status ) {
        this.raw_value = raw_full_status;
        if ( this.isOldFormat() ) {
            return;
        }
        this.status   = new SHINKEN.Status();
        this.contexts = new SHINKEN.OBJECT.ShinkenObjectContainer();
        this.contexts.initContents();
        this.parseStatus();
        this.parseContexts();
    },
    parseStatus  : function () {
        this.status.setCode( this.raw_value % 10, true );
    },
    parseContexts: function () {
        for ( let i = 0, _size_i = SHINKEN.STATUS.CONTEXT_BY_PRIORITY.length; i < _size_i; i++ ) {
            this.parseContext( SHINKEN.STATUS.CONTEXT_BY_PRIORITY[ i ] );
        }
    },
    parseContext : function ( context_object ) {
        if ( (this.raw_value / context_object.FULL_STATUS_RANK) % 10 > 1 ) {
            this.addContext( context_object );
        }
    },
    addContext   : function ( to_set ) {
        let to_add = new SHINKEN.Status();
        to_add.setObject( to_set );
        this.contexts.add( to_add );
    },
    //********************************  GETTER SETTER    ******************************************************************//
    isOldFormat   : function () {
        return this.raw_value === SHINKEN.STATUS.FULL_STATUS.__OLD_FORMAT;
    },
    getStatus     : function () {
        return this.status;
    },
    getMainContext: function () {
        return this.contexts.getContent( 0 );
    },
    getContexts   : function () {
        return this.contexts.getContents();
    },
    hasContext    : function () {
        return this.contexts.getSize();
    }
};