//__lib__ lib_common
"use strict";

SHINKEN.Status = function () {
    //this.code;
    //this.key;
    //this.name;
    //this.path;
    //this.path_extra;
    //this.priority;
    //this.tooltip_label
    //this.label;
};

SHINKEN.Status.prototype = {
    setObject    : function ( object_status ) {
        this.code = object_status[ "CODE" ];
        this.key  = SHINKEN.STATUS.CODE_TO_KEY[ this.code ];
        this.name = object_status[ "NAME" ];
        this.type = object_status[ "TYPE" ];
    },
    setCode      : function ( toSet ) {
        this.code = toSet;
        this.key  = SHINKEN.STATUS.CODE_TO_KEY[ this.code ];
        this.initEnd();
    },
    setKey       : function ( toSet ) {
        this.key  = toSet;
        this.code = SHINKEN.STATUS[ this.key ].CODE;
        this.initEnd();
    },
    initEnd      : function () {
        this.setName();
        this.priority = SHINKEN.STATUS[ this.key ].PRIORITY;
        this.label    = this.name;
        this.buildPath();
    },
    getCode      : function () {
        return this.code;
    },
    getLabel     : function () {
        return this.label;
    },
    getName      : function () {
        return this.name;
    },
    getUUID      : function () {
        return this.getName();
    },
    getPriority  : function () {
        return this.priority;
    },
    is           : function ( type ) {
        return this.isByCode( type.CODE );
    },
    isByCode     : function ( code ) {
        return this.code === code;
    },
    getPath      : function () {
        return this.path;
    },
    setPathExtra : function ( name ) {
        //this.path_extra = SHINKEN.STATUS.PATH.LOCATION_DIR + name + '.svg';
    },
    getClass     : function () {
        var _to_return = this.getName();
        if ( this.is_inherited ) {
            _to_return = 'inherited-' + _to_return;
        }
        return _to_return;
    },
    setName      : function () {
        this.name = SHINKEN.STATUS[ this.key ].NAME;
    },
    equals       : function ( status ) {
        if ( !status ) {
            return false;
        }
        if ( status.code !== this.code ) {
            return false;
        }
        if ( this.path_extra && status.path_extra && this.path_extra !== status.path_extra ) {
            return false;
        }
        return true;
    },
    buildPath    : function () {
        try {
            if ( this.name === SHINKEN.STATUS.NOTHING.NAME ) {
                this.path = '';
            }
            else {
                this.path = '/static/' + __SHINKEN_HTTP_START_TIME__ + '/img/icons/' + this.name + '.svg';
            }
        }
        catch ( e ) {
        
        }
    },
    buildHtml    : function () {
        //var _to_return = DomService.createElement( 'div', {
        //    'style': "width:100%;height:100%;"
        //} );
        //var _status    = DomService.createElement( 'div', {
        //    'style': "background:url(" + this.path + ") no-repeat",
        //    'class': 'element-status-big'
        //} );
        //_to_return.appendChild( _status );
        //if ( this.path_extra ) {
        //    var _status_extra = DomService.createElement( 'div', {
        //        'style': "background:url(" + this.path_extra + ") no-repeat",
        //        'class': 'element-status-small'
        //    } );
        //    _to_return.appendChild( _status_extra );
        //}
        //return _to_return;
    },
    getCodeSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.CODE;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.CODE;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.CODE;
        }
        return this.code;
    },
    getNameSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.NAME;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.NAME;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.NAME;
        }
        return this.name;
    }
};


