//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.ViewBehaviour           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.ViewBehaviour";
    this.init();
};
SHINKEN.OBJECT.ViewBehaviour.prototype = {
    init      : function ( data ) {
        this.initPhase();
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.PHASE:
                this.setPhase( value );
                break;
            case SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE:
                this [ key ] = value;
                break;
            case SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.PHASE_PREVIOUS:
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.ViewBehaviour]", "[IGNORED DATA]", key, value );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    changePhaseAction              : function ( to_set ) {
        this.setPhase( to_set );
        this[SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE] = DATE_TIME.getTimestampNow_format_sec();
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave        : function () {
        var _to_return                                                = {};
        _to_return[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.PHASE ]                = this.getCurrentPhase();
        _to_return[ SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE ]          = this[SHINKEN.OBJECT.VIEW.BEHAVIOUR.PARAM.LAST_UPDATE];
        return _to_return;
    },
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ViewBehaviour, SHINKEN.OBJECT.PhaseInterface );