//__lib__ lib_common_V02_01
"use strict";

var PROPERTY_V2 = PROPERTY_V2 || {};

PROPERTY_V2.VALIDATOR = {
    //********************************************  WITH PARAMETER  **************************************************//
    validWithParameter: function ( property, parameter, extra_forbidden_char, object_message ) {
        let messages = object_message || new SHINKEN.OBJECT.Messages();
        if ( !parameter ) {
            return;
        }
        PROPERTY_V2.VALIDATOR.isMandatory( messages, property, parameter.is_mandatory );
        switch ( parameter.validation_type ) {
            case SHINKEN_VALIDATION.CONST.BOOLEAN._KEY:
                PROPERTY_V2.VALIDATOR.isBoolean( messages, property );
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN:
                PROPERTY_V2.VALIDATOR.isIntegerBetween( messages, property, parameter.validation_value );
                break;
            case SHINKEN_VALIDATION.CONST.STRING.MAX_LENGTH:
                PROPERTY_V2.VALIDATOR.testStringLength( messages, property, parameter.validation_value );
                break;
            case SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY:
                PROPERTY_V2.VALIDATOR.isStringNotEmpty( messages, property );
                break;
            case SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN:
                PROPERTY_V2.VALIDATOR.testForbiddenChar( messages, property, parameter.validation_value );
                break;
            case SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY:
                PROPERTY_V2.VALIDATOR.isColorValid( messages, property );
                break;
            case SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN:
                PROPERTY_V2.VALIDATOR.isListIncludeIn( messages, property, parameter.validation_value );
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE:
                PROPERTY_V2.VALIDATOR.isPositiveInteger( messages, property );
                break;
            case SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE:
                PROPERTY_V2.VALIDATOR.isDefineStringOrIntegerPositive( messages, property, parameter.validation_value );
                break;
            case SHINKEN_VALIDATION.CONST.OTHERS.MAX_LENGTH__DONT_HAVE_FORBIDDEN__EMOJIS__ACCENTS:
                PROPERTY_V2.VALIDATOR.testStringLength( messages, property, parameter.validation_value[ 0 ] );
                PROPERTY_V2.VALIDATOR.testForbiddenChar( messages, property, parameter.validation_value[ 1 ] );
                PROPERTY_V2.VALIDATOR.testForbiddenEmojis( messages, property );
                PROPERTY_V2.VALIDATOR.testForbiddenAccents( messages, property );
                break;
            case SHINKEN_VALIDATION.CONST.OTHERS.NOT_EMPTY__MAX_LENGTH__DONT_HAVE_FORBIDDEN:
                PROPERTY_V2.VALIDATOR.isStringNotEmpty( messages, property );
                PROPERTY_V2.VALIDATOR.testStringLength( messages, property, parameter.validation_value[ 0 ] );
                PROPERTY_V2.VALIDATOR.testForbiddenChar( messages, property, parameter.validation_value[ 1 ] );
                break;
        }
        PROPERTY_V2.VALIDATOR.hasForbiddenCharacter( messages, property, extra_forbidden_char );
        this.sendValidation( property, messages );
    },
    //********************************************  COMMUNICATION WITH FORM  **************************************************//
    sendValidation: function ( property, messages ) {
        CONTROLLER.Form.doActionAfter( "add_message_validation", { [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]: property, [ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ]: messages } );
    },
    //********************************************  RULES VALIDATION  **************************************************//
    isMandatory                    : function ( messages, property, is_mandatory ) {
        if ( is_mandatory && SHINKEN.TOOLS.STRING.isEmpty( property.getValue() ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.mandatory_field', [DICTIONARY_COMMON_UI] ) );
        }
    },
    hasForbiddenCharacter          : function ( messages, property, extra_forbidden_char ) {
        if ( !extra_forbidden_char ) {
            return;
        }
        if ( SHINKEN.TOOLS.STRING.contains( property.getValue(), extra_forbidden_char ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.char_forbidden', [DICTIONARY_COMMON_UI] ), extra_forbidden_char ) );
        }
    },
    testForbiddenChar              : function ( messages, property, forbidden_char ) {
        if ( SHINKEN.TOOLS.STRING.containsAny( property.getValue(), forbidden_char ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.chars_forbidden', [DICTIONARY_COMMON_UI] ), forbidden_char ) );
        }
    },
    testForbiddenEmojis            : function ( messages, property ) {
        if ( property.getValue().match( SHINKEN_VALIDATION.CONST.REGEX.EMOJI ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.emojis_forbidden', [DICTIONARY_COMMON_UI] ) ) );
        }
    },
    testForbiddenAccents           : function ( messages, property ) {
        if ( property.getValue().match( SHINKEN_VALIDATION.CONST.REGEX.ACCENT ) ) {
            messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.accents_forbidden', [DICTIONARY_COMMON_UI] ) ) );
        }
    },
    isBoolean                      : function ( messages, property ) {
        let value = property.getValue();
        if ( ["true", "false", "default"].includes( value ) ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.must_be_a_boolean', [DICTIONARY_COMMON_UI] ) );
    },
    testStringLength               : function ( messages, property, max_length ) {
        let value = property.getValue();
        if ( typeof value === "string" && value.length < max_length ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.max_length', [DICTIONARY_COMMON_UI] ), max_length ) );
    },
    isIntegerBetween               : function ( messages, property, values_possible ) {
        let value      = property.getValue();
        let is_integer = SHINKEN.TOOLS.NUMBER.isInteger( value );
        if ( is_integer && parseInt( value ) >= values_possible[ 0 ] && parseInt( value ) <= values_possible[ 1 ] ) {
            return;
        }
        if ( !is_integer && SHINKEN.TOOLS.ARRAY.contains( values_possible, value ) ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.integer_between', [DICTIONARY_COMMON_UI] ), values_possible[ 0 ], values_possible[ 1 ] ) );
    },
    isStringNotEmpty               : function ( messages, property ) {
        let value = property.getValue();
        if ( typeof value === "string" && !SHINKEN.TOOLS.STRING.isEmpty( value ) ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.string_cant_be_empty', [DICTIONARY_COMMON_UI] ) );
    },
    isColorValid                   : function ( messages, property ) {
        let value = property.getValue();
        if ( value !== "" && !SHINKEN.TOOLS.STRING.containsRegex( value, SHINKEN_VALIDATION.CONST.COLOR.CSS.REGEX ) ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.color_is_invalid', [DICTIONARY_COMMON_UI] ) );
        
    },
    isListIncludeIn                : function ( messages, property, values_possible ) {
        if ( SHINKEN.TOOLS.ARRAY.contains( values_possible, property.getValue() ) ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.not_in_list', [DICTIONARY_COMMON_UI] ) );
    },
    isPositiveInteger              : function ( messages, property ) {
        let value = property.getValue();
        if ( value === property.getDefaultKey() ) {
            return;
        }
        let is_integer = SHINKEN.TOOLS.NUMBER.isInteger( value );
        if ( is_integer && parseInt( value ) > 0 ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validation.messages.tooltip_no_letter', [DICTIONARY_COMMON_UI] ) );
    },
    isDefineStringOrIntegerPositive: function ( messages, property, values_possible ) {
        let value      = property.getValue();
        let is_integer = SHINKEN.TOOLS.NUMBER.isInteger( value );
        if ( SHINKEN.TOOLS.ARRAY.contains( values_possible, value ) || is_integer && parseInt( value ) > 0 ) {
            return;
        }
        messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( _( 'validation.messages.must_be_positive_integer_or_define_value', [DICTIONARY_COMMON_UI] ), values_possible[ 0 ], values_possible[ 1 ] ) );
    }
};


