//priority 1048
//__lib__ lib_common_V02_01
"use strict";
SHINKEN.OBJECT.CommonFormInterface           = function () {
};
SHINKEN.OBJECT.CommonFormInterface.prototype = {
    addToPropertyModified              : function ( property_name ) {
        if ( !this.properties_modified.includes( property_name ) ) {
            this.properties_modified.push( property_name );
        }
    },
    askValidateForm                    : function ( param ) {
        this.addToPropertyModified( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
        if ( this.timeout__compute_validate_form ) {
            clearTimeout( this.timeout__compute_validate_form );
        }
        this.timeout__compute_validate_form = setTimeout( () => {
            this.validateForm( param );
            this.timeout__compute_validate_form = null;
            this.properties_modified            = [];
        }, 200 );
    },
    parseTilesBackgroundValueForPreview: function ( composed_key ) {
        switch ( composed_key ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_AND_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.ONLY_STATUS;
                }
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS;
                }
                break;
        }
    },
    parseConfigurationToArray          : function ( options_array, dictionary_key, property_structure, type ) {
        if ( !options_array ) {
            return;
        }
        let composed_key = property_structure.COMPOSED_KEY;
        let default_value;
        let dictionary;
        switch ( type ) {
            case WIDGET.CONST.TYPE.EXTERNAL_LINKS:
                default_value = this.getDefaultValueExternalLinks( type, composed_key );
                dictionary    = "";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE._KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR._KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER._KEY:
                const dict               = this.grid_object[ SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS ][ type ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT_AND_CFG );
                const default_dict_value = SHINKEN.TOOLS.DICT.getValueWithComposedKey( dict, composed_key );
                default_value          = this.is_default_form ? default_dict_value.cfg_value : default_dict_value.value;
                dictionary             = [DICTIONARY_COMMON_UI];
                break;
        }
        let to_return = [];
        
        const _keys = Object.keys( options_array );
        let value;
        let label;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            value = options_array[ _keys[ i ] ];
            label = value === "string_input" ? _( dictionary_key + ".input.placeholder", dictionary ) : _( dictionary_key + ".radios." + value, dictionary );
            to_return.push( { name: value, label: label } );
        }
        let default_label = default_value;
        if ( isTranslateKeyExisting( dictionary_key + ".radios." + default_value, dictionary ) ) {
            default_label = _( dictionary_key + ".radios." + default_value, dictionary );
        }
        default_label = SHINKEN.TOOLS.STRING.format( _( "property.default_label", [DICTIONARY_COMMON_UI] ), default_label );
        to_return.push( { name: WEATHER.CONST.DEFAULT_VALUE, label: default_label, [ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ]: true, [ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ]: default_value } );
        
        switch ( composed_key ) {
            case  WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED.COMPOSED_KEY:
                to_return[ 0 ].label = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-sound-svg' ) ).outerHTML + "<div class='shinken-label'>" + to_return[ 0 ].label + "</div>";
                to_return[ 1 ].label = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-sound-svg' ) ).outerHTML + "<div class='shinken-label'>" + to_return[ 1 ].label + "</div>";
                to_return[ 2 ].label = "<div class='shinken-label'>" + to_return[ 2 ].label + "</div>";
                break;
            case  WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED.COMPOSED_KEY:
                to_return[ 0 ].label = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-blink-icon' ) ).outerHTML + "<div class='shinken-label'>" + to_return[ 0 ].label + "</div>";
                to_return[ 1 ].label = DOM.Service.cloneElement( document.querySelector( '#id-shinken-template-view .shinken-blink-icon' ) ).outerHTML + "<div class='shinken-label'>" + to_return[ 1 ].label + "</div>";
                to_return[ 2 ].label = "<div class='shinken-label'>" + to_return[ 2 ].label + "</div>";
                break;
            case  WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED.COMPOSED_KEY:
                to_return[ 0 ].label = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .authentication-svg" ), { class: "shinken-weather-link-icon-authentication-needed" } ).outerHTML + "<div class='shinken-label'>" + to_return[ 0 ].label + "</div>";
                to_return[ 1 ].label = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .not-authentication-svg" ), { class: "shinken-weather-link-icon-authentication-needed" } ).outerHTML + "<div class='shinken-label'>" + to_return[ 1 ].label + "</div>";
                break;
            case  WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL.COMPOSED_KEY:
                to_return[ 1 ].label = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .https-icon-svg" ), { class: "shinken-weather-link-icon-https" } ).outerHTML + "<div class='shinken-label'>" + to_return[ 1 ].label + "</div>";
                to_return[ 2 ].label = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .not-https-icon-svg" ), { class: "shinken-weather-link-icon-https" } ).outerHTML + "<div class='shinken-label'>" + to_return[ 2 ].label + "</div>";
                break;
        }
        return to_return;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getController            : function () {
        return CONTROLLER.PageController;
    },
    setPropertyValue         : function ( property_name, value ) {
        this.doActionAfter( "property_value__set__by_js", {
            [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ]: this.getName(), [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: property_name, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: value
        } );
    },
    getHelpHtmlElementContent: function ( content ) {
        let type_content = content.type_content;
        let to_return;
        switch ( type_content ) {
            case "label_&_content":
            case "image_&_content":
                to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-elements" } );
                if ( content.elements ) {
                    content.elements.forEach( content_element => {
                        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: content_element.className }, content_element.content ), to_return );
                    } );
                    return to_return;
                }
                break;
        }
    },
    //********************************************  USER PREF  *****************************************************//
    getUserPref: function () {
        let to_return = {
            [ SHINKEN.USER_PREFS.KEY ]  : this.getName(),
            [ SHINKEN.USER_PREFS.VALUE ]: {}
        };
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            to_return[ SHINKEN.USER_PREFS.VALUE ][ this.getContent( i ).getUUID() ] = this.getContent( i ).getUserPref();
        }
        return to_return;
    }
};