//priority 1049
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.GridPageDefaultForm = function ( name, params ) {
    this.init( name, params );
};

SHINKEN.OBJECT.GridPageDefaultForm.prototype = {
    init             : function ( name, params ) {
        this.is_default_form = true;
        this.grid_object     = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ];
        this.page_object     = params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ];
        this.initCommon( name );
        this.initCounterCommon();
        this.initAllContent( params[ SHINKEN.USER_PREFS.PARAM_EVENT.DATA ] );
        this.properties_modified = [];
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
    },
    initAllContent   : function ( user_prefs ) {
        let prefs = user_prefs.getValueByKey( [this.getName()] );
        this.initWeatherWidgetDefault( prefs );
        this.initTitleWidgetDefault( prefs );
        this.initSeparatorWidgetDefault( prefs );
    },
    //********************************************  GETTER / SETTER **************************************************//
    setValueForProperty: function ( property_structure, property, type ) {
        let param_object;
        switch ( type ) {
            case WEATHER.CONST.WIDGET_TYPE.WEATHER :
                param_object = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.grid_object, "layouts.weather_widget_layout." + property_structure.COMPOSED_KEY );
                break;
            case WEATHER.CONST.WIDGET_TYPE.SEPARATOR :
                param_object = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.grid_object, "layouts.separator_widget_layout." + property_structure.COMPOSED_KEY );
                break;
            case WEATHER.CONST.WIDGET_TYPE.TITLE :
                param_object = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.grid_object, "layouts.title_widget_layout." + property_structure.COMPOSED_KEY );
                break;
            case WEATHER.CONST.EXTERNAL_LINKS._KEY :
                param_object = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.page_object, WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK.COMPOSED_KEY + "." + property_structure.COMPOSED_KEY );
                break;
        }
        property.doActionAfter( "property_value__set__by_data", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: param_object.getUserValue() + "" } );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "onchange_in_input_V3_done":
            case "click_on_item_selector_done":
                this.askValidateForm( params );
                break;
            case "change_radio_mode_done":
                this.synchronizationProperty( params, true );
                this.askValidateForm( params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ) !== this.getName() ) {
                    return;
                }
                if ( this.grid_for_preview && params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_UUID ) === this.grid_for_preview.getUUID() ) {
                    this.grid_for_preview.doActionAfter( event_name, params );
                    return;
                }
                this.property_set.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME ) ).doActionAfterLastModification( event_name, params );
                return;
            case "toggl_collapse_folder__is_open":
                for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( "toggl_collapse_folder__is_open__or__close_others", params );
                }
                this.getController().doActionAfter( "set__user_pref__data", { [ SHINKEN.USER_PREFS.PARAM_EVENT.DATA ]: this.getUserPref() } );
                return;
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case"change__widget_preview_zone__activity":
                        this.doActionAfter( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ], params );
                        return;
                }
                break;
            case "make_validation":
                CONTROLLER.Form.isValid();
                return;
        }
        this.doActionAfterCommon( event_name, params );
    },
    //********************************************  VALIDATION  *****************************************************//
    validateForm               : function ( params ) {
        const new_params                                    = {};
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ] = CONTROLLER.Form.isValid( params );
        
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
        new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_DEFAULT_VALUE_MODIFICATION );
        new_params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ] = this.properties_modified;
        new_params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ]                 = this.parseDataForSpecialCase( this.getDataToSave__20241114( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID, this.properties_modified ) );
        for ( let i = 0; i < this.properties_modified.length; i++ ) {
            new_params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.property_set.getContentByUUID( this.properties_modified[ i ] ).getLastModificationElement() );
        }
        
        this.grid_for_preview.doActionAfter( "value__param__configured__from_form__if_needed", new_params );
        CONTROLLER.PageController.doActionAfter( "default__param__configured__from_form", new_params );
        return true;
    },
    computeValidation__20241125: function ( params ) {
        this.status_validation      = COMPONENT.CONST.STATUS.VALID;
        let current_property;
        const validate_all_property = !params;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            current_property = this.property_set.getContent( i );
            if ( !validate_all_property && !this.properties_modified.includes( current_property.getName() ) ) {
                continue;
            }
            let parameter_validation = this.getParameterValidation( current_property );
            switch ( parameter_validation.key ) {
                case "height":
                    parameter_validation.updateMaximumValue( this.grid_object[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ].getValue() );
                    break;
                case "width":
                    parameter_validation.updateMaximumValue( this.grid_object[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ].getValue() );
                    break;
            }
            PROPERTY_V2.VALIDATOR.validWithParameter( current_property, parameter_validation, '"' );
        }
    },
    getParameterValidation     : function ( current_property ) {
        if ( WEATHER.CONST.isExternalLinkComposedKey( current_property.getName() ) ) {
            let _composed_key = SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( WEATHER.CONST.EXTERNAL_LINKS.PARAM.DEFAULT_LINK.COMPOSED_KEY + "." + current_property.getName(), "." );
            let _key          = SHINKEN.TOOLS.STRING.splitForGetLastOne( current_property.getName(), "." );
            return SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.page_object, _composed_key ).getValidOwnProperty( _key );
        }
        else {
            const split_composed_key = current_property.getName().split( "." );
            split_composed_key[ 0 ] += "_layout";
            split_composed_key.splice( 0, 0, SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS );
            let _composed_key = split_composed_key.join( "." );
            return SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this.grid_object, SHINKEN.TOOLS.STRING.splitAndJoinExceptLastOne( _composed_key, "." ) ).getValidOwnProperty( SHINKEN.TOOLS.STRING.splitForGetLastOne( _composed_key, "." ) );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtmlActions: function () {
    },
    //********************************************  COMPUTE  *****************************************************//
    getDefaultPreviewWidgetLayout: function () {
        const default_grid_layout          = this.grid_object.layouts[ WIDGET.CONST.PARAM.LAYOUTS.WEATHER._KEY ].content.layout.getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT );
        const CONST_INFORMATION_TO_DISPLAY = WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY;
        
        default_grid_layout[ CONST_INFORMATION_TO_DISPLAY._KEY ][ CONST_INFORMATION_TO_DISPLAY.SLA_AREA._KEY ][ CONST_INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY ].value             = true;
        default_grid_layout[ CONST_INFORMATION_TO_DISPLAY._KEY ][ CONST_INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY ][ CONST_INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY ].value = true;
        
        return default_grid_layout;
    },
    parseDataForSpecialCase      : function ( data ) {
        const _keys = Object.keys( data );
        let _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI ) {
                data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] = this.parseTilesBackgroundValueForPreview( _current_key );
            }
            switch ( _current_key ) {
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH.COMPOSED_KEY:
                case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH.COMPOSED_KEY:
                case WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH.COMPOSED_KEY:
                    if ( data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ) {
                        data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] = parseInt( data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] );
                    }
                    break;
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.HEIGHT.COMPOSED_KEY:
                case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.HEIGHT.COMPOSED_KEY:
                case WIDGET.CONST.PARAM.LAYOUTS.TITLE.HEIGHT.COMPOSED_KEY:
                    data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] = parseInt( data[ _current_key ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] );
                    break;
            }
        }
        return data;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.FormSetFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.CommonFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.TitleWidgetFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.SeparatorWidgetFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.WeatherWidgetFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.ExternalLinkFormInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageDefaultForm, SHINKEN.OBJECT.CounterInterfaceV2 );
