//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.RadioWidgetModeSpaceCreate           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.RadioWidgetModeSpaceCreate.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name );
        this.setLabel( _( "form.radio_widget_mode.label." + name ) );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    getIconSrc        : function () {
        return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/weather_visual_edit_create_space.png";
    },
    getShortCutLetter : function () {
        return "C";
    },
    getTooltipPosition: function () {
        return SHINKEN_TOOLTIP.PLACEMENT.TOP_LEFT;
    },
    //********************************************  HELP  *****************************************************//
    
    getHelpContents     : function () {
        return [
            {
                type_content: "label_&_content",
                elements    : [
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.create_space" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.maintain" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.move" ) }
                ]
            },
            {
                type_content: "unordered_title",
                label       : _( "edit_mode.windows.tooltips.labels_help.direction_widget_movement" )
            },
            {
                type_content: "image_&_content",
                elements    : [
                    { className: "shinken-help-img shinken-create-space" },
                    { className: "shinken-tooltip-help-label shinken-multi-line", content: _( "edit_mode.windows.tooltips.labels_help.to_the_down" ) }
                ]
            }
        
        ];
    },
    getHelpSpecificClass: function ( content ) {
        return "shinken-tooltip-space";
    }
    
    //********************************************  VALIDATION  *****************************************************//
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioWidgetModeSpaceCreate, SHINKEN.OBJECT.RadioMode );