//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.RadioWidgetModeSpaceDelete           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.RadioWidgetModeSpaceDelete.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name );
        this.setLabel( _( "form.radio_widget_mode.label." + name ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    getIconSrc          : function () {
        return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/weather_visual_edit_delete_space.png";
    },
    getShortCutLetter   : function () {
        return "S";
    },
    getTooltipPosition  : function () {
        return SHINKEN_TOOLTIP.PLACEMENT.TOP_LEFT;
    },
    getHelpContents     : function () {
        return [
            {
                type_content: "label_&_content",
                elements    : [
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.delete_space" ) },
                    { className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.maintain" ) },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { className: "shinken-tooltip-help-label", content: "+" },
                    { className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.move" ) }
                ]
            },
            {
                type_content: "unordered_title",
                label       : _( "edit_mode.windows.tooltips.labels_help.direction_widget_movement" )
            }, {
                
                type_content: "image_&_content",
                elements    : [
                    { className: "shinken-help-img shinken-delete-space" },
                    { className: "shinken-tooltip-help-label shinken-multi-line", content: _( "edit_mode.windows.tooltips.labels_help.to_the_top" ) }
                ]
            }
        
        ];
    },
    getHelpSpecificClass: function ( content ) {
        return "shinken-tooltip-space";
    }
    //********************************************  VALIDATION  *****************************************************//
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioWidgetModeSpaceDelete, SHINKEN.OBJECT.RadioMode );